/* $Id: gui-GTK_crc-dialog.c,v 1.3 2005/03/20 22:26:54 emvi Exp $ */

/* 
Copyright (C) 2005 Marek Wardziski (emvi at emvi eu org) 
 
This file is part of Ant. 
 
Ant is free software; you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation; either version 2 of the License, or 
(at your option) any later version. 
 
Ant is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
GNU General Public License for more details. 
 
You should have received a copy of the GNU General Public License 
along with Ant; if not, write to the Free Software 
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "main.h"
#include "gui-GTK.h"
#include "gui-GTK_handlers.h"
#include "misc.h"

GtkWidget *crc_dialog_window;
GtkWidget *crc_dialog_label1;
GtkWidget *crc_dialog_label2;
GtkWidget *crc_dialog_labelstart;
GtkWidget *crc_dialog_labelend;
GtkWidget *crc_dialog_hbox1;
GtkWidget *crc_dialog_hbox2;
GtkWidget *crc_dialog_startbyte;
GtkWidget *crc_dialog_endbyte;
GtkWidget *crc_dialog_radioatcursor;
GtkWidget *crc_dialog_radioatend;
GtkWidget *crc_dialog_radioafterend;

void crc_dialog_create() {
    int max_value;

    /* create dialog window */
    crc_dialog_window = gtk_dialog_new_with_buttons(_("Add FCS"), GTK_WINDOW(window_main),
				GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_STOCK_OK, GTK_RESPONSE_OK,
				GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				NULL);
    crc_dialog_label1 = gtk_label_new(_("Calculate FCS using bytes"));
    crc_dialog_hbox1 = gtk_hbox_new(FALSE, 0);
    crc_dialog_labelstart = gtk_label_new(_("from"));
    max_value = frame->len - 1;
    if (max_value == 0)
	max_value++;
    crc_dialog_startbyte = gtk_spin_button_new_with_range(0, max_value, 1);
    g_signal_connect(G_OBJECT(crc_dialog_startbyte), "button-press-event", G_CALLBACK(entry_mouseclicked), NULL);
    gtk_spin_button_set_value((GtkSpinButton*) crc_dialog_startbyte, 0);
    gtk_entry_set_alignment(GTK_ENTRY(crc_dialog_startbyte), 1);
    gtk_box_pack_start(GTK_BOX(crc_dialog_hbox1), crc_dialog_labelstart, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(crc_dialog_hbox1), crc_dialog_startbyte, TRUE, TRUE, 0);
    crc_dialog_hbox2 = gtk_hbox_new(FALSE, 0);
    crc_dialog_labelend = gtk_label_new(_("to"));
    crc_dialog_endbyte = gtk_spin_button_new_with_range(0, max_value, 1);
    g_signal_connect(G_OBJECT(crc_dialog_endbyte), "button-press-event", G_CALLBACK(entry_mouseclicked), NULL);
    gtk_spin_button_set_value((GtkSpinButton*) crc_dialog_endbyte, frame->len - 1);
    gtk_entry_set_alignment(GTK_ENTRY(crc_dialog_endbyte), 1);
    gtk_box_pack_start(GTK_BOX(crc_dialog_hbox2), crc_dialog_labelend, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(crc_dialog_hbox2), crc_dialog_endbyte, TRUE, TRUE, 0);
    crc_dialog_label2 = gtk_label_new(_("Write:"));
    crc_dialog_radioatcursor = gtk_radio_button_new_with_label(NULL, _("from cursor's position"));
    crc_dialog_radioatend = gtk_radio_button_new_with_label_from_widget(
						GTK_RADIO_BUTTON(crc_dialog_radioatcursor),
						_("in frame's last 4 bytes"));
    crc_dialog_radioafterend = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(crc_dialog_radioatcursor),
						_("add to end of the frame"));
    gtk_toggle_button_set_active((GtkToggleButton*) crc_dialog_radioafterend, TRUE);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(crc_dialog_window)->vbox), crc_dialog_label1, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(crc_dialog_window)->vbox), crc_dialog_hbox1, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(crc_dialog_window)->vbox), crc_dialog_hbox2, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(crc_dialog_window)->vbox), crc_dialog_label2, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(crc_dialog_window)->vbox), crc_dialog_radioatcursor, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(crc_dialog_window)->vbox), crc_dialog_radioatend, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(crc_dialog_window)->vbox), crc_dialog_radioafterend, TRUE, TRUE, 2);
    gtk_widget_show_all(crc_dialog_window);
}

void crc_dialog_write_frame() {
    int start, end, crc, position, position2;
    guint8 i;

    /* cleanup colors */
    if ((position = frame->fcs_position) > -1) {
	frame->fcs_position = -1;
	for (position2 = position; position2 < position + 4; position2++) {
	    if (position2 < frame->len)
		fill_one_byte_cells(position2);
	}
    }

    /* position of CRC */
    if (gtk_toggle_button_get_active((GtkToggleButton*) crc_dialog_radioatcursor))
        position = selected_byte;
    else if (gtk_toggle_button_get_active((GtkToggleButton*) crc_dialog_radioatend))
        position = frame->len - 4;
    else if (gtk_toggle_button_get_active((GtkToggleButton*) crc_dialog_radioafterend))
        position = frame->len;
    if (position < 0)
        position = 0;

    /* remember position */
    frame->fcs_position = position;

    /* add bytes to frame */
    if (frame->len < position + 4) {
        add_to_frame(position - frame->len + 4, NULL, 0);
        add_cells_to_tables();
    }
    start = gtk_spin_button_get_value_as_int((GtkSpinButton*) crc_dialog_startbyte);
    end = gtk_spin_button_get_value_as_int((GtkSpinButton*) crc_dialog_endbyte);
    crc = libnet_compute_crc(frame->data + start, end - start + 1);
    i = crc & 0xFF;
    memcpy(frame->data + position, &i, 1);
    i = (crc & 0xFF00) >> 8;
    memcpy(frame->data + position + 1, &i, 1);
    i = (crc & 0xFF0000) >> 16;
    memcpy(frame->data + position + 2, &i, 1);
    i = (crc & 0xFF000000) >> 24;
    memcpy(frame->data + position + 3, &i, 1);
    fill_one_byte_cells(position);
    fill_one_byte_cells(position + 1);
    fill_one_byte_cells(position + 2);
    fill_one_byte_cells(position + 3);
    fill_binary();
    fill_decimal();
    fill_datasize();
}
