/* $Id: gui-GTK_eth-dialog.c,v 1.3 2005/03/20 22:26:54 emvi Exp $ */

/* 
Copyright (C) 2005 Marek Wardziski (emvi at emvi eu org) 
 
This file is part of Ant. 
 
Ant is free software; you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation; either version 2 of the License, or 
(at your option) any later version. 
 
Ant is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
GNU General Public License for more details. 
 
You should have received a copy of the GNU General Public License 
along with Ant; if not, write to the Free Software 
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "main.h"
#include "misc.h"
#include "net.h"

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "gui-GTK.h"
#include "gui-GTK_handlers.h"

GtkWidget *eth_dialog_window;
GtkWidget *eth_dialog_label1;
GtkWidget *eth_dialog_hbox1;
GtkWidget *eth_dialog_checkdst;
GtkWidget *eth_dialog_dstmac;
GtkWidget *eth_dialog_hbox2;
GtkWidget *eth_dialog_checksrc;
GtkWidget *eth_dialog_combosrc;
GtkWidget *eth_dialog_srcmac;
GtkWidget *eth_dialog_hbox3;
GtkWidget *eth_dialog_checktype;
GtkWidget *eth_dialog_combotype;
GtkWidget *eth_dialog_type;
GtkWidget *eth_dialog_label2;
GtkWidget *eth_dialog_hbox4;
GtkWidget *eth_dialog_radioatstart;
GtkWidget *eth_dialog_radioatcursor;
GtkWidget *eth_dialog_buttonget;

char* table_types[] = { N_("0800 - IP"),
			N_("0806 - ARP"),
			N_("8035 - RARP"),
			N_("8137 - IPX"),
			N_("86DD - IPv6"),
			NULL};

gboolean eth_dialog_mac_keypress(GtkWidget *widget, GdkEventKey *event, gpointer data) {
    gint sel_start, sel_end;
    gboolean selection;

    /* allow for 'left' 'right' 'tab' 'home' 'end' key presses */
    if ((event->keyval == GDK_Right) || (event->keyval == GDK_Left) ||
	(event->keyval == GDK_Home) || (event->keyval == GDK_End) ||
	(event->keyval == GDK_Tab))
	return FALSE;

    /* backspace - change cursor position */
    if (event->keyval == GDK_BackSpace) {
        gtk_editable_get_selection_bounds((GtkEditable*) widget, &sel_start, &sel_end);
        if (sel_start > 0) {
	    sel_start = sel_start - 1 - ((sel_start % 3) == 0);
            gtk_editable_select_region((GtkEditable*) widget, sel_start, sel_start + 1);
	}
    }

    if (((event->keyval >= GDK_0) && (event->keyval <= GDK_9)) ||
        ((event->keyval >= GDK_a) && (event->keyval <= GDK_f)) ||
	((event->keyval >= GDK_A) && (event->keyval <= GDK_F))) {
	selection = gtk_editable_get_selection_bounds((GtkEditable*) widget, &sel_start, &sel_end);
	if (((sel_start + 1) % 3) == 0)
	    sel_start++;
	if (sel_start >= 17)
	    return TRUE;
	gtk_editable_select_region((GtkEditable*) widget, sel_start, sel_start + 1);
	return FALSE;
    }
    return TRUE;        /* don't do anything when other key pressed */
}

void eth_dialog_mac_changed(GtkWidget *widget, gpointer data) {
    gtk_entry_set_text((GtkEntry*) widget, g_ascii_strup(gtk_entry_get_text((GtkEntry*) widget), -1));
}

gboolean eth_dialog_type_keypress(GtkWidget *widget, GdkEventKey *event, gpointer data) {
    gint sel_start, sel_end;
    gboolean selection;

    /* allow for 'left' 'right' 'tab' 'home' 'end' key presses */
    if ((event->keyval == GDK_Right) || (event->keyval == GDK_Left) ||
	(event->keyval == GDK_Home) || (event->keyval == GDK_End) ||
	(event->keyval == GDK_Tab))
	return FALSE;

    /* backspace - change cursor position */
    if (event->keyval == GDK_BackSpace) {
        gtk_editable_get_selection_bounds((GtkEditable*) widget, &sel_start, &sel_end);
        if (sel_start > 0)
            gtk_editable_select_region((GtkEditable*) widget, sel_start - 1, sel_start);
    }

    if (((event->keyval >= GDK_0) && (event->keyval <= GDK_9)) ||
        ((event->keyval >= GDK_a) && (event->keyval <= GDK_f)) ||
	((event->keyval >= GDK_A) && (event->keyval <= GDK_F))) {
	selection = gtk_editable_get_selection_bounds((GtkEditable*) widget, &sel_start, &sel_end);
	if (sel_start >= 4)
	    return TRUE;
	gtk_editable_select_region((GtkEditable*) widget, sel_start, sel_start + 1);
	return FALSE;
    }
    return TRUE;        /* don't do anything when other key pressed */
}

void eth_dialog_checkdst_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(eth_dialog_dstmac, gtk_toggle_button_get_active(widget));
}

void eth_dialog_checksrc_toggled(GtkToggleButton *widget, gpointer data) {
    gboolean active;
    active = gtk_toggle_button_get_active(widget);
    gtk_widget_set_sensitive(eth_dialog_combosrc, active);
    gtk_widget_set_sensitive(eth_dialog_srcmac, active &
		(gtk_combo_box_get_active(GTK_COMBO_BOX(eth_dialog_combosrc)) == 0));
}

void eth_dialog_combosrc_changed(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(eth_dialog_srcmac,
		(gtk_combo_box_get_active(GTK_COMBO_BOX(eth_dialog_combosrc)) == 0));
}

void eth_dialog_checktype_toggled(GtkToggleButton *widget, gpointer data) {
    gboolean active;
    active = gtk_toggle_button_get_active(widget);
    gtk_widget_set_sensitive(eth_dialog_combotype, active);
    gtk_widget_set_sensitive(eth_dialog_type, active &
		(gtk_combo_box_get_active(GTK_COMBO_BOX(eth_dialog_combotype)) == 0));
}

void eth_dialog_combotype_changed(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(eth_dialog_type,
		(gtk_combo_box_get_active(GTK_COMBO_BOX(eth_dialog_combotype)) == 0));
}

void eth_dialog_buttonget_clicked(GtkWidget *widget, gpointer data) {
    int i;
    char *text, *text2;
    int position = 0;

    /* position in frame */
    if (gtk_toggle_button_get_active((GtkToggleButton*) eth_dialog_radioatcursor))
        position = selected_byte;
    else if (gtk_toggle_button_get_active((GtkToggleButton*) eth_dialog_radioatstart))
	position = 0;

    /* destination MAC address */
    text = malloc(18);
    if (frame->len > position + 5) {
	for (i = 0; i < 6; i++) {
	    text2 = int2hex(frame->data[position++]);
	    strncpy(&(text[i * 3]), text2, 2);
	    text[i * 3 + 2] = ':';
	    free(text2);
	}
	text[17] = 0;
	gtk_entry_set_text((GtkEntry*) eth_dialog_dstmac, text);
    }

    /* source MAC address */
    if (frame->len > position + 5) {
	for (i = 0; i < 6; i++) {
	    text2 = int2hex(frame->data[position++]);
	    strncpy(&(text[i * 3]), text2, 2);
	    text[i * 3 + 2] = ':';
	    free(text2);
	}
	text[17] = 0;
	gtk_entry_set_text((GtkEntry*) eth_dialog_srcmac, text);
	/* no iface selected and srcmac entry enabled */
	gtk_combo_box_set_active((GtkComboBox*) eth_dialog_combosrc, 0);
	gtk_widget_set_sensitive(eth_dialog_srcmac, gtk_toggle_button_get_active((GtkToggleButton*) eth_dialog_checksrc));
    }

    /* type */
    if ((frame->len > position + 1) && (frame->len >= 14)) {
	for (i = 0; i < 2; i++) {
	    text2 = int2hex(frame->data[position++]);
	    strncpy(&(text[i * 2]), text2, 2);
	    free(text2);
	}
	text[4] = 0;
	gtk_entry_set_text((GtkEntry*) eth_dialog_type, text);
	/* no type selected and srcmac entry enabled */
	gtk_combo_box_set_active((GtkComboBox*) eth_dialog_combotype, 0);
	gtk_widget_set_sensitive(eth_dialog_type, gtk_toggle_button_get_active((GtkToggleButton*) eth_dialog_checktype));
    }
    free(text);
}

void eth_dialog_create() {
    int i, selected;
    char *text;

    eth_dialog_window = gtk_dialog_new_with_buttons(_("Add Ethernet header"),
			    GTK_WINDOW(window_main),
			    GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                	    GTK_STOCK_OK, GTK_RESPONSE_OK,
                	    NULL);
    eth_dialog_buttonget = gtk_button_new_with_label(_("Get values from frame"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(eth_dialog_window)->action_area), eth_dialog_buttonget, TRUE, TRUE, 0);
    eth_dialog_label1 = gtk_label_new(_("Create header containing"));
    g_signal_connect(G_OBJECT(eth_dialog_buttonget), "clicked", G_CALLBACK(eth_dialog_buttonget_clicked), NULL);
    gtk_dialog_add_button(GTK_DIALOG(eth_dialog_window), GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL);

    eth_dialog_hbox1 = gtk_hbox_new(TRUE, 5);
    eth_dialog_checkdst = gtk_check_button_new_with_label(_("destination address"));
    gtk_toggle_button_set_active((GtkToggleButton*) eth_dialog_checkdst, TRUE);
    g_signal_connect(G_OBJECT(eth_dialog_checkdst), "toggled", G_CALLBACK(eth_dialog_checkdst_toggled), NULL);
    eth_dialog_dstmac = gtk_entry_new();
    gtk_entry_set_max_length(GTK_ENTRY(eth_dialog_dstmac), 17);
    gtk_entry_set_width_chars(GTK_ENTRY(eth_dialog_dstmac), 17);
    gtk_entry_set_alignment(GTK_ENTRY(eth_dialog_dstmac), 1);
    gtk_entry_set_text(GTK_ENTRY(eth_dialog_dstmac), "FF:FF:FF:FF:FF:FF");
    g_signal_connect(G_OBJECT(eth_dialog_dstmac), "key-press-event", G_CALLBACK(eth_dialog_mac_keypress), NULL);
    g_signal_connect(G_OBJECT(eth_dialog_dstmac), "changed", G_CALLBACK(eth_dialog_mac_changed), NULL);
    g_signal_connect(G_OBJECT(eth_dialog_dstmac), "button-press-event", G_CALLBACK(entry_mouseclicked), NULL);
    gtk_box_pack_start(GTK_BOX(eth_dialog_hbox1), eth_dialog_checkdst, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(eth_dialog_hbox1), eth_dialog_dstmac, TRUE, TRUE, 0);

    eth_dialog_hbox2 = gtk_hbox_new(TRUE, 5);
    eth_dialog_checksrc = gtk_check_button_new_with_label(_("source address"));
    gtk_toggle_button_set_active((GtkToggleButton*) eth_dialog_checksrc, TRUE);
    g_signal_connect(G_OBJECT(eth_dialog_checksrc), "toggled", G_CALLBACK(eth_dialog_checksrc_toggled), NULL);
    eth_dialog_combosrc = gtk_combo_box_new_text();
    gtk_combo_box_append_text((GtkComboBox*) eth_dialog_combosrc, _("-other-"));
    i = selected = 0;
    while ((text = get_iface_name(i++)) != NULL) {
        gtk_combo_box_append_text((GtkComboBox*) eth_dialog_combosrc, text);
	if (device != NULL && strcmp(text, device) == 0)
	    selected = i;
    }
    eth_dialog_srcmac = gtk_entry_new();
    /* select iface on combo and (en/dis)able entry after create */
    g_signal_connect(G_OBJECT(eth_dialog_combosrc), "changed", G_CALLBACK(eth_dialog_combosrc_changed), NULL);
    gtk_combo_box_set_active((GtkComboBox*) eth_dialog_combosrc, selected);
    gtk_entry_set_max_length(GTK_ENTRY(eth_dialog_srcmac), 17);
    gtk_entry_set_width_chars(GTK_ENTRY(eth_dialog_srcmac), 17);
    gtk_entry_set_alignment(GTK_ENTRY(eth_dialog_srcmac), 1);
    gtk_entry_set_text(GTK_ENTRY(eth_dialog_srcmac), "00:00:00:00:00:00");
    g_signal_connect(G_OBJECT(eth_dialog_srcmac), "key-press-event", G_CALLBACK(eth_dialog_mac_keypress), NULL);
    g_signal_connect(G_OBJECT(eth_dialog_srcmac), "button-press-event", G_CALLBACK(entry_mouseclicked), NULL);
    g_signal_connect(G_OBJECT(eth_dialog_srcmac), "changed", G_CALLBACK(eth_dialog_mac_changed), NULL);
    gtk_box_pack_start(GTK_BOX(eth_dialog_hbox2), eth_dialog_checksrc, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(eth_dialog_hbox2), eth_dialog_combosrc, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(eth_dialog_hbox2), eth_dialog_srcmac, TRUE, TRUE, 0);

    eth_dialog_hbox3 = gtk_hbox_new(TRUE, 5);
    eth_dialog_checktype = gtk_check_button_new_with_label(_("type/size"));
    gtk_toggle_button_set_active((GtkToggleButton*) eth_dialog_checktype, TRUE);
    g_signal_connect(G_OBJECT(eth_dialog_checktype), "toggled", G_CALLBACK(eth_dialog_checktype_toggled), NULL);
    eth_dialog_combotype = gtk_combo_box_new_text();
    gtk_combo_box_append_text((GtkComboBox*) eth_dialog_combotype, _("-other-"));
    i = 0;
    while (table_types[i] != NULL)
	gtk_combo_box_append_text((GtkComboBox*) eth_dialog_combotype, _(table_types[i++]));
    g_signal_connect(G_OBJECT(eth_dialog_combotype), "changed", G_CALLBACK(eth_dialog_combotype_changed), NULL);
    eth_dialog_type = gtk_entry_new();
    gtk_entry_set_max_length(GTK_ENTRY(eth_dialog_type), 4);
    gtk_entry_set_width_chars(GTK_ENTRY(eth_dialog_srcmac), 4);
    gtk_entry_set_alignment(GTK_ENTRY(eth_dialog_type), 1);
    gtk_entry_set_text(GTK_ENTRY(eth_dialog_type), "0000");
    /* set type after entry create */
    gtk_combo_box_set_active((GtkComboBox*) eth_dialog_combotype, 1);
    g_signal_connect(G_OBJECT(eth_dialog_type), "key-press-event", G_CALLBACK(eth_dialog_type_keypress), NULL);
    g_signal_connect(G_OBJECT(eth_dialog_type), "button-press-event", G_CALLBACK(entry_mouseclicked), NULL);
    g_signal_connect(G_OBJECT(eth_dialog_type), "changed", G_CALLBACK(eth_dialog_mac_changed), NULL);
    gtk_box_pack_start(GTK_BOX(eth_dialog_hbox3), eth_dialog_checktype, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(eth_dialog_hbox3), eth_dialog_combotype, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(eth_dialog_hbox3), eth_dialog_type, TRUE, TRUE, 0);

    eth_dialog_label2 = gtk_label_new(_("Write:"));
    eth_dialog_hbox4 = gtk_hbox_new(TRUE, 5);
    eth_dialog_radioatstart = gtk_radio_button_new_with_label(NULL, _("from begining of the frame"));
    eth_dialog_radioatcursor = gtk_radio_button_new_with_label_from_widget(
						GTK_RADIO_BUTTON(eth_dialog_radioatstart),
						_("from cursor's position"));
    gtk_toggle_button_set_active((GtkToggleButton*) eth_dialog_radioatstart, TRUE);
    gtk_box_pack_start(GTK_BOX(eth_dialog_hbox4), eth_dialog_radioatstart, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(eth_dialog_hbox4), eth_dialog_radioatcursor, TRUE, TRUE, 0);

    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(eth_dialog_window)->vbox), eth_dialog_label1, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(eth_dialog_window)->vbox), eth_dialog_hbox1, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(eth_dialog_window)->vbox), eth_dialog_hbox2, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(eth_dialog_window)->vbox), eth_dialog_hbox3, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(eth_dialog_window)->vbox), eth_dialog_label2, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(eth_dialog_window)->vbox), eth_dialog_hbox4, TRUE, TRUE, 2);
    gtk_widget_show_all(eth_dialog_window);
}

void eth_dialog_write_frame() {
    char *text, *texttype;
    int position, position2;
    guint8 i;

    /* cleanup */
    if ((position = frame->eth_position) > -1) {
	frame->eth_position = -1;
	for (position2 = position; position2 < position + 14; position2++) {
    	    if (position2 < frame->len)
        	fill_one_byte_cells(position2);
	}
    }

    /* position in frame */
    if (gtk_toggle_button_get_active((GtkToggleButton*) eth_dialog_radioatcursor))
        position = selected_byte;
    else if (gtk_toggle_button_get_active((GtkToggleButton*) eth_dialog_radioatstart))
	position = 0;

    /* remember position */
    frame->eth_position = position;

    /* get dst MAC address */
    if (gtk_toggle_button_get_active((GtkToggleButton*) eth_dialog_checkdst)) {
	/* add bytes to frame */
	if (frame->len < position + 6) {
	    add_to_frame(position - frame->len + 6, NULL, 0);
	    add_cells_to_tables();
	}
	for (position2 = 0; position2 < 6; position++, position2++) {
	    text = malloc(3);
	    text = gtk_editable_get_chars((GtkEditable*) eth_dialog_dstmac, position2 * 3, position2 * 3 + 2);
	    text[2] = 0;
	    i = (hex2int(text) & 0xFF);
	    free(text);
	    memcpy(frame->data + position, &i, 1);
	}
    } else
	position += 6;
    /* get src MAC address */
    if (gtk_toggle_button_get_active((GtkToggleButton*) eth_dialog_checksrc)) {
	/* add bytes to frame */
	if (frame->len < position + 6) {
	    add_to_frame(position - frame->len + 6, NULL, 0);
	    add_cells_to_tables();
	}
	i = gtk_combo_box_get_active(GTK_COMBO_BOX(eth_dialog_combosrc));
	if (i == 0) {
	    for (position2 = 0; position2 < 6; position++, position2++) {
		text = malloc(3);
		text = gtk_editable_get_chars((GtkEditable*) eth_dialog_srcmac, position2 * 3, position2 * 3 + 2);
		text[2] = 0;
		i = (hex2int(text) & 0xFF);
		free(text);
		memcpy(frame->data + position, &i, 1);
	    }
	} else {
	    device = get_iface_name(i - 1);
	    text = get_mac_address();
	    memcpy(frame->data + position, text, 6);
	    free(text);
	    position += 6;
	}
    } else
	position += 6;
    /* get type */
    if (gtk_toggle_button_get_active((GtkToggleButton*) eth_dialog_checktype)) {
	/* add bytes to frame */
	if (frame->len < position + 2) {
	    add_to_frame(position - frame->len + 2, NULL, 0);
	    add_cells_to_tables();
	}
	i = gtk_combo_box_get_active(GTK_COMBO_BOX(eth_dialog_combotype));
	texttype = malloc(5);
	if (i == 0)
	    texttype = gtk_editable_get_chars((GtkEditable*) eth_dialog_type, 0, 4);
	else
	    strncpy(texttype, _(table_types[i - 1]), 4);
	texttype[4] = 0;
	
	for (position2 = 0; position2 < 2; position++, position2++) {
	    text = malloc(3);
	    strncpy(text, &texttype[position2 * 2], 2);
	    text[2] = 0;
	    i = (hex2int(text) & 0xFF);
	    free(text);
	    memcpy(frame->data + position, &i, 1);
	}
	free(texttype);
    }

    /* refresh window */
    for (position2 = frame->eth_position; position2 < frame->eth_position + 14; position2++) {
        if (frame->len > position2)
            fill_one_byte_cells(position2);
    }
    fill_binary();
    fill_decimal();
    fill_datasize();
}
