/* $Id: gui-GTK_handlers.c,v 1.3 2005/03/20 22:26:54 emvi Exp $ */

/* 
Copyright (C) 2005 Marek Wardziski (emvi at emvi eu org) 
 
This file is part of Ant. 
 
Ant is free software; you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation; either version 2 of the License, or 
(at your option) any later version. 
 
Ant is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
GNU General Public License for more details. 
 
You should have received a copy of the GNU General Public License 
along with Ant; if not, write to the Free Software 
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <libnet.h>

#include "main.h"
#include "gui-GTK.h"
#include "misc.h"
#include "gui-GTK_misc.h"
#include "gui-GTK_send-dialog.h"
#include "gui-GTK_eth-dialog.h"
#include "gui-GTK_ip-dialog.h"
#include "gui-GTK_addframe-dialog.h"
#include "gui-GTK_ipcksum-dialog.h"
#include "gui-GTK_udp-dialog.h"
#include "gui-GTK_tcp-dialog.h"
#include "gui-GTK_udpcksum-dialog.h"
#include "gui-GTK_crc-dialog.h"
#include "gui-GTK_ipx-dialog.h"
#include "gui-GTK_spx-dialog.h"
#include "gui-GTK_about-dialog.h"
#include "net.h"

void menu_file_exit(GtkMenuItem *menu_item, gpointer data);

/* allow close program when delete clicked */
gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data) {
    menu_file_exit(NULL, NULL);
    return TRUE;
}

void buttonprevframe_clicked(GtkWidget *widget, gpointer data) {
    GdkColor color;

    if (selected_frame > 0) {
	color.red = color.green = color.blue= 0xFFFF;
	gtk_widget_modify_base(g_list_nth(list_cells_hex, selected_byte)->data, GTK_STATE_NORMAL, &color);
	gtk_widget_modify_base(g_list_nth(list_cells_ascii, selected_byte)->data, GTK_STATE_NORMAL, &color);
	selected_frame--;
	frame = g_list_nth_data(all_frames, selected_frame);
	selected_byte = 0;
	fill_frame_number();
	fill_tables();
	fill_binary();
	fill_decimal();
	fill_datasize();
    }
}

void buttonnextframe_clicked(GtkWidget *widget, gpointer data) {
    GdkColor color;

    if (g_list_length(all_frames) > selected_frame + 1) {
	color.red = color.green = color.blue= 0xFFFF;
	gtk_widget_modify_base(g_list_nth(list_cells_hex, selected_byte)->data, GTK_STATE_NORMAL, &color);
	gtk_widget_modify_base(g_list_nth(list_cells_ascii, selected_byte)->data, GTK_STATE_NORMAL, &color);
	selected_frame++;
	frame = g_list_nth_data(all_frames, selected_frame);
	selected_byte = 0;
	fill_frame_number();
	fill_tables();
	fill_binary();
	fill_decimal();
	fill_datasize();
    }
}

/*void cell_hex_change(GtkWidget *widget, gpointer data) {

}*/

gboolean cell_hex_keypress(GtkWidget *widget, GdkEventKey *event, gpointer data) {
    GList *next_widget;
    gint sel_start, sel_end, position, num_chars, rows, row_height;
    gboolean selection;
    char *ascii_text, *hex_text;
    GtkAdjustment *adjustment;

    switch (event->keyval) {
	/* when 'right' key pressed */
	case GDK_Right:
    	    /* and cursor position == last position */
	    num_chars = strlen(gtk_editable_get_chars((GtkEditable*) widget, 0, 2));
	    if (gtk_editable_get_position((GtkEditable*) widget) == num_chars) {
		/* go to next cell */
		next_widget = g_list_find(list_cells_hex, widget)->next;
		if (next_widget != NULL)
		    gtk_widget_grab_focus(next_widget->data);
	    }
	    return FALSE;

	/* when 'left' key pressed */
	case GDK_Left:
	    gtk_editable_get_selection_bounds((GtkEditable*) widget, &sel_start, &sel_end);
	    /* and cursor position = 0 or selected all text in cell */
	    if ((gtk_editable_get_position((GtkEditable*) widget) == 0) ||
		    ((sel_start == 0) && (sel_end == 2))) {
		/* go to prev cell */
		next_widget = g_list_find(list_cells_hex, widget)->prev;
		if (next_widget != NULL)
		    gtk_widget_grab_focus(next_widget->data);
	    }
	    return FALSE;

	/* when 'Up' key pressed */
	case GDK_Up:
	    if (selected_byte >= 16) {
		position = selected_byte - 16;
		next_widget = g_list_nth(list_cells_hex, position);
		gtk_widget_grab_focus(next_widget->data);
	    }
	    return TRUE;

	/* when 'Down' key pressed */
        case GDK_Down:
	    if (selected_byte < frame->len - 16) {
	        position = selected_byte + 16;
	        next_widget = g_list_nth(list_cells_hex, position);
		gtk_widget_grab_focus(next_widget->data);
	    }
	    return TRUE;

        /* when 'home' key pressed */
        case GDK_Home:
	    next_widget = g_list_nth(list_cells_hex, selected_byte - (selected_byte % 16));
	    gtk_widget_grab_focus(next_widget->data);
	    return FALSE;

	/* when 'end' key pressed */
	case GDK_End:
	    position = selected_byte + 15 - (selected_byte % 16);
	    if (position >= frame->len)
		position = frame->len - 1;
	    next_widget = g_list_nth(list_cells_hex, position);
	    gtk_widget_grab_focus(next_widget->data);
	    return FALSE;

	/* when 'PgDown' key pressed */
	case GDK_Page_Down:
	    adjustment = gtk_scrolled_window_get_vadjustment((GtkScrolledWindow*) scroll_tables);
	    row_height = adjustment->upper / ceil(g_list_length(list_cells_hex) / 16);
	    rows = floor(adjustment->page_size / row_height);
	    position = selected_byte + rows * 16;
	    while (position >= frame->len)
		position -= 16;
	    next_widget = g_list_nth(list_cells_hex, position);
	    gtk_widget_grab_focus(next_widget->data);
	    return FALSE;

	/* when 'PgUp' key pressed */
	case GDK_Page_Up:
	    adjustment = gtk_scrolled_window_get_vadjustment((GtkScrolledWindow*) scroll_tables);
	    row_height = adjustment->upper / ceil(g_list_length(list_cells_hex) / 16);
	    rows = floor(adjustment->page_size / row_height);
	    position = selected_byte - rows * 16;
	    while (position < 0)
		position += 16;
	    next_widget = g_list_nth(list_cells_hex, position);
	    gtk_widget_grab_focus(next_widget->data);
	    return FALSE;

	/* go to ascii table when 'tab' key pressed */
	case GDK_Tab:
	    gtk_widget_grab_focus(g_list_nth(list_cells_ascii, selected_byte)->data);
	    return TRUE;	/* don't do anything whit this 'tab' keypress */

	/* other correct keys */
	case GDK_BackSpace:
	case GDK_Delete:
	    return FALSE;
    }

    /* insert correct hex digit
    how many chars		0 1 1 1 2 2 2 2 2 2
    cursor at position		0 0 1 1 0 1 1 2 2 2
    selected chars		0 0 0 1 0 0 1 0 1 2
				- - - - n n - g - f
    -  - just print
    n  - overwrite next char
    g  - go to next cell and print there
    f  - overwrite only first char */
    if (((event->keyval >= GDK_0) && (event->keyval <= GDK_9)) ||
	    ((event->keyval >= GDK_a) && (event->keyval <= GDK_f)) ||
	    ((event->keyval >= GDK_A) && (event->keyval <= GDK_F))) {
	num_chars = strlen(gtk_editable_get_chars((GtkEditable*) widget, 0, 2));
	selection = gtk_editable_get_selection_bounds((GtkEditable*) widget, &sel_start, &sel_end);
	position = gtk_editable_get_position((GtkEditable*) widget);
	if (!selection) {
	    if (position == 2) {
		/* "g" option above:
		   go to next cell if exists, overwrite first char,
		   store cursor after that */
		next_widget = g_list_find(list_cells_hex, widget)->next;
		ascii_text = malloc(3);
		ascii_text[0] = event->keyval;
		if (next_widget != NULL) {
		    ascii_text[1] = 0;
		    gtk_widget_grab_focus(next_widget->data);
		    gtk_editable_delete_text((GtkEditable*) next_widget->data, 0, 1);
		    position = 0;
		    gtk_editable_insert_text((GtkEditable*) next_widget->data, ascii_text, 1, &position);
		} else {
		    /* there are no more cells
		       add byte to frame data and create new cell */
		    ascii_text[1] = '0';
		    ascii_text[2] = 0;
		    hex_text = malloc(2);
		    hex_text[0] = hex2int(ascii_text);
		    hex_text[1] = 0;
		    add_to_frame(1, hex_text, 0);
		    free(hex_text);
		    add_cells_to_tables();
		    next_widget = g_list_find(list_cells_hex, widget)->next;
		    gtk_widget_grab_focus(next_widget->data);
		}
		free(ascii_text);
		gtk_editable_select_region((GtkEditable*) next_widget->data, 1, 1);
		gtk_main_iteration_do(FALSE);
		return TRUE;
	    }
	    else if (num_chars == 2)
		/* "n" option above: delete char only */
		gtk_editable_delete_text((GtkEditable*) widget, position, position + 1);
	} else if ((sel_start == 0) && (sel_end == 2))
	    /* "f" option above: select first char only */
	    gtk_editable_select_region((GtkEditable*)widget, 0, 1);
	return FALSE;
    }
    
    return TRUE;	/* don't do anything when other key pressed */
}

gboolean cell_hex_focusin(GtkWidget *widget, GdkEventFocus *event, gpointer data) {
    GdkColor *color;

    /* kolor komrki */
    color = color_of_cell(selected_byte);
    gtk_widget_modify_base(g_list_nth(list_cells_hex, selected_byte)->data, GTK_STATE_NORMAL, color);
    gtk_widget_modify_base(g_list_nth(list_cells_ascii, selected_byte)->data, GTK_STATE_NORMAL, color);
    selected_byte = g_list_index(list_cells_hex, widget);
    color->red = color->green = 0xFFFF;
    color->blue = 0;
    gtk_widget_modify_base(widget, GTK_STATE_NORMAL, color);
    gtk_widget_modify_base(g_list_nth(list_cells_ascii, selected_byte)->data, GTK_STATE_NORMAL, color);
    scroll_datatables();
    fill_binary();
    fill_decimal();
    free(color);
    return FALSE;
}

gboolean cell_hex_focusout(GtkWidget *widget, GdkEventFocus *event, gpointer data) {
    gint position = 0;

    /* must have 2 chars, fill with "0"-s at start */
    while (strlen(gtk_editable_get_chars((GtkEditable*) widget, 0, 2)) < 2)
	gtk_editable_insert_text((GtkEditable*) widget, "0", 1, &position);
    /* uppercase */
    gtk_entry_set_text((GtkEntry*) widget,
	    g_ascii_strup(gtk_editable_get_chars((GtkEditable*) widget, 0, 2), 2));
    /* write to data and ascii table */
    frame->data[selected_byte] = hex2int(gtk_editable_get_chars((GtkEditable*) widget, 0, 2));
    fill_one_byte_cells(selected_byte);
    gtk_entry_select_region((GtkEntry*) widget, 0, 0);
    return FALSE;
}

gboolean cell_ascii_keypress(GtkWidget *widget, GdkEventKey *event, gpointer data) {
    GList *next_widget;
    gint position, sel_start, sel_end, cursor_position, num_chars, rows, row_height;
    gboolean selection;
    char *ascii_text, *utf_text;
    GtkAdjustment *adjustment;

    switch (event->keyval) {
	/* go to next cell when 'right' key pressed */
	case GDK_Right:
    	    if ((gtk_editable_get_position((GtkEditable*) widget) == 1) ||
		strlen(gtk_editable_get_chars((GtkEditable*) widget, 0, 1)) == 0) {
		next_widget = (g_list_find(list_cells_ascii, widget))->next;
		if (next_widget != NULL)
		    gtk_widget_grab_focus(next_widget->data);
	    }
	    return FALSE;

	/* go to prev cell when 'left' key pressed */
	case GDK_Left:
	    position = gtk_editable_get_position((GtkEditable*) widget);
	    if ((position == 0) ||
		    ((position > 0) &&
		     (gtk_editable_get_selection_bounds((GtkEditable*) widget, &sel_start, &sel_end)))) {
		next_widget = g_list_find(list_cells_ascii, widget)->prev;
		if (next_widget != NULL)
		    gtk_widget_grab_focus(next_widget->data);
	    }
	    return FALSE;

	/* go to bin table when 'tab' key pressed */
	case GDK_Tab:
	    gtk_widget_grab_focus(table_bin);
	    return TRUE;	/* don't do anything whit this 'tab' keypress */

	/* when 'Up' key pressed */
	case GDK_Up:
	    if (selected_byte >= 16) {
		position = selected_byte - 16;
		next_widget = g_list_nth(list_cells_ascii, position);
		gtk_widget_grab_focus(next_widget->data);
	    }
	    return TRUE;

	/* when 'Down' key pressed */
	case GDK_Down:
	    if (selected_byte < frame->len - 16) {
		position = selected_byte + 16;
		next_widget = g_list_nth(list_cells_ascii, position);
		gtk_widget_grab_focus(next_widget->data);
	    }
	    return TRUE;

	/* when 'home' key pressed */
	case GDK_Home:
	    next_widget = g_list_nth(list_cells_ascii, selected_byte - (selected_byte % 16));
	    gtk_widget_grab_focus(next_widget->data);
	    return FALSE;

	/* when 'end' key pressed */
	case GDK_End:
	    position = selected_byte + 15 - (selected_byte % 16);
	    if (position >= frame->len)
		position = frame->len - 1;
	    next_widget = g_list_nth(list_cells_ascii, position);
	    gtk_widget_grab_focus(next_widget->data);
	    return FALSE;

	/* when 'PgDown' key pressed */
	case GDK_Page_Down:
	    adjustment = gtk_scrolled_window_get_vadjustment((GtkScrolledWindow*) scroll_tables);
	    row_height = adjustment->upper / ceil(g_list_length(list_cells_ascii) / 16);
	    rows = floor(adjustment->page_size / row_height);
	    position = selected_byte + rows * 16;
	    while (position >= frame->len)
		position -= 16;
	    next_widget = g_list_nth(list_cells_ascii, position);
	    gtk_widget_grab_focus(next_widget->data);
	    return FALSE;

	/* when 'PgUp' key pressed */
	case GDK_Page_Up:
	    adjustment = gtk_scrolled_window_get_vadjustment((GtkScrolledWindow*) scroll_tables);
	    row_height = adjustment->upper / ceil(g_list_length(list_cells_ascii) / 16);
	    rows = floor(adjustment->page_size / row_height);
	    position = selected_byte - rows * 16;
	    while (position < 0)
		position += 16;
	    next_widget = g_list_nth(list_cells_ascii, position);
	    gtk_widget_grab_focus(next_widget->data);
	    return FALSE;
    }

    /* insert correct ascii char
    how many chars		0 1 1 1
    cursor at position		0 0 1 1
    selected chars		0 0 0 1
				- n g -
    -  - just print
    n  - overwrite next char
    g  - go to next cell and print there */

    /* alphanumeric key pressed */
    if (event->keyval < 0xFD00) {
	num_chars = strlen(gtk_editable_get_chars((GtkEditable*) widget, 0, 1));
	selection = gtk_editable_get_selection_bounds((GtkEditable*) widget, &sel_start, &sel_end);
	cursor_position = gtk_editable_get_position((GtkEditable*) widget);
	if ((num_chars > 0) && (!selection)) {
	    if (cursor_position == 0)
		/* "n" option above: delete char only */
		gtk_editable_delete_text((GtkEditable*) widget, cursor_position, cursor_position + 1);
	    else {
		/* "g" option above:
		   go to next cell if exists and overwrite it */
		next_widget = g_list_find(list_cells_ascii, widget)->next;
		ascii_text = malloc(2);
		ascii_text[0] = event->keyval;
		ascii_text[1] = 0;
		if (next_widget != NULL) {
		    gtk_widget_grab_focus(next_widget->data);
		    utf_text = ascii2utf(ascii_text);
		    gtk_entry_set_text((GtkEntry*) next_widget->data, utf_text);
		    free(utf_text);
		} else {
		    /* there are no more cells
		       add byte to frame data and create new cell */
		    add_to_frame(1, ascii_text, 0);
		    add_cells_to_tables();
		    next_widget = g_list_find(list_cells_ascii, widget)->next;
		    gtk_widget_grab_focus(next_widget->data);
		}
		free(ascii_text);
		gtk_editable_select_region((GtkEditable*) next_widget->data, 1, 1);
		return TRUE;
	    }
	}
    }
    return FALSE;
}

gboolean cell_ascii_focusin(GtkWidget *widget, GdkEventFocus *event, gpointer data) {
    GdkColor *color;

    /* kolor komrki */
    color = color_of_cell(selected_byte);
    gtk_widget_modify_base(g_list_nth(list_cells_hex, selected_byte)->data, GTK_STATE_NORMAL, color);
    gtk_widget_modify_base(g_list_nth(list_cells_ascii, selected_byte)->data, GTK_STATE_NORMAL, color);
    selected_byte = g_list_index(list_cells_ascii, widget);
    color->red = color->green = 0xFFFF;
    color->blue = 0;
    gtk_widget_modify_base(g_list_nth(list_cells_hex, selected_byte)->data, GTK_STATE_NORMAL, color);
    gtk_widget_modify_base(widget, GTK_STATE_NORMAL, color);
    scroll_datatables();
    fill_binary();
    fill_decimal();
    free(color);
    return FALSE;
}

gboolean cell_ascii_focusout(GtkWidget *widget, GdkEventFocus *event, gpointer data) {
    char *ascii;
    /* write to data and hex table */
    ascii = utf2ascii(gtk_editable_get_chars((GtkEditable*) widget, 0, 1));
    frame->data[selected_byte] = (int) ascii[0];
    free(ascii);
    fill_one_byte_cells(selected_byte);
    fill_binary();
    fill_decimal();
    gtk_entry_select_region((GtkEntry*) widget, 0, 0);
    return FALSE;
}

gboolean cell_bin_keypress(GtkWidget *widget, GdkEventKey *event, gpointer data) {
    gint sel_start, sel_end;
    gboolean selection;

    /* allow for 'left' 'right' 'tab' 'home' 'end' key presses */
    if ((event->keyval == GDK_Right) || (event->keyval == GDK_Left) ||
	(event->keyval == GDK_Home) || (event->keyval == GDK_End) ||
	(event->keyval == GDK_Tab))
	return FALSE;

    /* backspace - change cursor position */
    if (event->keyval == GDK_BackSpace) {
	gtk_editable_get_selection_bounds((GtkEditable*) widget, &sel_start, &sel_end);
	if (sel_start > 0)
	    gtk_editable_select_region((GtkEditable*) widget, sel_start - 1, sel_start);
    }

    /* write bit when '0' or '1' key pressed
    cursor at position		x x x 8 8 8
    selected chars		0 1 x 0 1 x
				n p f - p f
    p  - just print
    n  - overwrite next char
    f  - overwrite first selected char 
    -  - do nothing */
    if ((event->keyval == GDK_0) || (event->keyval == GDK_1)) {
	selection = gtk_editable_get_selection_bounds((GtkEditable*) widget, &sel_start, &sel_end);
	/* 'p' option above */
	if (selection && ((sel_end - sel_start) == 1))
	    return FALSE;
	/* 'f' and 'n' options above */
	if (selection || (sel_start < 8)) {
	    gtk_editable_select_region((GtkEditable*) widget, sel_start, sel_start + 1);
	    return FALSE;
	}
	/* '-' option above */
    }
    return TRUE;	/* do nothing when any other key pressed */
}

gboolean entry_mouseclicked(GtkWidget *widget, GdkEventButton *event, gpointer data) {
    if (event->button != 1)
	return TRUE;
    return FALSE;
}

gboolean cell_bin_focusout(GtkWidget *widget, GdkEventFocus *event, gpointer data) {
    gint position = 0;

    /* must have 8 chars, fill with "0"-s at start */
    while (strlen(gtk_editable_get_chars((GtkEditable*) widget, 0, 8)) < 8)
	gtk_editable_insert_text((GtkEditable*) widget, "0", 1, &position);
    /* write to data and ascii table */
    frame->data[selected_byte] = bin2int(gtk_editable_get_chars((GtkEditable*) widget, 0, 8));
    fill_one_byte_cells(selected_byte);
    fill_decimal();
    return FALSE;
}

gboolean cell_dec_keypress(GtkWidget *widget, GdkEventKey *event, gpointer data) {
    /* allow for 'left' 'right' 'tab' 'home' 'end' 'backspace' 'delete' any number key presses */
    if (((event->keyval >= GDK_0) && (event->keyval <= GDK_9)) ||
	(event->keyval == GDK_Right) || (event->keyval == GDK_Left) ||
	(event->keyval == GDK_Home) || (event->keyval == GDK_End) ||
	(event->keyval == GDK_Tab)) 
	return FALSE;

    return TRUE;	/* do nothing when any other key pressed */
}

gboolean cell_dec_focusout(GtkWidget *widget, GdkEventFocus *event, gpointer data) {
    int value;

    /* write to data and ascii table */
    value = dec2int(gtk_editable_get_chars((GtkEditable*) widget, 0, 3));
    if (value > 255)
	value = 255;
    frame->data[selected_byte] = value;
    fill_one_byte_cells(selected_byte);
    fill_binary();
    fill_decimal();
    return FALSE;
}

void datasize_changed(GtkWidget *widget, gpointer data) {
    int new_datalen;
    GtkWidget *dialog, *label;

    new_datalen = gtk_spin_button_get_value_as_int((GtkSpinButton*) widget);
    if (new_datalen < frame->len) {
	dialog = gtk_dialog_new_with_buttons(_("Warning"),
	    		GTK_WINDOW(window_main), GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
			GTK_STOCK_YES, GTK_RESPONSE_YES,
			GTK_STOCK_NO, GTK_RESPONSE_NO,
			NULL);
	label = gtk_label_new(_("\nFrame size reduction will cause partial data loss.\nAre you sure you want to reduce it?\n"));
	gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), label);
	gtk_widget_show_all(dialog);
	if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_YES) {
	    gtk_widget_destroy(dialog);
	    remove_from_frame(frame->len - new_datalen);
	    remove_cells_from_tables();
	    fill_binary();
	    fill_decimal();
	} else {
	    gtk_widget_destroy(dialog);
	    fill_datasize();
	}
    } else {
	add_to_frame(new_datalen - frame->len, NULL, 0);
	add_cells_to_tables();
    }
}

gboolean datasize_keypress(GtkWidget *widget, GdkEventKey *event, gpointer data) {
    /* go to hex table when 'tab' key pressed */
    if (event->keyval == GDK_Tab) {
	gtk_widget_grab_focus(g_list_nth(list_cells_hex, selected_byte)->data);
	return TRUE;	/* don't do anything whit this 'tab' keypress */
    }
    return FALSE;
}

void buttonaddcrc_clicked(GtkWidget *widget, gpointer data) {
    crc_dialog_create();
    if (gtk_dialog_run(GTK_DIALOG(crc_dialog_window)) == GTK_RESPONSE_OK) {
	crc_dialog_write_frame();
    }
    gtk_widget_destroy(crc_dialog_window);
}

void buttonaddeth_clicked(GtkWidget *widget, gpointer data) {
    eth_dialog_create();
    if (gtk_dialog_run(GTK_DIALOG(eth_dialog_window)) == GTK_RESPONSE_OK) {
	eth_dialog_write_frame();
    }
    gtk_widget_destroy(eth_dialog_window);
}

void buttonaddip_clicked(GtkWidget *widget, gpointer data) {
    if ((frame->ipx_position != -1) || (frame->spx_position != -1)) {
	if (! question_dialog(_("Frame contains IPX or SPX header. IP header insertion will cause removal of current headers.\n\nDo you want to continue?"))) {
	    return;
	}
    }
    ip_dialog_create();
    if (gtk_dialog_run(GTK_DIALOG(ip_dialog_window)) == GTK_RESPONSE_OK) {
	ip_dialog_write_frame();
    }
    gtk_widget_destroy(ip_dialog_window);
}

void buttonaddipcksum_clicked(GtkWidget *widget, gpointer data) {
    if (frame->ip_position == -1) {
	if (! question_dialog(_("Frame doesn't contain IP header.\nDo you want to continue IP checksum inserting?"))) {
	    return;
	}
    }
    ipcksum_dialog_create();
    if (gtk_dialog_run(GTK_DIALOG(ipcksum_dialog_window)) == GTK_RESPONSE_OK) {
	ipcksum_dialog_write_frame();
    }
    gtk_widget_destroy(ipcksum_dialog_window);
}

void buttonaddtcp_clicked(GtkWidget *widget, gpointer data) {
    if ((frame->ipx_position != -1) || (frame->spx_position != -1)) {
	if (! question_dialog(_("Frame contains IPX or SPX header. TCP header insertion will cause removal of current headers.\n\nDo you want to continue?"))) {
	    return;
	}
    }
    if (frame->ip_position == -1) {
	if (! question_dialog(_("Frame doesn't contain IP header. The exact position of TCP header's beginning is currently unknown. Inserting it may cause IP and TCP headers interference.\n\nDo you want to continue?"))) {
	    return;
	}
    }
    tcp_dialog_create();
    if (gtk_dialog_run(GTK_DIALOG(tcp_dialog_window)) == GTK_RESPONSE_OK) {
	tcp_dialog_write_frame();
    }
    gtk_widget_destroy(tcp_dialog_window);
}

void buttonaddudp_clicked(GtkWidget *widget, gpointer data) {
    if ((frame->ipx_position != -1) || (frame->spx_position != -1)) {
	if (! question_dialog(_("Frame contains IPX or SPX header. UDP header insertion will cause removal of current headers.\n\nDo you want to continue?"))) {
	    return;
	}
    }
    if (frame->ip_position == -1) {
	if (! question_dialog(_("Frame doesn't contain IP header. The exact position of UDP header's beginning is currently unknown. Inserting it may cause IP and UDP headers interference.\n\nDo you want to continue?"))) {
	    return;
	}
    }
    udp_dialog_create();
    if (gtk_dialog_run(GTK_DIALOG(udp_dialog_window)) == GTK_RESPONSE_OK) {
	udp_dialog_write_frame();
    }
    gtk_widget_destroy(udp_dialog_window);
}

void buttonaddtcpcksum_clicked(GtkWidget *widget, gpointer data) {
    if (frame->tcp_position == -1) {
	if (! question_dialog(_("Frame doesn't contain TCP header.\nDo you want to continue TCP checksum inserting?"))) {
	    return;
	}
    }
    udpcksum_dialog_create(FALSE);
    if (gtk_dialog_run(GTK_DIALOG(udpcksum_dialog_window)) == GTK_RESPONSE_OK) {
	udpcksum_dialog_write_frame(FALSE);
    }
    gtk_widget_destroy(udpcksum_dialog_window);
}

void buttonaddudpcksum_clicked(GtkWidget *widget, gpointer data) {
    if (frame->udp_position == -1) {
	if (! question_dialog(_("Frame doesn't contain UDP header.\nDo you want to continue UDP checksum inserting?"))) {
	    return;
	}
    }
    udpcksum_dialog_create(TRUE);
    if (gtk_dialog_run(GTK_DIALOG(udpcksum_dialog_window)) == GTK_RESPONSE_OK) {
	udpcksum_dialog_write_frame(TRUE);
    }
    gtk_widget_destroy(udpcksum_dialog_window);
}

void buttonaddipx_clicked(GtkWidget *widget, gpointer data) {
    if ((frame->ip_position != -1) || (frame->tcp_position != -1) || (frame->udp_position != -1)) {
	if (! question_dialog(_("Frame contains IP, TCP or UDP header. IPX header insertion will cause removal of current headers.\n\nDo you want to continue?"))) {
	    return;
	}
    }
    ipx_dialog_create();
    if (gtk_dialog_run(GTK_DIALOG(ipx_dialog_window)) == GTK_RESPONSE_OK) {
	ipx_dialog_write_frame();
    }
    gtk_widget_destroy(ipx_dialog_window);
}

void buttonaddspx_clicked(GtkWidget *widget, gpointer data) {
    if ((frame->ip_position != -1) || (frame->tcp_position != -1) || (frame->udp_position != -1)) {
	if (! question_dialog(_("Frame contains IP, TCP or UDP header. SPX header insertion will cause removal of current headers.\n\nDo you want to continue?"))) {
	    return;
	}
    }
    spx_dialog_create();
    if (gtk_dialog_run(GTK_DIALOG(spx_dialog_window)) == GTK_RESPONSE_OK) {
	spx_dialog_write_frame();
    }
    gtk_widget_destroy(spx_dialog_window);
}

void buttonaddframe_clicked(GtkWidget *widget, gpointer data) {
    frame_t *new_frame;
    int nr_frames;

    addframe_dialog_create();
    if (gtk_dialog_run(GTK_DIALOG(addframe_dialog_window)) == GTK_RESPONSE_OK) {
	nr_frames = g_list_length(all_frames);
	new_frame = malloc(sizeof(frame_t));
	if (gtk_toggle_button_get_active((GtkToggleButton*)addframe_dialog_radio_empty) == TRUE) {
    	    new_frame->data = malloc(1);
	    new_frame->len = 1;
	    new_frame->data[0] = 0;
	    new_frame->eth_position = -1;
	    new_frame->ip_position = -1;
	    new_frame->udp_position = -1;
	    new_frame->tcp_position = -1;
	    new_frame->fcs_position = -1;
	    new_frame->ipx_position = -1;
	    new_frame->spx_position = -1;
	} else {
	    memcpy(new_frame, frame, sizeof(frame_t));
	    new_frame->data = malloc(new_frame->len);
	    memcpy(new_frame->data, frame->data, new_frame->len);
	}
	selected_frame = ((nr_frames > 1)?gtk_spin_button_get_value_as_int((GtkSpinButton*) addframe_dialog_spin_framenr):1) + \
		gtk_combo_box_get_active((GtkComboBox*) addframe_dialog_combo_place) - 1;
	all_frames = g_list_insert(all_frames, new_frame, selected_frame);
	frame = new_frame;
	selected_byte = 0;
	fill_frame_number();
	fill_tables();
	fill_binary();
	fill_decimal();
	fill_datasize();
    }
    gtk_widget_destroy(addframe_dialog_window);
}

void buttondeleteframe_clicked(GtkWidget *widget, gpointer data) {

    if (! question_dialog(_("Frame data will be lost.\nDo you want to continue?"))) {
	return;
    }
    delete_frame();
    if (all_frames == NULL)
	init_frames();
    fill_frame_number();
    fill_tables();
    fill_binary();
    fill_decimal();
    fill_datasize();
}

void buttonremoveframes_clicked(GtkWidget *widget, gpointer data) {

    if (! question_dialog(_("All data will be lost.\nDo you want to continue?"))) {
	return;
    }
    remove_all_frames();
    init_frames();
    fill_frame_number();
    fill_tables();
    fill_binary();
    fill_decimal();
    fill_datasize();
}

void buttonsend_clicked(GtkWidget *widget, gpointer data) {
    send_dialog_create();
    if (gtk_dialog_run(GTK_DIALOG(send_dialog_window)) == GTK_RESPONSE_OK) {
	device = get_iface_name(gtk_combo_box_get_active(GTK_COMBO_BOX(send_dialog_combo_iface)));
	sent_frames = sent_series = 0;
	times = gtk_spin_button_get_value_as_int((GtkSpinButton*) send_dialog_spin_times);
	delay_frames = gtk_spin_button_get_value_as_int((GtkSpinButton*)send_dialog_spin_delayframes);
	delay_series = gtk_spin_button_get_value_as_int((GtkSpinButton*)send_dialog_spin_delayseries);
	gtk_widget_destroy(send_dialog_window);
	send_dialog_inprogress();
	send_timeout_id = g_timeout_add(delay_frames, (GSourceFunc)send_dialog_send, NULL);
    } else
	gtk_widget_destroy(send_dialog_window);
}

/* ========= MAIN MENU HANDLERS ========= */

void menu_file_new(GtkMenuItem *menu_item, gpointer data) {

    if (! question_dialog(_("All data will be lost.\nDo you want to continue?"))) {
	return;
    }
    gtk_widget_grab_focus(list_cells_hex->data);
    remove_all_frames();
    init_frames();
    fill_frame_number();
    fill_tables();
    fill_binary();
    fill_decimal();
    fill_datasize();
}

void menu_file_open(GtkMenuItem *menu_item, gpointer data) {
    GtkWidget *error_message;

    if (! question_dialog(_("All data will be lost.\nDo you want to continue?"))) {
	return;
    }
    if (open_dialog(_("Open"))) {
	remove_all_frames();
	if (! read_from_file()) {
	    error_message = gtk_message_dialog_new(GTK_WINDOW(window_main),
		                    GTK_DIALOG_DESTROY_WITH_PARENT,
				    GTK_MESSAGE_ERROR,
                                    GTK_BUTTONS_CLOSE,
                                    _("Data reading error.\n\
Possible causes:\n\
- no file access perrmissions\n\
- wrong file format"));
    	    gtk_dialog_run(GTK_DIALOG(error_message));
	    gtk_widget_destroy(error_message);
	}
	fill_frame_number();
	fill_tables();
	fill_binary();
	fill_decimal();
	fill_datasize();
    }
}

void menu_file_save(GtkMenuItem *menu_item, gpointer data) {

    gboolean save;
    if (strlen(file_name) == 0) {
	save = saveas_dialog(_("Save"));	/* is accepted? */
    } else
	save = TRUE;
    if (save)
	save_to_file();
}

void menu_file_saveas(GtkMenuItem *menu_item, gpointer data) {
    if (saveas_dialog(_("Save as...")))
        save_to_file();
}

void menu_file_exit(GtkMenuItem *menu_item, gpointer data) {

    if (! question_dialog(_("All data will be lost.\nDo you want to continue?"))) {
	return;
    }
    gtk_widget_hide(window_main);
    remove_framedata();
    remove_cells_from_tables();
    remove_all_frames();
    gtk_main_quit ();
}

void menu_add_eth(GtkWidget *menu_item, gpointer data) {
    eth_dialog_create();
    if (gtk_dialog_run(GTK_DIALOG(eth_dialog_window)) == GTK_RESPONSE_OK) {
	eth_dialog_write_frame();
    }
    gtk_widget_destroy(eth_dialog_window);
}

void menu_add_crc(GtkWidget *menu_item, gpointer data) {
    crc_dialog_create();
    if (gtk_dialog_run(GTK_DIALOG(crc_dialog_window)) == GTK_RESPONSE_OK) {
	crc_dialog_write_frame();
    }
    gtk_widget_destroy(crc_dialog_window);
}

void menu_add_ip(GtkWidget *menu_item, gpointer data) {
    if ((frame->ipx_position != -1) || (frame->spx_position != -1)) {
	if (! question_dialog(_("Frame contains IPX or SPX header. IP header insertion will cause removal of current headers.\n\nDo you want to continue?"))) {
	    return;
	}
    }
    ip_dialog_create();
    if (gtk_dialog_run(GTK_DIALOG(ip_dialog_window)) == GTK_RESPONSE_OK) {
	ip_dialog_write_frame();
    }
    gtk_widget_destroy(ip_dialog_window);
}

void menu_add_ipcksum(GtkWidget *menu_item, gpointer data) {
    if (frame->ip_position == -1) {
	if (! question_dialog(_("Frame doesn't contain IP header.\nDo you want to continue IP checksum inserting?"))) {
	    return;
	}
    }
    ipcksum_dialog_create();
    if (gtk_dialog_run(GTK_DIALOG(ipcksum_dialog_window)) == GTK_RESPONSE_OK) {
	ipcksum_dialog_write_frame();
    }
    gtk_widget_destroy(ipcksum_dialog_window);
}

void menu_add_tcp(GtkWidget *menu_item, gpointer data) {
    if ((frame->ipx_position != -1) || (frame->spx_position != -1)) {
	if (! question_dialog(_("Frame contains IPX or SPX header. TCP header insertion will cause removal of current headers.\n\nDo you want to continue?"))) {
	    return;
	}
    }
    if (frame->ip_position == -1) {
	if (! question_dialog(_("Frame doesn't contain IP header. The exact position of TCP header's beginning is currently unknown. Inserting it may cause IP and TCP headers interference.\n\nDo you want to continue?"))) {
	    return;
	}
    }
    tcp_dialog_create();
    if (gtk_dialog_run(GTK_DIALOG(tcp_dialog_window)) == GTK_RESPONSE_OK) {
	tcp_dialog_write_frame();
    }
    gtk_widget_destroy(tcp_dialog_window);
}

void menu_add_udp(GtkWidget *menu_item, gpointer data) {
    if ((frame->ipx_position != -1) || (frame->spx_position != -1)) {
	if (! question_dialog(_("Frame contains IPX or SPX header. UDP header insertion will cause removal of current headers.\n\nDo you want to continue?"))) {
	    return;
	}
    }
    if (frame->ip_position == -1) {
	if (! question_dialog(_("Frame doesn't contain IP header. The exact position of UDP header's beginning is currently unknown. Inserting it may cause IP and UDP headers interference.\n\nDo you want to continue?"))) {
	    return;
	}
    }
    udp_dialog_create();
    if (gtk_dialog_run(GTK_DIALOG(udp_dialog_window)) == GTK_RESPONSE_OK) {
	udp_dialog_write_frame();
    }
    gtk_widget_destroy(udp_dialog_window);
}

void menu_add_tcpcksum(GtkWidget *menu_item, gpointer data) {
    if (frame->tcp_position == -1) {
	if (! question_dialog(_("Frame doesn't contain TCP header.\nDo you want to continue TCP checksum inserting?"))) {
	    return;
	}
    }
    udpcksum_dialog_create(FALSE);
    if (gtk_dialog_run(GTK_DIALOG(udpcksum_dialog_window)) == GTK_RESPONSE_OK) {
	udpcksum_dialog_write_frame(FALSE);
    }
    gtk_widget_destroy(udpcksum_dialog_window);
}

void menu_add_udpcksum(GtkWidget *menu_item, gpointer data) {
    if (frame->udp_position == -1) {
	if (! question_dialog(_("Frame doesn't contain UDP header.\nDo you want to continue UDP checksum inserting?"))) {
	    return;
	}
    }
    udpcksum_dialog_create(TRUE);
    if (gtk_dialog_run(GTK_DIALOG(udpcksum_dialog_window)) == GTK_RESPONSE_OK) {
	udpcksum_dialog_write_frame(TRUE);
    }
    gtk_widget_destroy(udpcksum_dialog_window);
}

void menu_add_ipx(GtkWidget *menu_item, gpointer data) {
    if ((frame->ip_position != -1) || (frame->tcp_position != -1) || (frame->udp_position != -1)) {

	if (! question_dialog(_("Frame contains IP, TCP or UDP header. IPX header insertion will cause removal of current headers.\n\nDo you want to continue?"))) {
	    return;
	}
    }
    ipx_dialog_create();
    if (gtk_dialog_run(GTK_DIALOG(ipx_dialog_window)) == GTK_RESPONSE_OK) {
	ipx_dialog_write_frame();
    }
    gtk_widget_destroy(ipx_dialog_window);
}

void menu_add_spx(GtkWidget *menu_item, gpointer data) {
    if ((frame->ip_position != -1) || (frame->tcp_position != -1) || (frame->udp_position != -1)) {
	if (! question_dialog(_("Frame contains IP, TCP or UDP header. SPX header insertion will cause removal of current headers.\n\nDo you want to continue?"))) {
	    return;
	}
    }
    spx_dialog_create();
    if (gtk_dialog_run(GTK_DIALOG(spx_dialog_window)) == GTK_RESPONSE_OK) {
	spx_dialog_write_frame();
    }
    gtk_widget_destroy(spx_dialog_window);
}

void menu_frames_add(GtkMenuItem *menu_item, gpointer data) {
    frame_t *new_frame;
    int nr_frames;

    addframe_dialog_create();
    if (gtk_dialog_run(GTK_DIALOG(addframe_dialog_window)) == GTK_RESPONSE_OK) {
	nr_frames = g_list_length(all_frames);
	new_frame = malloc(sizeof(frame_t));
	if (gtk_toggle_button_get_active((GtkToggleButton*)addframe_dialog_radio_empty) == TRUE) {
    	    new_frame->data = malloc(1);
	    new_frame->len = 1;
	    new_frame->data[0] = 0;
	    new_frame->eth_position = -1;
	    new_frame->ip_position = -1;
	    new_frame->udp_position = -1;
	    new_frame->tcp_position = -1;
	    new_frame->fcs_position = -1;
	    new_frame->ipx_position = -1;
	    new_frame->spx_position = -1;
	} else {
	    memcpy(new_frame, frame, sizeof(frame_t));
	    new_frame->data = malloc(new_frame->len);
	    memcpy(new_frame->data, frame->data, new_frame->len);
	}
	selected_frame = ((nr_frames > 1)?gtk_spin_button_get_value_as_int((GtkSpinButton*) addframe_dialog_spin_framenr):1) + \
		gtk_combo_box_get_active((GtkComboBox*) addframe_dialog_combo_place) - 1;
	all_frames = g_list_insert(all_frames, new_frame, selected_frame);
	frame = new_frame;
	selected_byte = 0;
	fill_frame_number();
	fill_tables();
	fill_binary();
	fill_decimal();
	fill_datasize();
    }
    gtk_widget_destroy(addframe_dialog_window);
}

void menu_frames_delete(GtkMenuItem *menu_item, gpointer data) {

    if (! question_dialog(_("Frame data will be lost.\nDo you want to continue?"))) {
	return;
    }
    delete_frame();
    if (all_frames == NULL)
	init_frames();
    fill_frame_number();
    fill_tables();
    fill_binary();
    fill_decimal();
    fill_datasize();
}

void menu_frames_remove(GtkMenuItem *menu_item, gpointer data) {

    if (! question_dialog(_("All data will be lost.\nDo you want to continue?"))) {
	return;
    }
    remove_all_frames();
    init_frames();
    fill_frame_number();
    fill_tables();
    fill_binary();
    fill_decimal();
    fill_datasize();
}

void menu_frames_send(GtkMenuItem *menu_item, gpointer data) {
    send_dialog_create();
    if (gtk_dialog_run(GTK_DIALOG(send_dialog_window)) == GTK_RESPONSE_OK) {
	device = get_iface_name(gtk_combo_box_get_active(GTK_COMBO_BOX(send_dialog_combo_iface)));
	sent_frames = sent_series = 0;
	times = gtk_spin_button_get_value_as_int((GtkSpinButton*) send_dialog_spin_times);
	delay_frames = gtk_spin_button_get_value_as_int((GtkSpinButton*)send_dialog_spin_delayframes);
	delay_series = gtk_spin_button_get_value_as_int((GtkSpinButton*)send_dialog_spin_delayseries);
	gtk_widget_destroy(send_dialog_window);
	send_dialog_inprogress();
	send_timeout_id = g_timeout_add(delay_frames, (GSourceFunc)send_dialog_send, NULL);
    } else
	gtk_widget_destroy(send_dialog_window);
}

void menu_help_about(GtkMenuItem *menu_item, gpointer data) {
    about_dialog_create();
    gtk_dialog_run(GTK_DIALOG(about_dialog_window));
    gtk_widget_destroy(about_dialog_window);
}
