/* $Id: gui-GTK_ip-dialog.c,v 1.4 2005/03/20 22:26:54 emvi Exp $ */

/* 
Copyright (C) 2005 Marek Wardziski (emvi at emvi eu org) 
 
This file is part of Ant. 
 
Ant is free software; you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation; either version 2 of the License, or 
(at your option) any later version. 
 
Ant is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
GNU General Public License for more details. 
 
You should have received a copy of the GNU General Public License 
along with Ant; if not, write to the Free Software 
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "main.h"
#include "misc.h"
#include "net.h"

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "gui-GTK.h"
#include "gui-GTK_handlers.h"

GtkWidget *ip_dialog_window;
GtkWidget *ip_dialog_label1;
GtkWidget *ip_dialog_hbox1;
GtkWidget *ip_dialog_checkversion;
GtkWidget *ip_dialog_comboversion;
GtkWidget *ip_dialog_hbox2;
GtkWidget *ip_dialog_checkhlen;
GtkWidget *ip_dialog_combohlen;
GtkWidget *ip_dialog_hbox3;
GtkWidget *ip_dialog_checktos;
GtkWidget *ip_dialog_frametos;
GtkWidget *ip_dialog_vbox1;
GtkWidget *ip_dialog_label2;
GtkWidget *ip_dialog_comboprecedence;
GtkWidget *ip_dialog_vbox3;
GtkWidget *ip_dialog_checktosd;
GtkWidget *ip_dialog_checktost;
GtkWidget *ip_dialog_checktosr;
GtkWidget *ip_dialog_checktosm;
GtkWidget *ip_dialog_checktos0;
GtkWidget *ip_dialog_hbox4;
GtkWidget *ip_dialog_checklen;
GtkWidget *ip_dialog_len;
GtkWidget *ip_dialog_hbox5;
GtkWidget *ip_dialog_checkid;
GtkWidget *ip_dialog_id;
GtkWidget *ip_dialog_hbox6;
GtkWidget *ip_dialog_checkflags;
GtkWidget *ip_dialog_frameflags;
GtkWidget *ip_dialog_vbox2;
GtkWidget *ip_dialog_checkflagr;
GtkWidget *ip_dialog_checkflagdf;
GtkWidget *ip_dialog_checkflagmf;
GtkWidget *ip_dialog_hbox7;
GtkWidget *ip_dialog_checkoffset;
GtkWidget *ip_dialog_offset;
GtkWidget *ip_dialog_hbox8;
GtkWidget *ip_dialog_checkttl;
GtkWidget *ip_dialog_ttl;
GtkWidget *ip_dialog_hbox9;
GtkWidget *ip_dialog_checkprotocol;
GtkWidget *ip_dialog_comboprotocol;
GtkWidget *ip_dialog_protocol;
GtkWidget *ip_dialog_hbox10;
GtkWidget *ip_dialog_checksourceip;
GtkWidget *ip_dialog_combosourceip;
GtkWidget *ip_dialog_sourceip;
GtkWidget *ip_dialog_hbox11;
GtkWidget *ip_dialog_checkdestip;
GtkWidget *ip_dialog_destip;
GtkWidget *ip_dialog_label3;
GtkWidget *ip_dialog_hbox12;
GtkWidget *ip_dialog_radioatip;
GtkWidget *ip_dialog_radioatcursor;

GtkWidget *ip_dialog_buttonget;

char* table_versions[] = { N_("0"), N_("1"), N_("2"), N_("3"), N_("4 - IPv4"), N_("5"), N_("6 - IPv6"), N_("7"),
			   N_("8"), N_("9"), N_("10"), N_("11"), N_("12"), N_("13"), N_("14"), N_("15"), NULL};

char* table_hlens[] = { N_("0 (0 bytes)"), N_("1 (4 bytes)"), N_("2 (8 bytes)"), N_("3 (12 bytes)"),
			N_("4 (16 bytes)"), N_("5 (20 bytes)"), N_("6 (24 bytes)"), N_("7 (28 bytes)"),
			N_("8 (32 bytes)"), N_("9 (36 bytes)"), N_("10 (40 bytes)"), N_("11 (44 bytes)"),
			N_("12 (48 bytes)"), N_("13 (52 bytes)"), N_("14 (56 bytes)"), N_("15 (60 bytes)"), NULL};

char* table_precedences[] = {N_("0 - Routine"), N_("1 - Priority"), N_("2 - Immediate"), N_("3 - Flash"),
			     N_("4 - Flash override"), N_("5 - CRITIC/ECP"), N_("6 - Internetwork control"),
			     N_("7 - Network control"), NULL};
char* table_protocols[] = {N_("1 - ICMP, Internet Control Message Protocol"),
			   N_("6 - TCP, Transmission Control Protocol"),
			   N_("17 - UDP, User Datagram Protocol"),
			   N_("41 - IPv6 over IPv4"), NULL};

void ip_dialog_checkversion_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(ip_dialog_comboversion, gtk_toggle_button_get_active(widget));
}

void ip_dialog_checkhlen_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(ip_dialog_combohlen, gtk_toggle_button_get_active(widget));
}

void ip_dialog_checktos_toggled(GtkToggleButton *widget, gpointer data) {
    gboolean active;
    active = gtk_toggle_button_get_active(widget);
    gtk_widget_set_sensitive(ip_dialog_comboprecedence, active);
    gtk_widget_set_sensitive(ip_dialog_checktosd, active);
    gtk_widget_set_sensitive(ip_dialog_checktost, active);
    gtk_widget_set_sensitive(ip_dialog_checktosr, active);
    gtk_widget_set_sensitive(ip_dialog_checktosm, active);
    gtk_widget_set_sensitive(ip_dialog_checktos0, active);
}

void ip_dialog_checklen_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(ip_dialog_len, gtk_toggle_button_get_active(widget));
}

void ip_dialog_checkid_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(ip_dialog_id, gtk_toggle_button_get_active(widget));
}

void ip_dialog_checkflags_toggled(GtkToggleButton *widget, gpointer data) {
    gboolean active;
    active = gtk_toggle_button_get_active(widget);
    gtk_widget_set_sensitive(ip_dialog_checkflagr, active);
    gtk_widget_set_sensitive(ip_dialog_checkflagdf, active);
    gtk_widget_set_sensitive(ip_dialog_checkflagmf, active);
}

void ip_dialog_checkoffset_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(ip_dialog_offset, gtk_toggle_button_get_active(widget));
}

void ip_dialog_checkttl_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(ip_dialog_ttl, gtk_toggle_button_get_active(widget));
}

void ip_dialog_checkprotocol_toggled(GtkToggleButton *widget, gpointer data) {
    gboolean active;
    active = gtk_toggle_button_get_active(widget);
    gtk_widget_set_sensitive(ip_dialog_comboprotocol, active);
    gtk_widget_set_sensitive(ip_dialog_protocol, active &
		(gtk_combo_box_get_active(GTK_COMBO_BOX(ip_dialog_comboprotocol)) == 0));
}

void ip_dialog_comboprotocol_changed(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(ip_dialog_protocol,
		(gtk_combo_box_get_active(GTK_COMBO_BOX(ip_dialog_comboprotocol)) == 0));
}

void ip_dialog_checksourceip_toggled(GtkToggleButton *widget, gpointer data) {
    gboolean active;
    active = gtk_toggle_button_get_active(widget);
    gtk_widget_set_sensitive(ip_dialog_combosourceip, active);
    gtk_widget_set_sensitive(ip_dialog_sourceip, active &
		(gtk_combo_box_get_active(GTK_COMBO_BOX(ip_dialog_combosourceip)) == 0));
}

void ip_dialog_combosourceip_changed(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(ip_dialog_sourceip,
		(gtk_combo_box_get_active(GTK_COMBO_BOX(ip_dialog_combosourceip)) == 0));
}

void ip_dialog_checkdestip_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(ip_dialog_destip, gtk_toggle_button_get_active(widget));
}


gboolean ip_dialog_ip_keypress(GtkWidget *widget, GdkEventKey *event, gpointer data) {
    gint sel_start, sel_end;
    gboolean selection;
    char *text;
    gchar **ip;
    int i, len = 0, val = 0, ip_byte = 0, ip_pos = 0;

    /* allow for 'left' 'right' 'tab' 'home' 'end' key presses */
    if ((event->keyval == GDK_Right) || (event->keyval == GDK_Left) ||
	(event->keyval == GDK_Home) || (event->keyval == GDK_End) ||
	(event->keyval == GDK_Tab))
	return FALSE;

    if (((event->keyval >= GDK_0) && (event->keyval <= GDK_9)) ||
	(event->keyval == GDK_period) || (event->keyval == GDK_Delete) ||
	(event->keyval == GDK_BackSpace)) {

	selection = gtk_editable_get_selection_bounds((GtkEditable*) widget, &sel_start, &sel_end);
	sel_end -= sel_start;
	/* split address to single bytes */
	ip = g_strsplit(gtk_entry_get_text(GTK_ENTRY(widget)), ".", 4);
	/* find cursor position (nr of byte, nr of digit in byte) */
	ip_pos = sel_start;
	ip_byte = 0;
	for (i = 0; (i < 4) && (ip_pos > strlen(ip[i])); i++) {
	    ip_byte++;
	    ip_pos -= (strlen(ip[i]) + 1);
	}
	/* . pressed - go to first digit in next byte */
	if (event->keyval == GDK_period) {
	    if (ip_byte < 3) {
		ip_byte++;
		ip_pos = 0;
	    }
	    sel_end = strlen(ip[ip_byte]);
	}

	/* backspace */
	if (event->keyval == GDK_BackSpace) {
	    /* select 1 byte left if no selection */
	    if (selection)
		sel_end = 1;
	    else {
		ip_pos--;
		if (ip_pos < 0) {
		    if (ip_byte > 0) {
			ip_pos = strlen(ip[--ip_byte]) - 1;
			sel_end = 1;
		    } else {
			ip_pos = 0;
			sel_end = 0;
		    }
		} else
		    sel_end = 1;
	    }
	}

	/* delete */
	if (event->keyval == GDK_Delete) {
	    if (sel_end == 0)
		sel_end = 1;
	    if (ip_pos == strlen(ip[ip_byte])) {
		if (ip_byte < 3) {
		    ip_byte++;
		    ip_pos = 0;
		    sel_end = 1;
		} else
		    sel_end = 0;
	    }
	    if (sel_end > strlen(ip[ip_byte]) - ip_pos)
		sel_end = strlen(ip[ip_byte]) - ip_pos;
	}

	/* any digit */
	if ((event->keyval >= GDK_0) && (event->keyval <= GDK_9)) {
	    /* skip . if  */
	    if ((ip_pos == 3) && (strlen(ip[ip_byte]) == 3)) {
		/* stop if end of string */
		if (ip_byte == 3)
		    return TRUE;
		ip_byte++;
		ip_pos = 0;
		sel_end = strlen(ip[ip_byte]);
	    }
	    if (sel_end > strlen(ip[ip_byte]))
		sel_end = strlen(ip[ip_byte]);
	    if ((ip_pos < 3) && ((strlen(ip[ip_byte]) == 3) || (sel_end > 0)))
		if (sel_end == 0)
		    sel_end++;
	}

	/* remove selected & insert new */
	if (event->keyval != GDK_period) {
	    text = malloc(15);
	    memcpy(text, ip[ip_byte], ip_pos);
	    memcpy(text + ip_pos, event->string, strlen(event->string));
	    memcpy(text + ip_pos + strlen(event->string), ip[ip_byte] + ip_pos + sel_end, strlen(ip[ip_byte]) - ip_pos);
	    text[strlen(ip[ip_byte]) + strlen(event->string) - sel_end] = 0;
	    ip[ip_byte] = text;
	    /* FIXIT
	    free(text);*/

	    /* move cursor */
	    ip_pos += strlen(event->string);
	    if (ip_pos > strlen(ip[ip_byte])) {
		if (ip_byte < 3) {
		    ip_pos = 0;
		    ip_byte++;
		} else
		    ip_pos = strlen(ip[ip_byte]);
	    }
	    for (i = 0; i < 4; i++) {
		len = strlen(ip[i]);
		if (len == 0)
		    ip[i] = "0";
		val = dec2int(ip[i]);
		if (val > 255)
		    val = 255;
		ip[i] = int2dec(val);
		/* FIXIT: free(ip[i]) ? */
		if (ip_byte == i) {
		    if (ip_pos > 0) {
			ip_pos -= (len - strlen(ip[i]));
			if (ip_pos < 0)
			    ip_pos = 0;
		    }
		    ip_pos += ((len == 0) && (event->keyval == GDK_Delete));
		    if (ip_pos + sel_end > strlen(ip[i]))
			sel_end = strlen(ip[i]) - ip_pos;
		}
	    }
	}

	/* join bytes to address */
	text = ascii2utf(g_strjoinv(".", ip));
	gtk_entry_set_text(GTK_ENTRY(widget), text);
	free(text);

	/* set cursor position */
	if ((event->keyval == GDK_BackSpace) || (event->keyval == GDK_Delete))
	    sel_end = 0;
	sel_start = i = 0;
	while (i < ip_byte)
	    sel_start += strlen(ip[i++]) + 1;
	sel_start += ip_pos;
	gtk_editable_select_region((GtkEditable*) widget, sel_start, sel_start + sel_end);

	g_strfreev(ip);
    }
    return TRUE;        /* don't do anything when other key pressed */
}

void ip_dialog_buttonget_clicked(GtkWidget *widget, gpointer data) {
    int i;
    char *text;
    gchar **ip;
    int position = 0;

    /* position in frame */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_radioatcursor))
        position = selected_byte;
    else if (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_radioatip))
	position = 14;

    if (frame->len > position) {
	/* set version */
	gtk_combo_box_set_active(GTK_COMBO_BOX(ip_dialog_comboversion), frame->data[position] >> 4);
	/* set header len */
	gtk_combo_box_set_active(GTK_COMBO_BOX(ip_dialog_combohlen), frame->data[position] & 0x0F);
    }
    position++;

    /* set TOS */
    if (frame->len > position) {
	gtk_combo_box_set_active(GTK_COMBO_BOX(ip_dialog_comboprecedence), frame->data[position] >> 5);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ip_dialog_checktosd), (frame->data[position] & 0x10) > 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ip_dialog_checktost), (frame->data[position] & 0x08) > 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ip_dialog_checktosr), (frame->data[position] & 0x04) > 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ip_dialog_checktosm), (frame->data[position] & 0x02) > 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ip_dialog_checktos0), (frame->data[position] & 0x01) > 0);
    }
    position++;

    /* set len */
    if (frame->len > position + 1)
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(ip_dialog_len),
				(frame->data[position] << 8) + frame->data[position + 1]);
    position += 2;

    /* set id */
    if (frame->len > position + 1)
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(ip_dialog_id),
				(frame->data[position] << 8) + frame->data[position + 1]);
    position += 2;

    /* set flags */
    if (frame->len > position) {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ip_dialog_checkflagr), (frame->data[position] & 0x80) > 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ip_dialog_checkflagdf), (frame->data[position] & 0x40) > 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ip_dialog_checkflagmf), (frame->data[position] & 0x20) > 0);
    }

    /* set offset */
    if (frame->len > position + 1)
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(ip_dialog_offset),
			((frame->data[position] & 0x1F) << 11) + (frame->data[position + 1] << 3));
    position += 2;

    /* set TTL */
    if (frame->len > position)
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(ip_dialog_ttl), frame->data[position]);
    position++;

    /* set protocol */
    if (frame->len > position) {
	gtk_combo_box_set_active(GTK_COMBO_BOX(ip_dialog_comboprotocol), 0);
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(ip_dialog_protocol), frame->data[position]);
	gtk_widget_set_sensitive(ip_dialog_protocol, gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_checkprotocol));
    }
    /* skip ip checksum */
    position += 3;

    /* set source ip */
    if (frame->len > position + 3) {
	gtk_combo_box_set_active(GTK_COMBO_BOX(ip_dialog_combosourceip), 0);
	ip = g_strsplit(gtk_entry_get_text(GTK_ENTRY(ip_dialog_sourceip)), ".", 4);
	for (i = 0; i < 4; i++)
	    ip[i] = int2dec(frame->data[position++]);
        text = ascii2utf(g_strjoinv(".", ip));
	gtk_entry_set_text(GTK_ENTRY(ip_dialog_sourceip), text);
	gtk_widget_set_sensitive(ip_dialog_sourceip, gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_checksourceip));
	free(text);
	g_strfreev(ip);
    }

    /* set destination ip */
    if (frame->len > position + 3) {
	ip = g_strsplit(gtk_entry_get_text(GTK_ENTRY(ip_dialog_destip)), ".", 4);
	for (i = 0; i < 4; i++)
	    ip[i] = int2dec(frame->data[position++]);
	text = ascii2utf(g_strjoinv(".", ip));
	gtk_entry_set_text(GTK_ENTRY(ip_dialog_destip), text);
	free(text);
    }
}

void ip_dialog_create() {
    int i, selected;
    char *text;

    ip_dialog_window = gtk_dialog_new_with_buttons(_("Add IP header"),
			    GTK_WINDOW(window_main),
			    GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                	    GTK_STOCK_OK, GTK_RESPONSE_OK,
                	    NULL);
    ip_dialog_buttonget = gtk_button_new_with_label(_("Get values from frame"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ip_dialog_window)->action_area), ip_dialog_buttonget, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(ip_dialog_buttonget), "clicked", G_CALLBACK(ip_dialog_buttonget_clicked), NULL);
    gtk_dialog_add_button(GTK_DIALOG(ip_dialog_window), GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL);

    ip_dialog_label1 = gtk_label_new(_("Create header containing"));

    ip_dialog_hbox1 = gtk_hbox_new(TRUE, 5);
    ip_dialog_checkversion = gtk_check_button_new_with_label(_("Version"));
    gtk_toggle_button_set_active((GtkToggleButton*) ip_dialog_checkversion, TRUE);
    g_signal_connect(G_OBJECT(ip_dialog_checkversion), "toggled", G_CALLBACK(ip_dialog_checkversion_toggled), NULL);

    ip_dialog_comboversion = gtk_combo_box_new_text();
    i = 0;
    while (table_versions[i] != NULL)
	gtk_combo_box_append_text((GtkComboBox*) ip_dialog_comboversion, _(table_versions[i++]));
    gtk_combo_box_set_active((GtkComboBox*) ip_dialog_comboversion, 4);
    gtk_box_pack_start(GTK_BOX(ip_dialog_hbox1), ip_dialog_checkversion, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(ip_dialog_hbox1), ip_dialog_comboversion, TRUE, TRUE, 0);

    ip_dialog_hbox2 = gtk_hbox_new(TRUE, 5);
    ip_dialog_checkhlen = gtk_check_button_new_with_label(_("Internet Header Length"));
    gtk_toggle_button_set_active((GtkToggleButton*) ip_dialog_checkhlen, TRUE);
    g_signal_connect(G_OBJECT(ip_dialog_checkhlen), "toggled", G_CALLBACK(ip_dialog_checkhlen_toggled), NULL);

    ip_dialog_combohlen = gtk_combo_box_new_text();
    i = 0;
    while (table_hlens[i] != NULL)
	gtk_combo_box_append_text((GtkComboBox*) ip_dialog_combohlen, _(table_hlens[i++]));
    gtk_combo_box_set_active((GtkComboBox*) ip_dialog_combohlen, 5);
    gtk_box_pack_start(GTK_BOX(ip_dialog_hbox2), ip_dialog_checkhlen, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(ip_dialog_hbox2), ip_dialog_combohlen, TRUE, TRUE, 0);

    ip_dialog_checktos = gtk_check_button_new_with_label(_("Type Of Service"));
    gtk_toggle_button_set_active((GtkToggleButton*) ip_dialog_checktos, TRUE);
    ip_dialog_frametos = gtk_frame_new(_("Type of service"));
    ip_dialog_vbox1 = gtk_vbox_new(FALSE, 0);
    ip_dialog_hbox3 = gtk_hbox_new(TRUE, 5);
    ip_dialog_label2 = gtk_label_new(_("Precedence"));
    ip_dialog_comboprecedence = gtk_combo_box_new_text();
    i = 0;
    while (table_precedences[i] != NULL)
	gtk_combo_box_append_text((GtkComboBox*) ip_dialog_comboprecedence, _(table_precedences[i++]));
    gtk_combo_box_set_active((GtkComboBox*) ip_dialog_comboprecedence, 0);
    ip_dialog_checktosd = gtk_check_button_new_with_label(_("Low delay"));
    ip_dialog_checktost = gtk_check_button_new_with_label(_("High throughput"));
    ip_dialog_checktosr = gtk_check_button_new_with_label(_("High reliability"));
    ip_dialog_checktosm = gtk_check_button_new_with_label(_("Minimize monetary cost"));
    ip_dialog_checktos0 = gtk_check_button_new_with_label(_("Reserved"));
    gtk_container_add(GTK_CONTAINER(ip_dialog_frametos), ip_dialog_vbox1);
    gtk_box_pack_start(GTK_BOX(ip_dialog_vbox1), ip_dialog_hbox3, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ip_dialog_hbox3), ip_dialog_label2, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ip_dialog_hbox3), ip_dialog_comboprecedence, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ip_dialog_vbox1), ip_dialog_checktosd, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(ip_dialog_vbox1), ip_dialog_checktost, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(ip_dialog_vbox1), ip_dialog_checktosr, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(ip_dialog_vbox1), ip_dialog_checktosm, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(ip_dialog_vbox1), ip_dialog_checktos0, FALSE, FALSE, 0);
    g_signal_connect(G_OBJECT(ip_dialog_checktos), "toggled", G_CALLBACK(ip_dialog_checktos_toggled), NULL);

    ip_dialog_hbox4 = gtk_hbox_new(TRUE, 5);
    ip_dialog_checklen = gtk_check_button_new_with_label(_("Total length of datagram"));
    gtk_toggle_button_set_active((GtkToggleButton*) ip_dialog_checklen, TRUE);
    ip_dialog_len = gtk_spin_button_new_with_range(0, 65535, 1);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(ip_dialog_len), TRUE);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ip_dialog_len), frame->len - 14);
    gtk_entry_set_alignment(GTK_ENTRY(ip_dialog_len), 1);
    gtk_box_pack_start(GTK_BOX(ip_dialog_hbox4), ip_dialog_checklen, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(ip_dialog_hbox4), ip_dialog_len, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(ip_dialog_checklen), "toggled", G_CALLBACK(ip_dialog_checklen_toggled), NULL);
    
    ip_dialog_hbox5 = gtk_hbox_new(TRUE, 5);
    ip_dialog_checkid = gtk_check_button_new_with_label(_("Identification"));
    gtk_toggle_button_set_active((GtkToggleButton*) ip_dialog_checkid, TRUE);
    ip_dialog_id = gtk_spin_button_new_with_range(0, 65535, 1);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(ip_dialog_id), TRUE);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ip_dialog_id), random() % 65536);
    gtk_entry_set_alignment(GTK_ENTRY(ip_dialog_id), 1);
    gtk_box_pack_start(GTK_BOX(ip_dialog_hbox5), ip_dialog_checkid, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(ip_dialog_hbox5), ip_dialog_id, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(ip_dialog_checkid), "toggled", G_CALLBACK(ip_dialog_checkid_toggled), NULL);

    ip_dialog_hbox6 = gtk_hbox_new(TRUE, 5);
    ip_dialog_checkflags = gtk_check_button_new_with_label(_("Flags"));
    gtk_toggle_button_set_active((GtkToggleButton*) ip_dialog_checkflags, TRUE);
    ip_dialog_frameflags = gtk_frame_new(_("Flags"));
    ip_dialog_vbox2 = gtk_vbox_new(TRUE, 5);
    ip_dialog_checkflagr = gtk_check_button_new_with_label(_("Reserved"));
    ip_dialog_checkflagdf = gtk_check_button_new_with_label(_("Don't fragment"));
    ip_dialog_checkflagmf = gtk_check_button_new_with_label(_("More fragments"));
    gtk_box_pack_start(GTK_BOX(ip_dialog_vbox2), ip_dialog_checkflagr, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ip_dialog_vbox2), ip_dialog_checkflagdf, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ip_dialog_vbox2), ip_dialog_checkflagmf, TRUE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(ip_dialog_frameflags), ip_dialog_vbox2);
    gtk_box_pack_start(GTK_BOX(ip_dialog_hbox6), ip_dialog_checkflags, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(ip_dialog_hbox6), ip_dialog_frameflags, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(ip_dialog_checkflags), "toggled", G_CALLBACK(ip_dialog_checkflags_toggled), NULL);

    ip_dialog_hbox7 = gtk_hbox_new(TRUE, 5);
    ip_dialog_checkoffset = gtk_check_button_new_with_label(_("Fragment Offset"));
    gtk_toggle_button_set_active((GtkToggleButton*) ip_dialog_checkoffset, TRUE);
    ip_dialog_offset = gtk_spin_button_new_with_range(0, 65528, 8);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(ip_dialog_offset), TRUE);
    gtk_spin_button_set_snap_to_ticks(GTK_SPIN_BUTTON(ip_dialog_offset), TRUE);
    gtk_entry_set_alignment(GTK_ENTRY(ip_dialog_offset), 1);
    gtk_box_pack_start(GTK_BOX(ip_dialog_hbox7), ip_dialog_checkoffset, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(ip_dialog_hbox7), ip_dialog_offset, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(ip_dialog_checkoffset), "toggled", G_CALLBACK(ip_dialog_checkoffset_toggled), NULL);

    ip_dialog_hbox8 = gtk_hbox_new(TRUE, 5);
    ip_dialog_checkttl = gtk_check_button_new_with_label(_("Time to live"));
    gtk_toggle_button_set_active((GtkToggleButton*) ip_dialog_checkttl, TRUE);
    ip_dialog_ttl = gtk_spin_button_new_with_range(0, 255, 1);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(ip_dialog_ttl), TRUE);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ip_dialog_ttl), 64);
    gtk_entry_set_alignment(GTK_ENTRY(ip_dialog_ttl), 1);
    gtk_box_pack_start(GTK_BOX(ip_dialog_hbox8), ip_dialog_checkttl, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(ip_dialog_hbox8), ip_dialog_ttl, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(ip_dialog_checkttl), "toggled", G_CALLBACK(ip_dialog_checkttl_toggled), NULL);

    ip_dialog_hbox9 = gtk_hbox_new(FALSE, 5);
    ip_dialog_checkprotocol = gtk_check_button_new_with_label(_("Next level protocol"));
    gtk_toggle_button_set_active((GtkToggleButton*) ip_dialog_checkprotocol, TRUE);
    ip_dialog_comboprotocol = gtk_combo_box_new_text();
    gtk_combo_box_append_text((GtkComboBox*) ip_dialog_comboprotocol, _("-other-"));
    i = 0;
    while (table_protocols[i] != NULL)
	gtk_combo_box_append_text((GtkComboBox*) ip_dialog_comboprotocol, _(table_protocols[i++]));
    ip_dialog_protocol = gtk_spin_button_new_with_range(0, 255, 1);
    /* select protocol on combo and (en/dis)able entry after create */
    g_signal_connect(G_OBJECT(ip_dialog_comboprotocol), "changed", G_CALLBACK(ip_dialog_comboprotocol_changed), NULL);
    gtk_combo_box_set_active((GtkComboBox*) ip_dialog_comboprotocol, 2);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(ip_dialog_protocol), TRUE);
    gtk_entry_set_alignment(GTK_ENTRY(ip_dialog_protocol), 1);
    gtk_box_pack_start(GTK_BOX(ip_dialog_hbox9), ip_dialog_checkprotocol, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ip_dialog_hbox9), ip_dialog_comboprotocol, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(ip_dialog_hbox9), ip_dialog_protocol, FALSE, FALSE, 0);
    g_signal_connect(G_OBJECT(ip_dialog_checkprotocol), "toggled", G_CALLBACK(ip_dialog_checkprotocol_toggled), NULL);

    ip_dialog_hbox10 = gtk_hbox_new(FALSE, 5);
    ip_dialog_checksourceip = gtk_check_button_new_with_label(_("Source IP address"));
    gtk_toggle_button_set_active((GtkToggleButton*) ip_dialog_checksourceip, TRUE);
    ip_dialog_combosourceip = gtk_combo_box_new_text();
    gtk_combo_box_append_text((GtkComboBox*) ip_dialog_combosourceip, _("-other-"));
    i = selected = 0;
    while ((text = get_iface_name(i++)) != NULL) {
	gtk_combo_box_append_text((GtkComboBox*) ip_dialog_combosourceip, text);
	if (device != NULL && strcmp(text, device) == 0)
	    selected = i;
    }
    ip_dialog_sourceip = gtk_entry_new();
    /* select iface on combo and (en/dis)able entry after create */
    g_signal_connect(G_OBJECT(ip_dialog_combosourceip), "changed", G_CALLBACK(ip_dialog_combosourceip_changed), NULL);
    gtk_combo_box_set_active((GtkComboBox*) ip_dialog_combosourceip, selected);
    gtk_entry_set_max_length(GTK_ENTRY(ip_dialog_sourceip), 15);
    gtk_entry_set_width_chars(GTK_ENTRY(ip_dialog_sourceip), 15);
    gtk_entry_set_alignment(GTK_ENTRY(ip_dialog_sourceip), 1);
    gtk_entry_set_text(GTK_ENTRY(ip_dialog_sourceip), "0.0.0.0");
    gtk_box_pack_start(GTK_BOX(ip_dialog_hbox10), ip_dialog_checksourceip, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ip_dialog_hbox10), ip_dialog_combosourceip, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ip_dialog_hbox10), ip_dialog_sourceip, FALSE, FALSE, 0);
    g_signal_connect(G_OBJECT(ip_dialog_sourceip), "key-press-event", G_CALLBACK(ip_dialog_ip_keypress), NULL);
    g_signal_connect(G_OBJECT(ip_dialog_checksourceip), "toggled", G_CALLBACK(ip_dialog_checksourceip_toggled), NULL);

    ip_dialog_hbox11 = gtk_hbox_new(FALSE, 5);
    ip_dialog_checkdestip = gtk_check_button_new_with_label(_("Destination IP address"));
    gtk_toggle_button_set_active((GtkToggleButton*) ip_dialog_checkdestip, TRUE);
    ip_dialog_destip = gtk_entry_new();
    gtk_entry_set_max_length(GTK_ENTRY(ip_dialog_destip), 15);
    gtk_entry_set_width_chars(GTK_ENTRY(ip_dialog_destip), 15);
    gtk_entry_set_alignment(GTK_ENTRY(ip_dialog_destip), 1);
    gtk_entry_set_text(GTK_ENTRY(ip_dialog_destip), "0.0.0.0");
    gtk_box_pack_start(GTK_BOX(ip_dialog_hbox11), ip_dialog_checkdestip, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ip_dialog_hbox11), ip_dialog_destip, FALSE, FALSE, 0);
    g_signal_connect(G_OBJECT(ip_dialog_destip), "key-press-event", G_CALLBACK(ip_dialog_ip_keypress), NULL);
    g_signal_connect(G_OBJECT(ip_dialog_checkdestip), "toggled", G_CALLBACK(ip_dialog_checkdestip_toggled), NULL);

    ip_dialog_label3 = gtk_label_new(_("Write:"));
    ip_dialog_hbox12 = gtk_hbox_new(FALSE, 5);
    ip_dialog_radioatip = gtk_radio_button_new_with_label(NULL, _("from 14th byte of frame"));
    ip_dialog_radioatcursor = gtk_radio_button_new_with_label_from_widget(
						    GTK_RADIO_BUTTON(ip_dialog_radioatip),
						    _("from cursor's position"));
    gtk_toggle_button_set_active((GtkToggleButton*) ip_dialog_radioatip, TRUE);
    gtk_box_pack_start(GTK_BOX(ip_dialog_hbox12), ip_dialog_radioatip, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ip_dialog_hbox12), ip_dialog_radioatcursor, TRUE, TRUE, 0);

    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ip_dialog_window)->vbox), ip_dialog_label1, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ip_dialog_window)->vbox), ip_dialog_hbox1, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ip_dialog_window)->vbox), ip_dialog_hbox2, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ip_dialog_window)->vbox), ip_dialog_checktos, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ip_dialog_window)->vbox), ip_dialog_frametos, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ip_dialog_window)->vbox), ip_dialog_hbox4, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ip_dialog_window)->vbox), ip_dialog_hbox5, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ip_dialog_window)->vbox), ip_dialog_hbox6, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ip_dialog_window)->vbox), ip_dialog_hbox7, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ip_dialog_window)->vbox), ip_dialog_hbox8, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ip_dialog_window)->vbox), ip_dialog_hbox9, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ip_dialog_window)->vbox), ip_dialog_hbox10, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ip_dialog_window)->vbox), ip_dialog_hbox11, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ip_dialog_window)->vbox), ip_dialog_label3, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ip_dialog_window)->vbox), ip_dialog_hbox12, TRUE, TRUE, 2);
    gtk_widget_show_all(ip_dialog_window);
}

void ip_dialog_write_frame() {
    char *text;
    gchar **ip;
    int position, position2, value, i;

    /* cleanup */
    if ((position = frame->ip_position) > -1) {
	frame->ip_position = -1;
	for (position2 = position; position2 < position + 20; position2++) {
    	    if (frame->len > position2)
        	fill_one_byte_cells(position2);
	}
    }

    /* position in frame */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_radioatcursor))
        position = selected_byte;
    else if (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_radioatip))
	position = 14;

    /* cleanup old colors */
    if (frame->ipx_position > -1) {
	for (position2 = frame->ipx_position; position2 < frame->ipx_position + 30; position2++) {
	    if (frame->len > position2)
		set_default_color_for_cell(position2);
	}
    }
    if (frame->spx_position > -1) {
	for (position2 = frame->spx_position; position2 < frame->spx_position + 12; position2++) {
	    if (frame->len > position2)
		set_default_color_for_cell(position2);
	}
    }

    /* remember position */
    frame->ipx_position = -1;
    frame->spx_position = -1;
    frame->ip_position = position;

    /* get version */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_checkversion)) {
	/* add bytes to frame */
	if (frame->len < position + 1) {
	    add_to_frame(position - frame->len + 1, NULL, 0);
	    add_cells_to_tables();
	}
	frame->data[position] = (frame->data[position] & 0x0F) +
		(gtk_combo_box_get_active(GTK_COMBO_BOX(ip_dialog_comboversion)) << 4);
    }

    /* get Header len */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_checkhlen)) {
	/* add bytes to frame */
	if (frame->len < position + 1) {
	    add_to_frame(position - frame->len + 1, NULL, 0);
	    add_cells_to_tables();
	}
	frame->data[position] = (frame->data[position] & 0xF0) +
		gtk_combo_box_get_active(GTK_COMBO_BOX(ip_dialog_combohlen));
    }
    position++;

    /* get TOS */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_checktos)) {
	/* add bytes to frame */
	if (frame->len < position + 1) {
	    add_to_frame(position - frame->len + 1, NULL, 0);
	    add_cells_to_tables();
	}
	frame->data[position] = (gtk_combo_box_get_active(GTK_COMBO_BOX(ip_dialog_comboprecedence)) << 5) +
		    (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_checktosd) << 4) +
		    (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_checktost) << 3) +
		    (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_checktosr) << 2) +
		    (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_checktosm) << 1) +
		    gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_checktos0);
    }
    position++;

    /* get len */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_checklen)) {
	/* add bytes to frame */
	if (frame->len < position + 2) {
	    add_to_frame(position - frame->len + 2, NULL, 0);
	    add_cells_to_tables();
	}
	value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(ip_dialog_len));
	frame->data[position++] = (value & 0xFF00) >> 8;
	frame->data[position++] = value & 0xFF;
    } else
	position += 2;

    /* get identification */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_checkid)) {
	/* add bytes to frame */
	if (frame->len < position + 2) {
	    add_to_frame(position - frame->len + 2, NULL, 0);
	    add_cells_to_tables();
	}
	value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(ip_dialog_id));
	frame->data[position++] = (value & 0xFF00) >> 8;
	frame->data[position++] = value & 0xFF;
    } else
	position += 2;

    /* get flags */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_checkflags)) {
	/* add bytes to frame */
	if (frame->len < position + 1) {
	    add_to_frame(position - frame->len + 1, NULL, 0);
	    add_cells_to_tables();
	}
	frame->data[position] = (frame->data[position] & 0x1F) +
		    (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_checkflagr) << 7) +
		    (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_checkflagdf) << 6) +
		    (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_checkflagmf) << 5);
    }

    /* get offset */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_checkoffset)) {
	/* add bytes to frame */
	if (frame->len < position + 2) {
	    add_to_frame(position - frame->len + 2, NULL, 0);
	    add_cells_to_tables();
	}
	value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(ip_dialog_offset));
	frame->data[position] = (frame->data[position] & 0xE0) +
		    ((value & 0xF800) >> 11);
	position++;
	frame->data[position++] = (value & 0x7F8) >> 3;
    } else
	position += 2;

    /* get TTL */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_checkttl)) {
	/* add bytes to frame */
	if (frame->len < position + 1) {
	    add_to_frame(position - frame->len + 1, NULL, 0);
	    add_cells_to_tables();
	}
	value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(ip_dialog_ttl));
	frame->data[position] = value;
    }
    position++;

    /* get protocol */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_checkprotocol)) {
	/* add bytes to frame */
	if (frame->len < position + 1) {
	    add_to_frame(position - frame->len + 1, NULL, 0);
	    add_cells_to_tables();
	}
	i = gtk_combo_box_get_active(GTK_COMBO_BOX(ip_dialog_comboprotocol));
	text = malloc(4);
	if (i == 0)
	    text = gtk_editable_get_chars((GtkEditable*) ip_dialog_protocol, 0, 3);
	else {
	    memcpy(text, _(table_protocols[i - 1]), 3);
	}
	text[3] = 0;
	text[strspn(text, "0123456789")] = 0;
	frame->data[position] = dec2int(text) & 0xFF;
	free(text);
    }
    
    /* skip 2 bytes checksum */
    position += 3;

    /* get source ip */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_checksourceip)) {
	/* add bytes to frame */
	if (frame->len < position + 4) {
	    add_to_frame(position - frame->len + 4, NULL, 0);
	    add_cells_to_tables();
	}
	i = gtk_combo_box_get_active(GTK_COMBO_BOX(ip_dialog_combosourceip));
	if (i == 0) {
	    ip = g_strsplit(gtk_entry_get_text(GTK_ENTRY(ip_dialog_sourceip)), ".", 4);
	    for (position2 = 0; position2 < 4; position++, position2++) {
		i = dec2int(ip[position2]);
		frame->data[position] = i & 0xFF;
	    }
	    g_strfreev(ip);
	} else {
            device = get_iface_name(i - 1);
            text = get_ip_address();
            memcpy(frame->data + position, text, 4);
            free(text);
	    position += 4;
	}
    } else
	position += 4;

    /* get destination ip */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ip_dialog_checkdestip)) {
	/* add bytes to frame */
	if (frame->len < position + 4) {
	    add_to_frame(position - frame->len + 4, NULL, 0);
	    add_cells_to_tables();
	}
	ip = g_strsplit(gtk_entry_get_text(GTK_ENTRY(ip_dialog_destip)), ".", 4);
	for (position2 = 0; position2 < 4; position++, position2++) {
	    i = dec2int(ip[position2]);
	    frame->data[position] = i & 0xFF;
	}
	g_strfreev(ip);
    }

    /* refresh window */
    for (position2 = frame->ip_position; position2 < frame->ip_position + 20; position2++) {
        if (frame->len > position2)
            fill_one_byte_cells(position2);
    }
    fill_binary();
    fill_decimal();
    fill_datasize();
}
