/* $Id: gui-GTK_ipcksum-dialog.c,v 1.3 2005/03/20 22:26:54 emvi Exp $ */

/* 
Copyright (C) 2005 Marek Wardziski (emvi at emvi eu org) 
 
This file is part of Ant. 
 
Ant is free software; you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation; either version 2 of the License, or 
(at your option) any later version. 
 
Ant is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
GNU General Public License for more details. 
 
You should have received a copy of the GNU General Public License 
along with Ant; if not, write to the Free Software 
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "main.h"
#include "misc.h"
#include "net.h"

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "gui-GTK.h"
#include "gui-GTK_handlers.h"

GtkWidget *ipcksum_dialog_window;
GtkWidget *ipcksum_dialog_label1;
GtkWidget *ipcksum_dialog_hbox1;
GtkWidget *ipcksum_dialog_label2;
GtkWidget *ipcksum_dialog_start;
GtkWidget *ipcksum_dialog_hbox2;
GtkWidget *ipcksum_dialog_label3;
GtkWidget *ipcksum_dialog_end;
GtkWidget *ipcksum_dialog_label4;
GtkWidget *ipcksum_dialog_radio_atcursor;
GtkWidget *ipcksum_dialog_radio_atplace;

void ipcksum_dialog_create() {
    int max_value;

    /* create dialog window */
    ipcksum_dialog_window = gtk_dialog_new_with_buttons(_("Add IP checksum"),
				GTK_WINDOW(window_main), GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_STOCK_OK, GTK_RESPONSE_OK,
				GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				NULL);

    ipcksum_dialog_label1 = gtk_label_new(_("Calculate checksum"));

    ipcksum_dialog_hbox1 = gtk_hbox_new(FALSE, 0);
    ipcksum_dialog_label2 = gtk_label_new(_("Position of IP header's beginning"));
    max_value = frame->len - 1;
    if (max_value == 0)
	max_value++;
    ipcksum_dialog_start = gtk_spin_button_new_with_range(0, max_value, 1);
    g_signal_connect(G_OBJECT(ipcksum_dialog_start), "button-press-event", G_CALLBACK(entry_mouseclicked), NULL);
    gtk_spin_button_set_value((GtkSpinButton*) ipcksum_dialog_start, 14);
    gtk_entry_set_alignment(GTK_ENTRY(ipcksum_dialog_start), 1);
    gtk_box_pack_start(GTK_BOX(ipcksum_dialog_hbox1), ipcksum_dialog_label2, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ipcksum_dialog_hbox1), ipcksum_dialog_start, TRUE, TRUE, 0);

    ipcksum_dialog_hbox2 = gtk_hbox_new(FALSE, 0);
    ipcksum_dialog_label3 = gtk_label_new(_("Position of IP header's ending"));
    ipcksum_dialog_end = gtk_spin_button_new_with_range(0, max_value, 1);
    g_signal_connect(G_OBJECT(ipcksum_dialog_end), "button-press-event", G_CALLBACK(entry_mouseclicked), NULL);
    gtk_spin_button_set_value((GtkSpinButton*) ipcksum_dialog_end, 33);
    gtk_entry_set_alignment(GTK_ENTRY(ipcksum_dialog_end), 1);
    gtk_box_pack_start(GTK_BOX(ipcksum_dialog_hbox2), ipcksum_dialog_label3, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ipcksum_dialog_hbox2), ipcksum_dialog_end, TRUE, TRUE, 0);

    ipcksum_dialog_label4 = gtk_label_new(_("Write:"));
    ipcksum_dialog_radio_atcursor = gtk_radio_button_new_with_label(NULL, _("from cursor's position"));
    ipcksum_dialog_radio_atplace = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(ipcksum_dialog_radio_atcursor),
					    _("in IP header's checksum field"));
    gtk_toggle_button_set_active((GtkToggleButton*) ipcksum_dialog_radio_atplace, TRUE);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ipcksum_dialog_window)->vbox), ipcksum_dialog_label1, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ipcksum_dialog_window)->vbox), ipcksum_dialog_hbox1, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ipcksum_dialog_window)->vbox), ipcksum_dialog_hbox2, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ipcksum_dialog_window)->vbox), ipcksum_dialog_label4, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ipcksum_dialog_window)->vbox), ipcksum_dialog_radio_atcursor, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ipcksum_dialog_window)->vbox), ipcksum_dialog_radio_atplace, TRUE, TRUE, 2);
    gtk_widget_show_all(ipcksum_dialog_window);
}

void ipcksum_dialog_write_frame() {
    int start, end;
    guint16 cksum;
    int position = 0;

    /* position of checksum */
    if (gtk_toggle_button_get_active((GtkToggleButton*) ipcksum_dialog_radio_atcursor))
        position = selected_byte;
    else if (gtk_toggle_button_get_active((GtkToggleButton*) ipcksum_dialog_radio_atplace))
        position = 24;

    /* add bytes to frame */
    if (frame->len < position + 2) {
        add_to_frame(position - frame->len + 2, NULL, 0);
        add_cells_to_tables();
    }

    /* fill checksum field with 0-s */
    frame->data[position] = 0;
    frame->data[position + 1] = 0;

    start = gtk_spin_button_get_value_as_int((GtkSpinButton*) ipcksum_dialog_start);
    end = gtk_spin_button_get_value_as_int((GtkSpinButton*) ipcksum_dialog_end);
    cksum = libnet_ip_check((u_int16_t*) (frame->data + start), end - start + 1);
    memcpy(frame->data + position, &cksum, 2);
    fill_one_byte_cells(position);
    fill_one_byte_cells(position + 1);
    fill_binary();
    fill_decimal();
    fill_datasize();
}
