/* $Id: gui-GTK_misc.c,v 1.2 2005/02/05 16:04:19 emvi Exp $ */

/* 
Copyright (C) 2005 Marek Wardziski (emvi at emvi eu org) 
 
This file is part of Ant. 
 
Ant is free software; you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation; either version 2 of the License, or 
(at your option) any later version. 
 
Ant is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
GNU General Public License for more details. 
 
You should have received a copy of the GNU General Public License 
along with Ant; if not, write to the Free Software 
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include <string.h>
#include <stdlib.h>
#include <gtk/gtk.h>

#include "main.h"
#include "gui-GTK.h"

GdkColor color_default =	{0, 0xFFFF, 0xFFFF, 0xFFFF};
GdkColor color_eth =		{0, 0xFFFF, 0xC000, 0x0000};
GdkColor color_fcs =		{0, 0xFFFF, 0x0000, 0x0000};
GdkColor color_ip =		{0, 0x0000, 0xFFFF, 0xFFFF};
GdkColor color_ipx =		{0, 0x8000, 0x8000, 0xFFFF};
GdkColor color_tcp =		{0, 0x0000, 0xFFFF, 0x0000};
GdkColor color_udp =		{0, 0xFFFF, 0xFFFF, 0x0000};
GdkColor color_spx =		{0, 0xFFFF, 0x0000, 0xFFFF};

gboolean open_dialog(char *title) {
    GtkWidget *file_chooser_dialog;
    gboolean accept;

    file_chooser_dialog = gtk_file_chooser_dialog_new(title, GTK_WINDOW(window_main), GTK_FILE_CHOOSER_ACTION_OPEN,
	    GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
	    GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
	    NULL);
    gtk_file_chooser_set_local_only((GtkFileChooser*) file_chooser_dialog, TRUE);
    gtk_file_chooser_set_select_multiple((GtkFileChooser*) file_chooser_dialog, FALSE);
    accept = gtk_dialog_run(GTK_DIALOG(file_chooser_dialog)) == GTK_RESPONSE_ACCEPT;
    if (accept)
	file_name = gtk_file_chooser_get_filename((GtkFileChooser*) file_chooser_dialog);
    gtk_widget_destroy(file_chooser_dialog);
    return accept;
}

gboolean saveas_dialog(char *title) {
    GtkWidget *file_chooser_dialog;
    gboolean accept;

    file_chooser_dialog = gtk_file_chooser_dialog_new(title, GTK_WINDOW(window_main), GTK_FILE_CHOOSER_ACTION_SAVE,
	    GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
	    GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT,
	    NULL);
    gtk_file_chooser_set_local_only((GtkFileChooser*) file_chooser_dialog, TRUE);
    gtk_file_chooser_set_select_multiple((GtkFileChooser*) file_chooser_dialog, FALSE);
    accept = gtk_dialog_run(GTK_DIALOG(file_chooser_dialog)) == GTK_RESPONSE_ACCEPT;
    if (accept)
	file_name = gtk_file_chooser_get_filename((GtkFileChooser*) file_chooser_dialog);
    gtk_widget_destroy(file_chooser_dialog);
    return accept;
}

void scroll_datatables() {
    GtkAdjustment *adjustment;
    int row_nr, rows;
    double row_height;

    adjustment = gtk_scrolled_window_get_vadjustment((GtkScrolledWindow*)scroll_tables);
    if (adjustment->upper > adjustment->page_size) {
        row_nr = selected_byte / 16 + 1;
        rows = (frame->len - 1) / 16 + 1;
        row_height = adjustment->upper / rows;
        if ((adjustment->value + adjustment->page_size) < (row_nr * row_height))
            gtk_adjustment_set_value(adjustment, (row_nr * row_height) - adjustment->page_size);
	if (adjustment->value > ((row_nr - 1) * row_height))
    	    gtk_adjustment_set_value(adjustment, (row_nr - 1) * row_height);
        gtk_scrolled_window_set_vadjustment((GtkScrolledWindow*)scroll_tables, adjustment);
    }
}

/* Kolor dla komrki o podanym numerze */
GdkColor *color_of_cell(int number) {
    GdkColor *color;

    color = malloc(sizeof(GdkColor));

    /* domylnie biay */
    memcpy(color, &color_default, sizeof(GdkColor));

    /* czy FCS */
    if (frame->fcs_position >= 0) {
	if ((number >= frame->fcs_position) &&
		    (number < (frame->fcs_position + 4)))
	    memcpy(color, &color_fcs, sizeof(GdkColor));
    }

    /* czy SPX */
    if (frame->spx_position >= 0) {
	if ((number >= frame->spx_position) &&
		    (number < (frame->spx_position + 12)))
	    memcpy(color, &color_spx, sizeof(GdkColor));
    }

    /* czy IPX */
    if (frame->ipx_position >= 0) {
	if ((number >= frame->ipx_position) &&
		    (number < (frame->ipx_position + 30)))
	    memcpy(color, &color_ipx, sizeof(GdkColor));
    }

    /* czy nagwek tcp */
    if (frame->tcp_position >= 0) {
	if (number >= frame->tcp_position)
	    if ((number < (frame->tcp_position + 13)) ||
		    (number < (frame->tcp_position + ((frame->data[frame->tcp_position + 12] & 0xF0) >> 2))))
		memcpy(color, &color_tcp, sizeof(GdkColor));
    }

    /* czy nagwek udp */
    if (frame->udp_position >= 0) {
	if ((number >= frame->udp_position) &&
		    (number < (frame->udp_position + 8)))
	    memcpy(color, &color_udp, sizeof(GdkColor));
    }

    /* czy nagwek ip */
    if (frame->ip_position >= 0) {
	if ((number == frame->ip_position) || ((number > frame->ip_position) &&
		    (number < (frame->ip_position + ((frame->data[frame->ip_position] & 0x0F) << 2)))))
	    memcpy(color, &color_ip, sizeof(GdkColor));
    }

    /* czy nagwek ethernet */
    if (frame->eth_position >= 0) {
	if ((number >= frame->eth_position) &&
		    (number < (frame->eth_position + 14)))
	    memcpy(color, &color_eth, sizeof(GdkColor));
    }

    return color;
}
