/* $Id: gui-GTK_send-dialog.c,v 1.3 2005/03/20 22:26:54 emvi Exp $ */

/* 
Copyright (C) 2005 Marek Wardziski (emvi at emvi eu org) 
 
This file is part of Ant. 
 
Ant is free software; you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation; either version 2 of the License, or 
(at your option) any later version. 
 
Ant is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
GNU General Public License for more details. 
 
You should have received a copy of the GNU General Public License 
along with Ant; if not, write to the Free Software 
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "main.h"
#include "misc.h" 
#include "net.h" 

#include <gtk/gtk.h> 
#include "gui-GTK.h" 
#include "gui-GTK_handlers.h"

GtkWidget *send_dialog_window;
GtkWidget *send_dialog_hbox1;
GtkWidget *send_dialog_label2;
GtkWidget *send_dialog_spin_times;
GtkWidget *send_dialog_label3;
GtkWidget *send_dialog_hbox2;
GtkWidget *send_dialog_label4;
GtkWidget *send_dialog_spin_delayframes;
GtkWidget *send_dialog_hbox3;
GtkWidget *send_dialog_label5;
GtkWidget *send_dialog_spin_delayseries;
GtkWidget *send_dialog_hbox4;
GtkWidget *send_dialog_label6;
GtkWidget *send_dialog_combo_iface;

GtkWidget *send_progress_window;
GtkWidget *send_progress_bar;
GtkWidget *send_progress_button;

guint send_timeout_id = 0;

void send_dialog_create() {
    int i, selected;
    char *text;

    send_dialog_window = gtk_dialog_new_with_buttons(_("Data sending"),
			    GTK_WINDOW(window_main),
			    GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                	    GTK_STOCK_OK, GTK_RESPONSE_OK,
                	    GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                	    NULL);
    send_dialog_hbox1 = gtk_hbox_new(TRUE, 5);
    send_dialog_label2 = gtk_label_new(_("Number of series to send"));
    gtk_label_set_justify((GtkLabel*)send_dialog_label2, GTK_JUSTIFY_RIGHT);
    send_dialog_spin_times = gtk_spin_button_new_with_range(1, 100000, 1);
    g_signal_connect(G_OBJECT(send_dialog_spin_times), "button-press-event", G_CALLBACK(entry_mouseclicked), NULL);
    gtk_spin_button_set_numeric((GtkSpinButton*) send_dialog_spin_times, TRUE);
    gtk_entry_set_max_length((GtkEntry*)send_dialog_spin_times, 6);
    gtk_entry_set_width_chars((GtkEntry*)send_dialog_spin_times, 6);
    gtk_entry_set_alignment(GTK_ENTRY(send_dialog_spin_times), 1);
    gtk_box_pack_start(GTK_BOX(send_dialog_hbox1), send_dialog_label2, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(send_dialog_hbox1), send_dialog_spin_times, TRUE, TRUE, 0);
    send_dialog_hbox2 = gtk_hbox_new(TRUE, 5);
    send_dialog_label4 = gtk_label_new(_("Delay between frames in series [ms]"));
    send_dialog_spin_delayframes = gtk_spin_button_new_with_range(1, 10000, 1);
    g_signal_connect(G_OBJECT(send_dialog_spin_delayframes), "button-press-event", G_CALLBACK(entry_mouseclicked), NULL);
    gtk_spin_button_set_numeric((GtkSpinButton*) send_dialog_spin_delayframes, TRUE);
    if (g_list_length(all_frames) == 1)
	gtk_widget_set_sensitive(send_dialog_spin_delayframes, FALSE);
    gtk_entry_set_alignment(GTK_ENTRY(send_dialog_spin_delayframes), 1);
    gtk_box_pack_start(GTK_BOX(send_dialog_hbox2), send_dialog_label4, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(send_dialog_hbox2), send_dialog_spin_delayframes, TRUE, TRUE, 0);
    send_dialog_hbox3 = gtk_hbox_new(TRUE, 5);
    send_dialog_label5 = gtk_label_new(_("Delay between series [ms]"));
    send_dialog_spin_delayseries = gtk_spin_button_new_with_range(1, 10000, 1);
    g_signal_connect(G_OBJECT(send_dialog_spin_delayseries), "button-press-event", G_CALLBACK(entry_mouseclicked), NULL);
    gtk_spin_button_set_numeric((GtkSpinButton*) send_dialog_spin_delayseries, TRUE);
    gtk_entry_set_alignment(GTK_ENTRY(send_dialog_spin_delayseries), 1);
    gtk_box_pack_start(GTK_BOX(send_dialog_hbox3), send_dialog_label5, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(send_dialog_hbox3), send_dialog_spin_delayseries, TRUE, TRUE, 0);
    send_dialog_hbox4 = gtk_hbox_new(TRUE, 5);
    send_dialog_label6 = gtk_label_new(_("Interface"));
    send_dialog_combo_iface = gtk_combo_box_new_text();
    i = selected = 0;
    while ((text = get_iface_name(i++)) != NULL) {
	gtk_combo_box_append_text((GtkComboBox*) send_dialog_combo_iface, text);
	if (device != NULL && strcmp(text, device) == 0)
	    selected = i - 1;
    }
    gtk_combo_box_set_active((GtkComboBox*) send_dialog_combo_iface, selected);
    gtk_box_pack_start(GTK_BOX(send_dialog_hbox4), send_dialog_label6, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX(send_dialog_hbox4), send_dialog_combo_iface, TRUE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(send_dialog_window)->vbox), send_dialog_hbox1, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(send_dialog_window)->vbox), send_dialog_hbox2, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(send_dialog_window)->vbox), send_dialog_hbox3, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(send_dialog_window)->vbox), send_dialog_hbox4, TRUE, TRUE, 2);
    gtk_widget_show_all(send_dialog_window);
}

void send_progress_button_clicked(GtkWidget *widget, gpointer data) {
    g_source_remove(send_timeout_id);
    gtk_widget_destroy(send_progress_window);
}

/* don't allow close window when delete clicked */
gint send_progress_window_delete(GtkWidget *widget, GdkEvent *event, gpointer data) {
    return TRUE;
}

void send_dialog_inprogress() {
    char *progress_text;

    send_progress_window = gtk_dialog_new_with_buttons(_("Send..."),
					GTK_WINDOW(window_main),
					GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                			NULL);
    g_signal_connect (G_OBJECT(send_progress_window), "delete_event", G_CALLBACK(send_progress_window_delete), NULL);
    send_progress_bar = gtk_progress_bar_new();
    progress_text = malloc(14);
    sprintf(progress_text, "%i/%i", 0, times);
    gtk_progress_bar_set_text((GtkProgressBar*)send_progress_bar, progress_text);
    free(progress_text);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(send_progress_window)->vbox), send_progress_bar, TRUE, TRUE, 0);
    send_progress_button = gtk_button_new_with_label(_("Stop"));
    g_signal_connect(G_OBJECT(send_progress_button), "clicked", G_CALLBACK(send_progress_button_clicked), NULL);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(send_progress_window)->action_area), send_progress_button, TRUE, FALSE, 0);
    gtk_widget_show_all(send_progress_window);
}

gboolean send_dialog_send(gpointer data) {
    gdouble progress;
    char *progress_text;
    int nr_of_frames, sent_all, times_all;
    GtkWidget *error_message;

    if (! send_frame(sent_frames++)) {
	gtk_widget_destroy(send_progress_window);
	error_message = gtk_message_dialog_new(GTK_WINDOW(window_main),
				    GTK_DIALOG_DESTROY_WITH_PARENT,
				    GTK_MESSAGE_ERROR,
				    GTK_BUTTONS_CLOSE,
				    _("Frame sending error.\nThis may be caused by lack of root privileges."));
	gtk_dialog_run(GTK_DIALOG(error_message));
	gtk_widget_destroy(error_message);
	return FALSE;
    }
    nr_of_frames = g_list_length(all_frames);
    sent_all = sent_series * nr_of_frames + sent_frames;
    times_all = times * nr_of_frames;
    progress = (double)sent_all / (double)times_all;
    gtk_progress_bar_set_fraction((GtkProgressBar*)send_progress_bar, progress);
    progress_text = malloc(14);
    sprintf(progress_text, "%i/%i", sent_all, times_all);
    gtk_progress_bar_set_text((GtkProgressBar*)send_progress_bar, progress_text);
    free(progress_text);

    /* sent all - stop */
    if ((sent_frames >= nr_of_frames) && (sent_series >= times - 1)) {
    	gtk_button_set_label((GtkButton*) send_progress_button, _("Close"));
	return FALSE;
    }

    if ((sent_frames == 1) || (sent_frames >= nr_of_frames)) {
	if (sent_frames >= nr_of_frames) {
	    sent_series++;
	    sent_frames = 0;
	    send_timeout_id = g_timeout_add(delay_series, (GSourceFunc)send_dialog_send, NULL);
	    return FALSE;
	} else {
	    send_timeout_id = g_timeout_add(delay_frames, (GSourceFunc)send_dialog_send, NULL);
	    return FALSE;
	}
    }
    return TRUE;
}
