/* $Id: gui-GTK_spx-dialog.c,v 1.3 2005/03/20 22:26:54 emvi Exp $ */

/* 
Copyright (C) 2005 Marek Wardziski (emvi at emvi eu org) 
 
This file is part of Ant. 
 
Ant is free software; you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation; either version 2 of the License, or 
(at your option) any later version. 
 
Ant is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
GNU General Public License for more details. 
 
You should have received a copy of the GNU General Public License 
along with Ant; if not, write to the Free Software 
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "main.h"
#include "misc.h"
#include "net.h"

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "gui-GTK.h"
#include "gui-GTK_handlers.h"

GtkWidget *spx_dialog_window;
GtkWidget *spx_dialog_label1;
GtkWidget *spx_dialog_hbox1;
GtkWidget *spx_dialog_checkcc;
GtkWidget *spx_dialog_framecc;
GtkWidget *spx_dialog_vbox1;
GtkWidget *spx_dialog_checkccno1;
GtkWidget *spx_dialog_checkccno2;
GtkWidget *spx_dialog_checkccsn;
GtkWidget *spx_dialog_checkccspx2;
GtkWidget *spx_dialog_checkcceom;
GtkWidget *spx_dialog_checkccab;
GtkWidget *spx_dialog_checkccar;
GtkWidget *spx_dialog_checkcctc;
GtkWidget *spx_dialog_hbox2;
GtkWidget *spx_dialog_checkdatastr;
GtkWidget *spx_dialog_combodatastr;
GtkWidget *spx_dialog_datastr;
GtkWidget *spx_dialog_hbox3;
GtkWidget *spx_dialog_checksrcid;
GtkWidget *spx_dialog_srcid;
GtkWidget *spx_dialog_hbox4;
GtkWidget *spx_dialog_checkdstid;
GtkWidget *spx_dialog_dstid;
GtkWidget *spx_dialog_hbox5;
GtkWidget *spx_dialog_checkseqnr;
GtkWidget *spx_dialog_seqnr;
GtkWidget *spx_dialog_hbox6;
GtkWidget *spx_dialog_checkacknr;
GtkWidget *spx_dialog_acknr;
GtkWidget *spx_dialog_hbox7;
GtkWidget *spx_dialog_checkallnr;
GtkWidget *spx_dialog_allnr;
GtkWidget *spx_dialog_label2;
GtkWidget *spx_dialog_hbox8;
GtkWidget *spx_dialog_radioatspx;
GtkWidget *spx_dialog_radioatcursor;

GtkWidget *spx_dialog_buttonget;

char* table_spx_types[] = { N_("252 - orderly release request"),
			    N_("253 - orderly release acknowledgment"),
			    N_("254 - end of connection"),
			    N_("255 - end of connection acknowledgment"), NULL};

void spx_dialog_checkcc_toggled(GtkToggleButton *widget, gpointer data) {
    gboolean active = gtk_toggle_button_get_active(widget);
    gtk_widget_set_sensitive(spx_dialog_checkccno1, active);
    gtk_widget_set_sensitive(spx_dialog_checkccno2, active);
    gtk_widget_set_sensitive(spx_dialog_checkccsn, active);
    gtk_widget_set_sensitive(spx_dialog_checkccspx2, active);
    gtk_widget_set_sensitive(spx_dialog_checkcceom, active);
    gtk_widget_set_sensitive(spx_dialog_checkccab, active);
    gtk_widget_set_sensitive(spx_dialog_checkccar, active);
    gtk_widget_set_sensitive(spx_dialog_checkcctc, active);
}

void spx_dialog_checkdatastr_toggled(GtkToggleButton *widget, gpointer data) {
    gboolean active = gtk_toggle_button_get_active(widget);
    gtk_widget_set_sensitive(spx_dialog_combodatastr, active);
    gtk_widget_set_sensitive(spx_dialog_datastr, active &
		(gtk_combo_box_get_active(GTK_COMBO_BOX(spx_dialog_combodatastr)) == 0));
}

void spx_dialog_combodatastr_changed(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(spx_dialog_datastr,
    		(gtk_combo_box_get_active(GTK_COMBO_BOX(spx_dialog_combodatastr)) == 0));
}

void spx_dialog_checksrcid_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(spx_dialog_srcid, gtk_toggle_button_get_active(widget));
}

void spx_dialog_checkdstid_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(spx_dialog_dstid, gtk_toggle_button_get_active(widget));
}

void spx_dialog_checkseqnr_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(spx_dialog_seqnr, gtk_toggle_button_get_active(widget));
}

void spx_dialog_checkacknr_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(spx_dialog_acknr, gtk_toggle_button_get_active(widget));
}

void spx_dialog_checkallnr_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(spx_dialog_allnr, gtk_toggle_button_get_active(widget));
}

void spx_dialog_buttonget_clicked(GtkWidget *widget, gpointer data) {
    int position = 0;

    /* position in frame */
    if (gtk_toggle_button_get_active((GtkToggleButton*) spx_dialog_radioatcursor))
        position = selected_byte;
    else if (gtk_toggle_button_get_active((GtkToggleButton*) spx_dialog_radioatspx))
	position = 44;

    /* set connection control */
    if (frame->len > position) {
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(spx_dialog_checkccno1), (frame->data[position] & 0x01) > 0);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(spx_dialog_checkccno2), (frame->data[position] & 0x02) > 0);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(spx_dialog_checkccsn), (frame->data[position] & 0x04) > 0);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(spx_dialog_checkccspx2), (frame->data[position] & 0x08) > 0);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(spx_dialog_checkcceom), (frame->data[position] & 0x10) > 0);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(spx_dialog_checkccab), (frame->data[position] & 0x20) > 0);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(spx_dialog_checkccar), (frame->data[position] & 0x40) > 0);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(spx_dialog_checkcctc), (frame->data[position] & 0x80) > 0);
    }
    position++;

    /* set data stream type */
    if (frame->len > position) {
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spx_dialog_datastr), frame->data[position]);
	gtk_combo_box_set_active((GtkComboBox*) spx_dialog_combodatastr, 0);
	gtk_widget_set_sensitive(spx_dialog_datastr, gtk_toggle_button_get_active((GtkToggleButton*) spx_dialog_checkdatastr));
    }
    position++;

    /* set source connection id */
    if (frame->len > position + 1)
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spx_dialog_srcid),
				    (frame->data[position] << 8) + frame->data[position + 1]);
    position += 2;

    /* set destination connection id */
    if (frame->len > position + 1)
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spx_dialog_dstid),
				    (frame->data[position] << 8) + frame->data[position + 1]);
    position += 2;

    /* set sequence number */
    if (frame->len > position + 1)
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spx_dialog_seqnr),
				    (frame->data[position] << 8) + frame->data[position + 1]);
    position += 2;

    /* set acknowledge number */
    if (frame->len > position + 1)
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spx_dialog_acknr),
				    (frame->data[position] << 8) + frame->data[position + 1]);
    position += 2;

    /* set allocation number */
    if (frame->len > position + 1)
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(spx_dialog_allnr),
				    (frame->data[position] << 8) + frame->data[position + 1]);
}

void spx_dialog_create() {
    int value;

    spx_dialog_window = gtk_dialog_new_with_buttons(_("Add SPX header"),
			    GTK_WINDOW(window_main),
			    GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                	    GTK_STOCK_OK, GTK_RESPONSE_OK,
                	    NULL);
    spx_dialog_buttonget = gtk_button_new_with_label(_("Get values from frame"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(spx_dialog_window)->action_area), spx_dialog_buttonget, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(spx_dialog_buttonget), "clicked", G_CALLBACK(spx_dialog_buttonget_clicked), NULL);
    gtk_dialog_add_button(GTK_DIALOG(spx_dialog_window), GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL);

    spx_dialog_label1 = gtk_label_new(_("Create header containing"));

    spx_dialog_hbox1 = gtk_hbox_new(TRUE, 5);
    spx_dialog_checkcc = gtk_check_button_new_with_label(_("Connection control"));
    gtk_toggle_button_set_active((GtkToggleButton*) spx_dialog_checkcc, TRUE);
    spx_dialog_framecc = gtk_frame_new(_("Connection control"));
    spx_dialog_vbox1 = gtk_vbox_new(TRUE, 5);
    spx_dialog_checkccno1 = gtk_check_button_new_with_label(_("Unused 1"));
    spx_dialog_checkccno2 = gtk_check_button_new_with_label(_("Unused 2"));
    spx_dialog_checkccsn = gtk_check_button_new_with_label(_("Size negotiation"));
    spx_dialog_checkccspx2 = gtk_check_button_new_with_label(_("SPX II type"));
    spx_dialog_checkcceom = gtk_check_button_new_with_label(_("End Of Message"));
    spx_dialog_checkccab = gtk_check_button_new_with_label(_("Attention bit"));
    spx_dialog_checkccar = gtk_check_button_new_with_label(_("Acknowledge required"));
    spx_dialog_checkcctc = gtk_check_button_new_with_label(_("Transport control"));
    gtk_box_pack_start(GTK_BOX(spx_dialog_vbox1), spx_dialog_checkccno1, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(spx_dialog_vbox1), spx_dialog_checkccno2, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(spx_dialog_vbox1), spx_dialog_checkccsn, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(spx_dialog_vbox1), spx_dialog_checkccspx2, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(spx_dialog_vbox1), spx_dialog_checkcceom, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(spx_dialog_vbox1), spx_dialog_checkccab, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(spx_dialog_vbox1), spx_dialog_checkccar, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(spx_dialog_vbox1), spx_dialog_checkcctc, TRUE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(spx_dialog_framecc), spx_dialog_vbox1);
    gtk_box_pack_start(GTK_BOX(spx_dialog_hbox1), spx_dialog_checkcc, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(spx_dialog_hbox1), spx_dialog_framecc, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(spx_dialog_checkcc), "toggled", G_CALLBACK(spx_dialog_checkcc_toggled), NULL);

    spx_dialog_hbox2 = gtk_hbox_new(FALSE, 5);
    spx_dialog_checkdatastr = gtk_check_button_new_with_label(_("Data stream type"));
    gtk_toggle_button_set_active((GtkToggleButton*) spx_dialog_checkdatastr, TRUE);
    spx_dialog_combodatastr = gtk_combo_box_new_text();
    gtk_combo_box_append_text((GtkComboBox*) spx_dialog_combodatastr, _("-other-"));
    value = 0;
    while (table_spx_types[value] != NULL)
        gtk_combo_box_append_text((GtkComboBox*) spx_dialog_combodatastr, _(table_spx_types[value++]));
    gtk_combo_box_set_active((GtkComboBox*) spx_dialog_combodatastr, 0);
    spx_dialog_datastr = gtk_spin_button_new_with_range(0, 255, 1);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spx_dialog_datastr), TRUE);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(spx_dialog_datastr), 0);
    gtk_entry_set_alignment(GTK_ENTRY(spx_dialog_datastr), 1);
    gtk_box_pack_start(GTK_BOX(spx_dialog_hbox2), spx_dialog_checkdatastr, FALSE, FALSE, 0);
    gtk_box_pack_end(GTK_BOX(spx_dialog_hbox2), spx_dialog_datastr, FALSE, FALSE, 0);
    gtk_box_pack_end(GTK_BOX(spx_dialog_hbox2), spx_dialog_combodatastr, FALSE, FALSE, 0);
    g_signal_connect(G_OBJECT(spx_dialog_combodatastr), "changed", G_CALLBACK(spx_dialog_combodatastr_changed), NULL);
    g_signal_connect(G_OBJECT(spx_dialog_checkdatastr), "toggled", G_CALLBACK(spx_dialog_checkdatastr_toggled), NULL);

    spx_dialog_hbox3 = gtk_hbox_new(TRUE, 5);
    spx_dialog_checksrcid = gtk_check_button_new_with_label(_("source connection id"));
    gtk_toggle_button_set_active((GtkToggleButton*) spx_dialog_checksrcid, TRUE);
    spx_dialog_srcid = gtk_spin_button_new_with_range(0, 65535, 1);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spx_dialog_srcid), TRUE);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(spx_dialog_srcid), 0);
    gtk_entry_set_alignment(GTK_ENTRY(spx_dialog_srcid), 1);
    gtk_box_pack_start(GTK_BOX(spx_dialog_hbox3), spx_dialog_checksrcid, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(spx_dialog_hbox3), spx_dialog_srcid, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(spx_dialog_checksrcid), "toggled", G_CALLBACK(spx_dialog_checksrcid_toggled), NULL);

    spx_dialog_hbox4 = gtk_hbox_new(TRUE, 5);
    spx_dialog_checkdstid = gtk_check_button_new_with_label(_("destination connection id"));
    gtk_toggle_button_set_active((GtkToggleButton*) spx_dialog_checkdstid, TRUE);
    spx_dialog_dstid = gtk_spin_button_new_with_range(0, 65535, 1);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spx_dialog_dstid), TRUE);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(spx_dialog_dstid), 0);
    gtk_entry_set_alignment(GTK_ENTRY(spx_dialog_dstid), 1);
    gtk_box_pack_start(GTK_BOX(spx_dialog_hbox4), spx_dialog_checkdstid, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(spx_dialog_hbox4), spx_dialog_dstid, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(spx_dialog_checkdstid), "toggled", G_CALLBACK(spx_dialog_checkdstid_toggled), NULL);

    spx_dialog_hbox5 = gtk_hbox_new(TRUE, 5);
    spx_dialog_checkseqnr = gtk_check_button_new_with_label(_("sequence number"));
    gtk_toggle_button_set_active((GtkToggleButton*) spx_dialog_checkseqnr, TRUE);
    spx_dialog_seqnr = gtk_spin_button_new_with_range(0, 65535, 1);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spx_dialog_seqnr), TRUE);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(spx_dialog_seqnr), 0);
    gtk_entry_set_alignment(GTK_ENTRY(spx_dialog_seqnr), 1);
    gtk_box_pack_start(GTK_BOX(spx_dialog_hbox5), spx_dialog_checkseqnr, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(spx_dialog_hbox5), spx_dialog_seqnr, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(spx_dialog_checkseqnr), "toggled", G_CALLBACK(spx_dialog_checkseqnr_toggled), NULL);

    spx_dialog_hbox6 = gtk_hbox_new(TRUE, 5);
    spx_dialog_checkacknr = gtk_check_button_new_with_label(_("acknowledge number"));
    gtk_toggle_button_set_active((GtkToggleButton*) spx_dialog_checkacknr, TRUE);
    spx_dialog_acknr = gtk_spin_button_new_with_range(0, 65535, 1);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spx_dialog_acknr), TRUE);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(spx_dialog_acknr), 0);
    gtk_entry_set_alignment(GTK_ENTRY(spx_dialog_acknr), 1);
    gtk_box_pack_start(GTK_BOX(spx_dialog_hbox6), spx_dialog_checkacknr, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(spx_dialog_hbox6), spx_dialog_acknr, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(spx_dialog_checkacknr), "toggled", G_CALLBACK(spx_dialog_checkacknr_toggled), NULL);

    spx_dialog_hbox7 = gtk_hbox_new(TRUE, 5);
    spx_dialog_checkallnr = gtk_check_button_new_with_label(_("allocation number"));
    gtk_toggle_button_set_active((GtkToggleButton*) spx_dialog_checkallnr, TRUE);
    spx_dialog_allnr = gtk_spin_button_new_with_range(0, 65535, 1);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spx_dialog_allnr), TRUE);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(spx_dialog_allnr), 0);
    gtk_entry_set_alignment(GTK_ENTRY(spx_dialog_allnr), 1);
    gtk_box_pack_start(GTK_BOX(spx_dialog_hbox7), spx_dialog_checkallnr, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(spx_dialog_hbox7), spx_dialog_allnr, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(spx_dialog_checkallnr), "toggled", G_CALLBACK(spx_dialog_checkallnr_toggled), NULL);

    spx_dialog_label2 = gtk_label_new(_("Write:"));
    spx_dialog_hbox8 = gtk_hbox_new(TRUE, 5);
    spx_dialog_radioatspx = gtk_radio_button_new_with_label(NULL, _("from 44th byte of frame"));
    spx_dialog_radioatcursor = gtk_radio_button_new_with_label_from_widget(
						    GTK_RADIO_BUTTON(spx_dialog_radioatspx),
						    _("from cursor's position"));
    gtk_toggle_button_set_active((GtkToggleButton*) spx_dialog_radioatspx, TRUE);
    gtk_box_pack_start(GTK_BOX(spx_dialog_hbox8), spx_dialog_radioatspx, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(spx_dialog_hbox8), spx_dialog_radioatcursor, TRUE, TRUE, 0);

    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(spx_dialog_window)->vbox), spx_dialog_label1, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(spx_dialog_window)->vbox), spx_dialog_hbox1, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(spx_dialog_window)->vbox), spx_dialog_hbox2, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(spx_dialog_window)->vbox), spx_dialog_hbox3, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(spx_dialog_window)->vbox), spx_dialog_hbox4, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(spx_dialog_window)->vbox), spx_dialog_hbox5, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(spx_dialog_window)->vbox), spx_dialog_hbox6, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(spx_dialog_window)->vbox), spx_dialog_hbox7, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(spx_dialog_window)->vbox), spx_dialog_label2, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(spx_dialog_window)->vbox), spx_dialog_hbox8, TRUE, TRUE, 2);
    gtk_widget_show_all(spx_dialog_window);
}

void spx_dialog_write_frame() {
    int value, position, position2;
    char *text;

    /* cleanup */
    if ((position = frame->spx_position) > -1) {
	frame->spx_position = -1;
	for (position2 = position; position2 < position + 20; position2++) {
    	    if (frame->len > position2)
        	fill_one_byte_cells(position2);
	}
    }

    /* position in frame */
    if (gtk_toggle_button_get_active((GtkToggleButton*) spx_dialog_radioatcursor))
        position = selected_byte;
    else if (gtk_toggle_button_get_active((GtkToggleButton*) spx_dialog_radioatspx))
	position = 44;

    /* cleanup old colors */
    if (frame->ip_position > -1) {
        for (position2 = frame->ip_position; position2 < frame->ip_position + 20; position2++) {
            if (frame->len > position2)
                set_default_color_for_cell(position2);
        }
    }
    if (frame->tcp_position > -1) {
        for (position2 = frame->tcp_position; position2 < frame->tcp_position + 20; position2++) {
            if (frame->len > position2)
                set_default_color_for_cell(position2);
        }
    }
    if (frame->udp_position > -1) {
        for (position2 = frame->udp_position; position2 < frame->udp_position + 8; position2++) {
            if (frame->len > position2)
                set_default_color_for_cell(position2);
        }
    }

    /* remember position */
    frame->ip_position = -1;
    frame->tcp_position = -1;
    frame->udp_position = -1;
    frame->spx_position = position;

    /* get connection control */
    if (gtk_toggle_button_get_active((GtkToggleButton*) spx_dialog_checkcc)) {
        /* add bytes to frame */
	if (frame->len < position + 1) {
    	    add_to_frame(position - frame->len + 1, NULL, 0);
    	    add_cells_to_tables();
	}
	frame->data[position] =
            	    (gtk_toggle_button_get_active((GtkToggleButton*) spx_dialog_checkcctc) << 7) +
            	    (gtk_toggle_button_get_active((GtkToggleButton*) spx_dialog_checkccar) << 6) +
            	    (gtk_toggle_button_get_active((GtkToggleButton*) spx_dialog_checkccab) << 5) +
            	    (gtk_toggle_button_get_active((GtkToggleButton*) spx_dialog_checkcceom) << 4) +
            	    (gtk_toggle_button_get_active((GtkToggleButton*) spx_dialog_checkccspx2) << 3) +
            	    (gtk_toggle_button_get_active((GtkToggleButton*) spx_dialog_checkccsn) << 2) +
            	    (gtk_toggle_button_get_active((GtkToggleButton*) spx_dialog_checkccno2) << 1) +
            	    gtk_toggle_button_get_active((GtkToggleButton*) spx_dialog_checkccno1);
    }
    position++;

    /* get data stream type */
    if (gtk_toggle_button_get_active((GtkToggleButton*) spx_dialog_checkdatastr)) {
	/* add bytes to frame */
	if (frame->len < position + 1) {
	    add_to_frame(position - frame->len + 1, NULL, 0);
	    add_cells_to_tables();
	}

        value = gtk_combo_box_get_active(GTK_COMBO_BOX(spx_dialog_combodatastr));
	if (value == 0)
	    value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spx_dialog_datastr));
	else {
	    text = malloc(4);
	    strncpy(text, table_spx_types[value - 1], strspn(_(table_spx_types[value - 1]), "0123456789"));
	    text[strspn(_(table_spx_types[value - 1]), "0123456789")] = 0;
	    value = (dec2int(text) & 0xFF);
	    free(text);
	}
	frame->data[position] = value & 0xFF;
    }
    position++;

    /* get source connection id */
    if (gtk_toggle_button_get_active((GtkToggleButton*) spx_dialog_checksrcid)) {
	/* add bytes to frame */
	if (frame->len < position + 2) {
	    add_to_frame(position - frame->len + 2, NULL, 0);
	    add_cells_to_tables();
	}
	value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spx_dialog_srcid));
	frame->data[position++] = (value & 0xFF00) >> 8;
	frame->data[position++] = value & 0xFF;
    } else
	position += 2;

    /* get destination connection id */
    if (gtk_toggle_button_get_active((GtkToggleButton*) spx_dialog_checkdstid)) {
	/* add bytes to frame */
	if (frame->len < position + 2) {
	    add_to_frame(position - frame->len + 2, NULL, 0);
	    add_cells_to_tables();
	}
	value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spx_dialog_dstid));
	frame->data[position++] = (value & 0xFF00) >> 8;
	frame->data[position++] = value & 0xFF;
    } else
	position += 2;

    /* get sequence number */
    if (gtk_toggle_button_get_active((GtkToggleButton*) spx_dialog_checkseqnr)) {
	/* add bytes to frame */
	if (frame->len < position + 2) {
	    add_to_frame(position - frame->len + 2, NULL, 0);
	    add_cells_to_tables();
	}
	value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spx_dialog_seqnr));
	frame->data[position++] = (value & 0xFF00) >> 8;
	frame->data[position++] = value & 0xFF;
    } else
	position += 2;

    /* get acknowledge number */
    if (gtk_toggle_button_get_active((GtkToggleButton*) spx_dialog_checkacknr)) {
	/* add bytes to frame */
	if (frame->len < position + 2) {
	    add_to_frame(position - frame->len + 2, NULL, 0);
	    add_cells_to_tables();
	}
	value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spx_dialog_acknr));
	frame->data[position++] = (value & 0xFF00) >> 8;
	frame->data[position++] = value & 0xFF;
    } else
	position += 2;

    /* get allocation number */
    if (gtk_toggle_button_get_active((GtkToggleButton*) spx_dialog_checkallnr)) {
	/* add bytes to frame */
	if (frame->len < position + 2) {
	    add_to_frame(position - frame->len + 2, NULL, 0);
	    add_cells_to_tables();
	}
	value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spx_dialog_allnr));
	frame->data[position++] = (value & 0xFF00) >> 8;
	frame->data[position++] = value & 0xFF;
    } else
	position += 2;

    /* refresh window */
    for (position2 = frame->spx_position; position2 < frame->spx_position + 20; position2++) {
        if (frame->len > position2)
            fill_one_byte_cells(position2);
    }
    fill_binary();
    fill_decimal();
    fill_datasize();
}
