/* $Id: gui-GTK_tcp-dialog.c,v 1.3 2005/03/20 22:26:54 emvi Exp $ */

/* 
Copyright (C) 2005 Marek Wardziski (emvi at emvi eu org) 
 
This file is part of Ant. 
 
Ant is free software; you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation; either version 2 of the License, or 
(at your option) any later version. 
 
Ant is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
GNU General Public License for more details. 
 
You should have received a copy of the GNU General Public License 
along with Ant; if not, write to the Free Software 
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "main.h"
#include "misc.h"
#include "net.h"

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "gui-GTK.h"
#include "gui-GTK_handlers.h"

GtkWidget *tcp_dialog_window;
GtkWidget *tcp_dialog_label1;
GtkWidget *tcp_dialog_hbox1;
GtkWidget *tcp_dialog_checksrcport;
GtkWidget *tcp_dialog_srcport;
GtkWidget *tcp_dialog_hbox2;
GtkWidget *tcp_dialog_checkdstport;
GtkWidget *tcp_dialog_dstport;
GtkWidget *tcp_dialog_hbox3;
GtkWidget *tcp_dialog_checkseqnr;
GtkWidget *tcp_dialog_seqnr;
GtkWidget *tcp_dialog_hbox4;
GtkWidget *tcp_dialog_checkacknr;
GtkWidget *tcp_dialog_acknr;
GtkWidget *tcp_dialog_hbox5;
GtkWidget *tcp_dialog_checkoffset;
GtkWidget *tcp_dialog_offset;
GtkWidget *tcp_dialog_hbox6;
GtkWidget *tcp_dialog_checkreserved;
GtkWidget *tcp_dialog_framereserved;
GtkWidget *tcp_dialog_vbox3;
GtkWidget *tcp_dialog_checkreserved1;
GtkWidget *tcp_dialog_checkreserved2;
GtkWidget *tcp_dialog_checkreserved3;
GtkWidget *tcp_dialog_hbox7;
GtkWidget *tcp_dialog_checkecn;
GtkWidget *tcp_dialog_frameecn;
GtkWidget *tcp_dialog_vbox1;
GtkWidget *tcp_dialog_checkecnN;
GtkWidget *tcp_dialog_checkecnC;
GtkWidget *tcp_dialog_checkecnE;
GtkWidget *tcp_dialog_hbox8;
GtkWidget *tcp_dialog_checkcontrol;
GtkWidget *tcp_dialog_framecontrol;
GtkWidget *tcp_dialog_vbox2;
GtkWidget *tcp_dialog_checkcontrolU;
GtkWidget *tcp_dialog_checkcontrolA;
GtkWidget *tcp_dialog_checkcontrolP;
GtkWidget *tcp_dialog_checkcontrolR;
GtkWidget *tcp_dialog_checkcontrolS;
GtkWidget *tcp_dialog_checkcontrolF;
GtkWidget *tcp_dialog_hbox9;
GtkWidget *tcp_dialog_checkwindow;
GtkWidget *tcp_dialog_windowfield;
GtkWidget *tcp_dialog_hbox10;
GtkWidget *tcp_dialog_checkurgpointer;
GtkWidget *tcp_dialog_urgpointer;
GtkWidget *tcp_dialog_label2;
GtkWidget *tcp_dialog_hbox11;
GtkWidget *tcp_dialog_radioattcp;
GtkWidget *tcp_dialog_radioatcursor;
GtkWidget *tcp_dialog_buttonget;

void tcp_dialog_checksrcport_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(tcp_dialog_srcport, gtk_toggle_button_get_active(widget));
}

void tcp_dialog_checkdstport_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(tcp_dialog_dstport, gtk_toggle_button_get_active(widget));
}

void tcp_dialog_checkseqnr_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(tcp_dialog_seqnr, gtk_toggle_button_get_active(widget));
}

void tcp_dialog_checkacknr_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(tcp_dialog_acknr, gtk_toggle_button_get_active(widget));
}

void tcp_dialog_checkoffset_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(tcp_dialog_offset, gtk_toggle_button_get_active(widget));
}

void tcp_dialog_checkreserved_toggled(GtkToggleButton *widget, gpointer data) {
    gboolean active;
    active = gtk_toggle_button_get_active(widget);
    gtk_widget_set_sensitive(tcp_dialog_checkreserved1, active);
    gtk_widget_set_sensitive(tcp_dialog_checkreserved2, active);
    gtk_widget_set_sensitive(tcp_dialog_checkreserved3, active);
}

void tcp_dialog_checkecn_toggled(GtkToggleButton *widget, gpointer data) {
    gboolean active;
    active = gtk_toggle_button_get_active(widget);
    gtk_widget_set_sensitive(tcp_dialog_checkecnN, active);
    gtk_widget_set_sensitive(tcp_dialog_checkecnC, active);
    gtk_widget_set_sensitive(tcp_dialog_checkecnE, active);
}

void tcp_dialog_checkcontrol_toggled(GtkToggleButton *widget, gpointer data) {
    gboolean active;
    active = gtk_toggle_button_get_active(widget);
    gtk_widget_set_sensitive(tcp_dialog_checkcontrolU, active);
    gtk_widget_set_sensitive(tcp_dialog_checkcontrolA, active);
    gtk_widget_set_sensitive(tcp_dialog_checkcontrolP, active);
    gtk_widget_set_sensitive(tcp_dialog_checkcontrolR, active);
    gtk_widget_set_sensitive(tcp_dialog_checkcontrolS, active);
    gtk_widget_set_sensitive(tcp_dialog_checkcontrolF, active);
}

void tcp_dialog_checkwindow_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(tcp_dialog_windowfield, gtk_toggle_button_get_active(widget));
}

void tcp_dialog_checkurgpointer_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(tcp_dialog_urgpointer, gtk_toggle_button_get_active(widget));
}

void tcp_dialog_buttonget_clicked(GtkWidget *widget, gpointer data) {
    int position = 0;

    /* position in frame */
    if (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_radioatcursor))
        position = selected_byte;
    else if (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_radioattcp))
	position = 34;

    /* set source port */
    if (frame->len > position + 1)
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(tcp_dialog_srcport),
				(frame->data[position] << 8) + frame->data[position + 1]);
    position += 2;

    /* set destination port */
    if (frame->len > position + 1)
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(tcp_dialog_dstport),
				(frame->data[position] << 8) + frame->data[position + 1]);
    position += 2;

    /* set sequence number */
    if (frame->len > position + 3)
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(tcp_dialog_seqnr),
				(unsigned long long int)(frame->data[position] << 24) + 
				(unsigned long long int)(frame->data[position + 1] << 16) +
				(frame->data[position + 2] << 8) +
				frame->data[position + 3]);
    position += 4;

    /* set acknowledge number */
    if (frame->len > position + 3)
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(tcp_dialog_acknr),
				(unsigned long long int)(frame->data[position] << 24) + 
				(unsigned long long int)(frame->data[position + 1] << 16) +
				(frame->data[position + 2] << 8) +
				frame->data[position + 3]);
    position += 4;

    /* set offset */
    if (frame->len > position)
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(tcp_dialog_offset),
			    ((frame->data[position] & 0xF0) >> 2));

    /* set reserved */
    if (frame->len > position) {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tcp_dialog_checkreserved1), (frame->data[position] & 0x08) > 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tcp_dialog_checkreserved2), (frame->data[position] & 0x04) > 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tcp_dialog_checkreserved3), (frame->data[position] & 0x02) > 0);
    }

    /* set ecn */
    if (frame->len > position)
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tcp_dialog_checkecnN), (frame->data[position] & 0x01) > 0);
    if (frame->len > ++position) {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tcp_dialog_checkecnC), (frame->data[position] & 0x80) > 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tcp_dialog_checkecnE), (frame->data[position] & 0x40) > 0);
    }

    /* set control bits */
    if (frame->len > position) {
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tcp_dialog_checkcontrolU), (frame->data[position] & 0x20) > 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tcp_dialog_checkcontrolA), (frame->data[position] & 0x10) > 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tcp_dialog_checkcontrolP), (frame->data[position] & 0x08) > 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tcp_dialog_checkcontrolR), (frame->data[position] & 0x04) > 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tcp_dialog_checkcontrolS), (frame->data[position] & 0x02) > 0);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(tcp_dialog_checkcontrolF), (frame->data[position] & 0x01) > 0);
    }
    position++;

    /* set destination port */
    if (frame->len > position + 1)
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(tcp_dialog_windowfield),
				(frame->data[position] << 8) + frame->data[position + 1]);
    /* skip checksum */
    position += 4;

    /* set destination port */
    if (frame->len > position + 1)
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(tcp_dialog_urgpointer),
				(frame->data[position] << 8) + frame->data[position + 1]);
}

void tcp_dialog_create() {

    tcp_dialog_window = gtk_dialog_new_with_buttons(_("Add TCP header"),
			    GTK_WINDOW(window_main),
			    GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                	    GTK_STOCK_OK, GTK_RESPONSE_OK,
                	    NULL);
    tcp_dialog_buttonget = gtk_button_new_with_label(_("Get values from frame"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(tcp_dialog_window)->action_area), tcp_dialog_buttonget, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(tcp_dialog_buttonget), "clicked", G_CALLBACK(tcp_dialog_buttonget_clicked), NULL);
    gtk_dialog_add_button(GTK_DIALOG(tcp_dialog_window), GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL);

    tcp_dialog_label1 = gtk_label_new(_("Create header containing"));

    tcp_dialog_hbox1 = gtk_hbox_new(TRUE, 5);
    tcp_dialog_checksrcport = gtk_check_button_new_with_label(_("Surce port"));
    gtk_toggle_button_set_active((GtkToggleButton*) tcp_dialog_checksrcport, TRUE);
    tcp_dialog_srcport = gtk_spin_button_new_with_range(0, 65535, 1);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(tcp_dialog_srcport), TRUE);
    gtk_entry_set_alignment(GTK_ENTRY(tcp_dialog_srcport), 1);
    gtk_box_pack_start(GTK_BOX(tcp_dialog_hbox1), tcp_dialog_checksrcport, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(tcp_dialog_hbox1), tcp_dialog_srcport, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(tcp_dialog_checksrcport), "toggled", G_CALLBACK(tcp_dialog_checksrcport_toggled), NULL);

    tcp_dialog_hbox2 = gtk_hbox_new(TRUE, 5);
    tcp_dialog_checkdstport = gtk_check_button_new_with_label(_("Destination port"));
    gtk_toggle_button_set_active((GtkToggleButton*) tcp_dialog_checkdstport, TRUE);
    tcp_dialog_dstport = gtk_spin_button_new_with_range(0, 65535, 1);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(tcp_dialog_dstport), TRUE);
    gtk_entry_set_alignment(GTK_ENTRY(tcp_dialog_dstport), 1);
    gtk_box_pack_start(GTK_BOX(tcp_dialog_hbox2), tcp_dialog_checkdstport, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(tcp_dialog_hbox2), tcp_dialog_dstport, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(tcp_dialog_checkdstport), "toggled", G_CALLBACK(tcp_dialog_checkdstport_toggled), NULL);

    tcp_dialog_hbox3 = gtk_hbox_new(TRUE, 5);
    tcp_dialog_checkseqnr = gtk_check_button_new_with_label(_("Sequence number"));
    gtk_toggle_button_set_active((GtkToggleButton*) tcp_dialog_checkseqnr, TRUE);
    tcp_dialog_seqnr = gtk_spin_button_new_with_range(0, (gdouble)65536*65536-1, 1);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(tcp_dialog_seqnr), TRUE);
    gtk_entry_set_alignment(GTK_ENTRY(tcp_dialog_seqnr), 1);
    gtk_box_pack_start(GTK_BOX(tcp_dialog_hbox3), tcp_dialog_checkseqnr, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(tcp_dialog_hbox3), tcp_dialog_seqnr, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(tcp_dialog_checkseqnr), "toggled", G_CALLBACK(tcp_dialog_checkseqnr_toggled), NULL);

    tcp_dialog_hbox4 = gtk_hbox_new(TRUE, 5);
    tcp_dialog_checkacknr = gtk_check_button_new_with_label(_("Acknowledgment number"));
    gtk_toggle_button_set_active((GtkToggleButton*) tcp_dialog_checkacknr, TRUE);
    tcp_dialog_acknr = gtk_spin_button_new_with_range(0, (gdouble)65536*65536-1, 1);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(tcp_dialog_acknr), TRUE);
    gtk_entry_set_alignment(GTK_ENTRY(tcp_dialog_acknr), 1);
    gtk_box_pack_start(GTK_BOX(tcp_dialog_hbox4), tcp_dialog_checkacknr, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(tcp_dialog_hbox4), tcp_dialog_acknr, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(tcp_dialog_checkacknr), "toggled", G_CALLBACK(tcp_dialog_checkacknr_toggled), NULL);

    tcp_dialog_hbox5 = gtk_hbox_new(TRUE, 5);
    tcp_dialog_checkoffset = gtk_check_button_new_with_label(_("Data offset"));
    gtk_toggle_button_set_active((GtkToggleButton*) tcp_dialog_checkoffset, TRUE);
    tcp_dialog_offset = gtk_spin_button_new_with_range(0, 60, 4);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(tcp_dialog_offset), TRUE);
    gtk_spin_button_set_snap_to_ticks(GTK_SPIN_BUTTON(tcp_dialog_offset), TRUE);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(tcp_dialog_offset), 20);
    gtk_entry_set_alignment(GTK_ENTRY(tcp_dialog_offset), 1);
    gtk_box_pack_start(GTK_BOX(tcp_dialog_hbox5), tcp_dialog_checkoffset, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(tcp_dialog_hbox5), tcp_dialog_offset, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(tcp_dialog_checkoffset), "toggled", G_CALLBACK(tcp_dialog_checkoffset_toggled), NULL);

    tcp_dialog_hbox6 = gtk_hbox_new(TRUE, 5);
    tcp_dialog_checkreserved = gtk_check_button_new_with_label(_("Reserved bits"));
    gtk_toggle_button_set_active((GtkToggleButton*) tcp_dialog_checkreserved, TRUE);
    tcp_dialog_framereserved = gtk_frame_new(_("Reserved bits"));
    tcp_dialog_vbox3 = gtk_vbox_new(TRUE, 5);
    tcp_dialog_checkreserved1 = gtk_check_button_new_with_label(_("bit 1"));
    tcp_dialog_checkreserved2 = gtk_check_button_new_with_label(_("bit 2"));
    tcp_dialog_checkreserved3 = gtk_check_button_new_with_label(_("bit 3"));
    gtk_box_pack_start(GTK_BOX(tcp_dialog_vbox3), tcp_dialog_checkreserved1, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(tcp_dialog_vbox3), tcp_dialog_checkreserved2, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(tcp_dialog_vbox3), tcp_dialog_checkreserved3, TRUE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(tcp_dialog_framereserved), tcp_dialog_vbox3);
    gtk_box_pack_start(GTK_BOX(tcp_dialog_hbox6), tcp_dialog_checkreserved, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(tcp_dialog_hbox6), tcp_dialog_framereserved, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(tcp_dialog_checkreserved), "toggled", G_CALLBACK(tcp_dialog_checkreserved_toggled), NULL);

    tcp_dialog_hbox7 = gtk_hbox_new(TRUE, 5);
    tcp_dialog_checkecn = gtk_check_button_new_with_label(_("Explicit Congestion Notification"));
    gtk_toggle_button_set_active((GtkToggleButton*) tcp_dialog_checkecn, TRUE);
    tcp_dialog_frameecn = gtk_frame_new(_("ECN"));
    tcp_dialog_vbox1 = gtk_vbox_new(TRUE, 5);
    tcp_dialog_checkecnN = gtk_check_button_new_with_label(_("Nonce Sum"));
    tcp_dialog_checkecnC = gtk_check_button_new_with_label(_("CWR"));
    tcp_dialog_checkecnE = gtk_check_button_new_with_label(_("ECN-Echo"));
    gtk_box_pack_start(GTK_BOX(tcp_dialog_vbox1), tcp_dialog_checkecnN, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(tcp_dialog_vbox1), tcp_dialog_checkecnC, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(tcp_dialog_vbox1), tcp_dialog_checkecnE, TRUE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(tcp_dialog_frameecn), tcp_dialog_vbox1);
    gtk_box_pack_start(GTK_BOX(tcp_dialog_hbox7), tcp_dialog_checkecn, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(tcp_dialog_hbox7), tcp_dialog_frameecn, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(tcp_dialog_checkecn), "toggled", G_CALLBACK(tcp_dialog_checkecn_toggled), NULL);

    tcp_dialog_hbox8 = gtk_hbox_new(TRUE, 5);
    tcp_dialog_checkcontrol = gtk_check_button_new_with_label(_("Control bits"));
    gtk_toggle_button_set_active((GtkToggleButton*) tcp_dialog_checkcontrol, TRUE);
    tcp_dialog_framecontrol = gtk_frame_new(_("Control bits"));
    tcp_dialog_vbox2 = gtk_vbox_new(TRUE, 5);
    tcp_dialog_checkcontrolU = gtk_check_button_new_with_label(_("Urgent pointer"));
    tcp_dialog_checkcontrolA = gtk_check_button_new_with_label(_("Acknowledgment"));
    tcp_dialog_checkcontrolP = gtk_check_button_new_with_label(_("Push"));
    tcp_dialog_checkcontrolR = gtk_check_button_new_with_label(_("Reset connection"));
    tcp_dialog_checkcontrolS = gtk_check_button_new_with_label(_("Syncronize sequence numbers"));
    tcp_dialog_checkcontrolF = gtk_check_button_new_with_label(_("End of data"));
    gtk_box_pack_start(GTK_BOX(tcp_dialog_vbox2), tcp_dialog_checkcontrolU, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(tcp_dialog_vbox2), tcp_dialog_checkcontrolA, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(tcp_dialog_vbox2), tcp_dialog_checkcontrolP, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(tcp_dialog_vbox2), tcp_dialog_checkcontrolR, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(tcp_dialog_vbox2), tcp_dialog_checkcontrolS, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(tcp_dialog_vbox2), tcp_dialog_checkcontrolF, TRUE, TRUE, 0);
    gtk_container_add(GTK_CONTAINER(tcp_dialog_framecontrol), tcp_dialog_vbox2);
    gtk_box_pack_start(GTK_BOX(tcp_dialog_hbox8), tcp_dialog_checkcontrol, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(tcp_dialog_hbox8), tcp_dialog_framecontrol, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(tcp_dialog_checkcontrol), "toggled", G_CALLBACK(tcp_dialog_checkcontrol_toggled), NULL);

    tcp_dialog_hbox9 = gtk_hbox_new(TRUE, 5);
    tcp_dialog_checkwindow = gtk_check_button_new_with_label(_("Window"));
    gtk_toggle_button_set_active((GtkToggleButton*) tcp_dialog_checkwindow, TRUE);
    tcp_dialog_windowfield = gtk_spin_button_new_with_range(0, 65535, 1);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(tcp_dialog_windowfield), TRUE);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(tcp_dialog_windowfield), 65535);
    gtk_entry_set_alignment(GTK_ENTRY(tcp_dialog_windowfield), 1);
    gtk_box_pack_start(GTK_BOX(tcp_dialog_hbox9), tcp_dialog_checkwindow, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(tcp_dialog_hbox9), tcp_dialog_windowfield, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(tcp_dialog_checkwindow), "toggled", G_CALLBACK(tcp_dialog_checkwindow_toggled), NULL);

    tcp_dialog_hbox10 = gtk_hbox_new(TRUE, 5);
    tcp_dialog_checkurgpointer = gtk_check_button_new_with_label(_("Urgent pointer"));
    gtk_toggle_button_set_active((GtkToggleButton*) tcp_dialog_checkurgpointer, TRUE);
    tcp_dialog_urgpointer = gtk_spin_button_new_with_range(0, 65535, 1);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(tcp_dialog_urgpointer), TRUE);
    gtk_entry_set_alignment(GTK_ENTRY(tcp_dialog_urgpointer), 1);
    gtk_box_pack_start(GTK_BOX(tcp_dialog_hbox10), tcp_dialog_checkurgpointer, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(tcp_dialog_hbox10), tcp_dialog_urgpointer, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(tcp_dialog_checkurgpointer), "toggled", G_CALLBACK(tcp_dialog_checkurgpointer_toggled), NULL);

    tcp_dialog_label2 = gtk_label_new(_("Write:"));
    tcp_dialog_hbox11 = gtk_hbox_new(FALSE, 5);
    tcp_dialog_radioattcp = gtk_radio_button_new_with_label(NULL, _("from 34th byte of frame"));
    tcp_dialog_radioatcursor = gtk_radio_button_new_with_label_from_widget(
						    GTK_RADIO_BUTTON(tcp_dialog_radioattcp),
						    _("from cursor's position"));
    gtk_toggle_button_set_active((GtkToggleButton*) tcp_dialog_radioattcp, TRUE);
    gtk_box_pack_start(GTK_BOX(tcp_dialog_hbox11), tcp_dialog_radioattcp, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(tcp_dialog_hbox11), tcp_dialog_radioatcursor, TRUE, TRUE, 0);

    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(tcp_dialog_window)->vbox), tcp_dialog_label1, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(tcp_dialog_window)->vbox), tcp_dialog_hbox1, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(tcp_dialog_window)->vbox), tcp_dialog_hbox2, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(tcp_dialog_window)->vbox), tcp_dialog_hbox3, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(tcp_dialog_window)->vbox), tcp_dialog_hbox4, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(tcp_dialog_window)->vbox), tcp_dialog_hbox5, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(tcp_dialog_window)->vbox), tcp_dialog_hbox6, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(tcp_dialog_window)->vbox), tcp_dialog_hbox7, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(tcp_dialog_window)->vbox), tcp_dialog_hbox8, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(tcp_dialog_window)->vbox), tcp_dialog_hbox9, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(tcp_dialog_window)->vbox), tcp_dialog_hbox10, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(tcp_dialog_window)->vbox), tcp_dialog_label2, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(tcp_dialog_window)->vbox), tcp_dialog_hbox11, TRUE, TRUE, 2);
    gtk_widget_show_all(tcp_dialog_window);
}

void tcp_dialog_write_frame() {
    int value, position, position2;
    unsigned long long int value2;

    /* cleanup */
    if ((position = frame->tcp_position) > -1) {
	frame->tcp_position = -1;
	for (position2 = position; position2 < position + 20; position2++) {
    	    if (frame->len > position2)
        	fill_one_byte_cells(position2);
	}
    }

    /* position in frame */
    if (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_radioatcursor))
        position = selected_byte;
    else if (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_radioattcp))
	position = 34;

    /* cleanup old colors */
    if (frame->ipx_position > -1) {
        for (position2 = frame->ipx_position; position2 < frame->ipx_position + 30; position2++) {
            if (frame->len > position2)
                set_default_color_for_cell(position2);
        }
    }
    if (frame->spx_position > -1) {
        for (position2 = frame->spx_position; position2 < frame->spx_position + 12; position2++) {
            if (frame->len > position2)
                set_default_color_for_cell(position2);
        }
    }
    if (frame->udp_position > -1) {
        for (position2 = frame->udp_position; position2 < frame->udp_position + 8; position2++) {
            if (frame->len > position2)
                set_default_color_for_cell(position2);
        }
    }

    /* remember position */
    frame->ipx_position = -1;
    frame->spx_position = -1;
    frame->udp_position = -1;
    frame->tcp_position = position;

    /* get source port */
    if (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checksrcport)) {
	/* add bytes to frame */
	if (frame->len < position + 2) {
	    add_to_frame(position - frame->len + 2, NULL, 0);
	    add_cells_to_tables();
	}
	value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(tcp_dialog_srcport));
	frame->data[position++] = (value & 0xFF00) >> 8;
	frame->data[position++] = value & 0xFF;
    } else
	position += 2;

    /* get destination port */
    if (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checkdstport)) {
	/* add bytes to frame */
	if (frame->len < position + 2) {
	    add_to_frame(position - frame->len + 2, NULL, 0);
	    add_cells_to_tables();
	}
	value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(tcp_dialog_dstport));
	frame->data[position++] = (value & 0xFF00) >> 8;
	frame->data[position++] = value & 0xFF;
    } else
	position += 2;

    /* get sequence number */
    if (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checkseqnr)) {
	/* add bytes to frame */
	if (frame->len < position + 4) {
	    add_to_frame(position - frame->len + 4, NULL, 0);
	    add_cells_to_tables();
	}
	value2 = (unsigned long long int) gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(tcp_dialog_seqnr));
	frame->data[position++] = (value2 & 0xFF000000ULL) >> 24;
	frame->data[position++] = (value2 & 0xFF0000ULL) >> 16;
	frame->data[position++] = (value2 & 0xFF00) >> 8;
	frame->data[position++] = (value2 & 0xFF);
    } else
	position += 4;

    /* get acknowledge number */
    if (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checkacknr)) {
	/* add bytes to frame */
	if (frame->len < position + 4) {
	    add_to_frame(position - frame->len + 4, NULL, 0);
	    add_cells_to_tables();
	}
	value2 = (unsigned long long int) gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(tcp_dialog_acknr));
	frame->data[position++] = (value2 & 0xFF000000ULL) >> 24;
	frame->data[position++] = (value2 & 0xFF0000ULL) >> 16;
	frame->data[position++] = (value2 & 0xFF00) >> 8;
	frame->data[position++] = (value2 & 0xFF);
    } else
	position += 4;

    /* get offset */
    if (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checkoffset)) {
	/* add bytes to frame */
	if (frame->len < position + 1) {
	    add_to_frame(position - frame->len + 1, NULL, 0);
	    add_cells_to_tables();
	}
	value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(tcp_dialog_offset));
	frame->data[position] = (frame->data[position] & 0x0F) +
		    (value << 2);
    }

    /* get reserved */
    if (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checkreserved)) {
	/* add bytes to frame */
	if (frame->len < position + 1) {
	    add_to_frame(position - frame->len + 1, NULL, 0);
	    add_cells_to_tables();
	}
	frame->data[position] = (frame->data[position] & 0xF1) +
		    (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checkreserved1) << 3) +
		    (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checkreserved2) << 2) +
		    (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checkreserved3) << 1);
    }

    /* get ecn */
    if (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checkreserved)) {
	/* add bytes to frame */
	if (frame->len < position + 2) {
	    add_to_frame(position - frame->len + 2, NULL, 0);
	    add_cells_to_tables();
	}
	frame->data[position] = (frame->data[position] & 0xFE) +
		    gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checkecnN);
	position++;
	frame->data[position] = (frame->data[position] & 0x3F) +
		    (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checkecnC) << 7) +
		    (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checkecnE) << 6);
    } else
	position++;

    /* get control bits */
    if (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checkcontrol)) {
	/* add bytes to frame */
	if (frame->len < position + 1) {
	    add_to_frame(position - frame->len + 1, NULL, 0);
	    add_cells_to_tables();
	}
	frame->data[position] = (frame->data[position] & 0xC0) +
		    (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checkcontrolU) << 5) +
		    (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checkcontrolA) << 4) +
		    (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checkcontrolP) << 3) +
		    (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checkcontrolR) << 2) +
		    (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checkcontrolS) << 1) +
		    gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checkcontrolF);
    }
    position++;

    /* get window */
    if (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checkwindow)) {
	/* add bytes to frame */
	if (frame->len < position + 2) {
	    add_to_frame(position - frame->len + 2, NULL, 0);
	    add_cells_to_tables();
	}
	value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(tcp_dialog_windowfield));
	frame->data[position++] = (value & 0xFF00) >> 8;
	frame->data[position++] = value & 0xFF;
    } else
	position += 2;

    /* skip checksum field */
    position += 2;

    /* get urgent pointer */
    if (gtk_toggle_button_get_active((GtkToggleButton*) tcp_dialog_checkurgpointer)) {
	/* add bytes to frame */
	if (frame->len < position + 2) {
	    add_to_frame(position - frame->len + 2, NULL, 0);
	    add_cells_to_tables();
	}
	value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(tcp_dialog_urgpointer));
	frame->data[position++] = (value & 0xFF00) >> 8;
	frame->data[position] = value & 0xFF;
    }

    /* refresh window */
    for (position2 = frame->tcp_position; position2 < frame->tcp_position + 20; position2++) {
        if (frame->len > position2)
            fill_one_byte_cells(position2);
    }
    fill_binary();
    fill_decimal();
    fill_datasize();
}
