/* $Id: gui-GTK_udp-dialog.c,v 1.3 2005/03/20 22:26:54 emvi Exp $ */

/* 
Copyright (C) 2005 Marek Wardziski (emvi at emvi eu org) 
 
This file is part of Ant. 
 
Ant is free software; you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation; either version 2 of the License, or 
(at your option) any later version. 
 
Ant is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
GNU General Public License for more details. 
 
You should have received a copy of the GNU General Public License 
along with Ant; if not, write to the Free Software 
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "main.h"
#include "misc.h"
#include "net.h"

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "gui-GTK.h"
#include "gui-GTK_handlers.h"

GtkWidget *udp_dialog_window;
GtkWidget *udp_dialog_label1;
GtkWidget *udp_dialog_hbox1;
GtkWidget *udp_dialog_checksrcport;
GtkWidget *udp_dialog_srcport;
GtkWidget *udp_dialog_hbox2;
GtkWidget *udp_dialog_checkdstport;
GtkWidget *udp_dialog_dstport;
GtkWidget *udp_dialog_hbox3;
GtkWidget *udp_dialog_checklen;
GtkWidget *udp_dialog_len;
GtkWidget *udp_dialog_label2;
GtkWidget *udp_dialog_hbox4;
GtkWidget *udp_dialog_radioatudp;
GtkWidget *udp_dialog_radioatcursor;

GtkWidget *udp_dialog_buttonget;

void udp_dialog_checksrcport_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(udp_dialog_srcport, gtk_toggle_button_get_active(widget));
}

void udp_dialog_checkdstport_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(udp_dialog_dstport, gtk_toggle_button_get_active(widget));
}

void udp_dialog_checklen_toggled(GtkToggleButton *widget, gpointer data) {
    gtk_widget_set_sensitive(udp_dialog_len, gtk_toggle_button_get_active(widget));
}

void udp_dialog_buttonget_clicked(GtkWidget *widget, gpointer data) {
    int position = 0;

    /* position in frame */
    if (gtk_toggle_button_get_active((GtkToggleButton*) udp_dialog_radioatcursor))
        position = selected_byte;
    else if (gtk_toggle_button_get_active((GtkToggleButton*) udp_dialog_radioatudp))
	position = 34;

    /* set source port */
    if (frame->len > position + 1)
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(udp_dialog_srcport),
				(frame->data[position] << 8) + frame->data[position + 1]);
    position += 2;

    /* set destination port */
    if (frame->len > position + 1)
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(udp_dialog_dstport),
				(frame->data[position] << 8) + frame->data[position + 1]);
    position += 2;

    /* set len */
    if (frame->len > position + 1)
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(udp_dialog_len),
				(frame->data[position] << 8) + frame->data[position + 1]);
    position += 2;
}

void udp_dialog_create() {
    int value;

    udp_dialog_window = gtk_dialog_new_with_buttons(_("Add UDP header"),
			    GTK_WINDOW(window_main),
			    GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                	    GTK_STOCK_OK, GTK_RESPONSE_OK,
                	    NULL);
    udp_dialog_buttonget = gtk_button_new_with_label(_("Get values from frame"));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(udp_dialog_window)->action_area), udp_dialog_buttonget, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(udp_dialog_buttonget), "clicked", G_CALLBACK(udp_dialog_buttonget_clicked), NULL);
    gtk_dialog_add_button(GTK_DIALOG(udp_dialog_window), GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL);

    udp_dialog_label1 = gtk_label_new(_("Create header containing"));

    udp_dialog_hbox1 = gtk_hbox_new(TRUE, 5);
    udp_dialog_checksrcport = gtk_check_button_new_with_label(_("source port"));
    gtk_toggle_button_set_active((GtkToggleButton*) udp_dialog_checksrcport, TRUE);
    udp_dialog_srcport = gtk_spin_button_new_with_range(0, 65535, 1);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(udp_dialog_srcport), TRUE);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(udp_dialog_srcport), 0);
    gtk_entry_set_width_chars(GTK_ENTRY(udp_dialog_srcport), 5);
    gtk_entry_set_max_length(GTK_ENTRY(udp_dialog_srcport), 5);
    gtk_entry_set_alignment(GTK_ENTRY(udp_dialog_srcport), 1);
    gtk_box_pack_start(GTK_BOX(udp_dialog_hbox1), udp_dialog_checksrcport, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(udp_dialog_hbox1), udp_dialog_srcport, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(udp_dialog_checksrcport), "toggled", G_CALLBACK(udp_dialog_checksrcport_toggled), NULL);

    udp_dialog_hbox2 = gtk_hbox_new(TRUE, 5);
    udp_dialog_checkdstport = gtk_check_button_new_with_label(_("destination port"));
    gtk_toggle_button_set_active((GtkToggleButton*) udp_dialog_checkdstport, TRUE);
    udp_dialog_dstport = gtk_spin_button_new_with_range(0, 65535, 1);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(udp_dialog_dstport), TRUE);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(udp_dialog_dstport), 0);
    gtk_entry_set_width_chars(GTK_ENTRY(udp_dialog_dstport), 5);
    gtk_entry_set_max_length(GTK_ENTRY(udp_dialog_dstport), 5);
    gtk_entry_set_alignment(GTK_ENTRY(udp_dialog_dstport), 1);
    gtk_box_pack_start(GTK_BOX(udp_dialog_hbox2), udp_dialog_checkdstport, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(udp_dialog_hbox2), udp_dialog_dstport, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(udp_dialog_checkdstport), "toggled", G_CALLBACK(udp_dialog_checkdstport_toggled), NULL);

    udp_dialog_hbox3 = gtk_hbox_new(TRUE, 5);
    udp_dialog_checklen = gtk_check_button_new_with_label(_("length"));
    gtk_toggle_button_set_active((GtkToggleButton*) udp_dialog_checklen, TRUE);
    udp_dialog_len = gtk_spin_button_new_with_range(0, 65535, 1);
    gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(udp_dialog_len), TRUE);
    value = frame->len - 34;
    if (value < 8)
	value = 8;
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(udp_dialog_len), value);
    gtk_entry_set_width_chars(GTK_ENTRY(udp_dialog_len), 5);
    gtk_entry_set_max_length(GTK_ENTRY(udp_dialog_len), 5);
    gtk_entry_set_alignment(GTK_ENTRY(udp_dialog_len), 1);
    gtk_box_pack_start(GTK_BOX(udp_dialog_hbox3), udp_dialog_checklen, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(udp_dialog_hbox3), udp_dialog_len, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(udp_dialog_checklen), "toggled", G_CALLBACK(udp_dialog_checklen_toggled), NULL);

    udp_dialog_label2 = gtk_label_new(_("Write:"));
    udp_dialog_hbox4 = gtk_hbox_new(TRUE, 5);
    udp_dialog_radioatudp = gtk_radio_button_new_with_label(NULL, _("from 34th byte of frame"));
    udp_dialog_radioatcursor = gtk_radio_button_new_with_label_from_widget(
						    GTK_RADIO_BUTTON(udp_dialog_radioatudp),
						    _("from cursor's position"));
    gtk_toggle_button_set_active((GtkToggleButton*) udp_dialog_radioatudp, TRUE);
    gtk_box_pack_start(GTK_BOX(udp_dialog_hbox4), udp_dialog_radioatudp, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(udp_dialog_hbox4), udp_dialog_radioatcursor, TRUE, TRUE, 0);

    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(udp_dialog_window)->vbox), udp_dialog_label1, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(udp_dialog_window)->vbox), udp_dialog_hbox1, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(udp_dialog_window)->vbox), udp_dialog_hbox2, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(udp_dialog_window)->vbox), udp_dialog_hbox3, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(udp_dialog_window)->vbox), udp_dialog_label2, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(udp_dialog_window)->vbox), udp_dialog_hbox4, TRUE, TRUE, 2);
    gtk_widget_show_all(udp_dialog_window);
}

void udp_dialog_write_frame() {
    int value, position, position2;

    /* cleanup */
    if ((position = frame->udp_position) > -1) {
	frame->udp_position = -1;
        for (position2 = position; position2 < position + 12; position2++) {
    	    if (frame->len > position2)
        	fill_one_byte_cells(position2);
	}
    }

    /* position in frame */
    if (gtk_toggle_button_get_active((GtkToggleButton*) udp_dialog_radioatcursor))
        position = selected_byte;
    else if (gtk_toggle_button_get_active((GtkToggleButton*) udp_dialog_radioatudp))
	position = 34;

    /* cleanup old colors */
    if (frame->ipx_position > -1) {
        for (position2 = frame->ipx_position; position2 < frame->ipx_position + 30; position2++) {
            if (frame->len > position2)
                set_default_color_for_cell(position2);
        }
    }
    if (frame->spx_position > -1) {
        for (position2 = frame->spx_position; position2 < frame->spx_position + 12; position2++) {
            if (frame->len > position2)
                set_default_color_for_cell(position2);
        }
    }
    if (frame->tcp_position > -1) {
        for (position2 = frame->tcp_position; position2 < frame->tcp_position + 20; position2++) {
            if (frame->len > position2)
                set_default_color_for_cell(position2);
        }
    }

    /* remember position */
    frame->ipx_position = -1;
    frame->spx_position = -1;
    frame->tcp_position = -1;
    frame->udp_position = position;

    /* get source port */
    if (gtk_toggle_button_get_active((GtkToggleButton*) udp_dialog_checksrcport)) {
	/* add bytes to frame */
	if (frame->len < position + 2) {
	    add_to_frame(position - frame->len + 2, NULL, 0);
	    add_cells_to_tables();
	}
	value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(udp_dialog_srcport));
	frame->data[position++] = (value & 0xFF00) >> 8;
	frame->data[position++] = value & 0xFF;
    } else
	position += 2;

    /* get destination port */
    if (gtk_toggle_button_get_active((GtkToggleButton*) udp_dialog_checkdstport)) {
	/* add bytes to frame */
	if (frame->len < position + 2) {
	    add_to_frame(position - frame->len + 2, NULL, 0);
	    add_cells_to_tables();
	}
	value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(udp_dialog_dstport));
	frame->data[position++] = (value & 0xFF00) >> 8;
	frame->data[position++] = value & 0xFF;
    } else
	position += 2;

    /* get len */
    if (gtk_toggle_button_get_active((GtkToggleButton*) udp_dialog_checklen)) {
	/* add bytes to frame */
	if (frame->len < position + 2) {
	    add_to_frame(position - frame->len + 2, NULL, 0);
	    add_cells_to_tables();
	}
	value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(udp_dialog_len));
	frame->data[position++] = (value & 0xFF00) >> 8;
	frame->data[position++] = value & 0xFF;
    } else
	position += 2;

    if (frame->len < position + 2) {
	add_to_frame(position - frame->len + 2, NULL, 0);
	add_cells_to_tables();
    }

    /* refresh window */
    for (position2 = frame->udp_position; position2 < frame->udp_position + 12; position2++) {
        if (frame->len > position2)
            fill_one_byte_cells(position2);
    }
    fill_binary();
    fill_decimal();
    fill_datasize();
}
