/* $Id: gui-GTK_udpcksum-dialog.c,v 1.3 2005/03/20 22:26:54 emvi Exp $ */

/* 
Copyright (C) 2005 Marek Wardziski (emvi at emvi eu org) 
 
This file is part of Ant. 
 
Ant is free software; you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation; either version 2 of the License, or 
(at your option) any later version. 
 
Ant is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
GNU General Public License for more details. 
 
You should have received a copy of the GNU General Public License 
along with Ant; if not, write to the Free Software 
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "main.h"
#include "misc.h"
#include "net.h"

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "gui-GTK.h"
#include "gui-GTK_handlers.h"

GtkWidget *udpcksum_dialog_window;
GtkWidget *udpcksum_dialog_radiocount;
GtkWidget *udpcksum_dialog_radiozero;
GtkWidget *udpcksum_dialog_hbox1;
GtkWidget *udpcksum_dialog_label2;
GtkWidget *udpcksum_dialog_start;
GtkWidget *udpcksum_dialog_hbox2;
GtkWidget *udpcksum_dialog_label3;
GtkWidget *udpcksum_dialog_end;
GtkWidget *udpcksum_dialog_label4;
GtkWidget *udpcksum_dialog_radio_atcursor;
GtkWidget *udpcksum_dialog_radio_atplace;

void udpcksum_dialog_radiogroup1_changed(GtkRadioButton *widget, gpointer data) {
    gboolean active;

    active = (widget == GTK_RADIO_BUTTON(udpcksum_dialog_radiocount));
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget))) {
	gtk_widget_set_sensitive(udpcksum_dialog_start, active);
	gtk_widget_set_sensitive(udpcksum_dialog_end, active);
    }
}

/* udp: true - udp checksum
	false - tcp checksum */
void udpcksum_dialog_create(gboolean udp) {
    int max_value;

    /* create dialog window */
    if (udp)
	udpcksum_dialog_window = gtk_dialog_new_with_buttons(_("Add UDP checksum"),
				GTK_WINDOW(window_main), GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_STOCK_OK, GTK_RESPONSE_OK,
				GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				NULL);
    else
        udpcksum_dialog_window = gtk_dialog_new_with_buttons(_("Add TCP checksum"),
				GTK_WINDOW(window_main), GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
				GTK_STOCK_OK, GTK_RESPONSE_OK,
				GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				NULL);

    if (udp) {
	udpcksum_dialog_radiocount = gtk_radio_button_new_with_label(NULL, _("Calculate checksum"));
	g_signal_connect(G_OBJECT(udpcksum_dialog_radiocount), "toggled", G_CALLBACK(udpcksum_dialog_radiogroup1_changed), NULL);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(udpcksum_dialog_radiocount), TRUE);
	udpcksum_dialog_radiozero = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(udpcksum_dialog_radiocount),
					_("Fill checksum field with zeroes"));
	g_signal_connect(G_OBJECT(udpcksum_dialog_radiozero), "toggled", G_CALLBACK(udpcksum_dialog_radiogroup1_changed), NULL);
    } else
	udpcksum_dialog_radiocount = gtk_label_new(_("Calculate checksum"));

    udpcksum_dialog_hbox1 = gtk_hbox_new(FALSE, 0);
    if (udp)
	udpcksum_dialog_label2 = gtk_label_new(_("Position of UDP header's beginning"));
    else
	udpcksum_dialog_label2 = gtk_label_new(_("Position of TCP header's beginning"));
    max_value = frame->len;
    if (max_value == 0)
	max_value++;
    udpcksum_dialog_start = gtk_spin_button_new_with_range(0, max_value, 1);
    g_signal_connect(G_OBJECT(udpcksum_dialog_start), "button-press-event", G_CALLBACK(entry_mouseclicked), NULL);
    gtk_spin_button_set_value((GtkSpinButton*) udpcksum_dialog_start, 34);
    gtk_entry_set_alignment(GTK_ENTRY(udpcksum_dialog_start), 1);
    gtk_box_pack_start(GTK_BOX(udpcksum_dialog_hbox1), udpcksum_dialog_label2, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(udpcksum_dialog_hbox1), udpcksum_dialog_start, TRUE, TRUE, 0);

    udpcksum_dialog_hbox2 = gtk_hbox_new(FALSE, 0);
    udpcksum_dialog_label3 = gtk_label_new(_("Position of packet's ending"));
    udpcksum_dialog_end = gtk_spin_button_new_with_range(0, max_value, 1);
    g_signal_connect(G_OBJECT(udpcksum_dialog_end), "button-press-event", G_CALLBACK(entry_mouseclicked), NULL);
    gtk_spin_button_set_value((GtkSpinButton*) udpcksum_dialog_end, frame->len);
    gtk_entry_set_alignment(GTK_ENTRY(udpcksum_dialog_end), 1);
    gtk_box_pack_start(GTK_BOX(udpcksum_dialog_hbox2), udpcksum_dialog_label3, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(udpcksum_dialog_hbox2), udpcksum_dialog_end, TRUE, TRUE, 0);

    udpcksum_dialog_label4 = gtk_label_new(_("Write:"));
    udpcksum_dialog_radio_atcursor = gtk_radio_button_new_with_label(NULL, _("from cursor's position"));
    if (udp)
	udpcksum_dialog_radio_atplace = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(udpcksum_dialog_radio_atcursor),
					    _("in UDP header's checksum field"));
    else
	udpcksum_dialog_radio_atplace = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(udpcksum_dialog_radio_atcursor),
					    _("in TCP header's checksum field"));
    gtk_toggle_button_set_active((GtkToggleButton*) udpcksum_dialog_radio_atplace, TRUE);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(udpcksum_dialog_window)->vbox), udpcksum_dialog_radiocount, TRUE, TRUE, 2);
    if (udp)
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(udpcksum_dialog_window)->vbox), udpcksum_dialog_radiozero, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(udpcksum_dialog_window)->vbox), udpcksum_dialog_hbox1, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(udpcksum_dialog_window)->vbox), udpcksum_dialog_hbox2, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(udpcksum_dialog_window)->vbox), udpcksum_dialog_label4, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(udpcksum_dialog_window)->vbox), udpcksum_dialog_radio_atcursor, TRUE, TRUE, 2);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(udpcksum_dialog_window)->vbox), udpcksum_dialog_radio_atplace, TRUE, TRUE, 2);
    gtk_widget_show_all(udpcksum_dialog_window);
}

/* udp: true - udp checksum
	false - tcp checksum */
void udpcksum_dialog_write_frame(gpointer udp) {
    char *pseudoheader;
    int i;
    int position2;
    guint16 cksum;
    int position = 0;
    int position3 = 0;

    /* position of checksum */
    if (gtk_toggle_button_get_active((GtkToggleButton*) udpcksum_dialog_radio_atcursor))
        position = selected_byte;
    else if (gtk_toggle_button_get_active((GtkToggleButton*) udpcksum_dialog_radio_atplace))
	position = 40;
    if (! udp)
	position += 10;

    /* add bytes to frame */
    if (frame->len < position + 2) {
        add_to_frame(position - frame->len + 2, NULL, 0);
        add_cells_to_tables();
    }

    if (! udp || gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(udpcksum_dialog_radiocount))) {
	/* position of udp */
	position2 = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(udpcksum_dialog_start));

	pseudoheader = malloc(frame->len - position2 + 9);

	if (udp)
	    memset(pseudoheader, 0, 20);
	else
	    memset(pseudoheader, 0, 32);

	if (position2 >= 8)
	    memcpy(pseudoheader, frame->data + position2 - 8, 8);
	pseudoheader[8] = 0;
	if (position2 >= 11)
	    pseudoheader[9] = frame->data[position2 - 11];
	if (position2 >= 18) {
	    i = frame->data[position2 - 18] * 256 + frame->data[position2 - 17] - 20;
	    pseudoheader[10] = (i & 0xFF00) >> 8;
	    pseudoheader[11] = (i & 0xFF);
	}
	/* TCP/UDP header + data (without FCS) */
	memcpy(pseudoheader + 12, frame->data + position2, frame->len - position2 - 4);
	if (udp)
	    position3 = 18;
	else
	    position3 = 28;
	pseudoheader[position3] = pseudoheader[position3 + 1] = 0;
	pseudoheader[frame->len - position2 + 8] = 0;
	cksum = libnet_ip_check((u_int16_t*) pseudoheader, frame->len - position2 + 8 + ((frame->len - position2) % 2));
	/* change 0 to FFFF (udp only) */
	if (udp && cksum == 0)
	    cksum = 0xFFFF;
	free(pseudoheader);
    } else
	cksum = 0;

    memcpy(frame->data + position, &cksum, 2);
    fill_one_byte_cells(position);
    fill_one_byte_cells(position + 1);
    fill_binary();
    fill_decimal();
    fill_datasize();
}
