/* $Id: main.h,v 1.3 2005/03/20 22:26:54 emvi Exp $ */

/* 
Copyright (C) 2005 Marek Wardziski (emvi at emvi eu org) 
 
This file is part of Ant. 
 
Ant is free software; you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation; either version 2 of the License, or 
(at your option) any later version. 
 
Ant is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
GNU General Public License for more details. 
 
You should have received a copy of the GNU General Public License 
along with Ant; if not, write to the Free Software 
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include <glib.h>
#include <libintl.h>

#define _(s) gettext(s)
#define N_(s) (s)

typedef struct frame_t {
    int len;
    int eth_position;
    int ip_position;
    int tcp_position;
    int udp_position;
    int ipx_position;
    int spx_position;
    int fcs_position;
    char *data;
} frame_t;

extern GList *all_frames;
extern int selected_frame;
extern frame_t *frame;

extern int selected_byte;
extern char *file_name;
extern const char *charset;

void init_frames();
void delete_frame();
void remove_all_frames();
void remove_framedata();
int read_from_file();
void save_to_file();
