/* $Id: net.c,v 1.2 2005/02/05 16:04:19 emvi Exp $ */

/* 
Copyright (C) 2005 Marek Wardziski (emvi at emvi eu org) 
 
This file is part of Ant. 
 
Ant is free software; you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by 
the Free Software Foundation; either version 2 of the License, or 
(at your option) any later version. 
 
Ant is distributed in the hope that it will be useful, 
but WITHOUT ANY WARRANTY; without even the implied warranty of 
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
GNU General Public License for more details. 
 
You should have received a copy of the GNU General Public License 
along with Ant; if not, write to the Free Software 
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "config.h"

#include <libnet.h>
#include <net/if.h>
#include <netinet/in.h>
#include <sys/ioctl.h> 

#ifdef HAVE_LIBPCAP
#include <pcap.h>
#endif	/* HAVE_LIBPCAP */

#include "main.h"

char *device;
int sent_frames, times, sent_series, delay_frames, delay_series;
char error_msg[LIBNET_ERRBUF_SIZE];
libnet_t *libnet;

#ifdef HAVE_IF
struct if_nameindex *if_list;
#else
#ifdef HAVE_LIBPCAP
char libpcap_error_msg[PCAP_ERRBUF_SIZE];
pcap_if_t *if_list;
#endif	/* HAVE_LIBPCAP */
#endif	/* HAVE_IF */


void get_iface_list() {
#ifdef HAVE_IF
    if_list = if_nameindex();
#else
#ifdef HAVE_LIBPCAP
    pcap_findalldevs(&if_list, libpcap_error_msg);
#endif	/* HAVE_LIBPCAP */
#endif	/* HAVE_IF */
}

char *get_iface_name(int number) {
#ifdef HAVE_IF
    struct if_nameindex *list;
#else
#ifdef HAVE_LIBPCAP
    pcap_if_t *list;    
#endif	/* HAVE_LIBPCAP */
#endif	/* HAVE_IF */
    list = if_list;
    for (;number > 0; number--) {
#ifdef HAVE_IF
	list++;
    }
    return list->if_name;
#else
#ifdef HAVE_LIBPCAP
	if (list != NULL)
	    list = list->next;
	if ((list != NULL) && (strcmp(list->name, "any")) == 0)
	    list = list->next;
    }
    if (list != NULL)
	return list->name;
    else
	return NULL;
#endif	/* HAVE_LIBPCAP */
#endif	/* HAVE_IF */
}

void free_iface_list() {
#ifdef HAVE_LIBNET
    if_freenameindex(if_list);
#else
#ifdef HAVE_LIBPCAP
    pcap_freealldevs(if_list);
#endif	/* HAVE_LIBPCAP */
#endif	/* HAVE_LIBNET */
}

int send_frame(int number) {
    frame_t *frame_to_send;

    frame_to_send = g_list_nth_data(all_frames, number);
    libnet = libnet_init(LIBNET_LINK_ADV, device, error_msg);
    if (libnet == NULL)
	return FALSE;
    if (libnet_adv_write_link(libnet, frame_to_send->data, frame_to_send->len) < 0) {
	libnet_destroy(libnet);
	return FALSE;
    }
    libnet_destroy(libnet);
    return TRUE;
}

char *get_mac_address() {
    int fd;
    struct ifreq ifr;
    char *mac;

    fd = socket(AF_INET, SOCK_DGRAM, IPPROTO_IP);

    strncpy(ifr.ifr_name, device, sizeof(ifr.ifr_name));
    mac = malloc(6);
    if(ioctl(fd, SIOCGIFHWADDR, &ifr) != -1)
        memcpy(mac, ifr.ifr_hwaddr.sa_data, 6);
    else
        memset(mac, 0, 6);
    return mac;
}

char *get_ip_address() {
    int fd;
    struct ifreq ifr;
    char *ip;

    fd = socket(AF_INET, SOCK_DGRAM, IPPROTO_IP);

    strncpy(ifr.ifr_name, device, sizeof(ifr.ifr_name));
    ip = malloc(4);
    if(ioctl(fd, SIOCGIFDSTADDR, &ifr) != -1)
        memcpy(ip, ifr.ifr_dstaddr.sa_data + 2, 4);
    else
        memset(ip, 0, 4);
    return ip;
}
