/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.activities;

import com.aelitis.azureus.activities.VuzeActivitiesEntryBuddy;
import com.aelitis.azureus.buddy.impl.VuzeBuddyManager;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.login.NotLoggedInException;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentV3;
import com.aelitis.azureus.util.ConstantsV3;
import com.aelitis.azureus.util.LoginInfoManager;
import com.aelitis.azureus.util.MapUtils;
import java.util.Map;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;

public class VuzeActivitiesEntryContentShare
extends VuzeActivitiesEntryBuddy {
    public static final String URL_USERMESSAGE = "showsharemessage";
    private String userMessage;
    private long version;

    public String getUserMessage() {
        return this.userMessage;
    }

    public void setUserMessage(String userMessage) {
        this.userMessage = userMessage;
    }

    public VuzeActivitiesEntryContentShare() {
    }

    public VuzeActivitiesEntryContentShare(SelectedContentV3 content, String message) throws NotLoggedInException {
        String contentString;
        if (content == null) {
            return;
        }
        if (!LoginInfoManager.getInstance().isLoggedIn()) {
            VuzeBuddyManager.log("Can't share download: Not logged in");
            throw new NotLoggedInException();
        }
        DownloadManager dm = content.getDM();
        TOTorrent torrent = dm == null ? null : dm.getTorrent();
        boolean ourContent = content.isPlatformContent();
        this.setPlayable(content.canPlay());
        LoginInfoManager.LoginInfo userInfo = LoginInfoManager.getInstance().getUserInfo();
        this.setTypeID("buddy-share", true);
        this.setID("buddy-share-" + SystemTime.getCurrentTime());
        this.setTorrent(torrent);
        if (ourContent || torrent == null) {
            String url = ConstantsV3.URL_PREFIX + "details/" + content.getHash() + ".html?" + ConstantsV3.URL_SUFFIX + "&client_ref=" + "buddy-share";
            contentString = "<A HREF=\"" + url + "\">" + content.getDisplayName() + "</A>";
        } else {
            contentString = content.getDisplayName();
        }
        String textid = message == null || message.length() == 0 ? "v3.activity.share-content.no-msg" : "v3.activity.share-content";
        String text = MessageText.getString(textid, new String[]{userInfo.getProfileAHREF("buddy-share"), contentString, userInfo.displayName, UrlUtils.encode(message)});
        this.setText(text);
        if (dm != null) {
            this.setTorrentName(PlatformTorrentUtils.getContentTitle2(dm));
        } else {
            this.setTorrentName(content.getDisplayName());
        }
        this.setAssetImageURL(content.getThumbURL());
        this.userMessage = message;
        this.version = 2L;
        this.setAssetHash(content.getHash());
        if (content.getDM() != null) {
            this.setDownloadManager(content.getDM());
        }
        this.setShowThumb(true);
        if (content.getImageBytes() == null) {
            this.setImageBytes(PlatformTorrentUtils.getContentThumbnail(torrent));
        } else {
            this.setImageBytes(content.getImageBytes());
        }
        this.setIsPlatformContent(ourContent);
        this.setTimestamp(0L);
    }

    public Map toMap() {
        this.setDownloadManager(null);
        Map map = super.toMap();
        map.put("version", new Long(this.version));
        map.put("userMessage", this.userMessage);
        return map;
    }

    public void loadCommonFromMap(Map map) {
        super.loadCommonFromMap(map);
        Map torrentMap = MapUtils.getMapMap(map, "torrent", null);
        if (torrentMap != null) {
            try {
                this.setTorrent(TOTorrentFactory.deserialiseFromMap(torrentMap));
            }
            catch (TOTorrentException e) {
                e.printStackTrace();
            }
        }
        this.version = MapUtils.getMapLong(map, "version", 1L);
        if (this.version >= 2L && this.buddy != null) {
            String contentString;
            String textid;
            this.userMessage = MapUtils.getMapString(map, "userMessage", null);
            String string = textid = this.userMessage == null || this.userMessage.length() == 0 ? "v3.activity.share-content.no-msg" : "v3.activity.share-content";
            if (this.isPlatformContent() || this.getTorrent() == null) {
                String url = ConstantsV3.URL_PREFIX + "details/" + this.getAssetHash() + ".html?" + ConstantsV3.URL_SUFFIX + "&client_ref=" + "buddy-share";
                contentString = "<A HREF=\"" + url + "\">" + this.getTorrentName() + "</A>";
            } else {
                contentString = this.getTorrentName();
            }
            this.setText(MessageText.getString(textid, new String[]{this.buddy.getProfileAHREF("buddy-share"), contentString, this.buddy.getDisplayName(), URL_USERMESSAGE, UrlUtils.encode(this.userMessage)}));
        }
        this.setDRM(MapUtils.getMapBoolean(torrentMap, "isDRM", false));
    }
}

