/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.buddy;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesManager;
import com.aelitis.azureus.util.MapUtils;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.SystemTime;

public class QueuedVuzeShare {
    private String code;
    private String pk;
    private String downloadHash;
    private VuzeActivitiesEntry entry;
    private long sharedOn;

    public QueuedVuzeShare(Map map) {
        this.loadFromMap(map);
    }

    public QueuedVuzeShare() {
        this.setSharedOn(SystemTime.getCurrentTime());
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public void setPk(String pk) {
        this.pk = pk;
    }

    public String getPk() {
        return this.pk;
    }

    public void setDownloadHash(String downloadHash) {
        this.downloadHash = downloadHash;
    }

    public String getDownloadHash() {
        return this.downloadHash;
    }

    public void setActivityEntry(VuzeActivitiesEntry entry) {
        this.entry = entry;
    }

    public VuzeActivitiesEntry getActivityEntry() {
        return this.entry;
    }

    public Map toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", this.code);
        if (this.entry != null) {
            map.put("ActivityEntry", this.entry.toMap());
        }
        map.put("hash", this.downloadHash);
        map.put("pk", this.pk);
        map.put("sharedOn", new Long(this.sharedOn));
        return map;
    }

    private void loadFromMap(Map map) {
        this.setCode(MapUtils.getMapString(map, "code", null));
        this.setSharedOn(MapUtils.getMapLong(map, "sharedOn", 0L));
        Map entryMap = MapUtils.getMapMap(map, "ActivityEntry", null);
        if (entryMap != null) {
            VuzeActivitiesEntry entry = VuzeActivitiesManager.createEntryFromMap(entryMap, true);
            this.setActivityEntry(entry);
            if (this.sharedOn == 0L) {
                this.setSharedOn(entry.getTimestamp());
            }
        } else {
            this.setActivityEntry(null);
        }
        this.setDownloadHash(MapUtils.getMapString(map, "hash", null));
        this.setPk(MapUtils.getMapString(map, "pk", null));
        if (this.sharedOn == 0L) {
            this.sharedOn = SystemTime.getCurrentTime();
        }
    }

    public long getSharedOn() {
        return this.sharedOn;
    }

    public void setSharedOn(long sharedOn) {
        this.sharedOn = sharedOn;
    }
}

