/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.buddy.chat;

import com.aelitis.azureus.buddy.VuzeBuddy;
import com.aelitis.azureus.buddy.chat.ChatMessage;
import com.aelitis.azureus.buddy.chat.ChatMessageListener;
import com.aelitis.azureus.buddy.chat.DiscussionListener;
import java.util.ArrayList;
import java.util.List;

public class ChatDiscussion
implements ChatMessageListener {
    VuzeBuddy buddy;
    List messages;
    int unreadMessages;
    DiscussionListener listener;

    public ChatDiscussion(VuzeBuddy _buddy, boolean _check_persistent) {
        this.buddy = _buddy;
        this.messages = new ArrayList();
        if (_check_persistent) {
            List stored = this.buddy.getStoredChatMessages();
            for (int i = 0; i < stored.size(); ++i) {
                ChatMessage msg = (ChatMessage)stored.get(i);
                this.messages.add(msg);
                msg.addListener(this);
                ++this.unreadMessages;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkPersistentMessages() {
        List stored = this.buddy.getStoredChatMessages();
        boolean added = false;
        for (int i = 0; i < stored.size(); ++i) {
            ChatMessage msg = (ChatMessage)stored.get(i);
            List list = this.messages;
            synchronized (list) {
                if (!this.messages.contains(msg)) {
                    added = true;
                    this.messages.add(msg);
                    msg.addListener(this);
                    ++this.unreadMessages;
                    if (this.listener != null) {
                        this.listener.newMessage(msg);
                    }
                }
                continue;
            }
        }
        return added;
    }

    protected VuzeBuddy getBuddy() {
        return this.buddy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(ChatMessage message) {
        List list = this.messages;
        synchronized (list) {
            if (!this.messages.contains(message)) {
                ++this.unreadMessages;
                this.messages.add(message);
                message.addListener(this);
                if (this.listener != null) {
                    this.listener.newMessage(message);
                }
                if (!message.getRendered()) {
                    this.buddy.storeChatMessage(message);
                }
            }
        }
    }

    public void rendered(ChatMessage message) {
        this.buddy.deleteChatMessage(message);
    }

    public List getAllMessages() {
        this.unreadMessages = 0;
        return this.messages;
    }

    public List getNewMessages() {
        int nbMessages = this.messages.size();
        List result = this.messages.subList(nbMessages - this.unreadMessages, nbMessages);
        this.unreadMessages = 0;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllMessages() {
        List list = this.messages;
        synchronized (list) {
            this.messages.clear();
        }
    }

    public void clearNewMessages() {
        this.unreadMessages = 0;
    }

    public DiscussionListener getListener() {
        return this.listener;
    }

    public void setListener(DiscussionListener listener) {
        this.listener = listener;
    }

    public int getUnreadMessages() {
        return this.unreadMessages;
    }

    public int getNbMessages() {
        return this.messages.size();
    }
}

