/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.buddy.impl;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesEntryContentShare;
import com.aelitis.azureus.buddy.VuzeBuddy;
import com.aelitis.azureus.buddy.VuzeBuddyListener;
import com.aelitis.azureus.buddy.chat.ChatMessage;
import com.aelitis.azureus.buddy.impl.VuzeBuddyManager;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.login.NotLoggedInException;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddy;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddyMessage;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentV3;
import com.aelitis.azureus.util.ConstantsV3;
import com.aelitis.azureus.util.ImageDownloader;
import com.aelitis.azureus.util.LoginInfoManager;
import com.aelitis.azureus.util.MapUtils;
import com.aelitis.azureus.util.StringCompareUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.UrlUtils;

public class VuzeBuddyImpl
implements VuzeBuddy {
    protected String displayName;
    private String loginID;
    private String code;
    private long lastUpdated;
    private long createdOn;
    private String avatarURL;
    private CopyOnWriteList pluginBuddies = new CopyOnWriteList();
    private AEMonitor mon_pluginBuddies = new AEMonitor("pluginBuddies");
    private ArrayList listeners = new ArrayList(0);

    protected VuzeBuddyImpl(String publicKey) {
        this.addPublicKey(publicKey);
    }

    protected VuzeBuddyImpl() {
    }

    public void loadFromMap(Map mapNewBuddy) {
        if (mapNewBuddy == null) {
            return;
        }
        this.setDisplayName(MapUtils.getMapString(mapNewBuddy, "display-name", "" + ((Object)mapNewBuddy).hashCode()));
        this.setLoginID(MapUtils.getMapString(mapNewBuddy, "login-id", "" + ((Object)mapNewBuddy).hashCode()));
        List pkList = MapUtils.getMapList(mapNewBuddy, "pks", Collections.EMPTY_LIST);
        for (Object o : pkList) {
            String pk = null;
            if (o instanceof byte[]) {
                try {
                    pk = new String((byte[])o, "utf-8");
                }
                catch (UnsupportedEncodingException e) {}
            } else if (o instanceof String) {
                pk = (String)o;
            }
            if (pk == null) continue;
            this.addPublicKey(pk);
        }
        byte[] newAvatar = MapUtils.getMapByteArray(mapNewBuddy, "avatar", null);
        if (newAvatar != null) {
            this.setAvatar(newAvatar);
        }
        String newAvatarURL = MapUtils.getMapString(mapNewBuddy, "avatar.url", null);
        if (this.avatarURL == null && this.hasAvatar()) {
            this.avatarURL = newAvatarURL;
        } else if (!StringCompareUtils.equals(newAvatarURL, this.avatarURL) || !this.hasAvatar()) {
            this.avatarURL = newAvatarURL;
            if (this.avatarURL != null) {
                ImageDownloader.loadImage(this.avatarURL, new ImageDownloader.ImageDownloaderListener(){

                    public void imageDownloaded(byte[] image) {
                        VuzeBuddyManager.log("Got new avatar! " + VuzeBuddyImpl.this.toDebugString());
                        VuzeBuddyImpl.this.setAvatar(image);
                    }
                });
            }
        }
        this.setCode(MapUtils.getMapString(mapNewBuddy, "code", null));
        this.setCreatedOn(MapUtils.getMapLong(mapNewBuddy, "created-on", 0L));
    }

    public Map toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("display-name", this.displayName);
        map.put("login-id", this.loginID);
        map.put("code", this.code);
        map.put("created-on", new Long(this.createdOn));
        List<String> pks = Arrays.asList(this.getPublicKeys());
        map.put("pks", pks);
        map.put("avatar.url", this.avatarURL);
        return map;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        if (displayName == null) {
            displayName = "";
        }
        if (displayName.equals(this.displayName)) {
            return;
        }
        this.displayName = displayName;
        VuzeBuddyManager.triggerOrderChangedListener();
    }

    public String getLoginID() {
        return this.loginID;
    }

    public void setLoginID(String loginID) {
        this.loginID = loginID;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(long lastUpdated) {
        boolean trigger = this.lastUpdated > 0L;
        this.lastUpdated = lastUpdated;
        if (trigger) {
            VuzeBuddyManager.triggerChangeListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAvatar() {
        block5: {
            byte[] byArray;
            File file = this.getAvatarFile();
            if (!file.exists()) break block5;
            FileInputStream fis = new FileInputStream(file);
            try {
                byArray = FileUtil.readInputStreamAsByteArray(fis);
            }
            catch (Throwable throwable) {
                try {
                    fis.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            fis.close();
            return byArray;
        }
        return null;
    }

    private File getAvatarFile() {
        return new File(SystemProperties.getUserPath(), "friends" + File.separator + this.getLoginID().hashCode() + ".ico");
    }

    private boolean hasAvatar() {
        return this.getAvatarFile().exists();
    }

    public void setAvatar(byte[] avatar) {
        File file = this.getAvatarFile();
        FileUtil.writeBytesAsFile(file.getAbsolutePath(), avatar);
        VuzeBuddyManager.triggerChangeListener(this);
    }

    public boolean isOnline(boolean is_connected) {
        Iterator iter = this.pluginBuddies.iterator();
        while (iter.hasNext()) {
            BuddyPluginBuddy pluginBuddy = (BuddyPluginBuddy)iter.next();
            if (!pluginBuddy.isOnline(is_connected) || pluginBuddy.getOnlineStatus() == 4) continue;
            return true;
        }
        return false;
    }

    public int getVersion() {
        int version = 1;
        Iterator iter = this.pluginBuddies.iterator();
        while (iter.hasNext()) {
            BuddyPluginBuddy pluginBuddy = (BuddyPluginBuddy)iter.next();
            version = Math.max(pluginBuddy.getVersion(), version);
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPublicKey(String pk) {
        BuddyPluginBuddy pluginBuddy = VuzeBuddyManager.getBuddyPluginBuddyForVuze(pk);
        this.mon_pluginBuddies.enter();
        try {
            if (pluginBuddy != null && !this.pluginBuddies.contains(pluginBuddy)) {
                this.pluginBuddies.add(pluginBuddy);
            }
        }
        finally {
            this.mon_pluginBuddies.exit();
        }
        VuzeBuddyManager.linkPKtoBuddy(pk, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePublicKey(String pk) {
        this.mon_pluginBuddies.enter();
        try {
            Iterator iter = this.pluginBuddies.iterator();
            while (iter.hasNext()) {
                BuddyPluginBuddy pluginBuddy = (BuddyPluginBuddy)iter.next();
                if (!pluginBuddy.getPublicKey().equals(pk)) continue;
                iter.remove();
                if (pluginBuddy.getSubsystem() == 2) {
                    VuzeBuddyManager.log("Remove pk " + pk);
                    pluginBuddy.remove();
                    continue;
                }
                VuzeBuddyManager.log("Can't remove pk as it's not az3: " + pk);
            }
        }
        finally {
            this.mon_pluginBuddies.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPublicKeys() {
        this.mon_pluginBuddies.enter();
        try {
            String[] ret = new String[this.pluginBuddies.size()];
            int x = 0;
            Iterator iter = this.pluginBuddies.iterator();
            while (iter.hasNext()) {
                BuddyPluginBuddy pluginBuddy = (BuddyPluginBuddy)iter.next();
                if (pluginBuddy == null) continue;
                ret[x++] = pluginBuddy.getPublicKey();
            }
            String[] stringArray = ret;
            return stringArray;
        }
        finally {
            this.mon_pluginBuddies.exit();
        }
    }

    public void sendActivity(VuzeActivitiesEntry entry) throws NotLoggedInException {
        BuddyPluginBuddy[] buddies = (BuddyPluginBuddy[])this.pluginBuddies.toArray(new BuddyPluginBuddy[0]);
        VuzeBuddyManager.sendActivity(entry, buddies);
    }

    public void sendPayloadMap(Map map) throws NotLoggedInException {
        BuddyPluginBuddy[] buddies = (BuddyPluginBuddy[])this.pluginBuddies.toArray(new BuddyPluginBuddy[0]);
        VuzeBuddyManager.sendPayloadMap(map, buddies);
    }

    public void sendBuddyMessage(String namespace, Map map) throws NotLoggedInException {
        HashMap<String, Object> containerMap = new HashMap<String, Object>(3);
        containerMap.put("namespace", namespace);
        containerMap.put("VuzeMessageType", "BuddyMessage");
        containerMap.put("map", map);
        BuddyPluginBuddy[] buddies = (BuddyPluginBuddy[])this.pluginBuddies.toArray(new BuddyPluginBuddy[0]);
        VuzeBuddyManager.sendPayloadMap(containerMap, buddies);
    }

    public void shareDownload(SelectedContentV3 content, String message) throws NotLoggedInException {
        if (content == null) {
            return;
        }
        VuzeActivitiesEntryContentShare entry = new VuzeActivitiesEntryContentShare(content, message);
        entry.setBuddyID(LoginInfoManager.getInstance().getUserInfo().userName);
        this.sendActivity(entry);
    }

    public void tellBuddyToSyncUp() throws NotLoggedInException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("VuzeMessageType", "BuddySync");
        this.sendPayloadMap(map);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getProfileAHREF(String referer) {
        return this.getProfileAHREF(referer, false);
    }

    public String getProfileAHREF(String referer, boolean useImage) {
        StringBuffer buf = new StringBuffer();
        buf.append("<A HREF=\"");
        buf.append(ConstantsV3.URL_PREFIX);
        buf.append("profile/");
        buf.append(UrlUtils.encode(this.loginID));
        buf.append("?");
        buf.append(ConstantsV3.URL_SUFFIX);
        buf.append("&client_ref=");
        buf.append(UrlUtils.encode(referer));
        buf.append("\" TITLE=\"");
        buf.append(this.displayName);
        if (!this.loginID.equals(this.displayName)) {
            buf.append(" (");
            buf.append(this.loginID);
            buf.append(")");
        }
        buf.append("\">");
        if (useImage) {
            buf.append("%0 ");
        }
        buf.append(this.displayName);
        buf.append("</A>");
        return buf.toString();
    }

    public String getProfileUrl(String referer) {
        return ConstantsV3.URL_PREFIX + "profile/" + this.getLoginID() + "?" + ConstantsV3.URL_SUFFIX + "&client_ref=" + referer;
    }

    public int compare(Object arg0, Object arg1) {
        if (!(arg0 instanceof VuzeBuddy) || !(arg1 instanceof VuzeBuddy)) {
            return 0;
        }
        String c0 = ((VuzeBuddy)arg0).getDisplayName();
        String c1 = ((VuzeBuddy)arg1).getDisplayName();
        if (c0 == null) {
            c0 = "";
        }
        if (c1 == null) {
            c1 = "";
        }
        return c0.compareToIgnoreCase(c1);
    }

    public int compareTo(Object arg0) {
        return this.compare(this, arg0);
    }

    public void setCreatedOn(long createdOn) {
        this.createdOn = createdOn;
    }

    public long getCreatedOn() {
        return this.createdOn;
    }

    public String toDebugString() {
        return "Buddy {" + this.loginID + "}";
    }

    public void addListener(VuzeBuddyListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeListener(VuzeBuddyListener l) {
        this.listeners.remove(l);
    }

    public VuzeBuddyListener[] getListeners() {
        return this.listeners.toArray(new VuzeBuddyListener[0]);
    }

    public List getStoredChatMessages() {
        Iterator it = this.pluginBuddies.iterator();
        ArrayList<ChatMessage> result = new ArrayList<ChatMessage>();
        while (it.hasNext()) {
            BuddyPluginBuddy pluginBuddy = (BuddyPluginBuddy)it.next();
            List msgs = pluginBuddy.retrieveMessages(1);
            for (int i = 0; i < msgs.size(); ++i) {
                try {
                    BuddyPluginBuddyMessage msg = (BuddyPluginBuddyMessage)msgs.get(i);
                    ChatMessage cm = ChatMessage.deserialise(msg);
                    if (cm == null) continue;
                    result.add(cm);
                    continue;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public void storeChatMessage(ChatMessage msg) {
        String sender_pk = msg.getSenderPK();
        if (sender_pk != null) {
            BuddyPluginBuddy pluginBuddy = VuzeBuddyManager.getBuddyPluginBuddyForVuze(sender_pk);
            if (pluginBuddy == null) {
                VuzeBuddyManager.log("Can't persist message for " + sender_pk + ", buddy not found");
            } else {
                BuddyPluginBuddyMessage pm = pluginBuddy.storeMessage(1, msg.toMap());
                if (pm != null) {
                    msg.setPersistentMessage(pm);
                }
            }
        }
    }

    public void deleteChatMessage(ChatMessage msg) {
        BuddyPluginBuddyMessage pm = msg.getPersistentMessage();
        if (pm != null) {
            pm.delete();
        }
    }
}

