/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionProvider;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportFindValueReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportProgressListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransportRequestHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportStoreReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportTransferHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDP;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDPContact;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPContactImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPStatsImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketData;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketHelper;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyError;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyFindNode;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyFindValue;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyKeyBlock;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyPing;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyStats;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyStore;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestFindNode;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestFindValue;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestKeyBlock;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestPing;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestStats;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestStore;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandler;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandlerException;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandlerFactory;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketReceiver;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPRequestHandler;
import com.aelitis.azureus.core.dht.transport.util.DHTTransportRequestCounter;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class DHTTransportUDPImpl
implements DHTTransportUDP,
DHTUDPRequestHandler {
    public static boolean TEST_EXTERNAL_IP = false;
    public static final int TRANSFER_QUEUE_MAX = 64;
    public static final long MAX_TRANSFER_QUEUE_BYTES = 0x800000L;
    public static final long WRITE_XFER_RESEND_DELAY = 12500L;
    public static final long READ_XFER_REREQUEST_DELAY = 5000L;
    public static final long WRITE_REPLY_TIMEOUT = 60000L;
    public static final int MIN_ADDRESS_CHANGE_PERIOD_INIT_DEFAULT = 300000;
    public static final int MIN_ADDRESS_CHANGE_PERIOD_NEXT_DEFAULT = 600000;
    private static boolean XFER_TRACE = false;
    private String external_address;
    private int min_address_change_period = 300000;
    private byte protocol_version;
    private int network;
    private boolean v6;
    private String ip_override;
    private int port;
    private int max_fails_for_live;
    private int max_fails_for_unknown;
    private long request_timeout;
    private long store_timeout;
    private boolean reachable;
    private boolean reachable_accurate;
    private int dht_send_delay;
    private int dht_receive_delay;
    private DHTLogger logger;
    private DHTUDPPacketHandler packet_handler;
    private DHTTransportRequestHandler request_handler;
    private DHTTransportUDPContactImpl local_contact;
    private Map transfer_handlers = new HashMap();
    private Map read_transfers = new HashMap();
    private Map write_transfers = new HashMap();
    private int active_write_queue_processor_count;
    private long total_bytes_on_transfer_queues;
    private Map call_transfers = new HashMap();
    private long last_address_change;
    private List listeners = new ArrayList();
    private IpFilter ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
    private DHTTransportUDPStatsImpl stats;
    private boolean bootstrap_node = false;
    private static final int CONTACT_HISTORY_MAX = 32;
    private static final int CONTACT_HISTORY_PING_SIZE = 24;
    private Map contact_history = new LinkedHashMap(32, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 32;
        }
    };
    private static final int ROUTABLE_CONTACT_HISTORY_MAX = 32;
    private Map routable_contact_history = new LinkedHashMap(32, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 32;
        }
    };
    private long other_routable_total;
    private long other_non_routable_total;
    private static final int RECENT_REPORTS_HISTORY_MAX = 32;
    private Map recent_reports = new LinkedHashMap(32, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 32;
        }
    };
    private static final int STATS_PERIOD = 60000;
    private static final int STATS_DURATION_SECS = 600;
    private static final long STATS_INIT_PERIOD = 900000L;
    private long stats_start_time = SystemTime.getCurrentTime();
    private long last_alien_count;
    private long last_alien_fv_count;
    private Average alien_average = Average.getInstance(60000, 600);
    private Average alien_fv_average = Average.getInstance(60000, 600);
    private Random random;
    private static final int BAD_IP_BLOOM_FILTER_SIZE = 32000;
    private BloomFilter bad_ip_bloom_filter;
    private static AEMonitor class_mon;
    private AEMonitor this_mon = new AEMonitor("DHTTransportUDP");
    private boolean initial_address_change_deferred;
    private boolean address_changing;

    public DHTTransportUDPImpl(byte _protocol_version, int _network, boolean _v6, String _ip, String _default_ip, int _port, int _max_fails_for_live, int _max_fails_for_unknown, long _timeout, int _dht_send_delay, int _dht_receive_delay, boolean _bootstrap_node, boolean _initial_reachability, DHTLogger _logger) throws DHTTransportException {
        this.protocol_version = _protocol_version;
        this.network = _network;
        this.v6 = _v6;
        this.ip_override = _ip;
        this.port = _port;
        this.max_fails_for_live = _max_fails_for_live;
        this.max_fails_for_unknown = _max_fails_for_unknown;
        this.request_timeout = _timeout;
        this.dht_send_delay = _dht_send_delay;
        this.dht_receive_delay = _dht_receive_delay;
        this.bootstrap_node = _bootstrap_node;
        this.reachable = _initial_reachability;
        this.logger = _logger;
        this.store_timeout = this.request_timeout * 2L;
        try {
            this.random = new SecureRandom();
        }
        catch (Throwable e) {
            this.random = new Random();
            this.logger.log(e);
        }
        this.createPacketHandler();
        SimpleTimer.addPeriodicEvent("DHTUDP:stats", 60000L, new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                DHTTransportUDPImpl.this.updateStats();
            }
        });
        String default_ip = _default_ip == null ? (this.v6 ? "::1" : "127.0.0.1") : _default_ip;
        this.getExternalAddress(default_ip, this.logger);
        InetSocketAddress address = new InetSocketAddress(this.external_address, this.port);
        this.logger.log("Initial external address: " + address);
        this.local_contact = new DHTTransportUDPContactImpl(true, this, address, address, this.protocol_version, this.random.nextInt(), 0L);
    }

    protected void createPacketHandler() throws DHTTransportException {
        DHTUDPPacketHelper.registerCodecs();
        try {
            if (this.packet_handler != null) {
                this.packet_handler.destroy();
            }
            this.packet_handler = DHTUDPPacketHandlerFactory.getHandler(this, this);
        }
        catch (Throwable e) {
            throw new DHTTransportException("Failed to get packet handler", e);
        }
        this.packet_handler.setDelays(this.dht_send_delay, this.dht_receive_delay, (int)this.request_timeout);
        this.stats_start_time = SystemTime.getCurrentTime();
        if (this.stats == null) {
            this.stats = new DHTTransportUDPStatsImpl(this, this.protocol_version, this.packet_handler.getStats());
        } else {
            this.stats.setStats(this.packet_handler.getStats());
        }
    }

    protected void updateStats() {
        long alien_count = 0L;
        long[] aliens = this.stats.getAliens();
        for (int i = 0; i < aliens.length; ++i) {
            alien_count += aliens[i];
        }
        long alien_fv_count = aliens[1];
        this.alien_average.addValue((alien_count - this.last_alien_count) * 60000L / 1000L);
        this.alien_fv_average.addValue((alien_fv_count - this.last_alien_fv_count) * 60000L / 1000L);
        this.last_alien_count = alien_count;
        this.last_alien_fv_count = alien_fv_count;
        long now = SystemTime.getCurrentTime();
        if (now < this.stats_start_time) {
            this.stats_start_time = now;
        } else {
            if (Constants.isCVSVersion()) {
                long fv_average = this.alien_fv_average.getAverage();
                long all_average = this.alien_average.getAverage();
                this.logger.log("Aliens for net " + this.network + ": " + fv_average + "/" + all_average);
            }
            if (now - this.stats_start_time > 900000L) {
                this.reachable_accurate = true;
                boolean old_reachable = this.reachable;
                this.reachable = this.alien_fv_average.getAverage() > 1L ? true : this.alien_average.getAverage() > 3L;
                if (old_reachable != this.reachable) {
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        try {
                            ((DHTTransportListener)this.listeners.get(i)).reachabilityChanged(this.reachable);
                            continue;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            }
        }
    }

    protected void recordSkew(InetSocketAddress originator_address, long skew) {
        if (this.stats != null) {
            this.stats.recordSkew(originator_address, skew);
        }
    }

    protected int getNodeStatus() {
        if (this.bootstrap_node) {
            return 0;
        }
        if (this.reachable_accurate) {
            int status = this.reachable ? 1 : 0;
            return status;
        }
        return -1;
    }

    public boolean isReachable() {
        return this.reachable;
    }

    public byte getProtocolVersion() {
        return this.protocol_version;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int new_port) throws DHTTransportException {
        if (new_port == this.port) {
            return;
        }
        this.port = new_port;
        this.createPacketHandler();
        this.setLocalContact();
    }

    public int getNetwork() {
        return this.network;
    }

    public void testInstanceIDChange() throws DHTTransportException {
        this.local_contact = new DHTTransportUDPContactImpl(true, this, this.local_contact.getTransportAddress(), this.local_contact.getExternalAddress(), this.protocol_version, this.random.nextInt(), 0L);
    }

    public void testTransportIDChange() throws DHTTransportException {
        this.external_address = this.external_address.equals("127.0.0.1") ? "192.168.0.2" : "127.0.0.1";
        InetSocketAddress address = new InetSocketAddress(this.external_address, this.port);
        this.local_contact = new DHTTransportUDPContactImpl(true, this, address, address, this.protocol_version, this.local_contact.getInstanceID(), 0L);
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((DHTTransportListener)this.listeners.get(i)).localContactChanged(this.local_contact);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void testExternalAddressChange() {
        try {
            Iterator it = this.contact_history.values().iterator();
            DHTTransportUDPContactImpl c1 = (DHTTransportUDPContactImpl)it.next();
            DHTTransportUDPContactImpl c2 = (DHTTransportUDPContactImpl)it.next();
            this.externalAddressChange(c1, c2.getExternalAddress(), true);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void testNetworkAlive(boolean alive) {
        this.packet_handler.testNetworkAlive(alive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getExternalAddress(String default_address, DHTLogger log) {
        try {
            class_mon.enter();
            String new_external_address = null;
            try {
                InetAddress public_address;
                log.log("Obtaining external address");
                if (TEST_EXTERNAL_IP) {
                    new_external_address = this.v6 ? "::1" : "127.0.0.1";
                    log.log("    External IP address obtained from test data: " + new_external_address);
                }
                if (this.ip_override != null) {
                    new_external_address = this.ip_override;
                    log.log("    External IP address explicitly overridden: " + new_external_address);
                }
                if (new_external_address == null) {
                    ArrayList contacts;
                    try {
                        this.this_mon.enter();
                        contacts = new ArrayList(this.contact_history.values());
                    }
                    finally {
                        this.this_mon.exit();
                    }
                    String returned_address = null;
                    int returned_matches = 0;
                    int search_lim = Math.min(24, contacts.size());
                    log.log("    Contacts to search = " + search_lim);
                    for (int i = 0; i < search_lim; ++i) {
                        DHTTransportUDPContactImpl contact = (DHTTransportUDPContactImpl)contacts.remove((int)((double)contacts.size() * Math.random()));
                        InetSocketAddress a = this.askContactForExternalAddress(contact);
                        if (a != null && a.getAddress() != null) {
                            String ip = a.getAddress().getHostAddress();
                            if (returned_address == null) {
                                returned_address = ip;
                                log.log("    : contact " + contact.getString() + " reported external address as '" + ip + "'");
                                ++returned_matches;
                                continue;
                            }
                            if (returned_address.equals(ip)) {
                                log.log("    : contact " + contact.getString() + " also reported external address as '" + ip + "'");
                                if (++returned_matches != 3) continue;
                                new_external_address = returned_address;
                                log.log("    External IP address obtained from contacts: " + returned_address);
                                break;
                            }
                            log.log("    : contact " + contact.getString() + " reported external address as '" + ip + "', abandoning due to mismatch");
                            break;
                        }
                        log.log("    : contact " + contact.getString() + " didn't reply");
                    }
                }
                if (new_external_address == null && (public_address = this.logger.getPluginInterface().getUtilities().getPublicAddress(this.v6)) != null) {
                    new_external_address = public_address.getHostAddress();
                    log.log("    External IP address obtained: " + new_external_address);
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            if (new_external_address == null) {
                new_external_address = default_address;
                log.log("    External IP address defaulted:  " + new_external_address);
            }
            if (this.external_address == null || !this.external_address.equals(new_external_address)) {
                this.informLocalAddress(new_external_address);
            }
            this.external_address = new_external_address;
        }
        finally {
            class_mon.exit();
        }
    }

    protected void informLocalAddress(String address) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((DHTTransportListener)this.listeners.get(i)).currentAddress(address);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void externalAddressChange(final DHTTransportUDPContactImpl reporter, final InetSocketAddress new_address, boolean force) throws DHTTransportException {
        InetAddress ia = new_address.getAddress();
        if (ia == null) {
            Debug.out("reported new external address '" + new_address + "' is unresolved");
            throw new DHTTransportException("Address '" + new_address + "' is unresolved");
        }
        if (ia instanceof Inet4Address && this.v6 || ia instanceof Inet6Address && !this.v6) {
            return;
        }
        final String new_ip = ia.getHostAddress();
        if (new_ip.equals(this.external_address)) {
            return;
        }
        try {
            this.this_mon.enter();
            long now = SystemTime.getCurrentTime();
            if (now - this.last_address_change < (long)this.min_address_change_period) {
                return;
            }
            if (this.contact_history.size() < 32 && !force) {
                if (!this.initial_address_change_deferred) {
                    this.initial_address_change_deferred = true;
                    this.logger.log("Node " + reporter.getString() + " has reported that the external IP address is '" + new_address + "': deferring new checks");
                    new DelayedEvent("DHTTransportUDP:delayAC", 30000L, new AERunnable(){

                        public void runSupport() {
                            try {
                                DHTTransportUDPImpl.this.externalAddressChange(reporter, new_address, true);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    });
                }
                return;
            }
            this.logger.log("Node " + reporter.getString() + " has reported that the external IP address is '" + new_address + "'");
            if (this.invalidExternalAddress(ia)) {
                this.logger.log("     This is invalid as it is a private address.");
                return;
            }
            if (reporter.getExternalAddress().getAddress().getHostAddress().equals(new_ip)) {
                this.logger.log("     This is invalid as it is the same as the reporter's address.");
                return;
            }
            this.last_address_change = now;
            if (this.min_address_change_period == 300000) {
                this.min_address_change_period = 600000;
            }
        }
        finally {
            this.this_mon.exit();
        }
        final String old_external_address = this.external_address;
        new AEThread2("DHTTransportUDP:getAddress", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    DHTTransportUDPImpl.this.this_mon.enter();
                    if (DHTTransportUDPImpl.this.address_changing) {
                        return;
                    }
                    DHTTransportUDPImpl.this.address_changing = true;
                }
                finally {
                    DHTTransportUDPImpl.this.this_mon.exit();
                }
                try {
                    DHTTransportUDPImpl.this.getExternalAddress(new_ip, DHTTransportUDPImpl.this.logger);
                    if (old_external_address.equals(DHTTransportUDPImpl.this.external_address)) {
                        return;
                    }
                    DHTTransportUDPImpl.this.setLocalContact();
                }
                finally {
                    try {
                        DHTTransportUDPImpl.this.this_mon.enter();
                        DHTTransportUDPImpl.this.address_changing = false;
                    }
                    finally {
                        DHTTransportUDPImpl.this.this_mon.exit();
                    }
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void contactAlive(DHTTransportUDPContactImpl contact) {
        try {
            this.this_mon.enter();
            this.contact_history.put(contact.getTransportAddress(), contact);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHTTransportContact[] getReachableContacts() {
        try {
            this.this_mon.enter();
            Collection vals = this.routable_contact_history.values();
            DHTTransportContact[] res = new DHTTransportContact[vals.size()];
            vals.toArray(res);
            DHTTransportContact[] dHTTransportContactArray = res;
            return dHTTransportContactArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateContactStatus(DHTTransportUDPContactImpl contact, int status, boolean incoming) {
        try {
            this.this_mon.enter();
            contact.setNodeStatus(status);
            if (contact.getProtocolVersion() >= 12 && status != -1) {
                boolean other_routable;
                boolean bl = other_routable = (status & 1) != 0;
                if (other_routable) {
                    if (incoming) {
                        ++this.other_routable_total;
                    }
                    this.routable_contact_history.put(contact.getTransportAddress(), contact);
                } else if (incoming) {
                    ++this.other_non_routable_total;
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public int getRouteablePercentage() {
        if (this.other_routable_total + this.other_non_routable_total < 100L) {
            return -1;
        }
        return (int)(this.other_routable_total * 100L / (this.other_routable_total + this.other_non_routable_total));
    }

    protected boolean invalidExternalAddress(InetAddress ia) {
        return ia.isLinkLocalAddress() || ia.isLoopbackAddress() || ia.isSiteLocalAddress();
    }

    protected int getMaxFailForLiveCount() {
        return this.max_fails_for_live;
    }

    protected int getMaxFailForUnknownCount() {
        return this.max_fails_for_unknown;
    }

    public DHTTransportContact getLocalContact() {
        return this.local_contact;
    }

    protected void setLocalContact() {
        InetSocketAddress s_address = new InetSocketAddress(this.external_address, this.port);
        try {
            this.local_contact = new DHTTransportUDPContactImpl(true, this, s_address, s_address, this.protocol_version, this.random.nextInt(), 0L);
            this.logger.log("External address changed: " + s_address);
            Debug.out("DHTTransport: address changed to " + s_address);
            for (int i = 0; i < this.listeners.size(); ++i) {
                try {
                    ((DHTTransportListener)this.listeners.get(i)).localContactChanged(this.local_contact);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public DHTTransportContact importContact(DataInputStream is) throws IOException, DHTTransportException {
        DHTTransportUDPContactImpl contact = DHTUDPUtils.deserialiseContact(this, is);
        this.importContact(contact);
        return contact;
    }

    public DHTTransportUDPContact importContact(InetSocketAddress _address, byte _protocol_version) throws DHTTransportException {
        DHTTransportUDPContactImpl contact = new DHTTransportUDPContactImpl(false, this, _address, _address, _protocol_version, 0, 0L);
        this.importContact(contact);
        return contact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importContact(DHTTransportUDPContactImpl contact) {
        try {
            this.this_mon.enter();
            if (this.contact_history.size() < 32) {
                this.contact_history.put(contact.getTransportAddress(), contact);
            }
        }
        finally {
            this.this_mon.exit();
        }
        this.request_handler.contactImported(contact);
    }

    public void exportContact(DHTTransportContact contact, DataOutputStream os) throws IOException, DHTTransportException {
        DHTUDPUtils.serialiseContact(os, contact);
    }

    public void removeContact(DHTTransportContact contact) {
        this.request_handler.contactRemoved(contact);
    }

    public void setRequestHandler(DHTTransportRequestHandler _request_handler) {
        this.request_handler = new DHTTransportRequestCounter(_request_handler, this.stats);
    }

    public DHTTransportStats getStats() {
        return this.stats;
    }

    protected void checkAddress(DHTTransportUDPContactImpl contact) throws DHTUDPPacketHandlerException {
        if (this.ip_filter.isEnabled()) {
            byte[] addr = contact.getTransportAddress().getAddress().getAddress();
            if (this.bad_ip_bloom_filter == null) {
                this.bad_ip_bloom_filter = BloomFilterFactory.createAddOnly(32000);
            } else if (this.bad_ip_bloom_filter.contains(addr)) {
                throw new DHTUDPPacketHandlerException("IPFilter check fails (repeat)");
            }
            if (this.ip_filter.isInRange(contact.getTransportAddress().getAddress(), "DHT", null, this.logger.isEnabled(2))) {
                if (this.bad_ip_bloom_filter.getEntryCount() >= 3200) {
                    this.bad_ip_bloom_filter = BloomFilterFactory.createAddOnly(32000);
                }
                this.bad_ip_bloom_filter.add(addr);
                throw new DHTUDPPacketHandlerException("IPFilter check fails");
            }
        }
    }

    protected void sendPing(final DHTTransportUDPContactImpl contact, final DHTTransportReplyHandler handler, long timeout, int priority) {
        try {
            this.checkAddress(contact);
            final long connection_id = this.getConnectionID();
            DHTUDPPacketRequestPing request2 = new DHTUDPPacketRequestPing(this, connection_id, this.local_contact, contact);
            this.stats.pingSent(request2);
            this.requestSendRequestProcessor(contact, request2);
            this.packet_handler.sendAndReceive(request2, contact.getTransportAddress(), new DHTUDPPacketReceiver(){

                public void packetReceived(DHTUDPPacketReply packet, InetSocketAddress from_address, long elapsed_time) {
                    try {
                        if (packet.getConnectionId() != connection_id) {
                            throw new Exception("connection id mismatch");
                        }
                        contact.setInstanceIDAndVersion(packet.getTargetInstanceID(), packet.getProtocolVersion());
                        DHTTransportUDPImpl.this.requestSendReplyProcessor(contact, handler, packet, elapsed_time);
                        DHTTransportUDPImpl.this.stats.pingOK();
                        handler.pingReply(contact, (int)elapsed_time);
                    }
                    catch (DHTUDPPacketHandlerException e) {
                        this.error(e);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        this.error(new DHTUDPPacketHandlerException("ping failed", e));
                    }
                }

                public void error(DHTUDPPacketHandlerException e) {
                    DHTTransportUDPImpl.this.stats.pingFailed();
                    handler.failed(contact, e);
                }
            }, timeout, priority);
        }
        catch (Throwable e) {
            this.stats.pingFailed();
            handler.failed(contact, e);
        }
    }

    protected void sendPing(DHTTransportUDPContactImpl contact, DHTTransportReplyHandler handler) {
        this.sendPing(contact, handler, this.request_timeout, 1);
    }

    protected void sendImmediatePing(DHTTransportUDPContactImpl contact, DHTTransportReplyHandler handler, long timeout) {
        this.sendPing(contact, handler, timeout, 99);
    }

    protected void sendKeyBlockRequest(final DHTTransportUDPContactImpl contact, final DHTTransportReplyHandler handler, byte[] block_request, byte[] block_signature) {
        try {
            this.checkAddress(contact);
            final long connection_id = this.getConnectionID();
            DHTUDPPacketRequestKeyBlock request2 = new DHTUDPPacketRequestKeyBlock(this, connection_id, this.local_contact, contact);
            request2.setKeyBlockDetails(block_request, block_signature);
            this.stats.keyBlockSent(request2);
            request2.setRandomID(contact.getRandomID());
            this.requestSendRequestProcessor(contact, request2);
            this.packet_handler.sendAndReceive(request2, contact.getTransportAddress(), new DHTUDPPacketReceiver(){

                public void packetReceived(DHTUDPPacketReply packet, InetSocketAddress from_address, long elapsed_time) {
                    try {
                        if (packet.getConnectionId() != connection_id) {
                            throw new Exception("connection id mismatch");
                        }
                        contact.setInstanceIDAndVersion(packet.getTargetInstanceID(), packet.getProtocolVersion());
                        DHTTransportUDPImpl.this.requestSendReplyProcessor(contact, handler, packet, elapsed_time);
                        DHTTransportUDPImpl.this.stats.keyBlockOK();
                        handler.keyBlockReply(contact);
                    }
                    catch (DHTUDPPacketHandlerException e) {
                        this.error(e);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        this.error(new DHTUDPPacketHandlerException("send key block failed", e));
                    }
                }

                public void error(DHTUDPPacketHandlerException e) {
                    DHTTransportUDPImpl.this.stats.keyBlockFailed();
                    handler.failed(contact, e);
                }
            }, this.request_timeout, 1);
        }
        catch (Throwable e) {
            this.stats.keyBlockFailed();
            handler.failed(contact, e);
        }
    }

    protected void sendStats(final DHTTransportUDPContactImpl contact, final DHTTransportReplyHandler handler) {
        try {
            this.checkAddress(contact);
            final long connection_id = this.getConnectionID();
            DHTUDPPacketRequestStats request2 = new DHTUDPPacketRequestStats(this, connection_id, this.local_contact, contact);
            this.stats.statsSent(request2);
            this.requestSendRequestProcessor(contact, request2);
            this.packet_handler.sendAndReceive(request2, contact.getTransportAddress(), new DHTUDPPacketReceiver(){

                public void packetReceived(DHTUDPPacketReply packet, InetSocketAddress from_address, long elapsed_time) {
                    try {
                        if (packet.getConnectionId() != connection_id) {
                            throw new Exception("connection id mismatch");
                        }
                        contact.setInstanceIDAndVersion(packet.getTargetInstanceID(), packet.getProtocolVersion());
                        DHTTransportUDPImpl.this.requestSendReplyProcessor(contact, handler, packet, elapsed_time);
                        DHTUDPPacketReplyStats reply = (DHTUDPPacketReplyStats)packet;
                        DHTTransportUDPImpl.this.stats.statsOK();
                        if (reply.getStatsType() == 1) {
                            handler.statsReply(contact, reply.getOriginalStats());
                        } else {
                            System.out.println("new stats reply:" + reply.getString());
                        }
                    }
                    catch (DHTUDPPacketHandlerException e) {
                        this.error(e);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        this.error(new DHTUDPPacketHandlerException("stats failed", e));
                    }
                }

                public void error(DHTUDPPacketHandlerException e) {
                    DHTTransportUDPImpl.this.stats.statsFailed();
                    handler.failed(contact, e);
                }
            }, this.request_timeout, 2);
        }
        catch (Throwable e) {
            this.stats.statsFailed();
            handler.failed(contact, e);
        }
    }

    protected InetSocketAddress askContactForExternalAddress(DHTTransportUDPContactImpl contact) {
        try {
            this.checkAddress(contact);
            long connection_id = this.getConnectionID();
            DHTUDPPacketRequestPing request2 = new DHTUDPPacketRequestPing(this, connection_id, this.local_contact, contact);
            this.stats.pingSent(request2);
            final AESemaphore sem = new AESemaphore("DHTTransUDP:extping");
            final InetSocketAddress[] result = new InetSocketAddress[1];
            this.packet_handler.sendAndReceive(request2, contact.getTransportAddress(), new DHTUDPPacketReceiver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void packetReceived(DHTUDPPacketReply _packet, InetSocketAddress from_address, long elapsed_time) {
                    try {
                        DHTUDPPacketReplyError packet;
                        if (_packet instanceof DHTUDPPacketReplyPing) {
                            result[0] = DHTTransportUDPImpl.this.local_contact.getExternalAddress();
                        } else if (_packet instanceof DHTUDPPacketReplyError && (packet = (DHTUDPPacketReplyError)_packet).getErrorType() == 1) {
                            result[0] = packet.getOriginatingAddress();
                        }
                    }
                    finally {
                        sem.release();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void error(DHTUDPPacketHandlerException e) {
                    try {
                        DHTTransportUDPImpl.this.stats.pingFailed();
                    }
                    finally {
                        sem.release();
                    }
                }
            }, 5000L, 0);
            sem.reserve(5000L);
            return result[0];
        }
        catch (Throwable e) {
            this.stats.pingFailed();
            return null;
        }
    }

    public void sendStore(final DHTTransportUDPContactImpl contact, final DHTTransportReplyHandler handler, byte[][] keys, DHTTransportValue[][] value_sets, int priority) {
        block9: {
            final long connection_id = this.getConnectionID();
            int packet_count = 0;
            try {
                this.checkAddress(contact);
                int current_key_index = 0;
                int current_value_index = 0;
                while (current_key_index < keys.length) {
                    int packet_entries;
                    ++packet_count;
                    int space = 1359;
                    ArrayList<byte[]> key_list = new ArrayList<byte[]>();
                    ArrayList values_list = new ArrayList();
                    key_list.add(keys[current_key_index]);
                    space -= keys[current_key_index].length + 1;
                    values_list.add(new ArrayList());
                    while (space > 0 && current_key_index < keys.length) {
                        if (current_value_index == value_sets[current_key_index].length) {
                            current_value_index = 0;
                            if (key_list.size() == 255 || ++current_key_index == keys.length) break;
                            key_list.add(keys[current_key_index]);
                            space -= keys[current_key_index].length + 1;
                            values_list.add(new ArrayList());
                        }
                        DHTTransportValue value = value_sets[current_key_index][current_value_index];
                        int entry_size = 24 + value.getValue().length + 1;
                        List values = (List)values_list.get(values_list.size() - 1);
                        if (space < entry_size || values.size() == 255) break;
                        values.add(value);
                        space -= entry_size;
                        ++current_value_index;
                    }
                    if ((packet_entries = key_list.size()) > 0 && ((List)values_list.get(packet_entries - 1)).size() == 0) {
                        --packet_entries;
                    }
                    if (packet_entries != 0) {
                        byte[][] packet_keys = new byte[packet_entries][];
                        DHTTransportValue[][] packet_value_sets = new DHTTransportValue[packet_entries][];
                        for (int i = 0; i < packet_entries; ++i) {
                            packet_keys[i] = (byte[])key_list.get(i);
                            List values = (List)values_list.get(i);
                            packet_value_sets[i] = new DHTTransportValue[values.size()];
                            for (int j = 0; j < values.size(); ++j) {
                                packet_value_sets[i][j] = (DHTTransportValue)values.get(j);
                            }
                        }
                        DHTUDPPacketRequestStore request2 = new DHTUDPPacketRequestStore(this, connection_id, this.local_contact, contact);
                        this.stats.storeSent(request2);
                        request2.setRandomID(contact.getRandomID());
                        request2.setKeys(packet_keys);
                        request2.setValueSets(packet_value_sets);
                        final int f_packet_count = packet_count;
                        this.requestSendRequestProcessor(contact, request2);
                        this.packet_handler.sendAndReceive(request2, contact.getTransportAddress(), new DHTUDPPacketReceiver(){

                            public void packetReceived(DHTUDPPacketReply packet, InetSocketAddress from_address, long elapsed_time) {
                                try {
                                    if (packet.getConnectionId() != connection_id) {
                                        throw new Exception("connection id mismatch: sender=" + from_address + ",packet=" + packet.getString());
                                    }
                                    contact.setInstanceIDAndVersion(packet.getTargetInstanceID(), packet.getProtocolVersion());
                                    DHTTransportUDPImpl.this.requestSendReplyProcessor(contact, handler, packet, elapsed_time);
                                    DHTUDPPacketReplyStore reply = (DHTUDPPacketReplyStore)packet;
                                    DHTTransportUDPImpl.this.stats.storeOK();
                                    if (f_packet_count == 1) {
                                        handler.storeReply(contact, reply.getDiversificationTypes());
                                    }
                                }
                                catch (DHTUDPPacketHandlerException e) {
                                    this.error(e);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                    this.error(new DHTUDPPacketHandlerException("store failed", e));
                                }
                            }

                            public void error(DHTUDPPacketHandlerException e) {
                                DHTTransportUDPImpl.this.stats.storeFailed();
                                if (f_packet_count == 1) {
                                    handler.failed(contact, e);
                                }
                            }
                        }, this.store_timeout, priority);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                this.stats.storeFailed();
                if (packet_count > true) break block9;
                handler.failed(contact, e);
            }
        }
    }

    public void sendFindNode(final DHTTransportUDPContactImpl contact, final DHTTransportReplyHandler handler, byte[] nid) {
        try {
            this.checkAddress(contact);
            final long connection_id = this.getConnectionID();
            DHTUDPPacketRequestFindNode request2 = new DHTUDPPacketRequestFindNode(this, connection_id, this.local_contact, contact);
            this.stats.findNodeSent(request2);
            request2.setID(nid);
            request2.setNodeStatus(this.getNodeStatus());
            request2.setEstimatedDHTSize(this.request_handler.getTransportEstimatedDHTSize());
            this.requestSendRequestProcessor(contact, request2);
            this.packet_handler.sendAndReceive(request2, contact.getTransportAddress(), new DHTUDPPacketReceiver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void packetReceived(DHTUDPPacketReply packet, InetSocketAddress from_address, long elapsed_time) {
                    try {
                        if (packet.getConnectionId() != connection_id) {
                            throw new Exception("connection id mismatch");
                        }
                        contact.setInstanceIDAndVersion(packet.getTargetInstanceID(), packet.getProtocolVersion());
                        DHTTransportUDPImpl.this.requestSendReplyProcessor(contact, handler, packet, elapsed_time);
                        DHTUDPPacketReplyFindNode reply = (DHTUDPPacketReplyFindNode)packet;
                        contact.setRandomID(reply.getRandomID());
                        DHTTransportUDPImpl.this.updateContactStatus(contact, reply.getNodeStatus(), false);
                        DHTTransportUDPImpl.this.request_handler.setTransportEstimatedDHTSize(reply.getEstimatedDHTSize());
                        DHTTransportUDPImpl.this.stats.findNodeOK();
                        DHTTransportContact[] contacts = reply.getContacts();
                        for (int i = 0; DHTTransportUDPImpl.this.contact_history.size() < 32 && i < contacts.length; ++i) {
                            DHTTransportUDPContact c = (DHTTransportUDPContact)contacts[i];
                            try {
                                DHTTransportUDPImpl.this.this_mon.enter();
                                DHTTransportUDPImpl.this.contact_history.put(c.getTransportAddress(), c);
                                continue;
                            }
                            finally {
                                DHTTransportUDPImpl.this.this_mon.exit();
                            }
                        }
                        handler.findNodeReply(contact, contacts);
                    }
                    catch (DHTUDPPacketHandlerException e) {
                        this.error(e);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        this.error(new DHTUDPPacketHandlerException("findNode failed", e));
                    }
                }

                public void error(DHTUDPPacketHandlerException e) {
                    DHTTransportUDPImpl.this.stats.findNodeFailed();
                    handler.failed(contact, e);
                }
            }, this.request_timeout, 1);
        }
        catch (Throwable e) {
            this.stats.findNodeFailed();
            handler.failed(contact, e);
        }
    }

    public void sendFindValue(final DHTTransportUDPContactImpl contact, final DHTTransportReplyHandler handler, byte[] key, int max_values, byte flags) {
        block2: {
            try {
                this.checkAddress(contact);
                final long connection_id = this.getConnectionID();
                DHTUDPPacketRequestFindValue request2 = new DHTUDPPacketRequestFindValue(this, connection_id, this.local_contact, contact);
                this.stats.findValueSent(request2);
                request2.setID(key);
                request2.setMaximumValues(max_values);
                request2.setFlags(flags);
                this.requestSendRequestProcessor(contact, request2);
                this.packet_handler.sendAndReceive(request2, contact.getTransportAddress(), new DHTUDPPacketReceiver(){

                    public void packetReceived(DHTUDPPacketReply packet, InetSocketAddress from_address, long elapsed_time) {
                        try {
                            if (packet.getConnectionId() != connection_id) {
                                throw new Exception("connection id mismatch");
                            }
                            contact.setInstanceIDAndVersion(packet.getTargetInstanceID(), packet.getProtocolVersion());
                            DHTTransportUDPImpl.this.requestSendReplyProcessor(contact, handler, packet, elapsed_time);
                            DHTUDPPacketReplyFindValue reply = (DHTUDPPacketReplyFindValue)packet;
                            DHTTransportUDPImpl.this.stats.findValueOK();
                            DHTTransportValue[] res = reply.getValues();
                            if (res != null) {
                                boolean continuation = reply.hasContinuation();
                                handler.findValueReply(contact, res, reply.getDiversificationType(), continuation);
                            } else {
                                handler.findValueReply(contact, reply.getContacts());
                            }
                        }
                        catch (DHTUDPPacketHandlerException e) {
                            this.error(e);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                            this.error(new DHTUDPPacketHandlerException("findValue failed", e));
                        }
                    }

                    public void error(DHTUDPPacketHandlerException e) {
                        DHTTransportUDPImpl.this.stats.findValueFailed();
                        handler.failed(contact, e);
                    }
                }, this.request_timeout, 0);
            }
            catch (Throwable e) {
                if (e instanceof DHTUDPPacketHandlerException) break block2;
                this.stats.findValueFailed();
                handler.failed(contact, e);
            }
        }
    }

    protected DHTTransportFullStats getFullStats(DHTTransportUDPContactImpl contact) {
        if (contact == this.local_contact) {
            return this.request_handler.statsRequest(contact);
        }
        final DHTTransportFullStats[] res = new DHTTransportFullStats[]{null};
        final AESemaphore sem = new AESemaphore("DHTTransportUDP:getFullStats");
        this.sendStats(contact, new DHTTransportReplyHandlerAdapter(){

            public void statsReply(DHTTransportContact _contact, DHTTransportFullStats _stats) {
                res[0] = _stats;
                sem.release();
            }

            public void failed(DHTTransportContact _contact, Throwable _error) {
                sem.release();
            }
        });
        sem.reserve();
        return res[0];
    }

    protected void sendReadRequest(long connection_id, DHTTransportUDPContactImpl contact, byte[] transfer_key, byte[] key) {
        this.sendReadRequest(connection_id, contact, transfer_key, key, 0, 0);
    }

    protected void sendReadRequest(long connection_id, DHTTransportUDPContactImpl contact, byte[] transfer_key, byte[] key, int start_pos, int len) {
        DHTUDPPacketData request2 = new DHTUDPPacketData(this, connection_id, this.local_contact, contact);
        request2.setDetails((byte)0, transfer_key, key, new byte[0], start_pos, len, 0);
        try {
            this.checkAddress(contact);
            if (XFER_TRACE) {
                this.logger.log("Transfer read request: key = " + DHTLog.getFullString(key) + ", contact = " + contact.getString());
            }
            this.stats.dataSent(request2);
            this.packet_handler.send(request2, contact.getTransportAddress());
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    protected void sendReadReply(long connection_id, DHTTransportUDPContactImpl contact, byte[] transfer_key, byte[] key, byte[] data, int start_position, int length, int total_length) {
        DHTUDPPacketData request2 = new DHTUDPPacketData(this, connection_id, this.local_contact, contact);
        request2.setDetails((byte)1, transfer_key, key, data, start_position, length, total_length);
        try {
            this.checkAddress(contact);
            if (XFER_TRACE) {
                this.logger.log("Transfer read reply: key = " + DHTLog.getFullString(key) + ", contact = " + contact.getString());
            }
            this.stats.dataSent(request2);
            this.packet_handler.send(request2, contact.getTransportAddress());
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    protected void sendWriteRequest(long connection_id, DHTTransportUDPContactImpl contact, byte[] transfer_key, byte[] key, byte[] data, int start_position, int length, int total_length) {
        DHTUDPPacketData request2 = new DHTUDPPacketData(this, connection_id, this.local_contact, contact);
        request2.setDetails((byte)2, transfer_key, key, data, start_position, length, total_length);
        try {
            this.checkAddress(contact);
            if (XFER_TRACE) {
                this.logger.log("Transfer write request: key = " + DHTLog.getFullString(key) + ", contact = " + contact.getString());
            }
            this.stats.dataSent(request2);
            this.packet_handler.send(request2, contact.getTransportAddress());
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    protected void sendWriteReply(long connection_id, DHTTransportUDPContactImpl contact, byte[] transfer_key, byte[] key, int start_position, int length) {
        DHTUDPPacketData request2 = new DHTUDPPacketData(this, connection_id, this.local_contact, contact);
        request2.setDetails((byte)3, transfer_key, key, new byte[0], start_position, length, 0);
        try {
            this.checkAddress(contact);
            if (XFER_TRACE) {
                this.logger.log("Transfer write reply: key = " + DHTLog.getFullString(key) + ", contact = " + contact.getString());
            }
            this.stats.dataSent(request2);
            this.packet_handler.send(request2, contact.getTransportAddress());
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    public void registerTransferHandler(byte[] handler_key, DHTTransportTransferHandler handler) {
        this.logger.log("Transfer handler (" + handler.getName() + ") registered for key '" + ByteFormatter.encodeString(handler_key));
        this.transfer_handlers.put(new HashWrapper(handler_key), new transferHandlerInterceptor(handler));
    }

    protected int handleTransferRequest(DHTTransportUDPContactImpl target, long connection_id, byte[] transfer_key, byte[] request_key, byte[] data, int start, int length, boolean write_request, boolean first_packet_only) throws DHTTransportException {
        DHTTransportTransferHandler handler = (DHTTransportTransferHandler)this.transfer_handlers.get(new HashWrapper(transfer_key));
        if (handler == null) {
            this.logger.log("No transfer handler registered for key '" + ByteFormatter.encodeString(transfer_key) + "'");
            throw new DHTTransportException("No transfer handler registered");
        }
        if (data == null) {
            data = handler.handleRead(target, request_key);
        }
        if (data == null) {
            return -1;
        }
        if (data.length == 0) {
            if (write_request) {
                this.sendWriteRequest(connection_id, target, transfer_key, request_key, data, 0, 0, 0);
            } else {
                this.sendReadReply(connection_id, target, transfer_key, request_key, data, 0, 0, 0);
            }
        } else {
            if (start < 0) {
                start = 0;
            } else if (start >= data.length) {
                this.logger.log("dataRequest: invalid start position");
                return data.length;
            }
            if (length <= 0) {
                length = data.length;
            } else if (start + length > data.length) {
                this.logger.log("dataRequest: invalid length");
                return data.length;
            }
            int end = start + length;
            while (start < end) {
                int chunk = end - start;
                if (chunk > DHTUDPPacketData.MAX_DATA_SIZE) {
                    chunk = DHTUDPPacketData.MAX_DATA_SIZE;
                }
                if (write_request) {
                    this.sendWriteRequest(connection_id, target, transfer_key, request_key, data, start, chunk, data.length);
                    if (first_packet_only) {
                        break;
                    }
                } else {
                    this.sendReadReply(connection_id, target, transfer_key, request_key, data, start, chunk, data.length);
                }
                start += chunk;
            }
        }
        return data.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dataRequest(final DHTTransportUDPContactImpl originator, final DHTUDPPacketData req) {
        this.stats.dataReceived();
        byte packet_type = req.getPacketType();
        if (XFER_TRACE) {
            System.out.println("dataRequest: originator=" + originator.getAddress() + ",packet=" + req.getString());
        }
        if (packet_type == 1) {
            transferQueue queue = this.lookupTransferQueue(this.read_transfers, req.getConnectionId());
            if (queue != null) {
                queue.add(req);
            }
        } else if (packet_type == 3) {
            transferQueue queue = this.lookupTransferQueue(this.write_transfers, req.getConnectionId());
            if (queue != null) {
                queue.add(req);
            }
        } else {
            byte[] transfer_key = req.getTransferKey();
            if (packet_type == 0) {
                try {
                    this.handleTransferRequest(originator, req.getConnectionId(), transfer_key, req.getRequestKey(), null, req.getStartPosition(), req.getLength(), false, false);
                }
                catch (DHTTransportException e) {
                    this.logger.log(e);
                }
            } else {
                transferQueue old_queue = this.lookupTransferQueue(this.read_transfers, req.getConnectionId());
                if (old_queue != null) {
                    old_queue.add(req);
                } else {
                    final DHTTransportTransferHandler handler = (DHTTransportTransferHandler)this.transfer_handlers.get(new HashWrapper(transfer_key));
                    if (handler == null) {
                        this.logger.log("No transfer handler registered for key '" + ByteFormatter.encodeString(transfer_key) + "'");
                    } else {
                        try {
                            final transferQueue new_queue = new transferQueue(this.read_transfers, req.getConnectionId());
                            new_queue.add(req);
                            try {
                                this.this_mon.enter();
                                if (this.active_write_queue_processor_count >= 64) {
                                    new_queue.destroy();
                                    throw new DHTTransportException("Active write queue process thread limit exceeded");
                                }
                                ++this.active_write_queue_processor_count;
                                if (XFER_TRACE) {
                                    System.out.println("active_write_queue_processor_count=" + this.active_write_queue_processor_count);
                                }
                            }
                            finally {
                                this.this_mon.exit();
                            }
                            new AEThread2("DHTTransportUDP:writeQueueProcessor", true){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    try {
                                        byte[] write_data = DHTTransportUDPImpl.this.runTransferQueue(new_queue, new DHTTransportProgressListener(){

                                            public void reportSize(long size) {
                                                if (XFER_TRACE) {
                                                    System.out.println("writeXfer: size=" + size);
                                                }
                                            }

                                            public void reportActivity(String str) {
                                                if (XFER_TRACE) {
                                                    System.out.println("writeXfer: act=" + str);
                                                }
                                            }

                                            public void reportCompleteness(int percent) {
                                                if (XFER_TRACE) {
                                                    System.out.println("writeXfer: %=" + percent);
                                                }
                                            }
                                        }, originator, req.getTransferKey(), req.getRequestKey(), 60000L, false);
                                        if (write_data != null) {
                                            byte[] reply_data;
                                            if (req.getStartPosition() != 0 || req.getLength() != req.getTotalLength()) {
                                                DHTTransportUDPImpl.this.sendWriteReply(req.getConnectionId(), originator, req.getTransferKey(), req.getRequestKey(), 0, req.getTotalLength());
                                            }
                                            if ((reply_data = handler.handleWrite(originator, req.getRequestKey(), write_data)) != null) {
                                                DHTTransportUDPImpl.this.writeTransfer(new DHTTransportProgressListener(){

                                                    public void reportSize(long size) {
                                                        if (XFER_TRACE) {
                                                            System.out.println("writeXferReply: size=" + size);
                                                        }
                                                    }

                                                    public void reportActivity(String str) {
                                                        if (XFER_TRACE) {
                                                            System.out.println("writeXferReply: act=" + str);
                                                        }
                                                    }

                                                    public void reportCompleteness(int percent) {
                                                        if (XFER_TRACE) {
                                                            System.out.println("writeXferReply: %=" + percent);
                                                        }
                                                    }
                                                }, originator, req.getTransferKey(), req.getRequestKey(), reply_data, 60000L);
                                            }
                                        }
                                    }
                                    catch (DHTTransportException e) {
                                        DHTTransportUDPImpl.this.logger.log("Failed to process transfer queue: " + Debug.getNestedExceptionMessage(e));
                                    }
                                    finally {
                                        try {
                                            DHTTransportUDPImpl.this.this_mon.enter();
                                            DHTTransportUDPImpl.this.active_write_queue_processor_count--;
                                            if (XFER_TRACE) {
                                                System.out.println("active_write_queue_processor_count=" + DHTTransportUDPImpl.this.active_write_queue_processor_count);
                                            }
                                        }
                                        finally {
                                            DHTTransportUDPImpl.this.this_mon.exit();
                                        }
                                    }
                                }
                            }.start();
                            this.sendWriteReply(req.getConnectionId(), originator, req.getTransferKey(), req.getRequestKey(), req.getStartPosition(), req.getLength());
                        }
                        catch (DHTTransportException e) {
                            this.logger.log("Faild to create transfer queue");
                            this.logger.log(e);
                        }
                    }
                }
            }
        }
    }

    public byte[] readTransfer(DHTTransportProgressListener listener, DHTTransportContact target, byte[] handler_key, byte[] key, long timeout) throws DHTTransportException {
        long connection_id = this.getConnectionID();
        transferQueue transfer_queue = new transferQueue(this.read_transfers, connection_id);
        return this.runTransferQueue(transfer_queue, listener, target, handler_key, key, timeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] runTransferQueue(transferQueue transfer_queue, DHTTransportProgressListener listener, DHTTransportContact target, byte[] handler_key, byte[] key, long timeout, boolean read_transfer) throws DHTTransportException {
        TreeSet<DHTUDPPacketData> packets = new TreeSet<DHTUDPPacketData>(new Comparator(){

            public int compare(Object o1, Object o2) {
                DHTUDPPacketData p1 = (DHTUDPPacketData)o1;
                DHTUDPPacketData p2 = (DHTUDPPacketData)o2;
                return p1.getStartPosition() - p2.getStartPosition();
            }
        });
        int entire_request_count = 0;
        int transfer_size = -1;
        int transferred = 0;
        String target_name = DHTLog.getString2(target.getID());
        try {
            long start = SystemTime.getCurrentTime();
            if (read_transfer) {
                listener.reportActivity(this.getMessageText("request_all", target_name));
                ++entire_request_count;
                this.sendReadRequest(transfer_queue.getID(), (DHTTransportUDPContactImpl)target, handler_key, key);
            } else {
                ++entire_request_count;
            }
            block5: while (SystemTime.getCurrentTime() - start <= timeout) {
                Iterator it;
                DHTUDPPacketData reply = transfer_queue.receive(5000L);
                if (reply != null) {
                    if (transfer_size == -1) {
                        transfer_size = reply.getTotalLength();
                        listener.reportSize(transfer_size);
                    }
                    it = packets.iterator();
                    boolean duplicate = false;
                    while (it.hasNext()) {
                        DHTUDPPacketData p = (DHTUDPPacketData)it.next();
                        if (p.getStartPosition() >= reply.getStartPosition() + reply.getLength() || p.getStartPosition() + p.getLength() <= reply.getStartPosition()) continue;
                        duplicate = true;
                        break;
                    }
                    if (duplicate) continue;
                    listener.reportActivity(this.getMessageText("received_bit", new String[]{String.valueOf(reply.getStartPosition()), String.valueOf(reply.getStartPosition() + reply.getLength()), target_name}));
                    listener.reportCompleteness(transfer_size == 0 ? 100 : 100 * (transferred += reply.getLength()) / transfer_size);
                    packets.add(reply);
                    it = packets.iterator();
                    int pos = 0;
                    int actual_end = -1;
                    while (it.hasNext()) {
                        DHTUDPPacketData p = (DHTUDPPacketData)it.next();
                        if (actual_end == -1) {
                            actual_end = p.getTotalLength();
                        }
                        if (p.getStartPosition() != pos) continue block5;
                        if ((pos += p.getLength()) != actual_end) continue;
                        listener.reportActivity(this.getMessageText("complete"));
                        byte[] result = new byte[actual_end];
                        it = packets.iterator();
                        pos = 0;
                        while (it.hasNext()) {
                            p = (DHTUDPPacketData)it.next();
                            System.arraycopy(p.getData(), 0, result, pos, p.getLength());
                            pos += p.getLength();
                        }
                        byte[] byArray = result;
                        return byArray;
                    }
                    continue;
                }
                if (packets.size() == 0) {
                    if (entire_request_count == 2) {
                        listener.reportActivity(this.getMessageText("timeout", target_name));
                        it = null;
                        return it;
                    }
                    ++entire_request_count;
                    listener.reportActivity(this.getMessageText("rerequest_all", target_name));
                    this.sendReadRequest(transfer_queue.getID(), (DHTTransportUDPContactImpl)target, handler_key, key);
                    continue;
                }
                it = packets.iterator();
                int pos = 0;
                int actual_end = -1;
                while (it.hasNext()) {
                    DHTUDPPacketData p = (DHTUDPPacketData)it.next();
                    if (actual_end == -1) {
                        actual_end = p.getTotalLength();
                    }
                    if (p.getStartPosition() != pos) {
                        listener.reportActivity(this.getMessageText("rerequest_bit", new String[]{String.valueOf(pos), String.valueOf(p.getStartPosition()), target_name}));
                        this.sendReadRequest(transfer_queue.getID(), (DHTTransportUDPContactImpl)target, handler_key, key, pos, p.getStartPosition() - pos);
                    }
                    pos = p.getStartPosition() + p.getLength();
                }
                if (pos == actual_end) continue;
                listener.reportActivity(this.getMessageText("rerequest_bit", new String[]{String.valueOf(pos), String.valueOf(actual_end), target_name}));
                this.sendReadRequest(transfer_queue.getID(), (DHTTransportUDPContactImpl)target, handler_key, key, pos, actual_end - pos);
            }
            if (packets.size() == 0) {
                listener.reportActivity(this.getMessageText("timeout", target_name));
            } else {
                listener.reportActivity(this.getMessageText("timeout_some", new String[]{String.valueOf(packets.size()), target_name}));
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            transfer_queue.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTransfer(DHTTransportProgressListener listener, DHTTransportContact target, byte[] handler_key, byte[] key, byte[] data, long timeout) throws DHTTransportException {
        block10: {
            transferQueue transfer_queue = null;
            try {
                boolean ok;
                block9: {
                    long connection_id = this.getConnectionID();
                    transfer_queue = new transferQueue(this.write_transfers, connection_id);
                    ok = false;
                    boolean reply_received = false;
                    int loop = 0;
                    int total_length = data.length;
                    long start = SystemTime.getCurrentTime();
                    long last_packet_time = 0L;
                    while (true) {
                        DHTUDPPacketData packet;
                        long now;
                        if ((now = SystemTime.getCurrentTime()) < start) {
                            start = now;
                            last_packet_time = 0L;
                        } else if (now - start > timeout) break block9;
                        long time_since_last_packet = now - last_packet_time;
                        if (time_since_last_packet >= 12500L) {
                            listener.reportActivity(this.getMessageText(loop == 0 ? "sending" : "resending"));
                            ++loop;
                            total_length = this.handleTransferRequest((DHTTransportUDPContactImpl)target, connection_id, handler_key, key, data, -1, -1, true, reply_received);
                            last_packet_time = now;
                            time_since_last_packet = 0L;
                        }
                        if ((packet = transfer_queue.receive(12500L - time_since_last_packet)) == null) continue;
                        last_packet_time = now;
                        reply_received = true;
                        if (packet.getStartPosition() == 0 && packet.getLength() == total_length) break;
                    }
                    ok = true;
                }
                if (ok) {
                    listener.reportCompleteness(100);
                    listener.reportActivity(this.getMessageText("send_complete"));
                    break block10;
                }
                listener.reportActivity(this.getMessageText("send_timeout"));
                throw new DHTTransportException("Timeout");
            }
            finally {
                if (transfer_queue != null) {
                    transfer_queue.destroy();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] writeReadTransfer(DHTTransportProgressListener listener, DHTTransportContact target, byte[] handler_key, byte[] data, long timeout) throws DHTTransportException {
        byte[] call_key = new byte[20];
        this.random.nextBytes(call_key);
        AESemaphore call_sem = new AESemaphore("DHTTransportUDP:calSem");
        HashWrapper wrapped_key = new HashWrapper(call_key);
        try {
            this.this_mon.enter();
            this.call_transfers.put(wrapped_key, call_sem);
        }
        finally {
            this.this_mon.exit();
        }
        this.writeTransfer(listener, target, handler_key, call_key, data, timeout);
        if (call_sem.reserve(timeout)) {
            try {
                this.this_mon.enter();
                Object res = this.call_transfers.remove(wrapped_key);
                if (res instanceof byte[]) {
                    byte[] byArray = (byte[])res;
                    return byArray;
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
        throw new DHTTransportException("timeout");
    }

    public void process(DHTUDPPacketRequest request2, boolean alien) {
        if (this.request_handler == null) {
            this.logger.log("Ignoring packet as not yet ready to process");
            return;
        }
        try {
            boolean bad_originator;
            this.stats.incomingRequestReceived(request2, alien);
            InetSocketAddress transport_address = request2.getAddress();
            DHTTransportUDPContactImpl originating_contact = new DHTTransportUDPContactImpl(false, this, transport_address, request2.getOriginatorAddress(), request2.getOriginatorVersion(), request2.getOriginatorInstanceID(), request2.getClockSkew());
            try {
                this.checkAddress(originating_contact);
            }
            catch (DHTUDPPacketHandlerException e) {
                return;
            }
            this.requestReceiveRequestProcessor(originating_contact, request2);
            boolean bl = bad_originator = !originating_contact.addressMatchesID();
            if (bad_originator && !this.bootstrap_node) {
                String contact_string = originating_contact.getString();
                if (this.recent_reports.get(contact_string) == null) {
                    this.recent_reports.put(contact_string, "");
                    this.logger.log("Node " + contact_string + " has incorrect ID, reporting it to them");
                }
                DHTUDPPacketReplyError reply = new DHTUDPPacketReplyError(this, request2.getTransactionId(), request2.getConnectionId(), this.local_contact, originating_contact);
                reply.setErrorType(1);
                reply.setOriginatingAddress(originating_contact.getTransportAddress());
                this.requestReceiveReplyProcessor(originating_contact, reply);
                this.packet_handler.send(reply, request2.getAddress());
            } else {
                if (bad_originator) {
                    originating_contact = new DHTTransportUDPContactImpl(false, this, transport_address, transport_address, request2.getOriginatorVersion(), request2.getOriginatorInstanceID(), request2.getClockSkew());
                } else {
                    this.contactAlive(originating_contact);
                }
                if (request2 instanceof DHTUDPPacketRequestPing) {
                    if (!this.bootstrap_node) {
                        this.request_handler.pingRequest(originating_contact);
                        DHTUDPPacketReplyPing reply = new DHTUDPPacketReplyPing(this, request2.getTransactionId(), request2.getConnectionId(), this.local_contact, originating_contact);
                        this.requestReceiveReplyProcessor(originating_contact, reply);
                        this.packet_handler.send(reply, request2.getAddress());
                    }
                } else if (request2 instanceof DHTUDPPacketRequestKeyBlock) {
                    if (!this.bootstrap_node) {
                        DHTUDPPacketRequestKeyBlock kb_request = (DHTUDPPacketRequestKeyBlock)request2;
                        originating_contact.setRandomID(kb_request.getRandomID());
                        this.request_handler.keyBlockRequest(originating_contact, kb_request.getKeyBlockRequest(), kb_request.getKeyBlockSignature());
                        DHTUDPPacketReplyKeyBlock reply = new DHTUDPPacketReplyKeyBlock(this, request2.getTransactionId(), request2.getConnectionId(), this.local_contact, originating_contact);
                        this.requestReceiveReplyProcessor(originating_contact, reply);
                        this.packet_handler.send(reply, request2.getAddress());
                    }
                } else if (request2 instanceof DHTUDPPacketRequestStats) {
                    DHTUDPPacketRequestStats stats_request = (DHTUDPPacketRequestStats)request2;
                    DHTUDPPacketReplyStats reply = new DHTUDPPacketReplyStats(this, request2.getTransactionId(), request2.getConnectionId(), this.local_contact, originating_contact);
                    int type = stats_request.getStatsType();
                    if (type == 1) {
                        DHTTransportFullStats full_stats = this.request_handler.statsRequest(originating_contact);
                        reply.setOriginalStats(full_stats);
                    } else if (type == 2) {
                        DHTNetworkPositionProvider prov = DHTNetworkPositionManager.getProvider((byte)5);
                        byte[] data = new byte[]{};
                        if (prov != null) {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            DataOutputStream dos = new DataOutputStream(baos);
                            prov.serialiseStats(dos);
                            dos.flush();
                            data = baos.toByteArray();
                        }
                        reply.setNewStats(data, 5);
                    } else {
                        throw new IOException("Uknown stats type '" + type + "'");
                    }
                    this.requestReceiveReplyProcessor(originating_contact, reply);
                    this.packet_handler.send(reply, request2.getAddress());
                } else if (request2 instanceof DHTUDPPacketRequestStore) {
                    if (!this.bootstrap_node) {
                        DHTUDPPacketRequestStore store_request = (DHTUDPPacketRequestStore)request2;
                        originating_contact.setRandomID(store_request.getRandomID());
                        DHTTransportStoreReply res = this.request_handler.storeRequest(originating_contact, store_request.getKeys(), store_request.getValueSets());
                        if (res.blocked()) {
                            if (originating_contact.getProtocolVersion() >= 14) {
                                DHTUDPPacketReplyError reply = new DHTUDPPacketReplyError(this, request2.getTransactionId(), request2.getConnectionId(), this.local_contact, originating_contact);
                                reply.setErrorType(2);
                                reply.setKeyBlockDetails(res.getBlockRequest(), res.getBlockSignature());
                                this.requestReceiveReplyProcessor(originating_contact, reply);
                                this.packet_handler.send(reply, request2.getAddress());
                            } else {
                                DHTUDPPacketReplyStore reply = new DHTUDPPacketReplyStore(this, request2.getTransactionId(), request2.getConnectionId(), this.local_contact, originating_contact);
                                reply.setDiversificationTypes(new byte[store_request.getKeys().length]);
                                this.requestReceiveReplyProcessor(originating_contact, reply);
                                this.packet_handler.send(reply, request2.getAddress());
                            }
                        } else {
                            DHTUDPPacketReplyStore reply = new DHTUDPPacketReplyStore(this, request2.getTransactionId(), request2.getConnectionId(), this.local_contact, originating_contact);
                            reply.setDiversificationTypes(res.getDiversificationTypes());
                            this.requestReceiveReplyProcessor(originating_contact, reply);
                            this.packet_handler.send(reply, request2.getAddress());
                        }
                    }
                } else if (request2 instanceof DHTUDPPacketRequestFindNode) {
                    DHTUDPPacketRequestFindNode find_request = (DHTUDPPacketRequestFindNode)request2;
                    boolean acceptable = this.bootstrap_node ? bad_originator || Arrays.equals(find_request.getID(), originating_contact.getID()) : true;
                    if (acceptable) {
                        if (find_request.getProtocolVersion() >= 22) {
                            this.updateContactStatus(originating_contact, find_request.getNodeStatus(), true);
                            this.request_handler.setTransportEstimatedDHTSize(find_request.getEstimatedDHTSize());
                        }
                        DHTTransportContact[] res = this.request_handler.findNodeRequest(originating_contact, find_request.getID());
                        DHTUDPPacketReplyFindNode reply = new DHTUDPPacketReplyFindNode(this, request2.getTransactionId(), request2.getConnectionId(), this.local_contact, originating_contact);
                        reply.setRandomID(originating_contact.getRandomID());
                        reply.setNodeStatus(this.getNodeStatus());
                        reply.setEstimatedDHTSize(this.request_handler.getTransportEstimatedDHTSize());
                        reply.setContacts(res);
                        this.requestReceiveReplyProcessor(originating_contact, reply);
                        this.packet_handler.send(reply, request2.getAddress());
                    }
                } else if (request2 instanceof DHTUDPPacketRequestFindValue) {
                    if (!this.bootstrap_node) {
                        DHTUDPPacketRequestFindValue find_request = (DHTUDPPacketRequestFindValue)request2;
                        DHTTransportFindValueReply res = this.request_handler.findValueRequest(originating_contact, find_request.getID(), find_request.getMaximumValues(), find_request.getFlags());
                        if (res.blocked()) {
                            if (originating_contact.getProtocolVersion() >= 14) {
                                DHTUDPPacketReplyError reply = new DHTUDPPacketReplyError(this, request2.getTransactionId(), request2.getConnectionId(), this.local_contact, originating_contact);
                                reply.setErrorType(2);
                                reply.setKeyBlockDetails(res.getBlockedKey(), res.getBlockedSignature());
                                this.requestReceiveReplyProcessor(originating_contact, reply);
                                this.packet_handler.send(reply, request2.getAddress());
                            } else {
                                DHTUDPPacketReplyFindValue reply = new DHTUDPPacketReplyFindValue(this, request2.getTransactionId(), request2.getConnectionId(), this.local_contact, originating_contact);
                                reply.setValues(new DHTTransportValue[0], (byte)1, false);
                                this.requestReceiveReplyProcessor(originating_contact, reply);
                                this.packet_handler.send(reply, request2.getAddress());
                            }
                        } else {
                            DHTUDPPacketReplyFindValue reply = new DHTUDPPacketReplyFindValue(this, request2.getTransactionId(), request2.getConnectionId(), this.local_contact, originating_contact);
                            if (res.hit()) {
                                DHTTransportValue[] res_values = res.getValues();
                                int max_size = 1374;
                                ArrayList<DHTTransportValue> values = new ArrayList<DHTTransportValue>();
                                int values_size = 0;
                                int pos = 0;
                                while (pos < res_values.length) {
                                    DHTTransportValue v = res_values[pos];
                                    int v_len = v.getValue().length + 24;
                                    if (values_size > 0 && values_size + v_len > max_size) {
                                        DHTTransportValue[] x = new DHTTransportValue[values.size()];
                                        values.toArray(x);
                                        reply.setValues(x, res.getDiversificationType(), true);
                                        this.packet_handler.send(reply, request2.getAddress());
                                        values_size = 0;
                                        values = new ArrayList();
                                        continue;
                                    }
                                    values.add(v);
                                    values_size += v_len;
                                    ++pos;
                                }
                                DHTTransportValue[] x = new DHTTransportValue[values.size()];
                                values.toArray(x);
                                reply.setValues(x, res.getDiversificationType(), false);
                                this.requestReceiveReplyProcessor(originating_contact, reply);
                                this.packet_handler.send(reply, request2.getAddress());
                            } else {
                                reply.setContacts(res.getContacts());
                                this.requestReceiveReplyProcessor(originating_contact, reply);
                                this.packet_handler.send(reply, request2.getAddress());
                            }
                        }
                    }
                } else if (request2 instanceof DHTUDPPacketData) {
                    if (!this.bootstrap_node) {
                        this.dataRequest(originating_contact, (DHTUDPPacketData)request2);
                    }
                } else {
                    Debug.out("Unexpected packet:" + request2.toString());
                }
            }
        }
        catch (DHTUDPPacketHandlerException e) {
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected void requestReceiveRequestProcessor(DHTTransportUDPContactImpl contact, DHTUDPPacketRequest request2) {
    }

    protected void requestReceiveReplyProcessor(DHTTransportUDPContactImpl contact, DHTUDPPacketReply reply) {
        int action = reply.getAction();
        if (action == 1025 || action == 1029 || action == 1031) {
            reply.setNetworkPositions(this.local_contact.getNetworkPositions());
        }
    }

    protected void requestSendRequestProcessor(DHTTransportUDPContactImpl contact, DHTUDPPacketRequest request2) {
    }

    protected void requestSendReplyProcessor(DHTTransportUDPContactImpl remote_contact, DHTTransportReplyHandler handler, DHTUDPPacketReply reply, long elapsed_time) throws DHTUDPPacketHandlerException {
        DHTNetworkPosition[] remote_nps = reply.getNetworkPositions();
        if (remote_nps != null) {
            remote_contact.setNetworkPositions(remote_nps);
            DHTNetworkPositionManager.update(this.local_contact.getNetworkPositions(), remote_contact.getID(), remote_nps, elapsed_time);
        }
        if (reply.getAction() == 1032) {
            DHTUDPPacketReplyError error = (DHTUDPPacketReplyError)reply;
            switch (error.getErrorType()) {
                case 1: {
                    try {
                        this.externalAddressChange(remote_contact, error.getOriginatingAddress(), false);
                    }
                    catch (DHTTransportException e) {
                        Debug.printStackTrace(e);
                    }
                    throw new DHTUDPPacketHandlerException("address changed notification");
                }
                case 2: {
                    handler.keyBlockRequest(remote_contact, error.getKeyBlockRequest(), error.getKeyBlockSignature());
                    this.contactAlive(remote_contact);
                    throw new DHTUDPPacketHandlerException("key blocked");
                }
            }
            throw new DHTUDPPacketHandlerException("unknown error type " + error.getErrorType());
        }
        this.contactAlive(remote_contact);
    }

    protected long getConnectionID() {
        return Long.MIN_VALUE | this.random.nextLong();
    }

    public boolean supportsStorage() {
        return !this.bootstrap_node;
    }

    public void addListener(DHTTransportListener l) {
        this.listeners.add(l);
        if (this.external_address != null) {
            l.currentAddress(this.external_address);
        }
    }

    public void removeListener(DHTTransportListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected transferQueue lookupTransferQueue(Map transfers, long id) {
        try {
            this.this_mon.enter();
            transferQueue transferQueue2 = (transferQueue)transfers.get(new Long(id));
            return transferQueue2;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected String getMessageText(String resource) {
        return MessageText.getString("DHTTransport.report." + resource);
    }

    protected String getMessageText(String resource, String param) {
        return MessageText.getString("DHTTransport.report." + resource, new String[]{param});
    }

    protected String getMessageText(String resource, String[] params) {
        return MessageText.getString("DHTTransport.report." + resource, params);
    }

    static {
        if (XFER_TRACE) {
            System.out.println("**** DHTTransportUDPImpl xfer trace on ****");
        }
        class_mon = new AEMonitor("DHTTransportUDP:class");
    }

    protected class transferHandlerInterceptor
    implements DHTTransportTransferHandler {
        private DHTTransportTransferHandler handler;

        protected transferHandlerInterceptor(DHTTransportTransferHandler _handler) {
            this.handler = _handler;
        }

        public String getName() {
            return this.handler.getName();
        }

        public byte[] handleRead(DHTTransportContact originator, byte[] key) {
            return this.handler.handleRead(originator, key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] handleWrite(DHTTransportContact originator, byte[] key, byte[] value) {
            HashWrapper key_wrapper = new HashWrapper(key);
            try {
                DHTTransportUDPImpl.this.this_mon.enter();
                Object obj = DHTTransportUDPImpl.this.call_transfers.get(key_wrapper);
                if (obj instanceof AESemaphore) {
                    AESemaphore sem = (AESemaphore)obj;
                    DHTTransportUDPImpl.this.call_transfers.put(key_wrapper, value);
                    sem.release();
                    byte[] byArray = null;
                    return byArray;
                }
            }
            finally {
                DHTTransportUDPImpl.this.this_mon.exit();
            }
            return this.handler.handleWrite(originator, key, value);
        }
    }

    protected class transferQueue {
        private Map transfers;
        private long id;
        private boolean destroyed;
        private List packets = new ArrayList();
        private AESemaphore packets_sem = new AESemaphore("DHTUDPTransport:transferQueue");

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected transferQueue(Map _transfers, long _id) throws DHTTransportException {
            this.transfers = _transfers;
            this.id = _id;
            try {
                DHTTransportUDPImpl.this.this_mon.enter();
                if (this.transfers.size() > 64) {
                    Debug.out("Transfer queue count limit exceeded");
                    throw new DHTTransportException("Transfer queue limit exceeded");
                }
                Long l_id = new Long(this.id);
                transferQueue existing = (transferQueue)this.transfers.get(l_id);
                if (existing != null) {
                    existing.destroy();
                }
                this.transfers.put(l_id, this);
            }
            finally {
                DHTTransportUDPImpl.this.this_mon.exit();
            }
        }

        protected long getID() {
            return this.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void add(DHTUDPPacketData packet) {
            try {
                DHTTransportUDPImpl.this.this_mon.enter();
                if (this.destroyed) {
                    return;
                }
                if (DHTTransportUDPImpl.this.total_bytes_on_transfer_queues > 0x800000L) {
                    Debug.out("Transfer queue byte limit exceeded");
                    return;
                }
                int length = packet.getLength();
                DHTTransportUDPImpl.this.total_bytes_on_transfer_queues += length;
                if (XFER_TRACE) {
                    System.out.println("total_bytes_on_transfer_queues=" + DHTTransportUDPImpl.this.total_bytes_on_transfer_queues);
                }
                this.packets.add(packet);
            }
            finally {
                DHTTransportUDPImpl.this.this_mon.exit();
            }
            this.packets_sem.release();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DHTUDPPacketData receive(long timeout) {
            if (this.packets_sem.reserve(timeout)) {
                try {
                    DHTTransportUDPImpl.this.this_mon.enter();
                    if (this.destroyed) {
                        DHTUDPPacketData dHTUDPPacketData = null;
                        return dHTUDPPacketData;
                    }
                    DHTUDPPacketData packet = (DHTUDPPacketData)this.packets.remove(0);
                    int length = packet.getLength();
                    DHTTransportUDPImpl.this.total_bytes_on_transfer_queues -= length;
                    if (XFER_TRACE) {
                        System.out.println("total_bytes_on_transfer_queues=" + DHTTransportUDPImpl.this.total_bytes_on_transfer_queues);
                    }
                    DHTUDPPacketData dHTUDPPacketData = packet;
                    return dHTUDPPacketData;
                }
                finally {
                    DHTTransportUDPImpl.this.this_mon.exit();
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroy() {
            try {
                DHTTransportUDPImpl.this.this_mon.enter();
                this.destroyed = true;
                this.transfers.remove(new Long(this.id));
                for (int i = 0; i < this.packets.size(); ++i) {
                    DHTUDPPacketData packet = (DHTUDPPacketData)this.packets.get(i);
                    int length = packet.getLength();
                    DHTTransportUDPImpl.this.total_bytes_on_transfer_queues -= length;
                    if (!XFER_TRACE) continue;
                    System.out.println("total_bytes_on_transfer_queues=" + DHTTransportUDPImpl.this.total_bytes_on_transfer_queues);
                }
                this.packets.clear();
                this.packets_sem.releaseForever();
            }
            finally {
                DHTTransportUDPImpl.this.this_mon.exit();
            }
        }
    }
}

