/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.download;

import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManagerFile;
import com.aelitis.azureus.core.peer.cache.CacheDiscovery;
import com.aelitis.azureus.core.peer.cache.CachePeer;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.PieceRTAProvider;
import com.aelitis.azureus.core.peermanager.utils.PeerClassifier;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.average.Average;
import com.aelitis.azureus.core.util.average.AverageFactory;
import com.aelitis.azureus.plugins.extseed.ExternalSeedManualPeer;
import com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin;
import com.aelitis.azureus.util.ConstantsV3;
import com.aelitis.azureus.util.DownloadUtils;
import com.aelitis.azureus.util.PublishUtils;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.RealTimeInfo;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class EnhancedDownloadManager {
    public static int DEFAULT_MINIMUM_INITIAL_BUFFER_SECS_FOR_ETA = 30;
    public static int WMP_MINIMUM_INITIAL_BUFFER_SECS_FOR_ETA = 60;
    public static int MINIMUM_INITIAL_BUFFER_SECS;
    public static final int SPEED_CONTROL_INITIAL_DELAY = 10000;
    public static final int SPEED_INCREASE_GRACE_PERIOD = 3000;
    public static final int PEER_INJECT_GRACE_PERIOD = 3000;
    public static final int IDLE_PEER_DISCONNECT_PERIOD = 60000;
    public static final int IDLE_SEED_DISCONNECT_PERIOD = 60000;
    public static final int MIN_SEED_CONNECTION_TIME = 60000;
    public static final int IDLE_SEED_DISCONNECT_SECS = 60;
    public static final int CACHE_RECONNECT_MIN_PERIOD = 900000;
    public static final int CACHE_REQUERY_MIN_PERIOD = 3600000;
    public static final int TARGET_SPEED_EXCESS_MARGIN = 2048;
    public static final int DISCONNECT_CHECK_PERIOD = 10000;
    public static final int DISCONNECT_CHECK_TICKS = 10;
    public static final int REACTIVATE_PROVIDER_PERIOD = 5000;
    public static final int REACTIVATE_PROVIDER_PERIOD_TICKS = 5;
    public static final int LOG_PROG_STATS_PERIOD = 10000;
    public static final int LOG_PROG_STATS_TICKS = 10;
    private static final String TRACKER_PROG_PREFIX = "azprog";
    private static final String PM_SEED_TIME_KEY = "EnhancedDownloadManager:seedtime";
    private static final String PEER_CACHE_KEY = "EnhancedDownloadManager:cachepeer";
    private static int internal_content_stream_bps_increase_ratio;
    private static int internal_content_stream_bps_increase_absolute;
    private DownloadManagerEnhancer enhancer;
    private DownloadManager download_manager;
    private boolean platform_content;
    private transient PiecePicker current_piece_pickler;
    private boolean progressive_active = false;
    private long content_min_delivery_bps;
    private int minimum_initial_buffer_secs_for_eta;
    private int explicit_minimum_buffer_bytes;
    private bufferETAProvider buffer_provider = new bufferETAProvider();
    private boostETAProvider boost_provider = new boostETAProvider();
    private progressiveStats progressive_stats;
    private boolean progressive_informed = false;
    private long time_download_started;
    private Average download_speed_average = AverageFactory.MovingImmediateAverage(5);
    private boolean marked_active;
    private boolean destroyed;
    private DownloadManagerListener dmListener;
    private static final int STALLED_TIMEOUT = 120000;
    private boolean publish_handling_complete;
    private long publish_sent = -1L;
    private long publish_sent_time;
    private EnhancedDownloadManagerFile[] enhanced_files;
    private EnhancedDownloadManagerFile primary_file;
    private long last_speed_increase;
    private long last_peer_inject;
    private long last_lookup_time;
    private LinkedList new_peers;
    private List cache_peers;
    private List disconnected_cache_peers;
    private CachePeer[] lookup_peers;

    public static void setInternalContentStreamBPSIncreaseRatio(String caller_id, int ratio) {
        internal_content_stream_bps_increase_ratio = ratio;
    }

    public static void setInternalContentStreamBPSIncreaseAbsolute(String caller_id, int abs) {
        internal_content_stream_bps_increase_absolute = abs;
    }

    private void resetVars() {
        this.last_speed_increase = 0L;
        this.last_peer_inject = 0L;
        this.last_lookup_time = 0L;
        this.new_peers = null;
        this.cache_peers = null;
        this.disconnected_cache_peers = null;
        this.lookup_peers = null;
    }

    protected EnhancedDownloadManager(DownloadManagerEnhancer _enhancer, DownloadManager _download_manager) {
        this.enhancer = _enhancer;
        this.download_manager = _download_manager;
        DiskManagerFileInfo[] files = this.download_manager.getDiskManagerFileInfo();
        boolean found_wmv = false;
        for (int i = 0; i < files.length; ++i) {
            String file_name = files[i].getFile(true).getName().toLowerCase();
            if (!file_name.endsWith(".wmv")) continue;
            found_wmv = true;
            break;
        }
        this.minimum_initial_buffer_secs_for_eta = found_wmv ? WMP_MINIMUM_INITIAL_BUFFER_SECS_FOR_ETA : DEFAULT_MINIMUM_INITIAL_BUFFER_SECS_FOR_ETA;
        TOTorrent torrent = this.download_manager.getTorrent();
        if (torrent != null) {
            this.content_min_delivery_bps = PlatformTorrentUtils.getContentMinimumSpeedBps(torrent);
            this.platform_content = PlatformTorrentUtils.isContent(torrent, true);
            this.enhanced_files = new EnhancedDownloadManagerFile[files.length];
            Map meta_data = PlatformTorrentUtils.getFileMetaData(torrent);
            Map files_info = meta_data == null ? null : (Map)meta_data.get("files");
            long offset = 0L;
            for (int i = 0; i < files.length; ++i) {
                DiskManagerFileInfo f = files[i];
                Map file_info = files_info == null ? null : (Map)files_info.get("" + i);
                this.enhanced_files[i] = new EnhancedDownloadManagerFile(f, offset, file_info);
                offset += f.getLength();
            }
            int primary_index = PlatformTorrentUtils.getContentPrimaryFileIndex(this.download_manager.getTorrent());
            this.primary_file = primary_index >= 0 && primary_index < files.length ? this.enhanced_files[primary_index] : this.enhanced_files[0];
        } else {
            this.enhanced_files = new EnhancedDownloadManagerFile[0];
        }
        this.progressive_stats = this.createProgressiveStats(this.download_manager, this.primary_file);
        this.download_manager.addPeerListener(new DownloadManagerPeerListener(){

            public void peerManagerWillBeAdded(PEPeerManager peer_manager) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void peerManagerAdded(PEPeerManager manager) {
                EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
                synchronized (enhancedDownloadManager) {
                    EnhancedDownloadManager.this.time_download_started = SystemTime.getCurrentTime();
                    EnhancedDownloadManager.this.current_piece_pickler = manager.getPiecePicker();
                    if (EnhancedDownloadManager.this.progressive_active && EnhancedDownloadManager.this.current_piece_pickler != null) {
                        EnhancedDownloadManager.this.buffer_provider.activate(EnhancedDownloadManager.this.current_piece_pickler);
                        EnhancedDownloadManager.this.boost_provider.activate(EnhancedDownloadManager.this.current_piece_pickler);
                    }
                    EnhancedDownloadManager.this.resetVars();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void peerManagerRemoved(PEPeerManager manager) {
                EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
                synchronized (enhancedDownloadManager) {
                    EnhancedDownloadManager.this.time_download_started = 0L;
                    EnhancedDownloadManager.this.progressive_active = false;
                    if (EnhancedDownloadManager.this.current_piece_pickler != null) {
                        EnhancedDownloadManager.this.buffer_provider.deactivate(EnhancedDownloadManager.this.current_piece_pickler);
                        EnhancedDownloadManager.this.boost_provider.deactivate(EnhancedDownloadManager.this.current_piece_pickler);
                        EnhancedDownloadManager.this.current_piece_pickler = null;
                    }
                    EnhancedDownloadManager.this.resetVars();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void peerAdded(PEPeer peer) {
                if (EnhancedDownloadManager.this.platform_content) {
                    EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
                    synchronized (enhancedDownloadManager) {
                        if (EnhancedDownloadManager.this.new_peers == null) {
                            EnhancedDownloadManager.this.new_peers = new LinkedList();
                        }
                        EnhancedDownloadManager.this.new_peers.add(peer);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void peerRemoved(PEPeer peer) {
                if (EnhancedDownloadManager.this.platform_content) {
                    EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
                    synchronized (enhancedDownloadManager) {
                        CachePeer cache_peer;
                        if (EnhancedDownloadManager.this.new_peers != null) {
                            EnhancedDownloadManager.this.new_peers.remove(peer);
                            if (EnhancedDownloadManager.this.new_peers.size() == 0) {
                                EnhancedDownloadManager.this.new_peers = null;
                            }
                        }
                        if (EnhancedDownloadManager.this.cache_peers != null) {
                            EnhancedDownloadManager.this.cache_peers.remove(peer);
                            if (EnhancedDownloadManager.this.cache_peers.size() == 0) {
                                EnhancedDownloadManager.this.cache_peers = null;
                            }
                        }
                        if ((cache_peer = (CachePeer)peer.getData(EnhancedDownloadManager.PEER_CACHE_KEY)) == null && EnhancedDownloadManager.this.lookup_peers != null) {
                            for (int i = 0; i < EnhancedDownloadManager.this.lookup_peers.length; ++i) {
                                CachePeer cp = EnhancedDownloadManager.this.lookup_peers[i];
                                if (!cp.getAddress().getHostAddress().equals(peer.getIp()) || cp.getPort() != peer.getPort()) continue;
                                cache_peer = cp;
                            }
                        }
                        if (!(cache_peer == null || cache_peer.getType() != 2 || EnhancedDownloadManager.this.disconnected_cache_peers != null && EnhancedDownloadManager.this.disconnected_cache_peers.contains(cache_peer) || peer.hasReceivedBitField())) {
                            cache_peer.setAutoReconnect(false);
                        }
                    }
                }
            }
        });
    }

    public String getName() {
        return this.download_manager.getDisplayName();
    }

    public byte[] getHash() {
        TOTorrent t = this.download_manager.getTorrent();
        if (t == null) {
            return null;
        }
        try {
            return t.getHash();
        }
        catch (Throwable e) {
            return null;
        }
    }

    public boolean isPlatform() {
        TOTorrent torrent = this.download_manager.getTorrent();
        if (torrent != null) {
            return PlatformTorrentUtils.isContent(torrent, true);
        }
        return false;
    }

    public EnhancedDownloadManagerFile[] getFiles() {
        return this.enhanced_files;
    }

    public void setMinimumBufferBytes(int min) {
        this.log("Explicit min buffer set to " + min);
        this.explicit_minimum_buffer_bytes = min;
    }

    protected void refreshMetaData() {
        this.progressive_stats.refreshMetaData();
    }

    protected long getTimeRunning() {
        if (this.time_download_started == 0L) {
            return 0L;
        }
        long now = SystemTime.getCurrentTime();
        if (now < this.time_download_started) {
            this.time_download_started = now;
        }
        return now - this.time_download_started;
    }

    protected long getTargetSpeed() {
        long target_speed;
        long l = target_speed = this.progressive_active ? this.progressive_stats.getStreamBytesPerSecondMax() : this.content_min_delivery_bps;
        if (target_speed < this.content_min_delivery_bps) {
            target_speed = this.content_min_delivery_bps;
        }
        return target_speed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStats(int tick_count) {
        CachePeer cache_peer;
        this.updateProgressiveStats(tick_count);
        if (!this.platform_content) {
            return;
        }
        int state = this.download_manager.getState();
        if (state != 60 && state != 50) {
            return;
        }
        PEPeerManager pm = this.download_manager.getPeerManager();
        if (pm == null) {
            return;
        }
        long now = SystemTime.getCurrentTime();
        long target_speed = this.getTargetSpeed();
        PEPeerManagerStats stats = pm.getStats();
        long download_speed = stats.getDataReceiveRate();
        this.download_speed_average.update(download_speed);
        long time_downloading = this.getTimeRunning();
        int secs_since_last_up = pm.getStats().getTimeSinceLastDataSentInSeconds();
        if (secs_since_last_up == -1) {
            Long seed_time = (Long)pm.getData(PM_SEED_TIME_KEY);
            if (seed_time == null) {
                seed_time = new Long(now);
                pm.setData(PM_SEED_TIME_KEY, seed_time);
            }
            secs_since_last_up = (int)((now - seed_time) / 1000L);
        }
        ArrayList<PEPeer> peers_to_kick = new ArrayList<PEPeer>();
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            if (this.new_peers != null) {
                Iterator it = this.new_peers.iterator();
                while (it.hasNext()) {
                    PEPeer peer = (PEPeer)it.next();
                    cache_peer = (CachePeer)peer.getData(PEER_CACHE_KEY);
                    if (cache_peer == null) {
                        byte[] peer_id = peer.getId();
                        if (peer_id == null) continue;
                        try {
                            cache_peer = CacheDiscovery.categorisePeer(peer_id, InetAddress.getByName(peer.getIp()), peer.getPort());
                            peer.setData(PEER_CACHE_KEY, cache_peer);
                            if (cache_peer.getType() == 2) {
                                if (state == 60) {
                                    if (now - cache_peer.getCreateTime(now) >= 60000L && secs_since_last_up >= 60) {
                                        peers_to_kick.add(peer);
                                        this.addToDisconnectedCachePeers(cache_peer);
                                    } else {
                                        if (this.cache_peers == null) {
                                            this.cache_peers = new LinkedList();
                                        }
                                        this.cache_peers.add(peer);
                                    }
                                } else {
                                    peer.setHaveAggregationEnabled(false);
                                    if (target_speed <= 0L) {
                                        this.setPeerSpeed(peer, -1, now);
                                        peers_to_kick.add(peer);
                                        this.addToDisconnectedCachePeers(cache_peer);
                                    } else {
                                        long current_speed = (long)this.download_speed_average.getAverage();
                                        if (current_speed + 2048L > target_speed) {
                                            this.setPeerSpeed(peer, -1, now);
                                        }
                                        if (this.cache_peers == null) {
                                            this.cache_peers = new LinkedList();
                                        }
                                        this.cache_peers.add(peer);
                                    }
                                }
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                        it.remove();
                        continue;
                    }
                    it.remove();
                }
                if (this.new_peers.size() == 0) {
                    this.new_peers = null;
                }
            }
        }
        for (int i = 0; i < peers_to_kick.size(); ++i) {
            pm.removePeer((PEPeer)peers_to_kick.get(i), "Cache peer not required");
        }
        if (state == 50 && time_downloading > 10000L) {
            Iterator it;
            EnhancedDownloadManager enhancedDownloadManager2;
            long current_average = (long)this.download_speed_average.getAverage();
            if (current_average < target_speed) {
                long current_speed = this.getCurrentSpeed();
                long difference = target_speed - current_speed;
                if (this.last_speed_increase > now || now - this.last_speed_increase > 3000L) {
                    enhancedDownloadManager2 = this;
                    synchronized (enhancedDownloadManager2) {
                        if (this.cache_peers != null) {
                            it = this.cache_peers.iterator();
                            while (it.hasNext() && difference > 0L) {
                                PEPeer peer = (PEPeer)it.next();
                                PEPeerStats peer_stats = peer.getStats();
                                long peer_limit = peer_stats.getDownloadRateLimitBytesPerSecond();
                                if (peer_limit == 0L || peer_limit >= target_speed) continue;
                                this.setPeerSpeed(peer, (int)target_speed, now);
                                this.last_speed_increase = now;
                                difference = 0L;
                            }
                        }
                    }
                    if (difference > 0L && this.last_peer_inject > now || now - this.last_peer_inject > 3000L) {
                        HashSet<String> connected_peers = new HashSet<String>();
                        ArrayList<CachePeer> peers_to_try = new ArrayList<CachePeer>();
                        if (this.cache_peers != null) {
                            Iterator it2 = this.cache_peers.iterator();
                            while (it2.hasNext() && difference > 0L) {
                                PEPeer peer = (PEPeer)it2.next();
                                connected_peers.add(peer.getIp() + ":" + peer.getPort());
                            }
                        }
                        if (this.disconnected_cache_peers != null) {
                            while (this.disconnected_cache_peers.size() > 0) {
                                CachePeer cp = (CachePeer)this.disconnected_cache_peers.remove(0);
                                if (connected_peers.contains(cp.getAddress().getHostAddress() + ":" + cp.getPort())) continue;
                                if (this.lookup_peers != null) {
                                    for (int i = 0; i < this.lookup_peers.length; ++i) {
                                        CachePeer l_cp = this.lookup_peers[i];
                                        if (!l_cp.sameAs(cp)) continue;
                                        cp = null;
                                        break;
                                    }
                                }
                                if (cp == null) continue;
                                peers_to_try.add(cp);
                                break;
                            }
                            if (this.disconnected_cache_peers.size() == 0) {
                                this.disconnected_cache_peers = null;
                            }
                        }
                        if (peers_to_try.size() == 0) {
                            if (this.lookup_peers == null || now < this.last_lookup_time || now - this.last_lookup_time > 3600000L) {
                                this.last_lookup_time = now;
                                this.lookup_peers = CacheDiscovery.lookup(this.download_manager.getTorrent());
                            }
                            for (int i = 0; i < this.lookup_peers.length; ++i) {
                                CachePeer cp = this.lookup_peers[i];
                                if (!cp.getAutoReconnect() || now - cp.getInjectTime(now) <= 900000L || connected_peers.contains(cp.getAddress().getHostAddress() + ":" + cp.getPort())) continue;
                                peers_to_try.add(cp);
                            }
                        }
                        if (peers_to_try.size() > 0) {
                            CachePeer peer = (CachePeer)peers_to_try.get((int)(Math.random() * (double)peers_to_try.size()));
                            peer.setInjectTime(now);
                            pm.addPeer(peer.getAddress().getHostAddress(), peer.getPort(), 0, false, null);
                            this.last_peer_inject = now;
                        }
                    }
                }
            } else if (current_average > target_speed + 2048L) {
                long current_speed = this.getCurrentSpeed();
                long difference = current_speed - (target_speed + 2048L);
                enhancedDownloadManager2 = this;
                synchronized (enhancedDownloadManager2) {
                    if (this.cache_peers != null) {
                        it = this.cache_peers.iterator();
                        while (it.hasNext() && difference > 0L) {
                            PEPeer peer = (PEPeer)it.next();
                            PEPeerStats peer_stats = peer.getStats();
                            long peer_rate = peer_stats.getDataReceiveRate();
                            long peer_limit = peer_stats.getDownloadRateLimitBytesPerSecond();
                            if (peer_limit == -1L) {
                                difference -= peer_rate;
                                continue;
                            }
                            if (peer_limit != 0L && peer_rate > peer_limit) {
                                difference -= peer_rate - peer_limit;
                                continue;
                            }
                            if (peer_rate > difference) {
                                this.setPeerSpeed(peer, (int)(peer_rate - difference), now);
                                difference = 0L;
                                continue;
                            }
                            this.setPeerSpeed(peer, -1, now);
                            difference -= peer_rate;
                        }
                    }
                }
            }
        }
        if (tick_count % 10 == 0) {
            peers_to_kick.clear();
            EnhancedDownloadManager current_average = this;
            synchronized (current_average) {
                if (this.cache_peers != null) {
                    for (PEPeer peer : this.cache_peers) {
                        long time;
                        cache_peer = (CachePeer)peer.getData(PEER_CACHE_KEY);
                        if (state == 60) {
                            if (now - cache_peer.getCreateTime(now) < 60000L || secs_since_last_up < 60) continue;
                            peers_to_kick.add(peer);
                            this.addToDisconnectedCachePeers(cache_peer);
                            continue;
                        }
                        PEPeerStats peer_stats = peer.getStats();
                        if (peer_stats.getDownloadRateLimitBytesPerSecond() != -1 || now - (time = cache_peer.getSpeedChangeTime(now)) <= 60000L) continue;
                        peers_to_kick.add(peer);
                        this.addToDisconnectedCachePeers(cache_peer);
                    }
                }
            }
            for (int i = 0; i < peers_to_kick.size(); ++i) {
                pm.removePeer((PEPeer)peers_to_kick.get(i), "Cache peer disconnect-on-idle");
            }
        }
    }

    protected void addToDisconnectedCachePeers(CachePeer cache_peer) {
        if (this.disconnected_cache_peers == null) {
            this.disconnected_cache_peers = new ArrayList();
        }
        for (int i = 0; i < this.disconnected_cache_peers.size(); ++i) {
            CachePeer p = (CachePeer)this.disconnected_cache_peers.get(i);
            if (!p.sameAs(cache_peer)) continue;
            return;
        }
        this.disconnected_cache_peers.add(cache_peer);
    }

    protected void setPeerSpeed(PEPeer peer, int speed, long time) {
        CachePeer cache_peer = (CachePeer)peer.getData(PEER_CACHE_KEY);
        cache_peer.setSpeedChangeTime(time);
        peer.getStats().setDownloadRateLimitBytesPerSecond(speed);
    }

    protected long getCurrentSpeed() {
        PEPeerManager pm = this.download_manager.getPeerManager();
        long result = 0L;
        if (pm != null) {
            Iterator it = pm.getPeers().iterator();
            while (it.hasNext()) {
                result += ((PEPeer)it.next()).getStats().getDataReceiveRate();
            }
        }
        return result;
    }

    public boolean supportsProgressiveMode() {
        TOTorrent torrent = this.download_manager.getTorrent();
        if (torrent == null) {
            return false;
        }
        return this.enhancer.isProgressiveAvailable() && PlatformTorrentUtils.isContentProgressive(torrent);
    }

    public void setProgressiveMode(boolean active) {
        this.setProgressiveMode(active, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProgressiveMode(boolean active, boolean switching_progressive_downloads) {
        TOTorrent torrent = this.download_manager.getTorrent();
        if (torrent == null) {
            return;
        }
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            if (this.progressive_active == active) {
                return;
            }
            if (active && !this.supportsProgressiveMode()) {
                Debug.out("Attempt to set progress mode on non-progressible content - " + this.getName());
                return;
            }
            this.log("Progressive mode changed to " + active);
            final GlobalManager gm = this.download_manager.getGlobalManager();
            if (active) {
                if (this.dmListener == null) {
                    this.dmListener = new DownloadManagerAdapter(){

                        public void downloadComplete(DownloadManager manager) {
                            gm.resumeDownloads();
                        }
                    };
                }
                this.download_manager.addListener(this.dmListener);
                Object[] dms = gm.getDownloadManagers().toArray();
                for (int i = 0; i < dms.length; ++i) {
                    EnhancedDownloadManager edmCheck;
                    DownloadManager dmCheck = (DownloadManager)dms[i];
                    if (dmCheck.equals(this.download_manager) || dmCheck.isDownloadComplete(false) || PlatformTorrentUtils.getAdId(dmCheck.getTorrent()) != null) continue;
                    int state = dmCheck.getState();
                    if (state == 50 || state == 75) {
                        dmCheck.pause();
                    }
                    if ((edmCheck = this.enhancer.getEnhancedDownload(dmCheck)) == null || !edmCheck.getProgressiveMode()) continue;
                    edmCheck.setProgressiveMode(false, true);
                }
                if (this.download_manager.isPaused()) {
                    this.download_manager.resume();
                }
                if (this.download_manager.getState() == 70) {
                    this.download_manager.setStateWaiting();
                }
                if (this.download_manager.getPosition() != 1) {
                    this.download_manager.getGlobalManager().moveTo(this.download_manager, 1);
                }
            } else {
                this.download_manager.removeListener(this.dmListener);
                if (!switching_progressive_downloads) {
                    gm.resumeDownloads();
                }
            }
            this.progressive_active = active;
            if (this.current_piece_pickler != null) {
                if (this.progressive_active) {
                    this.buffer_provider.activate(this.current_piece_pickler);
                    this.boost_provider.activate(this.current_piece_pickler);
                    this.progressive_stats.update(0);
                } else {
                    this.buffer_provider.deactivate(this.current_piece_pickler);
                    this.boost_provider.deactivate(this.current_piece_pickler);
                    this.progressive_stats = this.createProgressiveStats(this.download_manager, this.primary_file);
                }
            } else {
                this.progressive_stats = this.createProgressiveStats(this.download_manager, this.primary_file);
            }
            if (!switching_progressive_downloads) {
                if (active) {
                    RealTimeInfo.setProgressiveActive(this.progressive_stats.getStreamBytesPerSecondMax());
                } else {
                    RealTimeInfo.setProgressiveInactive();
                }
            }
        }
        if (active && !this.progressive_informed) {
            this.progressive_informed = true;
            Download plugin_dl = PluginCoreUtils.wrap(this.download_manager);
            DownloadUtils.addTrackerExtension(plugin_dl, TRACKER_PROG_PREFIX, "y");
            this.download_manager.requestTrackerAnnounce(true);
        }
    }

    public boolean getProgressiveMode() {
        return this.progressive_active;
    }

    public long getProgressivePlayETA() {
        return this.getProgressivePlayETA(false);
    }

    public long getProgressivePlayETA(boolean ignore_min_buffer_size) {
        progressiveStats stats = this.getProgressiveStats();
        long eta = stats.getETA(ignore_min_buffer_size);
        return eta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected progressiveStats getProgressiveStats() {
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            return this.progressive_stats.getCopy();
        }
    }

    protected progressiveStats createProgressiveStats(DownloadManager dm, EnhancedDownloadManagerFile file) {
        TOTorrent torrent = this.download_manager.getTorrent();
        if (torrent != null && PlatformTorrentUtils.useEMP(torrent)) {
            return new progressiveStatsInternal(dm, file);
        }
        return new progressiveStatsExternal(dm, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateProgressiveStats(int tick_count) {
        if (!this.progressive_active) {
            return;
        }
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            PiecePicker piece_picker;
            if (!this.progressive_active) {
                return;
            }
            if (tick_count % 5 == 0 && (piece_picker = this.current_piece_pickler) != null) {
                this.buffer_provider.checkActivation(piece_picker);
            }
            this.progressive_stats.update(tick_count);
            long current_max = this.progressive_stats.getStreamBytesPerSecondMax();
            if (RealTimeInfo.getProgressiveActiveBytesPerSec() != current_max) {
                RealTimeInfo.setProgressiveActive(current_max);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRTA(boolean active) {
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            if (this.marked_active && !active) {
                this.marked_active = false;
                RealTimeInfo.removeRealTimeTask();
            }
            if (this.destroyed) {
                return;
            }
            if (!this.marked_active && active) {
                this.marked_active = true;
                RealTimeInfo.addRealTimeTask();
            }
        }
    }

    protected void checkPublishing() {
        if (this.publish_handling_complete) {
            return;
        }
        if (PublishUtils.isPublished(this.download_manager)) {
            if (PublishUtils.isPublishComplete(this.download_manager)) {
                this.publish_handling_complete = true;
            } else {
                TRTrackerScraperResponse scrape = this.download_manager.getTrackerScrapeResponse();
                if (scrape == null || scrape.getStatus() != 2) {
                    return;
                }
                if (scrape.getSeeds() >= 2) {
                    PublishUtils.setPublishComplete(this.download_manager);
                    this.publish_handling_complete = true;
                } else {
                    PEPeerManager pm = this.download_manager.getPeerManager();
                    if (pm != null) {
                        long now = SystemTime.getCurrentTime();
                        long pub_sent = this.download_manager.getStats().getTotalDataBytesSent();
                        if (pub_sent != this.publish_sent) {
                            this.publish_sent = pub_sent;
                            this.publish_sent_time = now;
                        }
                        if (this.publish_sent_time > now) {
                            this.publish_sent_time = now;
                        }
                        if (now - this.publish_sent_time > 120000L) {
                            this.publish_sent_time = now;
                            this.log("Publish: upload stalled - switching transports");
                            pm.setPreferUDP(!pm.getPreferUDP());
                            List peers = pm.getPeers();
                            for (int i = 0; i < peers.size(); ++i) {
                                PEPeer peer = (PEPeer)peers.get(i);
                                pm.removePeer(peer, "Transport switch");
                            }
                            this.download_manager.requestTrackerAnnounce(true);
                        } else if (pm.getNbPeers() == 0) {
                            this.log("Publish: no connected peers, forcing announce");
                            this.download_manager.requestTrackerAnnounce(true);
                        }
                    }
                }
            }
        } else if (SystemTime.getCurrentTime() - this.time_download_started > 120000L) {
            this.publish_handling_complete = true;
        }
    }

    public DiskManagerFileInfo getPrimaryFile() {
        return this.primary_file.getFile();
    }

    public long getContiguousAvailableBytes(DiskManagerFileInfo file) {
        return this.getContiguousAvailableBytes(file, 0);
    }

    public long getContiguousAvailableBytes(DiskManagerFileInfo file, int file_start_offset) {
        long max_available;
        if (file == null) {
            return -1L;
        }
        DiskManager dm = this.download_manager.getDiskManager();
        if (dm == null) {
            return -1L;
        }
        int piece_size = dm.getPieceLength();
        DiskManagerFileInfo[] files = dm.getFiles();
        long start_index = file_start_offset;
        for (int i = 0; i < files.length && files[i].getIndex() != file.getIndex(); ++i) {
            start_index += files[i].getLength();
        }
        int first_piece_index = (int)(start_index / (long)piece_size);
        int first_piece_offset = (int)(start_index % (long)piece_size);
        int last_piece_index = file.getLastPieceNumber();
        DiskManagerPiece[] pieces = dm.getPieces();
        DiskManagerPiece first_piece = pieces[first_piece_index];
        long available = 0L;
        if (!first_piece.isDone()) {
            boolean[] blocks = first_piece.getWritten();
            if (blocks == null) {
                if (first_piece.isDone()) {
                    available = first_piece.getLength() - first_piece_offset;
                }
            } else {
                int piece_offset = 0;
                for (int j = 0; j < blocks.length && blocks[j]; ++j) {
                    int block_size = first_piece.getBlockSize(j);
                    piece_offset += block_size;
                    if (available == 0L) {
                        if (piece_offset <= first_piece_offset) continue;
                        available = piece_offset - first_piece_offset;
                        continue;
                    }
                    available += (long)block_size;
                }
            }
        } else {
            available = first_piece.getLength() - first_piece_offset;
            for (int i = first_piece_index + 1; i <= last_piece_index; ++i) {
                DiskManagerPiece piece = pieces[i];
                if (piece.isDone()) {
                    available += (long)piece.getLength();
                    continue;
                }
                boolean[] blocks = piece.getWritten();
                if (blocks == null) {
                    if (!piece.isDone()) break;
                    available += (long)piece.getLength();
                    break;
                }
                for (int j = 0; j < blocks.length && blocks[j]; ++j) {
                    available += (long)piece.getBlockSize(j);
                }
                break;
            }
        }
        if (available > (max_available = file.getLength() - (long)file_start_offset)) {
            available = max_available;
        }
        return available;
    }

    public void setViewerPosition(DiskManagerFileInfo file_info, long bytes) {
        int index;
        if (file_info != null && (index = file_info.getIndex()) < this.enhanced_files.length) {
            bytes += this.enhanced_files[index].getByteOffestInTorrent();
        }
        this.progressive_stats.setViewerBytePosition(bytes);
    }

    public DownloadManager getDownloadManager() {
        return this.download_manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            this.setRTA(false);
            this.destroyed = true;
        }
    }

    protected void log(String str) {
        this.log(str, true);
    }

    protected void log(String str, boolean to_file) {
        this.log(this.download_manager, str, to_file);
    }

    protected void log(DownloadManager dm, String str, boolean to_file) {
        str = dm.getDisplayName() + ": " + str;
        if (to_file) {
            AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("v3.Stream");
            diag_logger.log(str);
        }
        if (ConstantsV3.DIAG_TO_STDOUT) {
            System.out.println(Thread.currentThread().getName() + "|" + System.currentTimeMillis() + "] " + str);
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"filechannel.rt.buffer.millis"}, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                int channel_buffer_millis = COConfigurationManager.getIntParameter("filechannel.rt.buffer.millis");
                MINIMUM_INITIAL_BUFFER_SECS = 2 * channel_buffer_millis / 1000;
            }
        });
        internal_content_stream_bps_increase_ratio = 5;
        internal_content_stream_bps_increase_absolute = 0;
    }

    protected class boostETAProvider
    implements PieceRTAProvider {
        private long[] piece_rtas;
        private long last_recalc;
        private int aggression;
        private boolean active;
        private interventionHandler intervention_handler = new interventionHandler();
        private long last_intervention;

        protected boostETAProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void activate(PiecePicker picker) {
            if (EnhancedDownloadManager.this.supportsProgressiveMode()) {
                EnhancedDownloadManager.this.log("Activating boost provider");
                EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
                synchronized (enhancedDownloadManager) {
                    this.intervention_handler.activate();
                    this.active = true;
                    picker.addRTAProvider(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void deactivate(PiecePicker picker) {
            if (this.active) {
                EnhancedDownloadManager.this.log("Deactivating boost provider");
            }
            EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
            synchronized (enhancedDownloadManager) {
                picker.removeRTAProvider(this);
                this.piece_rtas = null;
                this.active = false;
                this.intervention_handler.deactivate();
            }
        }

        public long[] updateRTAs(PiecePicker picker) {
            long now = SystemTime.getCurrentTime();
            if (now < this.last_recalc || now - this.last_recalc > 1000L) {
                this.last_recalc = now;
                DiskManager disk_manager = EnhancedDownloadManager.this.download_manager.getDiskManager();
                progressiveStats stats = EnhancedDownloadManager.this.getProgressiveStats();
                long max_bps = stats.getStreamBytesPerSecondMax();
                if (disk_manager == null || !stats.isProviderActive() || stats.getETA(false) < (long)(-MINIMUM_INITIAL_BUFFER_SECS) || max_bps == 0L) {
                    if (this.piece_rtas != null) {
                        EnhancedDownloadManager.this.log("Suspending boost provider");
                    }
                    this.piece_rtas = null;
                } else {
                    if (this.piece_rtas == null) {
                        EnhancedDownloadManager.this.log("Resuming boost provider");
                    }
                    this.piece_rtas = new long[disk_manager.getNbPieces()];
                    long[] local_rtas = this.piece_rtas;
                    long piece_size = disk_manager.getPieceLength();
                    int start_piece = (int)(stats.getBytePosition() / piece_size);
                    long bytes_offset = 0L;
                    int last_aggressive_piece = -1;
                    long time_to_stall = 0L;
                    if (EnhancedDownloadManager.this.explicit_minimum_buffer_bytes > 0) {
                        long total_avail = EnhancedDownloadManager.this.getContiguousAvailableBytes(EnhancedDownloadManager.this.getPrimaryFile());
                        long viewer_pos = stats.getViewerBytePosition();
                        long avail = total_avail - viewer_pos;
                        time_to_stall = (avail - (long)EnhancedDownloadManager.this.explicit_minimum_buffer_bytes) * 1000L / max_bps;
                        long buffer_zone = 3 * EnhancedDownloadManager.this.explicit_minimum_buffer_bytes;
                        if (avail <= buffer_zone) {
                            if (avail < 0L) {
                                avail = 0L;
                            }
                            this.aggression = avail <= (long)EnhancedDownloadManager.this.explicit_minimum_buffer_bytes ? 10 : (int)((buffer_zone - avail) * 10L / (buffer_zone - (long)EnhancedDownloadManager.this.explicit_minimum_buffer_bytes));
                            last_aggressive_piece = start_piece + (int)((buffer_zone + piece_size - 1L) / piece_size);
                        } else {
                            this.aggression = 0;
                        }
                    } else {
                        this.aggression = 0;
                    }
                    DiskManagerPiece[] dm_pieces = disk_manager.getPieces();
                    for (int i = start_piece; i < local_rtas.length; ++i) {
                        int time_factor;
                        if (i <= last_aggressive_piece) {
                            time_factor = (10 - this.aggression) * 1000 / 10;
                            time_factor = Math.max(time_factor, 10);
                            if (!(this.aggression < 7 || dm_pieces[i].isDone() || time_to_stall > 10000L || now >= this.last_intervention && now - this.last_intervention < 500L)) {
                                this.last_intervention = now;
                                this.intervention_handler.addPiece(i, SystemTime.getCurrentTime() + time_to_stall);
                            }
                        } else {
                            time_factor = 1000;
                        }
                        local_rtas[i] = now + (long)time_factor * (bytes_offset / max_bps);
                        bytes_offset += piece_size;
                    }
                }
            }
            return this.piece_rtas;
        }

        public long getCurrentPosition() {
            return 0L;
        }

        public long getBlockingPosition() {
            return 0L;
        }

        public long getStartTime() {
            return 0L;
        }

        public long getStartPosition() {
            return 0L;
        }

        public void setBufferMillis(long seconds) {
        }

        public String getUserAgent() {
            return null;
        }

        protected class interventionHandler {
            private AEThread2 thread;
            private AESemaphore request_sem;
            private List request_list;
            private List http_peers;
            private boolean borked;

            protected interventionHandler() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void activate() {
                interventionHandler interventionHandler2 = this;
                synchronized (interventionHandler2) {
                    boostETAProvider.this.active = true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void deactivate() {
                interventionHandler interventionHandler2 = this;
                synchronized (interventionHandler2) {
                    boostETAProvider.this.active = false;
                    if (this.thread != null) {
                        this.thread = null;
                        this.request_list = null;
                        this.request_sem.release();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void addPiece(int piece_number, long stall_time) {
                interventionHandler interventionHandler2 = this;
                synchronized (interventionHandler2) {
                    if (!boostETAProvider.this.active || this.borked) {
                        return;
                    }
                    if (this.thread == null) {
                        PluginInterface pi = EnhancedDownloadManager.this.enhancer.getCore().getPluginManager().getPluginInterfaceByClass(ExternalSeedPlugin.class);
                        if (pi == null) {
                            this.borked = true;
                            return;
                        }
                        ExternalSeedPlugin ext_seed = (ExternalSeedPlugin)pi.getPlugin();
                        ExternalSeedManualPeer[] peers = ext_seed.getManualWebSeeds(PluginCoreUtils.wrap(EnhancedDownloadManager.this.download_manager));
                        this.http_peers = null;
                        for (int i = 0; i < peers.length; ++i) {
                            ExternalSeedManualPeer peer = peers[i];
                            if (!PeerClassifier.isAzureusIP(peer.getIP())) continue;
                            if (this.http_peers == null) {
                                this.http_peers = new ArrayList();
                            }
                            this.http_peers.add(peer);
                        }
                        this.request_sem = new AESemaphore("EDH:intervention");
                        this.request_list = new ArrayList();
                        this.thread = new AEThread2("EDH:intervention", true){
                            private AESemaphore my_sem;
                            private List my_list;
                            private ExternalSeedManualPeer current_peer;
                            {
                                this.my_sem = interventionHandler.this.request_sem;
                                this.my_list = interventionHandler.this.request_list;
                            }

                            /*
                             * Exception decompiling
                             */
                            public void run() {
                                /*
                                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                                 * 
                                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                                 */
                                throw new IllegalStateException("Decompilation failed");
                            }
                        };
                        this.thread.start();
                    }
                    if ((this.request_list.isEmpty() || (long)piece_number < ((long[])this.request_list.get(0))[0] + 10L) && this.request_list.size() < 5) {
                        boolean found = false;
                        for (int i = 0; i < this.request_list.size(); ++i) {
                            long[] entry = (long[])this.request_list.get(i);
                            if (entry[0] != (long)piece_number) continue;
                            found = true;
                            entry[1] = Math.min(stall_time, entry[1]);
                        }
                        if (!found) {
                            EnhancedDownloadManager.this.log("Intervention: queueing piece " + piece_number + ", stall_time=" + (stall_time - SystemTime.getCurrentTime()));
                            this.request_list.add(new long[]{piece_number, stall_time});
                            this.request_sem.release();
                        }
                    }
                }
            }

            static /* synthetic */ List access$1800(interventionHandler x0) {
                return x0.http_peers;
            }
        }
    }

    protected class bufferETAProvider
    implements PieceRTAProvider {
        private long[] piece_rtas;
        private long last_buffer_size;
        private long last_buffer_size_time;
        private boolean active;

        protected bufferETAProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void activate(PiecePicker picker) {
            EnhancedDownloadManager.this.log("Activating buffer provider");
            EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
            synchronized (enhancedDownloadManager) {
                this.active = true;
                this.piece_rtas = new long[picker.getNumberOfPieces()];
                long now = SystemTime.getCurrentTime();
                for (int i = 0; i < this.piece_rtas.length; ++i) {
                    this.piece_rtas[i] = now + (long)(i * 60000);
                }
                picker.addRTAProvider(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void deactivate(PiecePicker picker) {
            if (this.active) {
                EnhancedDownloadManager.this.log("Deactivating buffer provider");
            }
            EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
            synchronized (enhancedDownloadManager) {
                picker.removeRTAProvider(this);
                this.piece_rtas = null;
                this.active = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void checkActivation(PiecePicker picker) {
            if (EnhancedDownloadManager.this.getProgressivePlayETA() > 0L) {
                EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
                synchronized (enhancedDownloadManager) {
                    if (this.piece_rtas == null) {
                        this.activate(picker);
                    }
                }
            }
        }

        public long[] updateRTAs(PiecePicker picker) {
            long[] rtas;
            DiskManager dm = EnhancedDownloadManager.this.download_manager.getDiskManager();
            if (dm != null && EnhancedDownloadManager.this.getProgressivePlayETA() <= 0L) {
                this.deactivate(picker);
            }
            if ((rtas = this.piece_rtas) != null) {
                long buffer_size = EnhancedDownloadManager.this.progressive_stats.getInitialBytesDownloaded();
                long now = SystemTime.getCurrentTime();
                if (this.last_buffer_size != buffer_size) {
                    this.last_buffer_size = buffer_size;
                    this.last_buffer_size_time = now;
                } else if (now < this.last_buffer_size_time) {
                    this.last_buffer_size_time = now;
                } else {
                    long block_time;
                    long stalled_for = now - this.last_buffer_size_time;
                    long dl_speed = EnhancedDownloadManager.this.progressive_stats.getDownloadBytesPerSecond();
                    if (dl_speed > 0L && stalled_for > Math.max(5000L, 5L * (block_time = 0xFA0000L / dl_speed))) {
                        long existing_rta;
                        DiskManagerPiece[] pieces;
                        long target_rta = now + block_time;
                        int blocked_piece_index = (int)(buffer_size / (long)dm.getPieceLength());
                        if (blocked_piece_index < (pieces = dm.getPieces()).length && pieces[blocked_piece_index].isDone()) {
                            if (++blocked_piece_index < pieces.length) {
                                if (pieces[blocked_piece_index].isDone()) {
                                    blocked_piece_index = -1;
                                }
                            } else {
                                blocked_piece_index = -1;
                            }
                        }
                        if (blocked_piece_index >= 0 && target_rta < (existing_rta = rtas[blocked_piece_index])) {
                            rtas[blocked_piece_index] = target_rta;
                            EnhancedDownloadManager.this.log("Buffer provider: reprioritising lagging piece " + blocked_piece_index + " with rta " + block_time);
                        }
                    }
                }
            }
            return rtas;
        }

        public long getCurrentPosition() {
            return 0L;
        }

        public long getStartTime() {
            return 0L;
        }

        public long getStartPosition() {
            return 0L;
        }

        public long getBlockingPosition() {
            return 0L;
        }

        public void setBufferMillis(long seconds) {
        }

        public String getUserAgent() {
            return null;
        }
    }

    protected abstract class progressiveStats
    implements Cloneable {
        protected progressiveStats() {
        }

        protected abstract boolean isProviderActive();

        protected abstract long getBytePosition();

        protected abstract long getStreamBytesPerSecondMax();

        protected abstract long getStreamBytesPerSecondMin();

        protected abstract long getInitialBytesDownloaded();

        protected abstract long getDownloadBytesPerSecond();

        protected abstract long getETA(boolean var1);

        protected abstract void setViewerBytePosition(long var1);

        protected abstract long getViewerBytePosition();

        protected abstract void update(int var1);

        protected abstract void refreshMetaData();

        protected progressiveStats getCopy() {
            try {
                return (progressiveStats)this.clone();
            }
            catch (CloneNotSupportedException e) {
                Debug.printStackTrace(e);
                return null;
            }
        }

        protected String formatBytes(long l) {
            return DisplayFormatters.formatByteCountToKiBEtc(l);
        }

        protected String formatSpeed(long l) {
            return DisplayFormatters.formatByteCountToKiBEtcPerSec(l);
        }
    }

    protected abstract class progressiveStatsCommon
    extends progressiveStats {
        private PieceRTAProvider current_provider;
        private String current_user_agent;
        protected long total_file_length;
        private Average capped_download_rate_average;
        private Average discard_rate_average;
        private long last_discard_bytes;
        private long actual_bytes_to_download;
        private long weighted_bytes_to_download;
        private long provider_life_secs;
        private long provider_initial_position;
        private long provider_byte_position;
        private long provider_last_byte_position;
        private long provider_blocking_byte_position;
        private Average provider_speed_average;
        private long last_eta;

        protected progressiveStatsCommon(DownloadManager dm, EnhancedDownloadManagerFile primary_file) {
            this.total_file_length = EnhancedDownloadManager.this.download_manager.getSize();
            this.capped_download_rate_average = AverageFactory.MovingImmediateAverage(10);
            this.discard_rate_average = AverageFactory.MovingImmediateAverage(10);
            this.last_discard_bytes = EnhancedDownloadManager.this.download_manager.getStats().getDiscarded();
            this.provider_last_byte_position = -1L;
            this.provider_speed_average = AverageFactory.MovingImmediateAverage(10);
            this.last_eta = -1L;
            this.calculateSpeeds(dm, primary_file);
            EnhancedDownloadManager.this.setRTA(false);
            EnhancedDownloadManager.this.log(EnhancedDownloadManager.this.download_manager, "content_stream_bps=" + this.getStreamBytesPerSecondMin() + ",primary=" + (primary_file == null ? "null" : primary_file.getString()), true);
        }

        protected void refreshMetaData() {
            this.calculateSpeeds(EnhancedDownloadManager.this.download_manager, EnhancedDownloadManager.this.primary_file);
        }

        protected abstract void calculateSpeeds(DownloadManager var1, EnhancedDownloadManagerFile var2);

        protected void updateCurrentProvider(PieceRTAProvider provider) {
            if (this.current_provider != provider || provider == null) {
                this.current_provider = provider;
                this.current_user_agent = null;
                this.provider_speed_average = AverageFactory.MovingImmediateAverage(10);
                if (this.current_provider == null) {
                    this.provider_life_secs = 0L;
                    this.provider_initial_position = 0L;
                    this.provider_byte_position = 0L;
                    this.provider_blocking_byte_position = 0L;
                    this.provider_last_byte_position = -1L;
                } else {
                    this.provider_byte_position = this.provider_initial_position = this.current_provider.getStartPosition();
                    this.provider_last_byte_position = this.provider_initial_position;
                    this.provider_blocking_byte_position = this.current_provider.getBlockingPosition();
                    this.provider_life_secs = (SystemTime.getCurrentTime() - this.current_provider.getStartTime()) / 1000L;
                    if (this.provider_life_secs < 0L) {
                        this.provider_life_secs = 0L;
                    }
                }
                EnhancedDownloadManager.this.setRTA(this.current_provider != null);
            } else {
                ++this.provider_life_secs;
                if (this.current_user_agent == null) {
                    this.current_user_agent = this.current_provider.getUserAgent();
                    if (this.current_user_agent != null) {
                        EnhancedDownloadManager.this.log("Provider user agent = " + this.current_user_agent);
                    }
                }
                this.provider_byte_position = this.current_provider.getCurrentPosition();
                this.provider_blocking_byte_position = this.current_provider.getBlockingPosition();
                long bytes_read = this.provider_byte_position - this.provider_last_byte_position;
                this.provider_speed_average.update(bytes_read);
                this.provider_last_byte_position = this.provider_byte_position;
            }
        }

        protected boolean isProviderActive() {
            return this.current_provider != null;
        }

        protected long getInitialProviderPosition() {
            return this.provider_initial_position;
        }

        protected long getProviderBytePosition() {
            return this.provider_byte_position;
        }

        protected long getProviderLifeSecs() {
            return this.provider_life_secs;
        }

        protected void update(int tick_count) {
            long download_rate = EnhancedDownloadManager.this.download_manager.getStats().getDataReceiveRate();
            this.capped_download_rate_average.update(download_rate);
            long discards = EnhancedDownloadManager.this.download_manager.getStats().getDiscarded();
            this.discard_rate_average.update(discards - this.last_discard_bytes);
            this.last_discard_bytes = discards;
            DiskManager disk_manager = EnhancedDownloadManager.this.download_manager.getDiskManager();
            PiecePicker picker = EnhancedDownloadManager.this.current_piece_pickler;
            if (this.getStreamBytesPerSecondMin() > 0L && disk_manager != null && picker != null) {
                List providers = picker.getRTAProviders();
                long max_cp = 0L;
                PieceRTAProvider best_provider = null;
                for (int i = 0; i < providers.size(); ++i) {
                    long cp;
                    PieceRTAProvider provider = (PieceRTAProvider)providers.get(i);
                    if (provider.getStartTime() <= 0L || (cp = provider.getCurrentPosition()) < max_cp) continue;
                    best_provider = provider;
                    max_cp = cp;
                }
                this.updateCurrentProvider(best_provider);
                this.updateViewerPosition();
                if (best_provider != null) {
                    long buffer_secs = this.getViewerBufferSeconds();
                    if (buffer_secs < 10L) {
                        buffer_secs = 10L;
                    }
                    best_provider.setBufferMillis(buffer_secs * 1000L);
                }
                DiskManagerPiece[] pieces = disk_manager.getPieces();
                this.actual_bytes_to_download = 0L;
                this.weighted_bytes_to_download = 0L;
                int first_incomplete_piece = -1;
                int piece_size = disk_manager.getPieceLength();
                for (int i = (int)(this.provider_byte_position / (long)piece_size); i < pieces.length; ++i) {
                    DiskManagerPiece piece = pieces[i];
                    if (piece.isDone()) continue;
                    if (first_incomplete_piece == -1) {
                        first_incomplete_piece = i;
                    }
                    boolean[] blocks = piece.getWritten();
                    int bytes_this_piece = 0;
                    if (blocks == null) {
                        bytes_this_piece = piece.getLength();
                    } else {
                        for (int j = 0; j < blocks.length; ++j) {
                            if (blocks[j]) continue;
                            bytes_this_piece += piece.getBlockSize(j);
                        }
                    }
                    if (bytes_this_piece <= 0) continue;
                    this.actual_bytes_to_download += (long)bytes_this_piece;
                    int diff = i - first_incomplete_piece;
                    if (diff == 0) {
                        this.weighted_bytes_to_download += (long)bytes_this_piece;
                        continue;
                    }
                    int weighted_bytes_done = piece.getLength() - bytes_this_piece;
                    weighted_bytes_done = weighted_bytes_done * (pieces.length - i) / (pieces.length - first_incomplete_piece);
                    this.weighted_bytes_to_download += (long)(piece.getLength() - weighted_bytes_done);
                }
            }
            EnhancedDownloadManager.this.log(this.getString(), tick_count % 10 == 0);
        }

        protected abstract void updateViewerPosition();

        protected abstract long getInitialBufferBytes(long var1, boolean var3);

        protected long getETA(boolean ignore_min_buffer_size) {
            long eta;
            DiskManager dm = EnhancedDownloadManager.this.download_manager.getDiskManager();
            if (dm == null) {
                return Long.MAX_VALUE;
            }
            if (dm.getRemainingExcludingDND() == 0L) {
                return 0L;
            }
            long download_rate = this.getDownloadBytesPerSecond();
            if (download_rate <= 0L) {
                return Long.MAX_VALUE;
            }
            long min_dl = this.getInitialBufferBytes(download_rate, ignore_min_buffer_size);
            long initial_downloaded = this.getInitialBytesDownloaded(min_dl);
            long rem_dl = min_dl - initial_downloaded;
            long rem_secs = rem_dl / download_rate;
            long secs_to_download = this.getSecondsToDownload();
            long secs_to_watch = this.getSecondsToWatch();
            if (rem_secs > (eta = (secs_to_download += secs_to_download / 10L) - secs_to_watch)) {
                eta = rem_secs;
            }
            if (!ignore_min_buffer_size && eta == 0L && this.last_eta != 0L) {
                this.last_eta = eta;
                EnhancedDownloadManager.this.log("ETA=0: rate=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(download_rate) + ",init_buff=" + min_dl + ",to_dl=" + secs_to_download + ",to_watch=" + secs_to_watch);
            }
            return eta;
        }

        public long getInitialBytesDownloaded() {
            return this.getInitialBytesDownloaded(Long.MAX_VALUE);
        }

        protected long getDownloadBytesPerSecond() {
            int global_limit;
            long original;
            long current = original = (long)this.capped_download_rate_average.getAverage();
            int dl_limit = EnhancedDownloadManager.this.download_manager.getStats().getDownloadRateLimitBytesPerSecond();
            if (dl_limit > 0) {
                current = Math.min(current, (long)dl_limit);
            }
            if ((global_limit = TransferSpeedValidator.getGlobalDownloadRateLimitBytesPerSecond()) > 0) {
                current = Math.min(current, (long)global_limit);
            }
            return current;
        }

        public long getInitialBytesDownloaded(long stop_counting_after) {
            DiskManager dm = EnhancedDownloadManager.this.download_manager.getDiskManager();
            if (dm == null) {
                return 0L;
            }
            long initial_downloaded = 0L;
            DiskManagerPiece[] pieces = dm.getPieces();
            for (int i = 0; i < pieces.length; ++i) {
                DiskManagerPiece piece = pieces[i];
                if (!piece.isDone()) {
                    boolean[] blocks = piece.getWritten();
                    if (blocks == null) break;
                    for (int j = 0; j < blocks.length && blocks[j]; ++j) {
                        initial_downloaded += (long)piece.getBlockSize(j);
                    }
                    break;
                }
                if ((initial_downloaded += (long)piece.getLength()) >= stop_counting_after) break;
            }
            return initial_downloaded;
        }

        protected long getSecondsToDownload() {
            long download_rate = this.getDownloadBytesPerSecond();
            if (download_rate == 0L) {
                return Long.MAX_VALUE;
            }
            return this.weighted_bytes_to_download / download_rate;
        }

        protected long getSecondsToWatch() {
            return (this.total_file_length - this.getViewerBytePosition()) / this.getStreamBytesPerSecondMin();
        }

        protected long getBytePosition() {
            return this.getViewerBytePosition();
        }

        protected long getViewerBufferSeconds() {
            return (this.provider_byte_position - this.getViewerBytePosition()) / this.getStreamBytesPerSecondMax();
        }

        protected String getString() {
            long dl_rate = this.getDownloadBytesPerSecond();
            long init_bytes = this.getInitialBufferBytes(dl_rate, false);
            return "play_eta=" + this.getETA(false) + "/d=" + this.getSecondsToDownload() + "/w=" + this.getSecondsToWatch() + ", dl_rate=" + this.formatSpeed(dl_rate) + ", download_rem=" + this.formatBytes(this.weighted_bytes_to_download) + "/" + this.formatBytes(this.actual_bytes_to_download) + ", discard_rate=" + this.formatSpeed((long)this.discard_rate_average.getAverage()) + ", init_done=" + this.getInitialBytesDownloaded(init_bytes) + ", init_buff=" + init_bytes + ", viewer: byte=" + this.formatBytes(this.getViewerBytePosition()) + " secs=" + this.getViewerBytePosition() / this.getStreamBytesPerSecondMin() + ", prov: byte=" + this.formatBytes(this.provider_byte_position) + " secs=" + this.provider_byte_position / this.getStreamBytesPerSecondMin() + " speed=" + this.formatSpeed((long)this.provider_speed_average.getAverage()) + " block= " + this.formatBytes(this.provider_blocking_byte_position) + " buffer=" + this.formatBytes(this.provider_byte_position - this.getViewerBytePosition()) + "/" + this.getViewerBufferSeconds();
        }
    }

    protected class progressiveStatsExternal
    extends progressiveStatsCommon {
        private long content_stream_bps_min;
        private long content_stream_bps_max;
        private long viewer_byte_position;

        protected progressiveStatsExternal(DownloadManager download_manager, EnhancedDownloadManagerFile primary_file) {
            super(download_manager, primary_file);
        }

        protected void calculateSpeeds(DownloadManager download_manager, EnhancedDownloadManagerFile primary_file) {
            TOTorrent torrent = download_manager.getTorrent();
            if (torrent == null) {
                return;
            }
            this.content_stream_bps_min = PlatformTorrentUtils.getContentStreamSpeedBps(torrent);
            if (this.content_stream_bps_min == 0L) {
                long size = torrent.getSize();
                this.content_stream_bps_min = size < 0xC800000L ? 30720L : (size < 1048576000L ? 204800L : 409600L);
            }
            this.content_stream_bps_max = this.content_stream_bps_min + this.content_stream_bps_min / 5L;
        }

        protected long getStreamBytesPerSecondMax() {
            return this.content_stream_bps_max;
        }

        protected long getStreamBytesPerSecondMin() {
            return this.content_stream_bps_min;
        }

        public long getInitialBufferBytes(long download_rate, boolean ignore_min_buffer_size) {
            long min_dl = (long)EnhancedDownloadManager.this.minimum_initial_buffer_secs_for_eta * this.getStreamBytesPerSecondMax();
            min_dl = Math.max(min_dl, ignore_min_buffer_size ? 0L : (long)EnhancedDownloadManager.this.explicit_minimum_buffer_bytes);
            long advice = EnhancedDownloadManager.this.primary_file.getInitialBufferBytes(download_rate);
            min_dl = Math.max(advice, min_dl);
            return min_dl;
        }

        protected void updateViewerPosition() {
            this.viewer_byte_position = this.getInitialProviderPosition() + this.getStreamBytesPerSecondMax() * this.getProviderLifeSecs();
            if (this.viewer_byte_position > this.total_file_length) {
                this.viewer_byte_position = this.total_file_length;
            }
            if (this.viewer_byte_position > this.getProviderBytePosition()) {
                this.viewer_byte_position = this.getProviderBytePosition();
            }
        }

        protected void setViewerBytePosition(long bytes) {
        }

        protected long getViewerBytePosition() {
            return this.viewer_byte_position;
        }
    }

    protected class progressiveStatsInternal
    extends progressiveStatsCommon {
        private long content_stream_bps_min;
        private long content_stream_bps_max;
        private long viewer_byte_position;
        private long viewer_byte_position_set_time;
        private long last_warning;

        protected progressiveStatsInternal(DownloadManager dm, EnhancedDownloadManagerFile primary_file) {
            super(dm, primary_file);
        }

        protected void calculateSpeeds(DownloadManager download_manager, EnhancedDownloadManagerFile primary_file) {
            TOTorrent torrent = download_manager.getTorrent();
            if (torrent == null) {
                return;
            }
            this.content_stream_bps_min = PlatformTorrentUtils.getContentStreamSpeedBps(torrent);
            if (this.content_stream_bps_min == 0L) {
                long size = torrent.getSize();
                this.content_stream_bps_min = size < 0xC800000L ? 30720L : (size < 1048576000L ? 204800L : 409600L);
            }
            this.content_stream_bps_min += (long)internal_content_stream_bps_increase_absolute;
            this.content_stream_bps_max = this.content_stream_bps_min + this.content_stream_bps_min / (long)internal_content_stream_bps_increase_ratio;
        }

        protected long getStreamBytesPerSecondMax() {
            return this.content_stream_bps_max;
        }

        protected long getStreamBytesPerSecondMin() {
            return this.content_stream_bps_min;
        }

        public long getInitialBufferBytes(long download_rate, boolean ignore_min_buffer_size) {
            long min_dl = ignore_min_buffer_size ? 0L : (long)EnhancedDownloadManager.this.explicit_minimum_buffer_bytes;
            long advice = EnhancedDownloadManager.this.primary_file.getInitialBufferBytes(download_rate);
            if (advice == 0L) {
                advice = (long)EnhancedDownloadManager.this.minimum_initial_buffer_secs_for_eta * this.getStreamBytesPerSecondMax();
            } else if (!ignore_min_buffer_size) {
                advice += (long)EnhancedDownloadManager.this.explicit_minimum_buffer_bytes;
            }
            min_dl = Math.max(advice, min_dl);
            return min_dl;
        }

        protected void updateViewerPosition() {
        }

        protected void setViewerBytePosition(long bytes) {
            this.viewer_byte_position_set_time = SystemTime.getCurrentTime();
            this.viewer_byte_position = bytes;
        }

        protected long getViewerBytePosition() {
            long now = SystemTime.getCurrentTime();
            if (now < this.viewer_byte_position_set_time) {
                this.viewer_byte_position_set_time = now;
            } else if (now - this.viewer_byte_position_set_time > 10000L && this.viewer_byte_position != 0L && (now < this.last_warning || now - this.last_warning >= 1000L)) {
                this.last_warning = now;
                EnhancedDownloadManager.this.log("No recent viewer position update (current=" + this.viewer_byte_position + ")");
            }
            return this.viewer_byte_position;
        }
    }
}

