/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.download;

import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.util.Debug;

public class EnhancedDownloadManagerFile {
    private DiskManagerFileInfo file;
    private long offset;
    private int header_size;
    private int[][] speeds;

    protected EnhancedDownloadManagerFile(DiskManagerFileInfo _file, long _offset, Map _map) {
        this.file = _file;
        this.offset = _offset;
        try {
            if (_map != null) {
                List stream_info;
                Long l_header_size = (Long)_map.get("header_size");
                if (l_header_size != null) {
                    this.header_size = l_header_size.intValue();
                }
                if ((stream_info = (List)_map.get("stream_info")) != null) {
                    this.speeds = new int[stream_info.size()][];
                    for (int i = 0; i < stream_info.size(); ++i) {
                        List entry = (List)stream_info.get(i);
                        int speed = ((Long)entry.get(0)).intValue();
                        int worst_buffer = ((Long)entry.get(1)).intValue();
                        int init_buffer = ((Long)entry.get(2)).intValue();
                        this.speeds[i] = new int[]{speed, worst_buffer, init_buffer};
                    }
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public DiskManagerFileInfo getFile() {
        return this.file;
    }

    public long getByteOffestInTorrent() {
        return this.offset;
    }

    public int getHeaderSize() {
        return this.header_size;
    }

    public int getInitialBufferBytes(long rate) {
        int buffer_size = 0;
        if (this.speeds != null && this.speeds.length > 0) {
            boolean found = false;
            int k_rate = (int)rate / 1024;
            for (int i = 0; i < this.speeds.length; ++i) {
                if (k_rate <= this.speeds[i][0]) continue;
                buffer_size = this.speeds[i][2] * 1024;
                found = true;
                break;
            }
            if (!found) {
                buffer_size = this.speeds[this.speeds.length - 1][2] * 1024;
            }
        }
        return this.header_size + buffer_size;
    }

    public String getString() {
        String speeds_str = "";
        if (this.speeds != null) {
            speeds_str = ",speeds=";
            for (int i = 0; i < this.speeds.length; ++i) {
                int[] s = this.speeds[i];
                speeds_str = speeds_str + (i == 0 ? "" : ",") + "[" + s[0] + "," + s[1] + "," + s[2] + "]";
            }
        }
        return this.file.getFile(true).getName() + ",header=" + this.header_size + speeds_str;
    }
}

