/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger;

import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.core.messenger.browser.BrowserMessageDispatcher;
import com.aelitis.azureus.core.messenger.browser.BrowserTransaction;
import com.aelitis.azureus.core.messenger.browser.BrowserTransactionManager;
import com.aelitis.azureus.core.messenger.browser.listeners.BrowserMessageListener;
import com.aelitis.azureus.util.ConstantsV3;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.Debug;

public abstract class ClientMessageContextImpl
implements ClientMessageContext {
    private String id;
    private BrowserMessageDispatcher dispatcher;
    private BrowserTransactionManager txnManager;

    public ClientMessageContextImpl(String id, BrowserMessageDispatcher dispatcher) {
        this.id = id;
        this.dispatcher = dispatcher;
        this.txnManager = new BrowserTransactionManager(this);
    }

    public void addMessageListener(BrowserMessageListener listener) {
        if (this.dispatcher != null) {
            this.dispatcher.addListener(listener);
        } else {
            this.debug("No dispatcher when trying to add MessageListener " + listener.getId() + ";" + Debug.getCompressedStackTrace());
        }
    }

    public BrowserTransaction cancelTransaction(String type) {
        return this.txnManager.cancelTransaction(type);
    }

    public void debug(String message) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("v3.CMsgr");
        diag_logger.log("[" + this.id + "] " + message);
        if (ConstantsV3.DIAG_TO_STDOUT) {
            System.out.println("[" + this.id + "] " + message);
        }
    }

    public void debug(String message, Throwable t) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("v3.CMsgr");
        diag_logger.log("[" + this.id + "] " + message);
        diag_logger.log(t);
        if (ConstantsV3.DIAG_TO_STDOUT) {
            System.err.println("[" + this.id + "] " + message);
            t.printStackTrace();
        }
    }

    public BrowserTransaction getTransaction(String type) {
        return this.txnManager.getTransaction(type);
    }

    public BrowserTransactionManager getTransactionManager() {
        return this.txnManager;
    }

    public void registerTransactionType(String type, Class clazz) {
        this.txnManager.registerTransactionType(type, clazz);
    }

    public void removeMessageListener(String listenerId) {
        if (this.dispatcher != null) {
            this.dispatcher.removeListener(listenerId);
        } else {
            this.debug("No dispatcher when trying to remove MessageListener " + listenerId + ";" + Debug.getCompressedStackTrace());
        }
    }

    public void removeMessageListener(BrowserMessageListener listener) {
        if (this.dispatcher != null) {
            this.dispatcher.removeListener(listener);
        } else {
            this.debug("No dispatcher when trying to remove MessageListener " + listener.getId() + ";" + Debug.getCompressedStackTrace());
        }
    }

    public BrowserTransaction startTransaction(String type) {
        return this.txnManager.startTransaction(type);
    }

    public BrowserMessageDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public String getID() {
        return this.id;
    }

    public void setMessageDispatcher(BrowserMessageDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }
}

