/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.core.messenger.ClientMessageContextImpl;
import com.aelitis.azureus.core.messenger.PlatformAuthorizedSender;
import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.core.messenger.browser.BrowserMessage;
import com.aelitis.azureus.core.messenger.browser.BrowserMessageDispatcher;
import com.aelitis.azureus.core.messenger.browser.listeners.MessageCompletionListener;
import com.aelitis.azureus.util.ConstantsV3;
import com.aelitis.azureus.util.JSONUtils;
import com.aelitis.azureus.util.MapUtils;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;

public class PlatformMessenger {
    private static final boolean DEBUG_URL = System.getProperty("platform.messenger.debug.url", "0").equals("1");
    private static final int MAX_POST_LENGTH = 0x180000;
    private static boolean USE_HTTP_POST = true;
    public static String REPLY_EXCEPTION = "exception";
    public static String REPLY_ACTION = "action";
    public static String REPLY_RESULT = "response";
    private static Map mapQueueAuthorized = new LinkedHashMap();
    private static Map mapQueueNoAZID = new LinkedHashMap();
    private static Map mapQueue = new LinkedHashMap();
    private static AEMonitor queue_mon = new AEMonitor("v3.PlatformMessenger.queue");
    private static Timer timerProcess = new Timer("v3.PlatformMessenger.queue");
    private static TimerEvent timerEvent = null;
    private static boolean initialized;
    private static fakeContext context;
    private static PlatformAuthorizedSender authorizedSender;
    private static boolean authorizedDelayed;

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        context = new fakeContext();
    }

    public static void setAuthorizedTransferListener(PlatformAuthorizedSender authorizedSender) {
        PlatformMessenger.debug("set Authorized Sender");
        PlatformMessenger.authorizedSender = authorizedSender;
    }

    public static ClientMessageContext getClientMessageContext() {
        if (!initialized) {
            PlatformMessenger.init();
        }
        return context;
    }

    public static void queueMessage(PlatformMessage message, PlatformMessengerListener listener) {
        PlatformMessenger.queueMessage(message, listener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queueMessage(PlatformMessage message, PlatformMessengerListener listener, boolean addToBottom) {
        block17: {
            if (!initialized) {
                PlatformMessenger.init();
            }
            if (message != null) {
                PlatformMessenger.debug("q " + message.toShortString() + ": " + message + " for " + new Date(message.getFireBefore()) + "; in " + (message.getFireBefore() - SystemTime.getCurrentTime()) + "ms");
                if (message.requiresAuthorization() && authorizedDelayed) {
                    PlatformMessenger.debug("   authorized msg is delayed");
                }
            } else {
                PlatformMessenger.debug("fire timerevent");
            }
            queue_mon.enter();
            try {
                long fireBefore;
                if (message != null) {
                    if (message.requiresAuthorization()) {
                        mapQueueAuthorized.put(message, listener);
                    } else if (message.sendAZID()) {
                        mapQueue.put(message, listener);
                    } else {
                        mapQueueNoAZID.put(message, listener);
                    }
                    fireBefore = message.getFireBefore();
                } else {
                    fireBefore = SystemTime.getCurrentTime();
                }
                if (timerEvent == null || timerEvent.hasRun()) {
                    timerEvent = timerProcess.addEvent(fireBefore, new TimerEventPerformer(){

                        public void perform(TimerEvent event2) {
                            timerEvent = null;
                            while (mapQueue.size() > 0) {
                                PlatformMessenger.processQueue(mapQueue, false, true);
                            }
                            if (!authorizedDelayed) {
                                while (mapQueueAuthorized.size() > 0) {
                                    PlatformMessenger.processQueue(mapQueueAuthorized, true, true);
                                }
                            }
                            while (mapQueueNoAZID.size() > 0) {
                                PlatformMessenger.processQueue(mapQueueNoAZID, false, false);
                            }
                        }
                    });
                    break block17;
                }
                try {
                    if (fireBefore < timerEvent.getWhen()) {
                        timerProcess.adjustAllBy(fireBefore - timerEvent.getWhen());
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            finally {
                queue_mon.exit();
            }
        }
    }

    public static void debug(String string) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("v3.PMsgr");
        diag_logger.log(string);
        if (ConstantsV3.DIAG_TO_STDOUT) {
            System.out.println(Thread.currentThread().getName() + "|" + System.currentTimeMillis() + "] " + string);
        }
    }

    protected static void debug(String string, Throwable e) {
        PlatformMessenger.debug(string + "\n\t" + Debug.getCompressedStackTrace(e, 1, 80));
    }

    public static void pushMessageNow(PlatformMessage message, PlatformMessengerListener listener) {
        PlatformMessenger.debug("push " + message.toShortString() + ": " + message);
        HashMap<PlatformMessage, PlatformMessengerListener> map = new HashMap<PlatformMessage, PlatformMessengerListener>(1);
        map.put(message, listener);
        PlatformMessenger.processQueue(map, message.requiresAuthorization(), message.sendAZID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void processQueue(Map mapQueue, final boolean requiresAuthorization, boolean sendAZID) {
        String sURL;
        boolean isRelayServer;
        if (!initialized) {
            PlatformMessenger.init();
        }
        final HashMap mapProcessing = new HashMap();
        boolean loginAndRetry = false;
        String server = null;
        StringBuffer urlStem = new StringBuffer();
        long sequenceNo = 0L;
        queue_mon.enter();
        try {
            boolean first = true;
            boolean isRelayServerBatch = false;
            Iterator iter = mapQueue.keySet().iterator();
            while (iter.hasNext()) {
                PlatformMessage message = (PlatformMessage)iter.next();
                Object value = mapQueue.get(message);
                boolean isRelayServer2 = "relay".equals(message.getListenerID());
                if (first) {
                    isRelayServerBatch = isRelayServer2;
                    first = false;
                } else if (isRelayServerBatch != isRelayServer2) {
                    break;
                }
                message.setSequenceNo(sequenceNo);
                StringBuffer urlStemSegment = new StringBuffer();
                if (sequenceNo > 0L) {
                    urlStemSegment.append('&');
                }
                String listenerID = message.getListenerID();
                String messageID = message.getMessageID();
                String params = message.getParameters().toString();
                try {
                    urlStemSegment.append("cmd=");
                    urlStemSegment.append(URLEncoder.encode(messageID, "UTF-8"));
                    urlStemSegment.append(BrowserMessage.MESSAGE_DELIM_ENCODED);
                    urlStemSegment.append(sequenceNo);
                    urlStemSegment.append(BrowserMessage.MESSAGE_DELIM_ENCODED);
                    urlStemSegment.append(URLEncoder.encode(listenerID, "UTF-8"));
                    urlStemSegment.append(BrowserMessage.MESSAGE_DELIM_ENCODED);
                    urlStemSegment.append(URLEncoder.encode(message.getOperationID(), "UTF-8"));
                    urlStemSegment.append(BrowserMessage.MESSAGE_DELIM_ENCODED);
                    urlStemSegment.append(URLEncoder.encode(params, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                if (sequenceNo > 0L && urlStem.length() + urlStemSegment.length() > 0x180000) {
                    PlatformMessenger.debug("breaking up batch at " + sequenceNo + " because max limit would be exceeded (" + urlStem.length() + " + " + urlStemSegment.length() + ")");
                } else {
                    urlStem.append(urlStemSegment);
                    String curServer = messageID + "-" + listenerID;
                    if (server == null) {
                        server = curServer;
                    } else if (!server.equals(curServer)) {
                        server = "multi";
                    }
                    PlatformMessengerListener listener = (PlatformMessengerListener)mapProcessing.get(message);
                    if (listener != null) {
                        listener.messageSent(message);
                    }
                    ++sequenceNo;
                    mapProcessing.put(message, value);
                    iter.remove();
                    if (mapProcessing.size() == 1) {
                        loginAndRetry = message.getLoginAndRetry();
                        continue;
                    }
                    if (loginAndRetry == message.getLoginAndRetry()) continue;
                }
                break;
            }
        }
        finally {
            queue_mon.exit();
        }
        if (mapProcessing.size() == 0) {
            return;
        }
        if (server == null) {
            server = "default";
        }
        String sURL_RPC = (isRelayServer = "AZMSG-relay".equals(server)) ? ConstantsV3.URL_RELAY_RPC : ConstantsV3.URL_PREFIX + "rpc/" + server;
        String suffix = ConstantsV3.URL_SUFFIX;
        if (!sendAZID) {
            suffix = suffix.replaceAll("azid=.*&", "");
        }
        String sPostData = null;
        if (USE_HTTP_POST) {
            sURL = sURL_RPC;
            sPostData = "service=rpc&" + urlStem.toString() + "&" + suffix;
            if (!requiresAuthorization) {
                if (DEBUG_URL) {
                    PlatformMessenger.debug("POST for " + mapProcessing.size() + ": " + sURL + "?" + sPostData);
                } else {
                    PlatformMessenger.debug("POST for " + mapProcessing.size() + ": " + sURL);
                }
            }
        } else {
            sURL = sURL_RPC + "?service=rpc" + "&" + urlStem.toString() + "&" + suffix;
            if (DEBUG_URL) {
                PlatformMessenger.debug("GET: " + sURL);
            } else {
                PlatformMessenger.debug("GET: " + sURL_RPC + "?service=rpc");
            }
        }
        final String fURL = sURL;
        final String fPostData = sPostData;
        final boolean fLoginAndRetry = loginAndRetry;
        AEThread2 thread = new AEThread2("v3.PlatformMessenger", true){

            public void run() {
                try {
                    PlatformMessenger.processQueueAsync(fURL, fPostData, mapProcessing, requiresAuthorization, fLoginAndRetry);
                }
                catch (Throwable e) {
                    if (e instanceof ResourceDownloaderException) {
                        PlatformMessenger.debug("Error while sending message(s) to Platform: " + e.toString());
                    } else {
                        PlatformMessenger.debug("Error while sending message(s) to Platform", e);
                    }
                    for (PlatformMessage message : mapProcessing.keySet()) {
                        PlatformMessengerListener l = (PlatformMessengerListener)mapProcessing.get(message);
                        if (l == null) continue;
                        try {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map.put("text", e.toString());
                            map.put("Throwable", e);
                            l.replyReceived(message, REPLY_EXCEPTION, map);
                        }
                        catch (Throwable e2) {
                            PlatformMessenger.debug("Error while sending replyReceived", e2);
                        }
                    }
                }
            }
        };
        thread.start();
    }

    protected static void processQueueAsync(String sURL, String sData, Map mapProcessing, boolean requiresAuthorization, boolean loginAndRetry) throws Exception {
        String s;
        URL url = new URL(sURL);
        AzureusCore core = AzureusCoreFactory.getSingleton();
        PluginInterface pi = core.getPluginManager().getDefaultPluginInterface();
        if (requiresAuthorization && authorizedSender != null) {
            AESemaphore sem_waitDL = new AESemaphore("Waiting for DL");
            authorizedSender.startDownload(url, sData, sem_waitDL, loginAndRetry);
            sem_waitDL.reserve();
            s = authorizedSender.getResults();
        } else {
            if (requiresAuthorization) {
                PlatformMessenger.debug("No Authorized Sender.. using non-auth request");
            }
            byte[] bytes = PlatformMessenger.downloadURL(pi, url, sData);
            s = new String(bytes, "UTF8");
        }
        if (s == null || s.length() == 0 || !Character.isDigit(s.charAt(0))) {
            PlatformMessenger.debug("Error while sending message(s) to Platform: reply: " + s + "\nurl: " + sURL + "\nPostData: " + sData);
            for (PlatformMessage message : mapProcessing.keySet()) {
                PlatformMessengerListener l = (PlatformMessengerListener)mapProcessing.get(message);
                if (l == null) continue;
                try {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("text", "result was " + s);
                    l.replyReceived(message, REPLY_EXCEPTION, map);
                }
                catch (Throwable e2) {
                    PlatformMessenger.debug("Error while sending replyReceived\nurl: " + sURL + "\nPostData: " + sData, e2);
                }
            }
            return;
        }
        HashMap<Long, BrowserMessage> mapSeqToBrowserMsg = new HashMap<Long, BrowserMessage>();
        String[] replies = s.split("\\n");
        for (int i = 0; i < replies.length; ++i) {
            String reply = replies[i];
            final String[] replySections = reply.split(";", 3);
            if (replySections.length < 2) continue;
            long sequenceNo = NumberFormat.getInstance().parse(replySections[0]).longValue();
            Map actionResults = null;
            if (replySections.length == 3) {
                try {
                    actionResults = JSONUtils.decodeJSON(replySections[2]);
                }
                catch (Throwable e) {
                    PlatformMessenger.debug("Error while sending message(s) to Platform: reply: " + s + "\nurl: " + sURL + "\nPostData: " + sData, e);
                }
            }
            PlatformMessage message = null;
            PlatformMessengerListener listener = null;
            for (PlatformMessage potentialMessage : mapProcessing.keySet()) {
                if (potentialMessage.getSequenceNo() != sequenceNo) continue;
                message = potentialMessage;
                listener = (PlatformMessengerListener)mapProcessing.get(message);
            }
            if (message == null) {
                PlatformMessenger.debug("No message with sequence number " + sequenceNo);
                continue;
            }
            PlatformMessenger.debug("Got a reply for " + message.toShortString() + "\n\t\t" + reply.substring(0, Math.min(8192, reply.length())));
            final PlatformMessage fMessage = message;
            final PlatformMessengerListener fListener = listener;
            final Map fActionResults = actionResults;
            if (i == 0) {
                // empty if block
            }
            if (replySections[1].equals("action")) {
                final BrowserMessageDispatcher dispatcher = context.getDispatcher();
                if (dispatcher == null) {
                    PlatformMessenger.debug("action requested.. no dispatcher");
                } else if (actionResults instanceof Map) {
                    boolean bRetry = MapUtils.getMapBoolean(actionResults, "retry-client-message", false);
                    List array = (List)MapUtils.getMapObject(actionResults, "messages", null, List.class);
                    if (actionResults.containsKey("messages")) {
                        for (int j = 0; j < array.size(); ++j) {
                            final String sMsg = (String)array.get(j);
                            PlatformMessenger.debug("handling (" + (bRetry ? " with retry" : " no retry") + "): " + sMsg);
                            final BrowserMessage browserMsg = new BrowserMessage(sMsg);
                            int seq = browserMsg.getSequence();
                            BrowserMessage existingBrowserMsg = (BrowserMessage)mapSeqToBrowserMsg.get(new Long(seq));
                            if (existingBrowserMsg != null) {
                                existingBrowserMsg.addCompletionListener(new MessageCompletionListener(){

                                    public void completed(boolean success, Object data) {
                                        PlatformMessenger.debug("got complete for " + sMsg);
                                        if (success) {
                                            PlatformMessenger.queueMessage(fMessage, fListener);
                                        } else if (fListener != null) {
                                            try {
                                                fListener.replyReceived(fMessage, replySections[1], fActionResults);
                                            }
                                            catch (Throwable e2) {
                                                PlatformMessenger.debug("Error while sending replyReceived", e2);
                                            }
                                        }
                                    }
                                });
                                continue;
                            }
                            if (bRetry) {
                                mapSeqToBrowserMsg.put(new Long(seq), browserMsg);
                                browserMsg.addCompletionListener(new MessageCompletionListener(){

                                    public void completed(boolean success, Object data) {
                                        PlatformMessenger.debug("got complete for " + sMsg + ";" + success);
                                        if (success) {
                                            PlatformMessenger.queueMessage(fMessage, fListener);
                                        } else if (fListener != null) {
                                            try {
                                                fListener.replyReceived(fMessage, replySections[1], fActionResults);
                                            }
                                            catch (Throwable e2) {
                                                PlatformMessenger.debug("Error while sending replyReceived", e2);
                                            }
                                        }
                                    }
                                });
                            }
                            new AEThread2("v3.Msg.Dispatch", true){

                                public void run() {
                                    dispatcher.dispatch(browserMsg);
                                }
                            }.start();
                        }
                    }
                    if (bRetry) continue;
                }
            }
            if (listener == null) continue;
            try {
                listener.replyReceived(message, replySections[1], actionResults);
                continue;
            }
            catch (Exception e2) {
                PlatformMessenger.debug("Error while sending replyReceived", e2);
            }
        }
        BrowserMessageDispatcher dispatcher = context.getDispatcher();
        if (dispatcher != null) {
            dispatcher.resetSequence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] downloadURL(PluginInterface pi, URL url, String postData) throws Exception {
        byte[] data;
        ResourceDownloaderFactory rdf = pi.getUtilities().getResourceDownloaderFactory();
        ResourceDownloader rd = rdf.create(url, postData);
        rd = rdf.getRetryDownloader(rd, 3);
        InputStream is = rd.download();
        try {
            int length = is.available();
            data = new byte[length];
            is.read(data);
        }
        finally {
            is.close();
        }
        return data;
    }

    public static void setAuthorizedDelayed(boolean authorizedDelayed) {
        PlatformMessenger.debug("setDelayAuthorized " + authorizedDelayed);
        PlatformMessenger.authorizedDelayed = authorizedDelayed;
        if (!authorizedDelayed && mapQueueAuthorized.size() > 0) {
            PlatformMessenger.queueMessage(null, null);
        }
    }

    public static boolean isAuthorizedDelayed() {
        return authorizedDelayed;
    }

    private static class fakeContext
    extends ClientMessageContextImpl {
        private void log(String str) {
            if (System.getProperty("browser.route.all.external.stimuli.for.testing", "false").equalsIgnoreCase("true")) {
                System.err.println(str);
            }
            this.debug(str);
        }

        public fakeContext() {
            super("fakeContext", null);
        }

        public void deregisterBrowser() {
            this.log("deregisterBrowser");
        }

        public void displayBrowserMessage(String message) {
            this.log("displayBrowserMessage - " + message);
        }

        public boolean executeInBrowser(String javascript) {
            this.log("executeInBrowser - " + javascript);
            return false;
        }

        public Object getBrowserData(String key) {
            this.log("getBrowserData - " + key);
            return null;
        }

        public boolean sendBrowserMessage(String key, String op) {
            this.log("sendBrowserMessage - " + key + "/" + op);
            return false;
        }

        public boolean sendBrowserMessage(String key, String op, Map params) {
            this.log("sendBrowserMessage - " + key + "/" + op + "/" + params);
            return false;
        }

        public void setBrowserData(String key, Object value) {
            this.log("setBrowserData - " + key + "/" + value);
        }

        public boolean sendBrowserMessage(String key, String op, Collection params) {
            this.log("sendBrowserMessage - " + key + "/" + op + "/" + params);
            return false;
        }

        public void setTorrentURLHandler(ClientMessageContext.torrentURLHandler handler) {
            this.log("setTorrentURLHandler - " + handler);
        }
    }
}

