/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.util.ConstantsV3;
import com.aelitis.azureus.util.LoginInfoManager;
import com.aelitis.azureus.util.MapUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class PlatformConfigMessenger {
    public static final String LISTENER_ID = "config";
    public static final String SECTION_TYPE_BIGBROWSE = "browse";
    public static final String SECTION_TYPE_MINIBROWSE = "minibrowse";
    private static int iRPCVersion = 0;
    private static String DEFAULT_RPC_WHITELIST = "https?://" + ConstantsV3.URL_ADDRESS.replaceAll("\\.", "\\\\.") + ":?[0-9]*/" + ".*";
    private static String[] sURLWhiteList = new String[]{DEFAULT_RPC_WHITELIST};
    private static String playAfterURL = null;
    private static boolean sendStats = true;
    protected static List listBlack = Collections.EMPTY_LIST;
    protected static long buddySyncOnShareMinTime;
    private static boolean doUrlQOS;
    private static boolean platformLoginComplete;
    protected static List platformLoginCompleteListeners;

    public static void getBrowseSections(String sectionType, long maxDelayMS, final GetBrowseSectionsReplyListener replyListener) {
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, "get-browse-sections", new Object[]{"section-type", sectionType, "locale", Locale.getDefault().toString()}, maxDelayMS);
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void messageSent(PlatformMessage message) {
                replyListener.messageSent();
            }

            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                if (reply != null) {
                    List array = (List)reply.get("value");
                    Map[] newReply = new HashMap[array.size()];
                    for (int i = 0; i < newReply.length; ++i) {
                        newReply[i] = (Map)array.get(i);
                        String url = (String)newReply[i].get("url");
                        if (url == null || url.startsWith("http://")) continue;
                        url = ConstantsV3.URL_PREFIX + url;
                        url = url.indexOf(63) < 0 ? url + "?" : url + "&";
                        url = url + ConstantsV3.URL_SUFFIX;
                        newReply[i].put("url", url);
                    }
                    replyListener.replyReceived(newReply);
                } else {
                    replyListener.replyReceived(new Map[0]);
                }
            }
        };
        PlatformMessenger.queueMessage(message, listener);
    }

    public static void login(long maxDelayMS) {
        PlatformManager pm = PlatformManagerFactory.getPlatformManager();
        String azComputerID = "";
        try {
            azComputerID = pm.getAzComputerID();
        }
        catch (PlatformManagerException e) {
            // empty catch block
        }
        Object[] params = new Object[]{"version", "4.0.0.4", "locale", Locale.getDefault().toString(), "azCID", azComputerID, "vid", COConfigurationManager.getStringParameter("ID")};
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, "login", params, maxDelayMS);
        message.setRequiresAuthorizationNoCheck();
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                if (reply == null) {
                    return;
                }
                try {
                    List listURLs = (List)MapUtils.getMapObject(reply, "url-whitelist", null, List.class);
                    if (listURLs != null) {
                        String[] sNewWhiteList = new String[listURLs.size() + 1];
                        sNewWhiteList[0] = DEFAULT_RPC_WHITELIST;
                        for (int i = 0; i < listURLs.size(); ++i) {
                            String string = (String)listURLs.get(i);
                            PlatformMessenger.debug("v3.login: got whitelist of " + string);
                            sNewWhiteList[i + 1] = string;
                        }
                        PlatformConfigMessenger.access$102(sNewWhiteList);
                    }
                }
                catch (Exception e) {
                    Debug.out(e);
                }
                listBlack = MapUtils.getMapList(reply, "url-blacklist", Collections.EMPTY_LIST);
                try {
                    List listDomains = (List)MapUtils.getMapObject(reply, "tracker-domains", null, List.class);
                    if (listDomains != null) {
                        for (int i = 0; i < listDomains.size(); ++i) {
                            String s = (String)listDomains.get(i);
                            PlatformTorrentUtils.addPlatformHost(s);
                            PlatformMessenger.debug("v3.login: got tracker domain of " + s);
                        }
                    }
                }
                catch (Exception e) {
                    Debug.out(e);
                }
                try {
                    sendStats = MapUtils.getMapBoolean(reply, "send-stats", true);
                    doUrlQOS = MapUtils.getMapBoolean(reply, "do-url-qos", false);
                }
                catch (Exception e) {
                    // empty catch block
                }
                buddySyncOnShareMinTime = MapUtils.getMapLong(reply, "buddy-sync-on-share-min-time-secs", 60000L);
                try {
                    iRPCVersion = MapUtils.getMapInt(reply, "rpc-version", 0);
                    playAfterURL = MapUtils.getMapString(reply, "play-after-url", null);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
                Map mapUserInfo = MapUtils.getMapMap(reply, "user-info", null);
                if (mapUserInfo != null) {
                    LoginInfoManager.getInstance().setUserInfo(mapUserInfo);
                }
                platformLoginComplete = true;
                Object[] listeners = platformLoginCompleteListeners.toArray();
                platformLoginCompleteListeners = Collections.EMPTY_LIST;
                for (int i = 0; i < listeners.length; ++i) {
                    try {
                        PlatformLoginCompleteListener l = (PlatformLoginCompleteListener)listeners[i];
                        l.platformLoginComplete();
                        continue;
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                }
            }

            public void messageSent(PlatformMessage message) {
            }
        };
        PlatformMessenger.pushMessageNow(message, listener);
    }

    public static void sendUsageStats(Map stats, long timestamp, String version, PlatformMessengerListener l) {
        if (!sendStats) {
            return;
        }
        try {
            PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, "send-usage-stats2", new Object[]{"stats", stats, "version", version, "timestamp", new Long(timestamp), "ago-ms", new Long(SystemTime.getCurrentTime() - timestamp)}, 5000L);
            PlatformMessenger.queueMessage(message, l);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public static String[] getURLWhitelist() {
        return sURLWhiteList;
    }

    public static boolean urlCanRPC(String url) {
        return PlatformConfigMessenger.urlCanRPC(url, false);
    }

    public static boolean urlCanRPC(String url, boolean showDebug) {
        if (url == null) {
            Debug.out("URL null and should be blocked");
            return false;
        }
        if (Constants.isCVSVersion() && url.startsWith("file://")) {
            return true;
        }
        String[] whitelist = PlatformConfigMessenger.getURLWhitelist();
        for (int i = 0; i < whitelist.length; ++i) {
            if (!url.matches(whitelist[i])) continue;
            return true;
        }
        if (showDebug) {
            Debug.out("urlCanRPC: URL '" + url + "' " + " does not match one of the " + whitelist.length + " whitelist entries");
        }
        return false;
    }

    public static boolean isURLBlocked(String url) {
        if (url == null) {
            Debug.out("URL null and should be blocked");
            return true;
        }
        for (String blackListed : listBlack) {
            if (!url.matches(blackListed)) continue;
            Debug.out("URL '" + url + "' " + " is blocked by " + blackListed);
            return true;
        }
        return false;
    }

    public static int getRPCVersion() {
        return iRPCVersion;
    }

    public static String getPlayAfterURL() {
        return playAfterURL;
    }

    public static boolean allowSendStats() {
        return sendStats;
    }

    public static long getBuddySyncOnShareMinTimeSecs() {
        return buddySyncOnShareMinTime;
    }

    public static void setBuddySyncOnShareMinTimeSecs(long buddySyncOnShareMinTime) {
        PlatformConfigMessenger.buddySyncOnShareMinTime = buddySyncOnShareMinTime;
    }

    public static boolean doUrlQOS() {
        return doUrlQOS;
    }

    public static void addPlatformLoginCompleteListener(PlatformLoginCompleteListener l) {
        try {
            if (l == null) {
                return;
            }
            if (platformLoginComplete) {
                l.platformLoginComplete();
                return;
            }
            if (platformLoginCompleteListeners == Collections.EMPTY_LIST) {
                platformLoginCompleteListeners = new ArrayList(1);
            }
            platformLoginCompleteListeners.add(l);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    static /* synthetic */ String[] access$102(String[] x0) {
        sURLWhiteList = x0;
        return x0;
    }

    static {
        doUrlQOS = false;
        platformLoginComplete = false;
        platformLoginCompleteListeners = Collections.EMPTY_LIST;
    }

    public static interface GetBrowseSectionsReplyListener {
        public void messageSent();

        public void replyReceived(Map[] var1);
    }

    public static interface PlatformLoginCompleteListener {
        public void platformLoginComplete();
    }
}

