/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.util.AzpdFileAccess;
import com.aelitis.azureus.util.ConstantsV3;
import com.aelitis.azureus.util.DCAdManager;
import com.aelitis.azureus.util.JSONUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.util.encoders.Base64;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class PlatformDCAdManager {
    private static final int UNSENT_TIMEOUT = 604800000;
    public static String RPC_LISTENER_ID = "asxads";
    public static String OP_GETADVERT = "get-advert";
    public static String OP_SAVEIMPRESSIONS = "save-impressions";
    public static List unsentImpressions = new ArrayList();
    public static AEMonitor mon_unsentImpressions = new AEMonitor("unsavedImpressions");
    public static boolean DEBUG_ADS = false;
    private static int RESEND_DELAY = 600000;
    private static TimerEvent resendEvent;

    public static void getAdvert(final DownloadManager adEnabledDownload, long maxDelayMS, final GetAdvertDataReplyListener replyListener) {
        PlatformDCAdManager.debug("enter - PlatformDCDdManager.getAdvert");
        String contentHash = "";
        try {
            contentHash = adEnabledDownload.getTorrent().getHashWrapper().toBase32String();
        }
        catch (TOTorrentException te) {
            PlatformDCAdManager.debug("Failed to get currentHash", te);
            te.printStackTrace();
        }
        ArrayList<String> contentList = new ArrayList<String>();
        contentList.add(contentHash);
        List adList = PlatformDCAdManager.getExistingAds();
        HashMap<String, List> params = new HashMap<String, List>();
        params.put("hashes", contentList);
        params.put("ads", adList);
        PlatformMessage message = new PlatformMessage("AZMSG", RPC_LISTENER_ID, OP_GETADVERT, params, maxDelayMS);
        if (!PlatformDCAdManager.azpdFileFound(message)) {
            File f = PlatformDCAdManager.determineAzpdFileName(message);
            PlatformDCAdManager.saveTempAzpdFile(f);
        }
        PlatformMessenger.queueMessage(message, new PlatformMessengerListener(){

            public void messageSent(PlatformMessage message) {
                PlatformDCAdManager.debug("getAdvert - messageSent");
                if (replyListener != null) {
                    replyListener.messageSent();
                }
            }

            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                boolean success = false;
                try {
                    PlatformDCAdManager.debug("getAdvert - replyReceived");
                    PlatformDCAdManager.debug(replyType, message, reply);
                    if (reply != null) {
                        ArrayList<TOTorrent> adTorrents = new ArrayList<TOTorrent>();
                        List torrentsList = (List)reply.get("torrents");
                        if (torrentsList != null) {
                            for (int i = 0; i < torrentsList.size(); ++i) {
                                byte[] torrentBEncoded = Base64.decode((String)torrentsList.get(i));
                                try {
                                    TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedByteArray(torrentBEncoded);
                                    adTorrents.add(torrent);
                                    continue;
                                }
                                catch (TOTorrentException e) {
                                    Debug.out("PlatformDCAdManager.getAdvert - replyRecieved: " + e);
                                }
                            }
                        }
                        Map webParams = PlatformDCAdManager.saveResponseToAzpdFile(reply, message);
                        DCAdManager.addParmasToDownloadManager(adEnabledDownload, webParams);
                        success = true;
                        if (replyListener != null) {
                            replyListener.adsReceived(adTorrents, webParams);
                        }
                    }
                }
                catch (Exception e) {
                    Debug.out(e);
                }
                if (!success && replyListener != null) {
                    replyListener.replyReceived(replyType, reply);
                }
            }
        });
        PlatformDCAdManager.debug("leave - PlatformDCDdManager.getAdvert");
    }

    private static void saveTempAzpdFile(File azpdFile) {
        String content = PlatformDCAdManager.getTempAzpdTemplate();
        AzpdFileAccess.writeAzpdFile(azpdFile, content);
        PlatformDCAdManager.debug("temp data=_" + content + "_  to azpd file=" + azpdFile.getAbsolutePath());
    }

    private static String getTempAzpdTemplate() {
        return "{\"ad_hash\":[],\"playlist\":\"<ASX version=\\\"3.0\\\">\\n<ENTRY ClientSkip=\\\"yes\\\">\\n<TITLE>Default<\\/TITLE>\\n<PARAM NAME=\\\"Prebuffer\\\" VALUE=\\\"true\\\"\\/>\\n<REF HREF=\\\"<##-CONTENT-PATH-##>\\\"\\/>\\n<\\/ENTRY>\\n<\\/ASX>\"}";
    }

    private static Map saveResponseToAzpdFile(Map reply, PlatformMessage message) {
        HashMap<String, String> saveToFile = new HashMap<String, String>();
        saveToFile.putAll(reply);
        saveToFile.remove("torrents");
        if (saveToFile.get("Throwable") != null) {
            return PlatformDCAdManager.saveDefaultResponseToAzpdFile(message);
        }
        long currTime = System.currentTimeMillis();
        saveToFile.put("az-create-time", "" + currTime);
        if (saveToFile.get("az-expire-time") == null) {
            long expireTime = currTime + 604800000L;
            saveToFile.put("az-expire-time", "" + expireTime);
        }
        String s = JSONUtils.encodeToJSON(saveToFile);
        File file = PlatformDCAdManager.determineAzpdFileName(message);
        AzpdFileAccess.writeAzpdFile(file, s);
        PlatformDCAdManager.debug("data=_" + s + "_  to azpd file=" + file.getAbsolutePath());
        return JSONUtils.decodeJSON(s);
    }

    private static Map saveDefaultResponseToAzpdFile(PlatformMessage message) {
        File azpdFile = PlatformDCAdManager.determineAzpdFileName(message);
        PlatformDCAdManager.saveTempAzpdFile(azpdFile);
        PlatformDCAdManager.debug("using content-only template due to error.");
        try {
            Map webParams = AzpdFileAccess.readAzpdFileToMap(azpdFile);
            webParams.put("is-off-line", "true");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return new HashMap();
    }

    private static File determineAzpdFileName(PlatformMessage message) {
        List contentList;
        File azpdFile = AzpdFileAccess.getAzpdDir();
        String azpdFileNameBase = "no_file";
        Map requestParamMap = message.getParameters();
        if (requestParamMap != null && (contentList = (List)requestParamMap.get("hashes")) != null) {
            azpdFileNameBase = (String)contentList.get(0);
        }
        File file = new File(azpdFile, azpdFileNameBase + ".azpd");
        return file;
    }

    private static boolean azpdFileFound(PlatformMessage message) {
        File f = PlatformDCAdManager.determineAzpdFileName(message);
        return f.exists();
    }

    private static List getExistingAds() {
        DownloadManager[] existingAds = DCAdManager.getInstance().getAds(true);
        ArrayList adList = new ArrayList();
        for (int i = 0; i < existingAds.length; ++i) {
            DownloadManager dm = existingAds[i];
            try {
                TOTorrent torrent = dm.getTorrent();
                String hash = torrent.getHashWrapper().toBase32String();
                String adid = PlatformTorrentUtils.getAdId(torrent);
                HashMap<String, String> mapAd = new HashMap<String, String>();
                mapAd.put("hash", hash);
                adList.add(mapAd);
                continue;
            }
            catch (TOTorrentException te) {
                PlatformDCAdManager.debug("Failed while reading existing ads", te);
                te.printStackTrace();
            }
        }
        return adList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveImpression(String impressionUrl, long viewedOn, String contentHash, String torrentHash, String adHash, String thirdPartyImpressionUrl, long maxDelayMS) {
        try {
            HashMap<String, Object> ad = new HashMap<String, Object>();
            ad.put("tracking-id", impressionUrl);
            ad.put("viewed-on", new Long(viewedOn));
            ad.put("content-hash", contentHash);
            if (torrentHash != null) {
                ad.put("torrent-hash", torrentHash);
            }
            if (adHash != null) {
                ad.put("hash", adHash);
            }
            if (thirdPartyImpressionUrl != null) {
                ad.put("thirdPartyImp", thirdPartyImpressionUrl);
            }
            try {
                mon_unsentImpressions.enter();
                unsentImpressions.add(ad);
            }
            finally {
                mon_unsentImpressions.exit();
            }
            PlatformDCAdManager.saveUnsentImpressions();
            PlatformDCAdManager.sendUnsentImpressions(maxDelayMS);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendUnsentImpressions(long maxDelayMS) {
        List sendingImpressions;
        try {
            mon_unsentImpressions.enter();
            sendingImpressions = unsentImpressions;
            unsentImpressions = new ArrayList();
            PlatformDCAdManager.saveUnsentImpressions();
        }
        finally {
            mon_unsentImpressions.exit();
        }
        if (sendingImpressions.size() == 0) {
            return;
        }
        final List fSendingImpressions = sendingImpressions;
        HashMap<String, Object> ads = new HashMap<String, Object>();
        ads.put("ads", fSendingImpressions);
        ads.put("rpc-version", new Long(2L));
        try {
            PlatformDCAdManager.debug("sending " + fSendingImpressions.size() + " impressions");
            PlatformMessage message = new PlatformMessage("AZMSG", RPC_LISTENER_ID, OP_SAVEIMPRESSIONS, ads, maxDelayMS);
            PlatformMessenger.queueMessage(message, new PlatformMessengerListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                    if (!replyType.equals(PlatformMessenger.REPLY_RESULT)) {
                        PlatformDCAdManager.debug("sending " + fSendingImpressions + " impressions failed. " + reply);
                        try {
                            mon_unsentImpressions.enter();
                            unsentImpressions.addAll(fSendingImpressions);
                            PlatformDCAdManager._setupResendTimer();
                        }
                        finally {
                            mon_unsentImpressions.exit();
                        }
                        PlatformDCAdManager.saveUnsentImpressions();
                        return;
                    }
                    PlatformDCAdManager.debug("sending " + fSendingImpressions.size() + " impressions completed");
                }

                public void messageSent(PlatformMessage message) {
                }
            });
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    protected static void _setupResendTimer() {
        if (resendEvent != null) {
            resendEvent.cancel();
            resendEvent = null;
        }
        resendEvent = SimpleTimer.addEvent("resender", SystemTime.getOffsetTime(RESEND_DELAY), new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                PlatformDCAdManager.debug("resend impressions triggered");
                PlatformDCAdManager.sendUnsentImpressions(5000L);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveUnsentImpressions() {
        try {
            mon_unsentImpressions.enter();
            HashMap<String, List> map = new HashMap<String, List>();
            map.put("unsent", unsentImpressions);
            FileUtil.writeResilientConfigFile("unsentdata.config", map);
        }
        finally {
            mon_unsentImpressions.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadUnsentImpressions() {
        block8: {
            try {
                mon_unsentImpressions.enter();
                Map map = BDecoder.decodeStrings(FileUtil.readResilientConfigFile("unsentdata.config"));
                Object value = map.get("unsent");
                if (value instanceof List) {
                    unsentImpressions = (List)value;
                    Iterator iter = unsentImpressions.iterator();
                    while (iter.hasNext()) {
                        long viewedOn = 0L;
                        Map ad = (Map)iter.next();
                        try {
                            if (ad.containsKey("viewed-on")) {
                                viewedOn = (Long)ad.get("viewed-on");
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (SystemTime.getCurrentTime() - viewedOn <= 604800000L) continue;
                        iter.remove();
                        PlatformDCAdManager.debug("timing out impression " + ad.get("tracking-id"));
                    }
                    break block8;
                }
                unsentImpressions.clear();
            }
            finally {
                mon_unsentImpressions.exit();
            }
        }
    }

    public static void debug(String string) {
        PlatformDCAdManager.debug(string, null);
    }

    public static void debug(String string, Throwable e) {
        try {
            AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("v3.ads");
            diag_logger.log(string);
            if (e != null) {
                diag_logger.log(e);
                Debug.out(string, e);
            }
            if (ConstantsV3.DIAG_TO_STDOUT || DEBUG_ADS) {
                System.out.println(Thread.currentThread().getName() + "|ADS|" + System.currentTimeMillis() + "] " + string);
                if (e != null) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void debug(String replyType, PlatformMessage message, Map reply) {
        PlatformDCAdManager.debug("------ PlatformDCAdManager.getAdvert()  PlatformMessageListener.reply()  ------");
        PlatformDCAdManager.debug(replyType);
        PlatformDCAdManager.debug(message.toString());
        if (reply != null) {
            String wOrd = (String)reply.get("web_ord");
            String wAdId = (String)reply.get("web_ad_id");
            String playlist = (String)reply.get("playlist");
            PlatformDCAdManager.debug("web_ord: " + wOrd);
            PlatformDCAdManager.debug("web_ad_id: " + wAdId);
            PlatformDCAdManager.debug("playlist: " + playlist);
        }
        PlatformDCAdManager.debug("-------------------------------------------------------------------------------");
    }

    public static interface GetAdvertDataReplyListener {
        public void messageSent();

        public void adsReceived(List var1, Map var2);

        public void replyReceived(String var1, Map var2);
    }
}

