/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSocksProxy;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProxyLoginHandler;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelperFilterFactory;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.AESemaphore;

public class NetworkAdminSocksProxyImpl
implements NetworkAdminSocksProxy {
    private final String TARGET_HOST = "version.azureusplatform.com";
    private final int TARGET_PORT = 80;
    private String host;
    private String port;
    private String user;
    private String password;

    protected NetworkAdminSocksProxyImpl(String _host, String _port, String _user, String _password) {
        this.host = _host;
        this.port = _port;
        this.user = _user;
        this.password = _password;
    }

    protected boolean isConfigured() {
        return this.host.length() > 0;
    }

    public String getName() {
        return this.host + ":" + this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String[] getVersionsSupported() throws NetworkAdminException {
        NetworkAdminException failure = null;
        ArrayList<String> versions = new ArrayList<String>();
        try {
            this.testVersion("V4");
            versions.add("4");
        }
        catch (NetworkAdminException e) {
            failure = e;
        }
        try {
            this.testVersion("V4a");
            versions.add("4a");
        }
        catch (NetworkAdminException e) {
            failure = e;
        }
        try {
            this.testVersion("V5");
            versions.add("5");
        }
        catch (NetworkAdminException e) {
            failure = e;
        }
        if (versions.size() > 0) {
            return versions.toArray(new String[versions.size()]);
        }
        throw failure;
    }

    public String getString() {
        String res = this.getName();
        if (this.user.length() > 0) {
            res = res + " [auth=" + this.user + "]";
        }
        res = res + ", versions=";
        try {
            String[] versions = this.getVersionsSupported();
            for (int j = 0; j < versions.length; ++j) {
                res = res + (j == 0 ? "" : ",") + versions[j];
            }
        }
        catch (NetworkAdminException e) {
            res = res + "unknown (" + e.getLocalizedMessage() + ")";
        }
        return res;
    }

    protected void testVersion(final String version) throws NetworkAdminException {
        boolean RES_CONNECT_FAILED = false;
        boolean RES_SOCKS_FAILED = true;
        int RES_OK = 3;
        final AESemaphore sem = new AESemaphore("NetworkAdminSocksProxy:test");
        final int[] result = new int[]{0};
        final NetworkAdminException[] error = new NetworkAdminException[]{null};
        try {
            InetSocketAddress socks_address = new InetSocketAddress(InetAddress.getByName(this.host), Integer.parseInt(this.port));
            final InetSocketAddress target_address = new InetSocketAddress("version.azureusplatform.com", 80);
            TCPConnectionManager.ConnectListener connect_listener = new TCPConnectionManager.ConnectListener(){

                public void connectAttemptStarted() {
                }

                public void connectSuccess(SocketChannel channel) {
                    final TCPTransportImpl transport = new TCPTransportImpl(new ProtocolEndpointTCP(target_address), false, false, null);
                    transport.setFilter(TCPTransportHelperFilterFactory.createTransparentFilter(channel));
                    new ProxyLoginHandler(transport, target_address, new ProxyLoginHandler.ProxyListener(){

                        public void connectSuccess() {
                            transport.close("Done");
                            result[0] = 3;
                            sem.release();
                        }

                        public void connectFailure(Throwable failure_msg) {
                            transport.close("Proxy login failed");
                            result[0] = 1;
                            error[0] = new NetworkAdminException("Proxy connect failed", failure_msg);
                            sem.release();
                        }
                    }, version, NetworkAdminSocksProxyImpl.this.user, NetworkAdminSocksProxyImpl.this.password);
                }

                public void connectFailure(Throwable failure_msg) {
                    result[0] = 0;
                    error[0] = new NetworkAdminException("Connect failed", failure_msg);
                    sem.release();
                }
            };
            TCPNetworkManager.getSingleton().getConnectDisconnectManager().requestNewConnection(socks_address, connect_listener, 2);
        }
        catch (Throwable e) {
            result[0] = 0;
            error[0] = new NetworkAdminException("Connect failed", e);
            sem.release();
        }
        if (!sem.reserve(10000L)) {
            result[0] = 0;
            error[0] = new NetworkAdminException("Connect timeout");
        }
        if (result[0] != 3) {
            throw error[0];
        }
    }
}

