/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTestScheduledTest;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTestScheduledTestListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTestScheduler;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSpeedTesterResult;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminSpeedTestScheduledTestImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminSpeedTesterBTImpl;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;

public class NetworkAdminSpeedTestSchedulerImpl
implements NetworkAdminSpeedTestScheduler {
    private static NetworkAdminSpeedTestSchedulerImpl instance = null;
    private NetworkAdminSpeedTestScheduledTestImpl currentTest = null;
    private PluginInterface plugin;

    public static synchronized NetworkAdminSpeedTestScheduler getInstance() {
        if (instance == null) {
            instance = new NetworkAdminSpeedTestSchedulerImpl();
        }
        return instance;
    }

    private NetworkAdminSpeedTestSchedulerImpl() {
        AzureusCore ac = AzureusCoreFactory.getSingleton();
        PluginManager pm = ac.getPluginManager();
        this.plugin = pm.getDefaultPluginInterface();
    }

    public void initialise() {
        NetworkAdminSpeedTesterBTImpl.startUp(this.plugin);
    }

    public synchronized NetworkAdminSpeedTestScheduledTest getCurrentTest() {
        return this.currentTest;
    }

    public synchronized NetworkAdminSpeedTestScheduledTest scheduleTest(int type) throws NetworkAdminException {
        if (this.currentTest != null) {
            throw new NetworkAdminException("Test already scheduled");
        }
        if (type != 1) {
            throw new NetworkAdminException("Unknown test type");
        }
        this.currentTest = new NetworkAdminSpeedTestScheduledTestImpl(this.plugin, new NetworkAdminSpeedTesterBTImpl(this.plugin));
        this.currentTest.getTester().setMode(type);
        this.currentTest.addListener(new NetworkAdminSpeedTestScheduledTestListener(){

            public void stage(NetworkAdminSpeedTestScheduledTest test, String step) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void complete(NetworkAdminSpeedTestScheduledTest test) {
                NetworkAdminSpeedTestSchedulerImpl networkAdminSpeedTestSchedulerImpl = NetworkAdminSpeedTestSchedulerImpl.this;
                synchronized (networkAdminSpeedTestSchedulerImpl) {
                    NetworkAdminSpeedTestSchedulerImpl.this.currentTest = null;
                }
            }
        });
        return this.currentTest;
    }

    public NetworkAdminSpeedTesterResult getLastResult(int type) {
        if (type == 1) {
            return NetworkAdminSpeedTesterBTImpl.getLastResult();
        }
        Debug.out("Unknown test type");
        return null;
    }
}

