/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.control.impl;

import com.aelitis.azureus.core.peermanager.control.PeerControlInstance;
import com.aelitis.azureus.core.peermanager.control.SpeedTokenDispenser;
import com.aelitis.azureus.core.peermanager.control.impl.PeerControlSchedulerImpl;
import com.aelitis.azureus.core.peermanager.control.impl.SpeedTokenDispenserBasic;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class PeerControlSchedulerBasic
extends PeerControlSchedulerImpl
implements AzureusCoreStatsProvider {
    private Random random = new Random();
    private Map instance_map = new HashMap();
    private List pending_registrations = new ArrayList();
    private volatile boolean registrations_changed;
    private volatile long latest_time;
    protected AEMonitor this_mon = new AEMonitor("PeerControlSchedulerBasic");
    private final SpeedTokenDispenserBasic tokenDispenser = new SpeedTokenDispenserBasic();
    private long last_lag_log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule() {
        this.latest_time = SystemTime.getCurrentTime();
        SystemTime.registerConsumer(new SystemTime.TickConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void consume(long time) {
                PeerControlSchedulerBasic peerControlSchedulerBasic = PeerControlSchedulerBasic.this;
                synchronized (peerControlSchedulerBasic) {
                    PeerControlSchedulerBasic.this.latest_time = time;
                    PeerControlSchedulerBasic.this.notify();
                }
            }
        });
        LinkedList instances = new LinkedList();
        long latest_time_used = 0L;
        long tick_count = 0L;
        long last_stats_time = this.latest_time;
        while (true) {
            Object it;
            if (this.registrations_changed) {
                try {
                    this.this_mon.enter();
                    it = instances.iterator();
                    while (it.hasNext()) {
                        if (!((instanceWrapper)it.next()).isUnregistered()) continue;
                        it.remove();
                    }
                    for (int i = 0; i < this.pending_registrations.size(); ++i) {
                        instances.add(this.pending_registrations.get(i));
                    }
                    this.pending_registrations.clear();
                    this.registrations_changed = false;
                }
                finally {
                    this.this_mon.exit();
                }
            }
            for (instanceWrapper inst : instances) {
                long target = inst.getNextTick();
                long diff = target - latest_time_used;
                if (diff > 0L && diff <= (long)SCHEDULE_PERIOD_MILLIS) continue;
                ++tick_count;
                inst.schedule(this.latest_time);
                ++this.schedule_count;
                long new_target = target + (long)SCHEDULE_PERIOD_MILLIS;
                diff = new_target - latest_time_used;
                if (diff <= 0L || diff > (long)SCHEDULE_PERIOD_MILLIS) {
                    new_target = latest_time_used + (long)SCHEDULE_PERIOD_MILLIS;
                }
                inst.setNextTick(new_target);
            }
            it = this;
            synchronized (it) {
                if (this.latest_time == latest_time_used) {
                    ++this.wait_count;
                    try {
                        long wait_start = SystemTime.getHighPrecisionCounter();
                        this.wait();
                        long wait_time = SystemTime.getHighPrecisionCounter() - wait_start;
                        this.total_wait_time += wait_time;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                } else {
                    ++this.yield_count;
                    Thread.yield();
                }
                latest_time_used = this.latest_time;
            }
            long stats_diff = latest_time_used - last_stats_time;
            if (stats_diff <= 10000L) continue;
            last_stats_time = latest_time_used;
            tick_count = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(PeerControlInstance instance) {
        instanceWrapper wrapper2 = new instanceWrapper(instance);
        wrapper2.setNextTick(this.latest_time + (long)this.random.nextInt(SCHEDULE_PERIOD_MILLIS));
        try {
            this.this_mon.enter();
            HashMap<PeerControlInstance, instanceWrapper> new_map = new HashMap<PeerControlInstance, instanceWrapper>(this.instance_map);
            new_map.put(instance, wrapper2);
            this.instance_map = new_map;
            this.pending_registrations.add(wrapper2);
            this.registrations_changed = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(PeerControlInstance instance) {
        try {
            this.this_mon.enter();
            HashMap new_map = new HashMap(this.instance_map);
            instanceWrapper wrapper2 = (instanceWrapper)new_map.remove(instance);
            if (wrapper2 == null) {
                Debug.out("instance wrapper not found");
                return;
            }
            wrapper2.unregister();
            this.instance_map = new_map;
            this.registrations_changed = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public SpeedTokenDispenser getSpeedTokenDispenser() {
        return this.tokenDispenser;
    }

    public void updateScheduleOrdering() {
    }

    protected class instanceWrapper {
        private PeerControlInstance instance;
        private boolean unregistered;
        private long next_tick;
        private long last_schedule;

        protected instanceWrapper(PeerControlInstance _instance) {
            this.instance = _instance;
        }

        protected void unregister() {
            this.unregistered = true;
        }

        protected boolean isUnregistered() {
            return this.unregistered;
        }

        protected void setNextTick(long t) {
            this.next_tick = t;
        }

        protected long getNextTick() {
            return this.next_tick;
        }

        protected void schedule(long now) {
            if (this.last_schedule > 0L && now - this.last_schedule > 1000L && now - PeerControlSchedulerBasic.this.last_lag_log > 1000L) {
                PeerControlSchedulerBasic.this.last_lag_log = now;
                System.out.println("Scheduling lagging: " + (now - this.last_schedule));
            }
            this.last_schedule = now;
            try {
                this.instance.schedule();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }
}

