/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.speedmanager.SpeedManagerLimitEstimate;

public class SMConst {
    public static final int START_DOWNLOAD_RATE_MAX = 61440;
    public static final int START_UPLOAD_RATE_MAX = 30720;
    public static final int MIN_UPLOAD_BYTES_PER_SEC = 5120;
    public static final int MIN_DOWNLOAD_BYTES_PER_SEC = 20480;
    public static final int RATE_UNLIMITED = 0;

    private SMConst() {
    }

    public static int checkForMinUploadValue(int rateBytesPerSec) {
        if (rateBytesPerSec < 5120) {
            return 5120;
        }
        return rateBytesPerSec;
    }

    public static int checkForMinDownloadValue(int rateBytesPerSec) {
        if (rateBytesPerSec < 20480) {
            return 20480;
        }
        return rateBytesPerSec;
    }

    public static int calculateMinUpload(int maxBytesPerSec) {
        int min = maxBytesPerSec / 10;
        return SMConst.checkForMinUploadValue(min);
    }

    public static int calculateMinDownload(int maxBytesPerSec) {
        int min = maxBytesPerSec / 10;
        return SMConst.checkForMinDownloadValue(min);
    }

    public static SpeedManagerLimitEstimate filterEstimate(SpeedManagerLimitEstimate estimate, int startValue) {
        int estBytesPerSec = SMConst.filterLimit(estimate.getBytesPerSec(), startValue);
        return new FilteredLimitEstimate(estBytesPerSec, estimate.getEstimateType(), estimate.getMetricRating(), estimate.getString());
    }

    public static int filterLimit(int bytesPerSec, int startValue) {
        int retVal = Math.max(bytesPerSec, startValue);
        if (bytesPerSec == 0) {
            return bytesPerSec;
        }
        return retVal;
    }

    static class FilteredLimitEstimate
    implements SpeedManagerLimitEstimate {
        int bytesPerSec;
        float type;
        float metric;
        String name;

        public FilteredLimitEstimate(int _bytesPerSec, float _type, float _metric, String _name) {
            this.bytesPerSec = _bytesPerSec;
            this.type = _type;
            this.metric = _metric;
            this.name = _name;
        }

        public int getBytesPerSec() {
            return this.bytesPerSec;
        }

        public float getEstimateType() {
            return this.type;
        }

        public float getMetricRating() {
            return this.metric;
        }

        public int[][] getSegments() {
            return new int[0][];
        }

        public String getString() {
            return this.name;
        }
    }
}

