/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionManager;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;

public class SubscriptionUtils {
    public static SubscriptionDownloadDetails[] getAllCachedDownloadDetails() {
        List dms = AzureusCoreFactory.getSingleton().getGlobalManager().getDownloadManagers();
        ArrayList<SubscriptionDownloadDetails> result = new ArrayList<SubscriptionDownloadDetails>();
        SubscriptionManager sub_man = SubscriptionManagerFactory.getSingleton();
        for (int i = 0; i < dms.size(); ++i) {
            DownloadManager dm = (DownloadManager)dms.get(i);
            TOTorrent torrent = dm.getTorrent();
            if (torrent == null) continue;
            try {
                Subscription[] subs = sub_man.getKnownSubscriptions(torrent.getHash());
                if (subs == null || subs.length <= 0) continue;
                result.add(new SubscriptionDownloadDetails(dm, subs));
                continue;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return result.toArray(new SubscriptionDownloadDetails[result.size()]);
    }

    public static class SubscriptionDownloadDetails {
        private DownloadManager download;
        private Subscription[] subscriptions;

        protected SubscriptionDownloadDetails(DownloadManager dm, Subscription[] subs) {
            this.download = dm;
            this.subscriptions = subs;
        }

        public DownloadManager getDownload() {
            return this.download;
        }

        public Subscription[] getSubscriptions() {
            return this.subscriptions;
        }
    }
}

