/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CopyOnWriteSet {
    private volatile Set set = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object o) {
        Set set = this.set;
        synchronized (set) {
            HashSet<Object> new_set = new HashSet<Object>(this.set);
            new_set.add(o);
            this.set = new_set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        Set set = this.set;
        synchronized (set) {
            HashSet new_set = new HashSet(this.set);
            boolean res = new_set.remove(o);
            this.set = new_set;
            return res;
        }
    }

    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    public int size() {
        return this.set.size();
    }

    public Iterator iterator() {
        return new CopyOnWriteSetIterator(this.set.iterator());
    }

    private class CopyOnWriteSetIterator
    implements Iterator {
        private Iterator it;
        private Object last;

        protected CopyOnWriteSetIterator(Iterator _it) {
            this.it = _it;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            this.last = this.it.next();
            return this.last;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException("next has not been called!");
            }
            CopyOnWriteSet.this.remove(this.last);
        }
    }
}

