/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.versioncheck;

import com.aelitis.azureus.core.versioncheck.VersionCheckClientUDPReply;
import com.aelitis.azureus.core.versioncheck.VersionCheckClientUDPRequest;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketReply;
import com.aelitis.net.udp.uc.PRUDPPacketReplyDecoder;
import com.aelitis.net.udp.uc.PRUDPPacketRequest;
import com.aelitis.net.udp.uc.PRUDPPacketRequestDecoder;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;

public class VersionCheckClientUDPCodecs {
    public static final int ACT_VERSION_REQUEST = 32;
    public static final int ACT_VERSION_REPLY = 33;
    private static boolean registered = false;

    public static void registerCodecs() {
        if (registered) {
            return;
        }
        registered = true;
        PRUDPPacketReplyDecoder reply_decoder = new PRUDPPacketReplyDecoder(){

            public PRUDPPacketReply decode(PRUDPPacketHandler handler, InetSocketAddress originator, DataInputStream is, int action, int transaction_id) throws IOException {
                switch (action) {
                    case 33: {
                        return new VersionCheckClientUDPReply(is, transaction_id);
                    }
                }
                throw new IOException("Unrecognised action '" + action + "'");
            }
        };
        HashMap<Integer, 1> reply_decoders = new HashMap<Integer, 1>();
        reply_decoders.put(new Integer(33), reply_decoder);
        PRUDPPacketReply.registerDecoders(reply_decoders);
        PRUDPPacketRequestDecoder request_decoder = new PRUDPPacketRequestDecoder(){

            public PRUDPPacketRequest decode(PRUDPPacketHandler handler, DataInputStream is, long connection_id, int action, int transaction_id) throws IOException {
                switch (action) {
                    case 32: {
                        return new VersionCheckClientUDPRequest(is, connection_id, transaction_id);
                    }
                }
                throw new IOException("unsupported request type");
            }
        };
        HashMap<Integer, 2> request_decoders = new HashMap<Integer, 2>();
        request_decoders.put(new Integer(32), request_decoder);
        PRUDPPacketRequest.registerDecoders(request_decoders);
    }
}

