/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.net.buddy.swt;

import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginAZ2;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginAZ2ChatListener;
import com.aelitis.azureus.plugins.net.buddy.BuddyPluginBuddy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class BuddyPluginViewChat
implements BuddyPluginAZ2ChatListener {
    private BuddyPlugin plugin;
    private BuddyPluginAZ2.chatInstance chat;
    private LocaleUtilities lu;
    private Shell shell;
    private StyledText log;
    private Table buddy_table;
    private List participants = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BuddyPluginViewChat(BuddyPlugin _plugin, Display _display, BuddyPluginAZ2.chatInstance _chat) {
        this.plugin = _plugin;
        this.chat = _chat;
        this.lu = this.plugin.getPluginInterface().getUtilities().getLocaleUtilities();
        this.shell = new Shell(_display, 3312);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                BuddyPluginViewChat.this.closed();
            }
        });
        this.shell.setText(this.lu.getLocalisedMessageText("azbuddy.chat.title"));
        Utils.setShellIcon(this.shell);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.shell.setLayout((Layout)layout);
        GridData grid_data = new GridData(1808);
        this.shell.setLayoutData((Object)grid_data);
        this.log = new StyledText((Composite)this.shell, 526920);
        grid_data = new GridData(1808);
        grid_data.horizontalSpan = 1;
        grid_data.horizontalIndent = 4;
        grid_data.widthHint = 300;
        grid_data.heightHint = 400;
        this.log.setLayoutData((Object)grid_data);
        this.log.setIndent(4);
        this.log.setEditable(false);
        Composite rhs = new Composite((Composite)this.shell, 0);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        rhs.setLayout((Layout)layout);
        grid_data = new GridData(1808);
        grid_data.widthHint = 150;
        rhs.setLayoutData((Object)grid_data);
        this.buddy_table = new Table(rhs, 268503042);
        String[] headers = new String[]{"azbuddy.ui.table.name"};
        int[] sizes = new int[]{150};
        int[] aligns = new int[]{16384};
        for (int i = 0; i < headers.length; ++i) {
            TableColumn tc = new TableColumn(this.buddy_table, aligns[i]);
            tc.setWidth(sizes[i]);
            Messages.setLanguageText((Widget)tc, headers[i]);
        }
        this.buddy_table.setHeaderVisible(true);
        grid_data = new GridData(1808);
        grid_data.heightHint = this.buddy_table.getHeaderHeight() * 3;
        this.buddy_table.setLayoutData((Object)grid_data);
        this.buddy_table.addListener(36, new Listener(){

            public void handleEvent(Event event2) {
                TableItem item = (TableItem)event2.item;
                int index = BuddyPluginViewChat.this.buddy_table.indexOf(item);
                if (index < 0 || index >= BuddyPluginViewChat.this.participants.size()) {
                    return;
                }
                BuddyPluginAZ2.chatParticipant participant = (BuddyPluginAZ2.chatParticipant)BuddyPluginViewChat.this.participants.get(index);
                BuddyPluginBuddy buddy = participant.getBuddy();
                if (buddy == null) {
                    item.setForeground(0, Colors.red);
                } else if (buddy.isOnline(false)) {
                    item.setForeground(0, Colors.black);
                } else {
                    item.setForeground(0, Colors.grey);
                }
                item.setText(0, participant.getName());
            }
        });
        final Text text = new Text((Composite)this.shell, 2626);
        grid_data = new GridData(768);
        grid_data.horizontalSpan = 2;
        grid_data.heightHint = 50;
        text.setLayoutData((Object)grid_data);
        text.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    e.doit = false;
                    BuddyPluginViewChat.this.sendMessage(text.getText());
                    text.setText("");
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        text.setFocus();
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    BuddyPluginViewChat.this.close();
                }
            }
        });
        BuddyPluginAZ2.chatParticipant[] existing_participants = this.chat.getParticipants();
        List list = this.participants;
        synchronized (list) {
            this.participants.addAll(Arrays.asList(existing_participants));
        }
        this.updateTable(false);
        BuddyPluginAZ2.chatMessage[] history = this.chat.getHistory();
        for (int i = 0; i < history.length; ++i) {
            this.logChatMessage(history[i].getNickName(), Colors.blue, history[i].getMessage());
        }
        this.chat.addListener(this);
        this.shell.pack();
        Utils.createURLDropTarget((Composite)this.shell, text);
        Utils.centreWindow(this.shell);
        this.shell.open();
    }

    protected void updateTable(boolean async) {
        if (async) {
            if (!this.buddy_table.isDisposed()) {
                this.buddy_table.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (BuddyPluginViewChat.this.buddy_table.isDisposed()) {
                            return;
                        }
                        BuddyPluginViewChat.this.updateTable(false);
                    }
                });
            }
        } else {
            this.buddy_table.setItemCount(this.participants.size());
            this.buddy_table.clearAll();
            this.buddy_table.redraw();
        }
    }

    protected void close() {
        this.shell.dispose();
    }

    protected void closed() {
        this.chat.removeListener(this);
        this.chat.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void participantAdded(BuddyPluginAZ2.chatParticipant participant) {
        List list = this.participants;
        synchronized (list) {
            this.participants.add(participant);
        }
        this.updateTable(true);
    }

    public void participantChanged(BuddyPluginAZ2.chatParticipant participant) {
        this.updateTable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void participantRemoved(BuddyPluginAZ2.chatParticipant participant) {
        List list = this.participants;
        synchronized (list) {
            this.participants.remove(participant);
        }
        this.updateTable(true);
    }

    protected void sendMessage(String text) {
        HashMap<String, byte[]> msg = new HashMap<String, byte[]>();
        try {
            msg.put("line", text.getBytes("UTF-8"));
        }
        catch (Throwable e) {
            msg.put("line", text.getBytes());
        }
        this.logChatMessage(this.plugin.getNickname(), Colors.green, msg);
        this.chat.sendMessage(msg);
    }

    public void messageReceived(final BuddyPluginAZ2.chatParticipant participant, final Map msg) {
        if (!this.log.isDisposed()) {
            this.log.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (BuddyPluginViewChat.this.log.isDisposed()) {
                        return;
                    }
                    try {
                        BuddyPluginViewChat.this.logChatMessage(participant.getName(), Colors.blue, msg);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            });
        }
    }

    protected void logChatMessage(String buddy_name, Color colour, Map map) {
        String msg;
        byte[] line = (byte[])map.get("line");
        try {
            msg = new String(line, "UTF-8");
        }
        catch (Throwable e) {
            msg = new String(line);
        }
        if (buddy_name.length() > 32) {
            buddy_name = buddy_name.substring(0, 16) + "...";
        }
        int start = this.log.getText().length();
        if (msg.startsWith("/me")) {
            msg = msg.substring(3).trim();
            String me = "* " + buddy_name + " " + msg;
            this.log.append(me);
            if (colour != Colors.black) {
                StyleRange styleRange = new StyleRange();
                styleRange.start = start;
                styleRange.length = me.length();
                styleRange.foreground = colour;
                this.log.setStyleRange(styleRange);
            }
            this.log.append("\n");
        } else {
            String says = this.lu.getLocalisedMessageText("azbuddy.chat.says", new String[]{buddy_name}) + "\n";
            this.log.append(says);
            if (colour != Colors.black) {
                StyleRange styleRange = new StyleRange();
                styleRange.start = start;
                styleRange.length = says.length();
                styleRange.foreground = colour;
                this.log.setStyleRange(styleRange);
            }
            this.log.append(msg + "\n");
        }
        this.log.setSelection(this.log.getText().length());
    }
}

