/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.selectedcontent;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfo;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.HashWrapper;

public class SelectedContent
implements ISelectedContent {
    private String hash;
    private DownloadManager dm;
    private String displayName;
    private DownloadUrlInfo downloadInfo;

    public SelectedContent(DownloadManager dm) throws Exception {
        this.setDM(dm);
        this.setHash(dm.getTorrent().getHashWrapper().toBase32String());
        this.setDisplayName(dm.getDisplayName());
    }

    public SelectedContent(String hash, String displayName) {
        this.hash = hash;
        this.displayName = displayName;
    }

    public SelectedContent() {
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public DownloadManager getDM() {
        if (this.dm == null && this.hash != null) {
            GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
            return gm.getDownloadManager(new HashWrapper(Base32.decode(this.hash)));
        }
        return this.dm;
    }

    public void setDM(DownloadManager dm) {
        this.dm = dm;
        if (this.dm != null) {
            try {
                this.hash = this.dm.getTorrent().getHashWrapper().toBase32String();
            }
            catch (Exception e) {
                this.hash = null;
            }
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public DownloadUrlInfo getDownloadInfo() {
        return this.downloadInfo;
    }

    public void setDownloadInfo(DownloadUrlInfo info) {
        this.downloadInfo = info;
    }
}

