/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt;

import com.aelitis.azureus.launcher.Launcher;
import com.aelitis.azureus.ui.swt.Initializer;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Sleak {
    Display display;
    Shell shell;
    List list;
    Canvas canvas;
    Button start;
    Button stop;
    Button check;
    Text text;
    Text label;
    Object[] oldObjects = new Object[0];
    Error[] oldErrors = new Error[0];
    Object[] objects = new Object[0];
    Error[] errors = new Error[0];
    Map all = new HashMap();
    ArrayList oldNonResources = new ArrayList();

    public void open() {
        this.display = Display.getCurrent();
        this.shell = new Shell(this.display);
        this.shell.setText("S-Leak");
        this.list = new List((Composite)this.shell, 2560);
        this.list.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                Sleak.this.refreshObject();
            }
        });
        this.text = new Text((Composite)this.shell, 2816);
        this.canvas = new Canvas((Composite)this.shell, 2048);
        this.canvas.addListener(9, new Listener(){

            public void handleEvent(Event event2) {
                Sleak.this.paintCanvas(event2);
            }
        });
        this.check = new Button((Composite)this.shell, 32);
        this.check.setText("Stack");
        this.check.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Sleak.this.toggleStackTrace();
            }
        });
        this.start = new Button((Composite)this.shell, 8);
        this.start.setText("Snap");
        this.start.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                Sleak.this.refreshAll();
            }
        });
        this.stop = new Button((Composite)this.shell, 8);
        this.stop.setText("Diff");
        this.stop.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                Sleak.this.refreshDifference();
            }
        });
        this.label = new Text((Composite)this.shell, 2058);
        this.label.setText("0 object(s)");
        this.shell.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                Sleak.this.layout();
            }
        });
        this.check.setSelection(false);
        this.text.setVisible(false);
        Point size = this.shell.getSize();
        this.shell.setSize(size.x / 2, size.y / 2);
        this.shell.open();
    }

    void refreshLabel() {
        int colors = 0;
        int cursors = 0;
        int fonts = 0;
        int gcs = 0;
        int images = 0;
        int regions = 0;
        int others = 0;
        int composites = 0;
        int labels = 0;
        for (int i = 0; i < this.objects.length; ++i) {
            Object object = this.objects[i];
            if (object instanceof Color) {
                ++colors;
                continue;
            }
            if (object instanceof Cursor) {
                ++cursors;
                continue;
            }
            if (object instanceof Font) {
                ++fonts;
                continue;
            }
            if (object instanceof GC) {
                ++gcs;
                continue;
            }
            if (object instanceof Image) {
                ++images;
                continue;
            }
            if (object instanceof Region) {
                ++regions;
                continue;
            }
            if (object instanceof Composite) {
                ++composites;
                continue;
            }
            if (object instanceof Label) {
                ++labels;
                continue;
            }
            ++others;
        }
        String string = "";
        if (colors != 0) {
            string = string + colors + " Color(s)\n";
        }
        if (cursors != 0) {
            string = string + cursors + " Cursor(s)\n";
        }
        if (fonts != 0) {
            string = string + fonts + " Font(s)\n";
        }
        if (gcs != 0) {
            string = string + gcs + " GC(s)\n";
        }
        if (images != 0) {
            string = string + images + " Image(s)\n";
        }
        if (composites != 0) {
            string = string + composites + " composite(s)\n";
        }
        if (labels != 0) {
            string = string + labels + " label(s)\n";
        }
        if (others != 0) {
            string = string + others + " Other(s)\n";
        }
        if (string.length() != 0) {
            string = string.substring(0, string.length() - 1);
        }
        this.label.setText(string);
    }

    void refreshDifference() {
        DeviceData info = this.display.getDeviceData();
        if (!info.tracking) {
            MessageBox dialog = new MessageBox(this.shell, 40);
            dialog.setText(this.shell.getText());
            dialog.setMessage("Warning: Device is not tracking resource allocation");
            dialog.open();
        }
        Object[] newObjects = info.objects;
        Error[] newErrors = info.errors;
        Object[] diffObjects = new Object[newObjects.length];
        Error[] diffErrors = new Error[newErrors.length];
        int countResourceType = 0;
        for (int i = 0; i < newObjects.length; ++i) {
            int index;
            for (index = 0; index < this.oldObjects.length && newObjects[i] != this.oldObjects[index]; ++index) {
            }
            if (index != this.oldObjects.length) continue;
            diffObjects[countResourceType] = newObjects[i];
            diffErrors[countResourceType] = newErrors[i];
            ++countResourceType;
        }
        Shell[] shells = this.display.getShells();
        ArrayList nonResourceList = new ArrayList();
        for (int i = 0; i < shells.length; ++i) {
            Shell shell = shells[i];
            if (shell == this.shell) continue;
            this.buildObjectList((Control)shell, nonResourceList);
        }
        this.oldNonResources = nonResourceList;
        Object[] nonResources = nonResourceList.toArray();
        int countNonResources = nonResources.length;
        int total = countResourceType + countNonResources;
        this.objects = new Object[total];
        this.errors = new Error[total];
        System.arraycopy(diffObjects, 0, this.objects, 0, countResourceType);
        System.arraycopy(diffErrors, 0, this.errors, 0, countResourceType);
        System.arraycopy(nonResources, 0, this.objects, countResourceType, countNonResources);
        this.list.removeAll();
        this.text.setText("");
        this.canvas.redraw();
        for (int i = 0; i < this.objects.length; ++i) {
            this.list.add(this.objectName(this.objects[i]));
        }
        System.out.println(countResourceType);
        this.refreshLabel();
        this.layout();
    }

    private void buildObjectList(Control control, ArrayList list) {
        if (!this.oldNonResources.contains(control)) {
            list.add(control);
        }
        if (control instanceof Composite) {
            Composite c = (Composite)control;
            Control[] children = c.getChildren();
            for (int i = 0; i < children.length; ++i) {
                Control control2 = children[i];
                this.buildObjectList(control2, list);
            }
        }
    }

    String objectName(Object object) {
        Date timeAdded = (Date)this.all.get(object);
        if (timeAdded == null) {
            timeAdded = new Date();
            this.all.put(object, timeAdded);
        }
        String string = timeAdded + "] " + object.toString();
        if (object instanceof Resource) {
            return string;
        }
        int index = string.indexOf(" {");
        if (index == -1) {
            return string;
        }
        string = string.substring(0, index);
        if (object instanceof Composite) {
            Control[] children = ((Composite)object).getChildren();
            string = string + ": " + children.length + " kids";
        }
        return string;
    }

    void toggleStackTrace() {
        this.refreshObject();
        this.layout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintCanvas(Event event2) {
        this.canvas.setCursor(null);
        int index = this.list.getSelectionIndex();
        if (index == -1) {
            return;
        }
        GC gc = event2.gc;
        Object object = this.objects[index];
        if (object instanceof Color) {
            if (((Color)object).isDisposed()) {
                gc.drawString("Color disposed", 0, 0);
                return;
            }
            gc.setBackground((Color)object);
            gc.fillRectangle(this.canvas.getClientArea());
            return;
        }
        if (object instanceof Cursor) {
            if (((Cursor)object).isDisposed()) {
                gc.drawString("Cursor disposed", 0, 0);
                return;
            }
            this.canvas.setCursor((Cursor)object);
            return;
        }
        if (object instanceof Font) {
            if (((Font)object).isDisposed()) {
                gc.drawString("Font disposed", 0, 0);
                return;
            }
            gc.setFont((Font)object);
            FontData[] array = gc.getFont().getFontData();
            String string = "";
            String lf = this.text.getLineDelimiter();
            for (int i = 0; i < array.length; ++i) {
                FontData data = array[i];
                String style = "NORMAL";
                int bits = data.getStyle();
                if (bits != 0) {
                    if ((bits & 1) != 0) {
                        style = "BOLD ";
                    }
                    if ((bits & 2) != 0) {
                        style = style + "ITALIC";
                    }
                }
                string = string + data.getName() + " " + data.getHeight() + " " + style + lf;
            }
            gc.drawString(string, 0, 0);
            return;
        }
        if (object instanceof Image) {
            if (((Image)object).isDisposed()) {
                gc.drawString("Image disposed", 0, 0);
                return;
            }
            Image image = (Image)object;
            gc.drawString(image.getBounds().toString(), 0, 0);
            gc.drawImage(image, 0, 15);
            return;
        }
        if (object instanceof Region) {
            if (((Region)object).isDisposed()) {
                return;
            }
            String string = ((Region)object).getBounds().toString();
            gc.drawString(string, 0, 0);
            return;
        }
        if (object instanceof Control) {
            Object data;
            Control control = (Control)object;
            if (control.isDisposed()) {
                return;
            }
            Rectangle bounds = control.getBounds();
            gc.drawString(object.toString(), 0, 0);
            gc.drawString(bounds.toString(), 0, 20);
            if (object instanceof Widget && (data = ((Widget)object).getData("sleak")) != null) {
                gc.drawString(data.toString(), 0, 35);
            }
            GC gcControl = new GC((Drawable)control);
            try {
                Image img = new Image((Device)control.getDisplay(), bounds.width, bounds.height);
                gcControl.copyArea(img, 0, 0);
                gc.drawImage(img, 0, 45);
                img.dispose();
            }
            catch (Exception e) {
            }
            finally {
                gcControl.dispose();
            }
            return;
        }
    }

    void refreshObject() {
        int index = this.list.getSelectionIndex();
        if (index == -1) {
            return;
        }
        if (this.check.getSelection() && index < this.errors.length && this.errors[index] == null) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            PrintStream s = new PrintStream(stream);
            this.errors[index].printStackTrace(s);
            this.text.setText(stream.toString());
            this.text.setVisible(true);
            this.canvas.setVisible(false);
        } else {
            this.canvas.setVisible(true);
            this.text.setVisible(false);
            this.canvas.redraw();
        }
    }

    void refreshAll() {
        this.oldObjects = new Object[0];
        this.oldErrors = new Error[0];
        this.oldNonResources = new ArrayList();
        this.refreshDifference();
        this.oldObjects = this.objects;
        this.oldErrors = this.errors;
    }

    void layout() {
        Rectangle rect = this.shell.getClientArea();
        int width = 0;
        String[] items = this.list.getItems();
        GC gc = new GC((Drawable)this.list);
        for (int i = 0; i < this.objects.length; ++i) {
            width = Math.max(width, gc.stringExtent((String)items[i]).x);
        }
        gc.dispose();
        Point size1 = this.start.computeSize(-1, -1);
        Point size2 = this.stop.computeSize(-1, -1);
        Point size3 = this.check.computeSize(-1, -1);
        Point size4 = this.label.computeSize(-1, -1);
        width = Math.max(size1.x, Math.max(size2.x, Math.max(size3.x, width)));
        width = Math.max(64, Math.max(size4.x, this.list.computeSize((int)width, (int)-1).x));
        this.start.setBounds(0, 0, width, size1.y);
        this.stop.setBounds(0, size1.y, width, size2.y);
        this.check.setBounds(0, size1.y + size2.y, width, size3.y);
        this.label.setBounds(0, rect.height - size4.y, width, size4.y);
        int height = size1.y + size2.y + size3.y;
        this.list.setBounds(0, height, width, rect.height - height - size4.y);
        this.text.setBounds(width, 0, rect.width - width, rect.height);
        this.canvas.setBounds(width, 0, rect.width - width, rect.height);
    }

    public static void main(String[] args) {
        if (Launcher.checkAndLaunch(Sleak.class, args)) {
            return;
        }
        DeviceData data = new DeviceData();
        data.tracking = true;
        Display display = new Display(data);
        Sleak sleak = new Sleak();
        sleak.open();
        Initializer.main(args);
        while (!sleak.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        try {
            if (!display.isDisposed()) {
                display.dispose();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

