/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import com.aelitis.azureus.util.DataSourceUtils;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnAzProduct
extends CoreTableColumn
implements TableCellAddedListener,
TableCellToolTipListener,
TableCellRefreshListener {
    public static String COLUMN_ID = "AzProduct";
    private static UISWTGraphicImpl graphicProductAzureus;
    private static UISWTGraphicImpl graphicProductGlobe;
    private static int width;

    public ColumnAzProduct(String sTableID) {
        super(COLUMN_ID, sTableID);
        this.initializeAsGraphic(width);
        this.setWidthLimits(width, width);
        this.setAlignment(3);
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
    }

    public void refresh(TableCell cell) {
        long sortVal;
        boolean isContent = DataSourceUtils.isPlatformContent(cell.getDataSource());
        long l = sortVal = isContent ? 1L : 0L;
        if (!cell.setSortValue(sortVal) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setGraphic(isContent ? graphicProductAzureus : graphicProductGlobe);
    }

    public void cellHover(TableCell cell) {
        if (Constants.isCVSVersion()) {
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm == null) {
                return;
            }
            TOTorrent torrent = dm.getTorrent();
            long refreshOn = PlatformTorrentUtils.getMetaDataRefreshOn(torrent);
            long diff = (refreshOn - SystemTime.getCurrentTime()) / 1000L;
            cell.setToolTip("Meta data auto refreshes in " + TimeFormatter.format(diff));
        }
    }

    public void cellHoverComplete(TableCell cell) {
    }

    static {
        Image img = ImageLoaderFactory.getInstance().getImage("column.azproduct.product");
        width = img.getBounds().width;
        graphicProductAzureus = new UISWTGraphicImpl(img);
        img = ImageLoaderFactory.getInstance().getImage("column.azproduct.globe");
        width = Math.max(width, img.getBounds().width);
        graphicProductGlobe = new UISWTGraphicImpl(img);
    }
}

