/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.util.DataSourceUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnThumbnail
extends CoreTableColumn
implements TableCellRefreshListener,
TableCellSWTPaintListener {
    public static final String COLUMN_ID = "Thumbnail";
    private static final int WIDTH_SMALL = 35;
    private static final int WIDTH_BIG = 60;
    private static final int WIDTH_ACTIVITY = 80;
    private Map mapCellTorrent = new HashMap();

    public ColumnThumbnail(String sTableID) {
        super(COLUMN_ID, sTableID);
        if ("Activity.big".equals(sTableID)) {
            this.initializeAsGraphic(80);
        } else {
            this.initializeAsGraphic(sTableID.endsWith(".big") ? 60 : 35);
        }
        this.setAlignment(3);
    }

    public void dispose(TableCell cell) {
        this.mapCellTorrent.remove(cell);
    }

    public void refresh(TableCell cell) {
        Object ds = cell.getDataSource();
        TOTorrent newTorrent = DataSourceUtils.getTorrent(ds);
        long sortIndex = PlatformTorrentUtils.isContent(newTorrent, true) ? 0L : 1L;
        boolean bChanged = cell.setSortValue(sortIndex);
        TOTorrent torrent = (TOTorrent)this.mapCellTorrent.get(cell);
        if (!cell.isShown() || newTorrent == torrent && !bChanged && cell.isValid()) {
            return;
        }
        torrent = newTorrent;
        this.mapCellTorrent.put(cell, torrent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cellPaint(GC gc, TableCellSWT cell) {
        Object ds = cell.getDataSource();
        TOTorrent torrent = (TOTorrent)this.mapCellTorrent.get(cell);
        if (torrent == null) {
            return;
        }
        byte[] imageBytes = null;
        if (ds instanceof VuzeActivitiesEntry) {
            imageBytes = ((VuzeActivitiesEntry)ds).getImageBytes();
        }
        if (imageBytes == null) {
            imageBytes = PlatformTorrentUtils.getContentThumbnail(torrent);
        }
        Image imgThumbnail = null;
        Rectangle cellBounds = cell.getBounds();
        if (imageBytes != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(imageBytes);
            imgThumbnail = new Image((Device)Display.getDefault(), (InputStream)bis);
        } else {
            Image icon;
            DownloadManager dm = DataSourceUtils.getDM(ds);
            String path = null;
            if (dm == null) {
                TOTorrentFile[] files;
                if (torrent != null && (files = torrent.getFiles()).length > 0) {
                    path = files[0].getRelativePath();
                }
            } else {
                path = dm.getDownloadState().getPrimaryFile();
            }
            if (path != null && (icon = ImageRepository.getPathIcon(path, cellBounds.height >= 32 && cellBounds.width >= 32, torrent != null && !torrent.isSimpleTorrent())) != null) {
                imgThumbnail = new Image((Device)Display.getDefault(), icon, 0);
            }
        }
        if (null != imgThumbnail) {
            int dstHeight;
            int dstWidth;
            if (cellBounds.height > 30) {
                cellBounds.y += 2;
                cellBounds.height -= 4;
            }
            Rectangle imgBounds = imgThumbnail.getBounds();
            if (imgBounds.width > cellBounds.width || imgBounds.height > cellBounds.height) {
                dstWidth = cellBounds.width - 4;
                dstHeight = imgBounds.height * cellBounds.width / imgBounds.width;
                if (cellBounds.height < 30) {
                    ++cellBounds.y;
                    --cellBounds.height;
                }
            } else {
                dstWidth = imgBounds.width;
                dstHeight = imgBounds.height;
            }
            try {
                gc.setAdvanced(true);
                gc.setInterpolation(2);
            }
            catch (Exception e) {
                // empty catch block
            }
            int x = cellBounds.x + (cellBounds.width - dstWidth) / 2;
            int y = cellBounds.y + (cellBounds.height - dstHeight) / 2;
            if (dstWidth > 0 && dstHeight > 0 && !imgBounds.isEmpty()) {
                Rectangle dst = new Rectangle(x, y, dstWidth, dstHeight);
                Rectangle lastClipping = gc.getClipping();
                try {
                    gc.setClipping(cellBounds);
                    gc.drawImage(imgThumbnail, 0, 0, imgBounds.width, imgBounds.height, x, y, dstWidth, dstHeight);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
                finally {
                    gc.setClipping(lastClipping);
                }
            }
            imgThumbnail.dispose();
        }
    }
}

