/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.extlistener;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.browser.BrowserMessage;
import com.aelitis.azureus.core.messenger.browser.BrowserMessageDispatcher;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfo;
import com.aelitis.azureus.ui.swt.browser.listener.ConfigListener;
import com.aelitis.azureus.ui.swt.browser.listener.TorrentListener;
import com.aelitis.azureus.ui.swt.shells.main.MainWindow;
import com.aelitis.azureus.ui.swt.utils.TorrentUIUtilsV3;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.aelitis.azureus.util.ExternalStimulusHandler;
import com.aelitis.azureus.util.ExternalStimulusListener;
import com.aelitis.azureus.util.MapUtils;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;

public class StimulusRPC {
    public static void hookListeners(final AzureusCore core, final MainWindow mainWindow) {
        ExternalStimulusHandler.addListener(new ExternalStimulusListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean receive(String name, Map values) {
                try {
                    BrowserMessage browserMsg;
                    ClientMessageContext context;
                    block25: {
                        Map decodedMap;
                        String lId;
                        String opId;
                        block26: {
                            String url;
                            block27: {
                                if (values == null) {
                                    return false;
                                }
                                if (!name.equals("AZMSG")) {
                                    return false;
                                }
                                Object valueObj = values.get("value");
                                if (!(valueObj instanceof String)) {
                                    return false;
                                }
                                String value = (String)valueObj;
                                context = PlatformMessenger.getClientMessageContext();
                                if (context == null) {
                                    return false;
                                }
                                browserMsg = new BrowserMessage(value);
                                context.debug("Received External message: " + browserMsg);
                                opId = browserMsg.getOperationId();
                                lId = browserMsg.getListenerId();
                                if (!opId.equals("open-url")) break block26;
                                decodedMap = browserMsg.getDecodedMap();
                                url = MapUtils.getMapString(decodedMap, "url", null);
                                if (decodedMap.containsKey("target")) break block27;
                                context.debug("no target for url: " + url);
                                break block25;
                            }
                            if (PlatformConfigMessenger.isURLBlocked(url)) {
                                context.debug("url blocked: " + url);
                                break block25;
                            } else if (!PlatformConfigMessenger.urlCanRPC(url)) {
                                context.debug("url not in whitelistL " + url);
                                break block25;
                            } else {
                                BrowserMessageDispatcher dispatcher;
                                UIFunctions functions = UIFunctionsManager.getUIFunctions();
                                if (functions != null) {
                                    functions.bringToFront();
                                }
                                if ((dispatcher = context.getDispatcher()) != null) {
                                    dispatcher.dispatch(browserMsg);
                                    dispatcher.resetSequence();
                                    return true;
                                }
                                context.debug("No dispatcher for StimulusRPC" + opId);
                                return true;
                            }
                        }
                        if (opId.equals("load-torrent")) {
                            decodedMap = browserMsg.getDecodedMap();
                            if (decodedMap.containsKey("b64")) {
                                String b64 = MapUtils.getMapString(decodedMap, "b64", null);
                                return TorrentListener.loadTorrentByB64(core, b64);
                            }
                            if (decodedMap.containsKey("url")) {
                                String url = MapUtils.getMapString(decodedMap, "url", null);
                                boolean blocked = PlatformConfigMessenger.isURLBlocked(url);
                                if (blocked) {
                                    Debug.out("stopped loading torrent URL because it's not in whitelist");
                                    return false;
                                }
                                boolean playNow = MapUtils.getMapBoolean(decodedMap, "play-now", false);
                                boolean playPrepare = MapUtils.getMapBoolean(decodedMap, "play-prepare", false);
                                boolean bringToFront = MapUtils.getMapBoolean(decodedMap, "bring-to-front", true);
                                DownloadUrlInfo dlInfo = new DownloadUrlInfo(url);
                                dlInfo.setReferer(MapUtils.getMapString(decodedMap, "referer", null));
                                TorrentUIUtilsV3.loadTorrent(core, dlInfo, playNow, playPrepare, bringToFront, false);
                                return true;
                            }
                        } else {
                            if (opId.equals("is-ready")) {
                                return mainWindow.isReady();
                            }
                            if (opId.equals("is-version-ge")) {
                                Map decodedMap2 = browserMsg.getDecodedMap();
                                if (!decodedMap2.containsKey("version")) return false;
                                String id = MapUtils.getMapString(decodedMap2, "id", "client");
                                String version = MapUtils.getMapString(decodedMap2, "version", "");
                                if (!id.equals("client")) return false;
                                if (Constants.compareVersions("4.0.0.4", version) < 0) return false;
                                return true;
                            }
                            if (opId.equals("is-active-tab")) {
                                Map decodedMap3 = browserMsg.getDecodedMap();
                                if (!decodedMap3.containsKey("tab")) return false;
                                String tabID = MapUtils.getMapString(decodedMap3, "tab", "");
                                if (tabID.length() <= 0) return false;
                                SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
                                SideBarEntrySWT info = sidebar.getCurrentSideBarInfo();
                                if (info == null) return false;
                                return info.id.equals(tabID);
                            }
                            if ("config".equals(lId)) {
                                if ("is-new-install".equals(opId)) {
                                    return COConfigurationManager.isNewInstall();
                                }
                                if ("check-for-updates".equals(opId)) {
                                    ConfigListener.checkForUpdates();
                                    return true;
                                }
                                if ("log-diags".equals(opId)) {
                                    ConfigListener.logDiagnostics();
                                    return true;
                                }
                            }
                        }
                    }
                    if (System.getProperty("browser.route.all.external.stimuli.for.testing", "false").equalsIgnoreCase("true")) {
                        BrowserMessageDispatcher dispatcher = context.getDispatcher();
                        if (dispatcher == null) return false;
                        dispatcher.dispatch(browserMsg);
                        return false;
                    }
                    System.err.println("Unhandled external stimulus: " + browserMsg);
                    return false;
                }
                catch (Exception e) {
                    Debug.out(e);
                }
                return false;
            }

            public int query(String name, Map values) {
                return Integer.MIN_VALUE;
            }
        });
    }
}

