/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells;

import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.util.List;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.ui.swt.ITwistieListener;
import org.gudy.azureus2.ui.swt.TwistieSection;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.StyledShell;
import org.gudy.azureus2.ui.swt.components.widgets.BubbleButton;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.progress.ProgressReportMessage;

public class StyledMessageWindow
extends StyledShell {
    private Label messageLabel = null;
    private String message = null;
    private List detailMessages = null;
    private BubbleButton closeButton = null;
    private StyledText detailListWidget;
    private TwistieSection detailTwistie;
    private Label titleLabel = null;
    private String title = null;
    private Color errorColor;

    public StyledMessageWindow(Shell parentShell, int borderWidth) {
        super(parentShell, borderWidth);
        this.createControls(this.getContent());
    }

    public StyledMessageWindow(Shell parentShell, int borderWidth, boolean useCustomTrim) {
        super(parentShell, borderWidth, useCustomTrim);
        this.createControls(this.getContent());
    }

    private void createControls(Composite parent) {
        this.errorColor = Colors.colorError;
        this.setBackground(ColorCache.getColor((Device)parent.getDisplay(), 38, 38, 38));
        parent.setBackground(ColorCache.getColor((Device)parent.getDisplay(), 13, 13, 13));
        parent.setLayout((Layout)new FormLayout());
        parent.setBackgroundMode(2);
        this.titleLabel = new Label(parent, 0);
        Utils.setFontHeight((Control)this.titleLabel, 12, 0);
        this.titleLabel.setForeground(ColorCache.getColor((Device)parent.getDisplay(), 206, 206, 206));
        FormData titleLabelData = new FormData();
        titleLabelData.top = new FormAttachment(0, 6);
        titleLabelData.left = new FormAttachment(0, 6);
        this.titleLabel.setLayoutData((Object)titleLabelData);
        this.messageLabel = new Label(parent, 64);
        this.messageLabel.setForeground(ColorCache.getColor((Device)parent.getDisplay(), 206, 206, 206));
        FormData messageLabelData = new FormData();
        messageLabelData.top = new FormAttachment((Control)this.titleLabel, 20);
        messageLabelData.left = new FormAttachment(0, 20);
        messageLabelData.width = 300;
        this.messageLabel.setLayoutData((Object)messageLabelData);
        this.closeButton = new BubbleButton(parent);
        FormData closeButtonData = new FormData();
        closeButtonData.right = new FormAttachment(100, -20);
        closeButtonData.bottom = new FormAttachment(100, -20);
        this.closeButton.setLayoutData(closeButtonData);
        this.closeButton.setText("Close");
        this.closeButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                StyledMessageWindow.this.close();
            }
        });
        this.detailTwistie = new TwistieSection(parent, 8);
        this.detailTwistie.setVisible(false);
        FormData detailTwistieData = new FormData();
        detailTwistieData.left = new FormAttachment(0, 20);
        detailTwistieData.right = new FormAttachment(100, -20);
        detailTwistieData.top = new FormAttachment((Control)this.messageLabel, 20);
        detailTwistieData.bottom = new FormAttachment((Control)this.closeButton, -20);
        this.detailTwistie.setLayoutData(detailTwistieData);
        this.detailTwistie.setTitle("Detail:");
        Composite sectionContent = this.detailTwistie.getContent();
        this.detailTwistie.setForeground(ColorCache.getColor((Device)parent.getDisplay(), 206, 206, 206));
        sectionContent.setLayout((Layout)new FormLayout());
        this.detailListWidget = new StyledText(sectionContent, 576);
        this.detailListWidget.setEditable(false);
        FormData detailListWidgetData = new FormData();
        detailListWidgetData.left = new FormAttachment(0, 0);
        detailListWidgetData.right = new FormAttachment(100, 0);
        detailListWidgetData.top = new FormAttachment(0, 0);
        detailListWidgetData.bottom = new FormAttachment(100, 0);
        detailListWidgetData.height = 100;
        detailListWidgetData.width = 300;
        this.detailListWidget.setLayoutData((Object)detailListWidgetData);
        this.detailListWidget.setBackground(ColorCache.getColor((Device)parent.getDisplay(), 255, 255, 230));
        this.detailTwistie.addTwistieListener(new ITwistieListener(){

            public void isCollapsed(boolean value) {
                if (null != StyledMessageWindow.this.getShell() && !StyledMessageWindow.this.getShell().isDisposed()) {
                    StyledMessageWindow.this.getShell().pack(true);
                }
            }
        });
    }

    public void open() {
        this.messageLabel.setText(this.message != null ? this.message : "");
        this.messageLabel.setSize(this.messageLabel.computeSize(-1, -1));
        if (null != this.title) {
            this.titleLabel.setText(this.title);
        }
        if (null != this.detailMessages && !this.detailMessages.isEmpty()) {
            boolean hasError = false;
            for (Object obj : this.detailMessages) {
                if (!(obj instanceof ProgressReportMessage)) continue;
                ProgressReportMessage message = (ProgressReportMessage)obj;
                if (!hasError && message.isError()) {
                    hasError = true;
                }
                this.appendToDetail(message.getValue(), message.isError());
            }
            this.detailTwistie.setVisible(hasError);
        } else {
            this.detailListWidget.setText("");
            this.detailTwistie.setVisible(false);
        }
        this.getShell().pack(true);
        super.open();
    }

    private void appendToDetail(String value, boolean isError) {
        if (null == value || value.length() < 1) {
            return;
        }
        if (null == this.detailListWidget || this.detailListWidget.isDisposed()) {
            return;
        }
        int charCount = this.detailListWidget.getCharCount();
        this.detailListWidget.append(value + "\n");
        if (isError) {
            StyleRange style2 = new StyleRange();
            style2.start = charCount;
            style2.length = value.length();
            style2.foreground = this.errorColor;
            this.detailListWidget.setStyleRange(style2);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String successMessage) {
        this.message = successMessage;
    }

    public List getDetailMessages() {
        return this.detailMessages;
    }

    public void setDetailMessages(List detailMessages) {
        this.detailMessages = detailMessages;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

