/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import com.aelitis.azureus.ui.swt.utils.ImageLoader;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.util.AECallback;
import org.gudy.azureus2.core3.util.AERunnableWithCallback;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.ui.swt.Utils;

public class SWTSkinObjectImage
extends SWTSkinObjectBasic {
    protected static final Long DRAW_SCALE = new Long(1L);
    protected static final Long DRAW_STRETCH = new Long(2L);
    protected static final Long DRAW_NORMAL = new Long(0L);
    protected static final Long DRAW_TILE = new Long(3L);
    protected static final Long DRAW_CENTER = new Long(4L);
    protected static final Long DRAW_HCENTER = new Long(5L);
    private static boolean ALWAYS_USE_PAINT = false;
    Label label;
    private boolean customImage;
    private String customImageID;
    private static PaintListener paintListener = new PaintListener(){

        public void paintControl(PaintEvent e) {
            try {
                e.gc.setAdvanced(true);
                e.gc.setInterpolation(2);
            }
            catch (Exception ex) {
                // empty catch block
            }
            Label label = (Label)e.widget;
            Image imgSrc = (Image)label.getData("image");
            if (imgSrc == null) {
                return;
            }
            Rectangle imgSrcBounds = imgSrc.getBounds();
            Point size = label.getSize();
            Long drawMode = (Long)label.getData("drawmode");
            if (drawMode == DRAW_STRETCH) {
                e.gc.drawImage(imgSrc, 0, 0, imgSrcBounds.width, imgSrcBounds.height, 0, 0, size.x, size.y);
            } else if (drawMode == DRAW_CENTER) {
                e.gc.drawImage(imgSrc, (size.x - imgSrcBounds.width) / 2, (size.y - imgSrcBounds.height) / 2);
            } else if (drawMode == DRAW_HCENTER) {
                e.gc.drawImage(imgSrc, (size.x - imgSrcBounds.width) / 2, 0);
            } else if (drawMode == DRAW_SCALE) {
                e.gc.drawImage(imgSrc, 0, 0, imgSrcBounds.width, imgSrcBounds.height, 0, 0, size.x, size.y);
            } else {
                Image imgLeft;
                int x0 = 0;
                int y0 = 0;
                int x1 = size.x;
                int y1 = size.y;
                Image imgRight = (Image)label.getData("image-right");
                if (imgRight != null) {
                    int width = imgRight.getBounds().width;
                    x1 -= width;
                }
                if ((imgLeft = (Image)label.getData("image-left")) != null) {
                    e.gc.drawImage(imgLeft, 0, 0);
                    x0 += imgLeft.getBounds().width;
                }
                for (int y = y0; y < y1; y += imgSrcBounds.height) {
                    for (int x = x0; x < x1; x += imgSrcBounds.width) {
                        e.gc.drawImage(imgSrc, x, y);
                    }
                }
                if (imgRight != null) {
                    e.gc.drawImage(imgRight, x1, 0);
                }
            }
        }
    };
    private boolean noSetLabelImage = false;
    private int h_align;

    public SWTSkinObjectImage(SWTSkin skin, SWTSkinProperties skinProperties, String sID, String sConfigID, String sImageID, SWTSkinObject parent) {
        super(skin, skinProperties, sID, sConfigID, "image", parent);
        this.setControl((Control)this.createImageLabel(sConfigID, sImageID));
        this.customImage = false;
        this.customImageID = null;
    }

    private Label createImageLabel(String sConfigID, String sImageID) {
        ImageLoader imageLoader;
        Image image;
        String sCursor;
        String sURL;
        int style = 64;
        String sAlign = this.properties.getStringValue(sConfigID + ".align");
        if (sAlign != null) {
            this.h_align = SWTSkinUtils.getAlignment(sAlign, 0);
            if (this.h_align != 0) {
                style |= this.h_align;
            }
        }
        if (this.properties.getIntValue(sConfigID + ".border", 0) == 1) {
            style |= 0x800;
        }
        Object createOn = this.parent == null ? this.skin.getShell() : (Composite)this.parent.getControl();
        this.label = new Label((Composite)createOn, style);
        this.label.setData("SkinObject", (Object)this);
        Color color = this.properties.getColor(sConfigID + ".color");
        if (color != null) {
            this.label.setBackground(color);
        }
        if ((sURL = this.properties.getStringValue(sConfigID + ".url")) != null && sURL.length() > 0) {
            this.label.setToolTipText(sURL);
            this.label.addListener(4, new Listener(){

                public void handleEvent(Event arg0) {
                    Utils.launch(UrlUtils.encode(sURL));
                }
            });
        }
        if ((sCursor = this.properties.getStringValue(sConfigID + ".cursor")) != null && sCursor.length() > 0 && sCursor.equalsIgnoreCase("hand")) {
            this.label.addListener(6, this.skin.getHandCursorListener(this.label.getDisplay()));
            this.label.addListener(7, this.skin.getHandCursorListener(this.label.getDisplay()));
        }
        if (!ImageLoader.isRealImage(image = (imageLoader = this.skin.getImageLoader(this.properties)).getImage(sImageID))) {
            sImageID = sConfigID + ".image";
            image = imageLoader.getImage(sImageID);
        }
        if (ImageLoader.isRealImage(image)) {
            this.setLabelImage(sConfigID, sImageID, null);
        }
        return this.label;
    }

    protected void setLabelImage(String sImageID, AECallback callback) {
        this.setLabelImage(this.sConfigID, sImageID, callback);
    }

    private void setLabelImage(final String sConfigID, final String sImageID, AECallback callback) {
        Utils.execSWTThread(new AERunnableWithCallback(callback){

            public Object runSupport() {
                String sDrawMode;
                if (SWTSkinObjectImage.this.label == null || SWTSkinObjectImage.this.label.isDisposed()) {
                    return null;
                }
                if (sImageID != null && sImageID.equals(SWTSkinObjectImage.this.label.getData("ImageID"))) {
                    return SWTSkinObjectImage.this.label.getImage();
                }
                ImageLoader imageLoader = SWTSkinObjectImage.this.skin.getImageLoader(SWTSkinObjectImage.this.properties);
                Image[] images = sImageID == null || sImageID.length() == 0 ? null : imageLoader.getImages(sImageID);
                Image image = null;
                if (images.length == 3) {
                    Image imageLeft = images[0];
                    if (ImageLoader.isRealImage(imageLeft)) {
                        SWTSkinObjectImage.this.label.setData("image-left", (Object)imageLeft);
                    }
                    image = images[1];
                    Image imageRight = images[2];
                    if (ImageLoader.isRealImage(imageRight)) {
                        SWTSkinObjectImage.this.label.setData("image-right", (Object)imageRight);
                    }
                } else if (images.length > 0) {
                    image = images[0];
                }
                if (image == null) {
                    image = ImageLoader.noImage;
                }
                if ((sDrawMode = SWTSkinObjectImage.this.properties.getStringValue(sConfigID + ".drawmode")) == null) {
                    sDrawMode = SWTSkinObjectImage.this.properties.getStringValue(SWTSkinObjectImage.this.sConfigID + ".drawmode", "");
                }
                Long drawMode = sDrawMode.equals("scale") ? DRAW_SCALE : (sDrawMode.equals("stretch") ? DRAW_STRETCH : (sDrawMode.equals("center") ? DRAW_CENTER : (sDrawMode.equals("h-center") ? DRAW_HCENTER : (sDrawMode.equalsIgnoreCase("tile") || ALWAYS_USE_PAINT ? DRAW_TILE : DRAW_NORMAL))));
                SWTSkinObjectImage.this.label.setData("drawmode", (Object)drawMode);
                if (drawMode != DRAW_NORMAL) {
                    SWTSkinObjectImage.this.noSetLabelImage = true;
                    Rectangle imgBounds = image.getBounds();
                    if (drawMode != DRAW_CENTER && drawMode != DRAW_HCENTER && drawMode != DRAW_STRETCH) {
                        SWTSkinObjectImage.this.label.setSize(imgBounds.width, imgBounds.height);
                    }
                    SWTSkinObjectImage.this.label.setData("image", (Object)image);
                    if (drawMode == DRAW_TILE) {
                        FormData fd = (FormData)SWTSkinObjectImage.this.label.getLayoutData();
                        if (fd == null) {
                            fd = new FormData(imgBounds.width, imgBounds.height);
                        } else {
                            fd.width = imgBounds.width;
                            fd.height = imgBounds.height;
                        }
                        SWTSkinObjectImage.this.label.setLayoutData((Object)fd);
                    }
                    SWTSkinObjectImage.this.label.removePaintListener(paintListener);
                    SWTSkinObjectImage.this.label.addPaintListener(paintListener);
                    SWTSkinObjectImage.this.label.setImage(null);
                } else if (sDrawMode.equals("scale")) {
                    SWTSkinObjectImage.this.noSetLabelImage = true;
                    Rectangle imgBounds = image.getBounds();
                    SWTSkinObjectImage.this.label.setSize(imgBounds.width, imgBounds.height);
                    SWTSkinObjectImage.this.label.setData("image", (Object)image);
                } else {
                    Image oldImage = SWTSkinObjectImage.this.label.getImage();
                    SWTSkinObjectImage.this.label.setImage(image);
                    SWTSkinObjectImage.this.label.setData("ImageID", (Object)sImageID);
                    if (oldImage == null || image == null || !oldImage.getBounds().equals((Object)image.getBounds())) {
                        Utils.relayout((Control)SWTSkinObjectImage.this.label);
                    }
                }
                SWTSkinObjectImage.this.label.redraw();
                SWTSkinUtils.addMouseImageChangeListeners((Control)SWTSkinObjectImage.this.label);
                return image;
            }
        });
    }

    public void setBackground(String sConfigID, String sSuffix) {
    }

    public String switchSuffix(String suffix, int level, boolean walkUp, boolean walkDown) {
        suffix = super.switchSuffix(suffix, level, walkUp, walkDown);
        if (this.customImage) {
            return suffix;
        }
        if (suffix == null) {
            return null;
        }
        String sImageID = (this.customImageID == null ? this.sConfigID + ".image" : this.customImageID) + suffix;
        ImageLoader imageLoader = this.skin.getImageLoader(this.properties);
        Image image = imageLoader.getImage(sImageID);
        if (this.debug) {
            System.out.println(sImageID + image + ";" + ImageLoader.isRealImage(image));
        }
        if (image != ImageLoader.noImage) {
            this.setLabelImage(sImageID, null);
        }
        return suffix;
    }

    public Image getImage() {
        return this.label.getImage();
    }

    public void setImage(Image image) {
        this.customImage = true;
        this.customImageID = null;
        this.label.setData("image", (Object)image);
        this.label.setData("image-left", null);
        this.label.setData("image-right", null);
        if (!this.noSetLabelImage) {
            this.label.setImage(image);
        } else {
            this.label.redraw();
        }
        Utils.relayout((Control)this.label);
    }

    protected void setImageByID(String sConfigID, AECallback callback) {
        if (!this.customImage && this.customImageID != null && this.customImageID.equals(sConfigID)) {
            if (callback != null) {
                callback.callbackFailure(null);
            }
            return;
        }
        this.customImage = false;
        this.customImageID = sConfigID;
        String sImageID = sConfigID + this.getSuffix();
        ImageLoader imageLoader = this.skin.getImageLoader(this.properties);
        Image image = imageLoader.getImage(sImageID);
        if (ImageLoader.isRealImage(image)) {
            this.setLabelImage(sConfigID, sImageID, callback);
        } else {
            this.setLabelImage(sConfigID, sConfigID, callback);
        }
    }
}

