/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.subscriptions;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionHistory;
import com.aelitis.azureus.core.subs.SubscriptionListener;
import com.aelitis.azureus.core.subs.SubscriptionManager;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.core.subs.SubscriptionManagerListener;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.swt.browser.BrowserContext;
import com.aelitis.azureus.ui.swt.browser.CookiesListener;
import com.aelitis.azureus.ui.swt.browser.OpenCloseSearchDetailsListener;
import com.aelitis.azureus.ui.swt.browser.listener.ConfigListener;
import com.aelitis.azureus.ui.swt.browser.listener.DisplayListener;
import com.aelitis.azureus.ui.swt.browser.listener.ExternalLoginCookieListener;
import com.aelitis.azureus.ui.swt.browser.listener.MetaSearchListener;
import com.aelitis.azureus.ui.swt.browser.listener.TorrentListener;
import com.aelitis.azureus.ui.swt.browser.listener.VuzeListener;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionListWindow;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionWizard;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarListener;
import com.aelitis.azureus.util.ConstantsV3;
import com.aelitis.azureus.util.MapUtils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AERunnableObject;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginConfigListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarEntry;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarVitalityImage;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarVitalityImageListener;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnCreationListener;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.PropertiesWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.plugins.UISWTInputReceiver;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;

public class SubscriptionManagerUI {
    public static final Object SUB_IVIEW_KEY = new Object();
    public static final Object SUB_EDIT_MODE_KEY = new Object();
    private static final String EDIT_MODE_MARKER = "&editMode=1";
    private Graphic icon_rss_big;
    private Graphic icon_rss_small;
    private Graphic icon_rss_all_add_small;
    private Graphic icon_rss_all_add_big;
    private Graphic icon_rss_some_add_small;
    private Graphic icon_rss_some_add_big;
    private List icon_list = new ArrayList();
    private SubscriptionManager subs_man;
    private MenuItemListener markAllResultsListener;
    private MenuItemListener unmarkAllResultsListener;
    private MenuItemListener deleteAllResultsListener;
    private MenuItemListener resetAuthListener;
    private MenuItemListener resetResultsListener;
    private MenuItemListener exportListener;
    private MenuItemListener renameListener;
    private MenuItemListener removeListener;
    private MenuItemListener forceCheckListener;
    private MenuItemListener upgradeListener;
    private MenuItemListener propertiesListener;
    private boolean side_bar_setup;
    private List columns = new ArrayList();

    public SubscriptionManagerUI(AzureusCore core) {
        final PluginInterface default_pi = core.getPluginManager().getDefaultPluginInterface();
        TableManager table_manager = default_pi.getUIManager().getTableManager();
        if (Constants.isCVSVersion()) {
            TableContextMenuItem menu_item_itorrents = table_manager.addContextMenuItem("MyTorrents", "azsubs.contextmenu.lookupassoc");
            TableContextMenuItem menu_item_ctorrents = table_manager.addContextMenuItem("MySeeders", "azsubs.contextmenu.lookupassoc");
            menu_item_itorrents.setStyle(1);
            menu_item_ctorrents.setStyle(1);
            MenuItemListener listener = new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    TableRow[] rows = (TableRow[])target;
                    if (rows.length > 0) {
                        Download download = (Download)rows[0].getDataSource();
                        new SubscriptionListWindow(PluginCoreUtils.unwrap(download), false);
                    }
                }
            };
            menu_item_itorrents.addMultiListener(listener);
            menu_item_ctorrents.addMultiListener(listener);
        }
        this.createSubsColumns(table_manager);
        final UIManager ui_manager = default_pi.getUIManager();
        ui_manager.addUIListener(new UIManagerListener(){

            public void UIAttached(UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    final UISWTInstance swt = (UISWTInstance)instance;
                    SubscriptionManagerUI.this.icon_rss_small = SubscriptionManagerUI.this.loadGraphic(swt, "btn_rss_subscribe_orange_30x14.png");
                    SubscriptionManagerUI.this.icon_rss_big = SubscriptionManagerUI.this.icon_rss_small;
                    SubscriptionManagerUI.this.icon_rss_all_add_small = SubscriptionManagerUI.this.loadGraphic(swt, "btn_rss_subscribed_gray_30x14.png");
                    SubscriptionManagerUI.this.icon_rss_all_add_big = SubscriptionManagerUI.this.icon_rss_all_add_small;
                    SubscriptionManagerUI.this.icon_rss_some_add_small = SubscriptionManagerUI.this.loadGraphic(swt, "btn_rss_subscribed_gray_30x14.png");
                    SubscriptionManagerUI.this.icon_rss_some_add_big = SubscriptionManagerUI.this.icon_rss_some_add_small;
                    SubscriptionManagerUI.this.subs_man = SubscriptionManagerFactory.getSingleton();
                    SubscriptionManagerUI.this.subs_man.addListener(new SubscriptionManagerListener(){

                        public void subscriptionAdded(Subscription subscription) {
                        }

                        public void subscriptionChanged(Subscription subscription) {
                        }

                        public void subscriptionSelected(Subscription subscription) {
                        }

                        public void subscriptionRemoved(Subscription subscription) {
                        }

                        public void associationsChanged(byte[] hash) {
                            SubscriptionManagerUI.this.refreshColumns();
                        }
                    });
                    BasicPluginConfigModel configModel = ui_manager.createBasicPluginConfigModel("root", "Subscriptions");
                    final IntParameter max_results = configModel.addIntParameter2("subscriptions.config.maxresults", "subscriptions.config.maxresults", SubscriptionManagerUI.this.subs_man.getMaxNonDeletedResults());
                    default_pi.getPluginconfig().addListener(new PluginConfigListener(){

                        public void configSaved() {
                            SubscriptionManagerUI.this.subs_man.setMaxNonDeletedResults(max_results.getValue());
                        }
                    });
                    SkinViewManager.addListener(new SkinViewManager.SkinViewManagerListener(){

                        public void skinViewAdded(SkinView skinview) {
                            if (skinview instanceof SideBar) {
                                SubscriptionManagerUI.this.setupSideBar((SideBar)skinview, swt);
                            }
                        }
                    });
                    SideBar sideBar = (SideBar)SkinViewManager.getByClass(SideBar.class);
                    if (sideBar != null) {
                        SubscriptionManagerUI.this.setupSideBar(sideBar, swt);
                    }
                }
            }

            public void UIDetached(UIInstance instance) {
            }
        });
    }

    private void createSubsColumns(TableManager table_manager) {
        final TableCellRefreshListener subs_refresh_listener = new TableCellRefreshListener(){

            public void refresh(TableCell _cell) {
                TableCellSWT cell = (TableCellSWT)_cell;
                if (SubscriptionManagerUI.this.subs_man == null) {
                    return;
                }
                Download dl = (Download)cell.getDataSource();
                if (dl == null) {
                    return;
                }
                Torrent torrent = dl.getTorrent();
                if (torrent != null) {
                    String tooltip;
                    Graphic graphic;
                    Subscription[] subs = SubscriptionManagerUI.this.subs_man.getKnownSubscriptions(torrent.getHash());
                    int num_subscribed = 0;
                    int num_unsubscribed = 0;
                    for (int i = 0; i < subs.length; ++i) {
                        if (subs[i].isSubscribed()) {
                            ++num_subscribed;
                            continue;
                        }
                        ++num_unsubscribed;
                    }
                    int height = cell.getHeight();
                    int sort_order = 0;
                    if (subs.length == 0) {
                        graphic = null;
                        tooltip = null;
                    } else if (num_subscribed == subs.length) {
                        graphic = height >= 22 ? SubscriptionManagerUI.this.icon_rss_all_add_big : SubscriptionManagerUI.this.icon_rss_all_add_small;
                        tooltip = MessageText.getString("subscript.all.subscribed");
                    } else if (num_subscribed > 0) {
                        graphic = height >= 22 ? SubscriptionManagerUI.this.icon_rss_some_add_big : SubscriptionManagerUI.this.icon_rss_some_add_small;
                        tooltip = MessageText.getString("subscript.some.subscribed");
                        sort_order = 10000;
                    } else {
                        graphic = height >= 22 ? SubscriptionManagerUI.this.icon_rss_big : SubscriptionManagerUI.this.icon_rss_small;
                        tooltip = MessageText.getString("subscript.none.subscribed");
                        sort_order = 1000000;
                    }
                    cell.setGraphic(graphic);
                    cell.setToolTip(tooltip);
                    cell.setSortValue(sort_order += 1000 * num_unsubscribed + num_subscribed);
                    cell.setCursorID(graphic == null ? 0 : 21);
                } else {
                    cell.setCursorID(0);
                    cell.setSortValue(0L);
                }
            }
        };
        final TableCellMouseListener subs_mouse_listener = new TableCellMouseListener(){

            public void cellMouseTrigger(TableCellMouseEvent event2) {
                Subscription[] subs;
                TableCell cell;
                Download dl;
                Torrent torrent;
                if (event2.eventType == 0 && (torrent = (dl = (Download)(cell = event2.cell).getDataSource()).getTorrent()) != null && (subs = SubscriptionManagerUI.this.subs_man.getKnownSubscriptions(torrent.getHash())).length > 0) {
                    event2.skipCoreFunctionality = true;
                    new SubscriptionWizard(PluginCoreUtils.unwrap(dl));
                }
            }
        };
        table_manager.registerColumn(Download.class, "azsubs.ui.column.subs", new TableColumnCreationListener(){

            public void tableColumnCreated(TableColumn result) {
                result.setAlignment(3);
                result.setPosition(-2);
                result.setWidth(75);
                result.setRefreshInterval(-3);
                result.setType(2);
                result.addCellRefreshListener(subs_refresh_listener);
                result.addCellMouseListener(subs_mouse_listener);
                SubscriptionManagerUI.this.columns.add(result);
            }
        });
        final TableCellRefreshListener link_refresh_listener = new TableCellRefreshListener(){

            public void refresh(TableCell _cell) {
                TableCellSWT cell = (TableCellSWT)_cell;
                if (SubscriptionManagerUI.this.subs_man == null) {
                    return;
                }
                Download dl = (Download)cell.getDataSource();
                if (dl == null) {
                    return;
                }
                String str = "";
                Torrent torrent = dl.getTorrent();
                if (torrent != null) {
                    byte[] hash = torrent.getHash();
                    Subscription[] subs = SubscriptionManagerUI.this.subs_man.getKnownSubscriptions(hash);
                    for (int i = 0; i < subs.length; ++i) {
                        Subscription sub = subs[i];
                        if (!sub.hasAssociation(hash)) continue;
                        str = str + (str.length() == 0 ? "" : "; ") + sub.getName();
                    }
                }
                cell.setCursorID(str.length() > 0 ? 21 : 0);
                cell.setText(str);
            }
        };
        final TableCellMouseListener link_mouse_listener = new TableCellMouseListener(){

            public void cellMouseTrigger(TableCellMouseEvent event2) {
                TableCell cell;
                Download dl;
                Torrent torrent;
                if (event2.eventType == 0 && (torrent = (dl = (Download)(cell = event2.cell).getDataSource()).getTorrent()) != null) {
                    byte[] hash = torrent.getHash();
                    Subscription[] subs = SubscriptionManagerUI.this.subs_man.getKnownSubscriptions(hash);
                    for (int i = 0; i < subs.length; ++i) {
                        sideBarItem item;
                        Subscription sub = subs[i];
                        if (!sub.hasAssociation(hash) || (item = (sideBarItem)sub.getUserData(SUB_IVIEW_KEY)) == null) continue;
                        event2.skipCoreFunctionality = true;
                        item.activate();
                        break;
                    }
                }
            }
        };
        table_manager.registerColumn(Download.class, "azsubs.ui.column.subs_link", new TableColumnCreationListener(){

            public void tableColumnCreated(TableColumn result) {
                result.setAlignment(1);
                result.setPosition(-1);
                result.setWidth(85);
                result.setRefreshInterval(-3);
                result.setType(3);
                result.addCellRefreshListener(link_refresh_listener);
                result.addCellMouseListener(link_mouse_listener);
                SubscriptionManagerUI.this.columns.add(result);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupSideBar(final SideBar side_bar, final UISWTInstance swt_ui) {
        SubscriptionManagerUI subscriptionManagerUI = this;
        synchronized (subscriptionManagerUI) {
            if (this.side_bar_setup) {
                return;
            }
            this.side_bar_setup = true;
        }
        SideBarEntrySWT mainSBEntry = SideBar.getSideBarInfo("Subscriptions");
        if (mainSBEntry != null) {
            SideBarVitalityImage addSub = mainSBEntry.addVitalityImage("image.sidebar.subs.add");
            addSub.setToolTip("Add Subscription");
            addSub.addListener(new SideBarVitalityImageListener(){

                public void sbVitalityImage_clicked(int x, int y) {
                    new SubscriptionWizard();
                }
            });
            mainSBEntry.setImageLeftID("image.sidebar.subscriptions");
            mainSBEntry.setTitleInfo(new ViewTitleInfo(){

                public Object getTitleInfoProperty(int propertyID) {
                    if (propertyID == 5) {
                        return MessageText.getString("subscriptions.view.title");
                    }
                    return null;
                }
            });
        }
        this.markAllResultsListener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof SideBarEntry) {
                    SideBarEntry info = (SideBarEntry)target;
                    Subscription subs = (Subscription)info.getDatasource();
                    subs.getHistory().markAllResultsRead();
                    SubscriptionManagerUI.this.refreshView(subs);
                }
            }
        };
        this.unmarkAllResultsListener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof SideBarEntry) {
                    SideBarEntry info = (SideBarEntry)target;
                    Subscription subs = (Subscription)info.getDatasource();
                    subs.getHistory().markAllResultsUnread();
                    SubscriptionManagerUI.this.refreshView(subs);
                }
            }
        };
        this.deleteAllResultsListener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof SideBarEntry) {
                    SideBarEntry info = (SideBarEntry)target;
                    Subscription subs = (Subscription)info.getDatasource();
                    subs.getHistory().deleteAllResults();
                    SubscriptionManagerUI.this.refreshView(subs);
                }
            }
        };
        this.resetAuthListener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof SideBarEntry) {
                    SideBarEntry info = (SideBarEntry)target;
                    Subscription subs = (Subscription)info.getDatasource();
                    try {
                        Engine engine = subs.getEngine();
                        if (engine instanceof WebEngine) {
                            ((WebEngine)engine).setCookies(null);
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    try {
                        subs.getManager().getScheduler().downloadAsync(subs, true);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        };
        this.resetResultsListener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof SideBarEntry) {
                    SideBarEntry info = (SideBarEntry)target;
                    Subscription subs = (Subscription)info.getDatasource();
                    subs.getHistory().reset();
                    try {
                        subs.getEngine().reset();
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    try {
                        subs.getManager().getScheduler().downloadAsync(subs, true);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        };
        this.exportListener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof SideBarEntry) {
                    SideBarEntry info = (SideBarEntry)target;
                    final Subscription subs = (Subscription)info.getDatasource();
                    final Shell shell = Utils.findAnyShell();
                    shell.getDisplay().asyncExec((Runnable)new AERunnable(){

                        public void runSupport() {
                            FileDialog dialog = new FileDialog(shell, 139264);
                            dialog.setFilterPath(TorrentOpener.getFilterPathData());
                            dialog.setText(MessageText.getString("subscript.export.select.template.file"));
                            dialog.setFilterExtensions(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                            dialog.setFilterNames(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                            String path = TorrentOpener.setFilterPathData(dialog.open());
                            if (path != null) {
                                String lc = path.toLowerCase();
                                if (!lc.endsWith(".vuze") && !lc.endsWith(".vuz")) {
                                    path = path + ".vuze";
                                }
                                try {
                                    VuzeFile vf = subs.getVuzeFile();
                                    vf.write(new File(path));
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            }
        };
        this.renameListener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof SideBarEntry) {
                    SideBarEntry info = (SideBarEntry)target;
                    Subscription subs = (Subscription)info.getDatasource();
                    UISWTInputReceiver entry = (UISWTInputReceiver)swt_ui.getInputReceiver();
                    entry.setPreenteredText(subs.getName(), false);
                    entry.maintainWhitespace(false);
                    entry.allowEmptyInput(false);
                    entry.setTitle("MyTorrentsView.menu.rename");
                    entry.prompt();
                    if (!entry.hasSubmittedInput()) {
                        return;
                    }
                    String input = entry.getSubmittedInput().trim();
                    if (input.length() > 0) {
                        try {
                            subs.setName(input);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            }
        };
        this.removeListener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof SideBarEntry) {
                    SideBarEntry info = (SideBarEntry)target;
                    Subscription subs = (Subscription)info.getDatasource();
                    MessageBoxShell mb = new MessageBoxShell(Utils.findAnyShell(), MessageText.getString("message.confirm.delete.title"), MessageText.getString("message.confirm.delete.text", new String[]{subs.getName()}), new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
                    int result = mb.open();
                    if (result == 0) {
                        subs.remove();
                    }
                }
            }
        };
        this.forceCheckListener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof SideBarEntry) {
                    SideBarEntry info = (SideBarEntry)target;
                    Subscription subs = (Subscription)info.getDatasource();
                    try {
                        subs.getManager().getScheduler().downloadAsync(subs, true);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        };
        this.upgradeListener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof SideBarEntry) {
                    SideBarEntry info = (SideBarEntry)target;
                    Subscription subs = (Subscription)info.getDatasource();
                    subs.resetHighestVersion();
                }
            }
        };
        this.propertiesListener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof SideBarEntry) {
                    SideBarEntry info = (SideBarEntry)target;
                    Subscription subs = (Subscription)info.getDatasource();
                    SubscriptionManagerUI.this.showProperties(subs);
                }
            }
        };
        this.subs_man.addListener(new SubscriptionManagerListener(){

            public void subscriptionAdded(Subscription subscription) {
                SubscriptionManagerUI.this.addSubscription(side_bar, subscription, true);
            }

            public void subscriptionChanged(Subscription subscription) {
                SubscriptionManagerUI.this.changeSubscription(side_bar, subscription);
            }

            public void subscriptionSelected(Subscription subscription) {
                sideBarItem item = (sideBarItem)subscription.getUserData(SUB_IVIEW_KEY);
                if (item != null) {
                    item.activate();
                }
            }

            public void subscriptionRemoved(Subscription subscription) {
                SubscriptionManagerUI.this.removeSubscription(side_bar, subscription);
            }

            public void associationsChanged(byte[] association_hash) {
            }
        });
        Subscription[] subs = this.subs_man.getSubscriptions();
        for (int i = 0; i < subs.length; ++i) {
            this.addSubscription(side_bar, subs[i], false);
        }
        side_bar.addListener(new SideBarListener(){
            private long last_select = 0L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void sidebarItemSelected(SideBarEntrySWT new_entry, SideBarEntrySWT old_entry) {
                IView view;
                if (new_entry == old_entry && (view = new_entry.getIView()) instanceof subscriptionView) {
                    try {
                        if (SystemTime.getMonotonousTime() - this.last_select > 1000L) {
                            ((subscriptionView)view).updateBrowser(false);
                        }
                    }
                    finally {
                        this.last_select = SystemTime.getMonotonousTime();
                    }
                }
            }
        });
    }

    protected void changeSubscription(SideBar side_bar, Subscription subs) {
        if (subs.isSubscribed()) {
            this.addSubscription(side_bar, subs, true);
        } else {
            this.removeSubscription(side_bar, subs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addSubscription(final SideBar side_bar, final Subscription subs, final boolean show) {
        if (!subs.isSubscribed()) {
            return;
        }
        this.refreshColumns();
        SubscriptionManagerUI subscriptionManagerUI = this;
        synchronized (subscriptionManagerUI) {
            final sideBarItem existing_si = (sideBarItem)subs.getUserData(SUB_IVIEW_KEY);
            if (existing_si == null) {
                final sideBarItem new_si = new sideBarItem();
                subs.setUserData(SUB_IVIEW_KEY, new_si);
                Utils.execSWTThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        SubscriptionManagerUI subscriptionManagerUI = SubscriptionManagerUI.this;
                        synchronized (subscriptionManagerUI) {
                            if (new_si.isDestroyed()) {
                                return;
                            }
                            subscriptionView view = new subscriptionView(subs);
                            new_si.setView(view);
                            String key = "Subscription_" + ByteFormatter.encodeString(subs.getPublicKey());
                            TreeItem tree_item = side_bar.createTreeItemFromIView("Subscriptions", view, key, subs, false, show);
                            SideBarEntrySWT entry = SideBar.getSideBarInfo(key);
                            new_si.setTreeItem(tree_item, entry);
                            SubscriptionManagerUI.this.setStatus(subs, new_si);
                            PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
                            PluginInterface pi = pm.getDefaultPluginInterface();
                            UIManager uim = pi.getUIManager();
                            MenuManager menuManager = uim.getMenuManager();
                            MenuItem menuItem = menuManager.addMenuItem("sidebar." + key, "Subscription.menu.forcecheck");
                            menuItem.setText(MessageText.getString("Subscription.menu.forcecheck"));
                            menuItem.addListener(SubscriptionManagerUI.this.forceCheckListener);
                            menuItem = menuManager.addMenuItem("sidebar." + key, "Subscription.menu.clearall");
                            menuItem.addListener(SubscriptionManagerUI.this.markAllResultsListener);
                            menuItem = menuManager.addMenuItem("sidebar." + key, "Subscription.menu.dirtyall");
                            menuItem.addListener(SubscriptionManagerUI.this.unmarkAllResultsListener);
                            menuItem = menuManager.addMenuItem("sidebar." + key, "Subscription.menu.deleteall");
                            menuItem.addListener(SubscriptionManagerUI.this.deleteAllResultsListener);
                            menuItem = menuManager.addMenuItem("sidebar." + key, "Subscription.menu.reset");
                            menuItem.addListener(SubscriptionManagerUI.this.resetResultsListener);
                            try {
                                Engine e = subs.getEngine();
                                if (e instanceof WebEngine && ((WebEngine)e).isNeedsAuth()) {
                                    menuItem = menuManager.addMenuItem("sidebar." + key, "Subscription.menu.resetauth");
                                    menuItem.addListener(SubscriptionManagerUI.this.resetAuthListener);
                                }
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                            menuManager.addMenuItem("sidebar." + key, "s1").setStyle(4);
                            if (subs.isUpdateable()) {
                                menuItem = menuManager.addMenuItem("sidebar." + key, "MyTorrentsView.menu.rename");
                                menuItem.addListener(SubscriptionManagerUI.this.renameListener);
                            }
                            menuItem = menuManager.addMenuItem("sidebar." + key, "Subscription.menu.upgrade");
                            menuItem.addListener(SubscriptionManagerUI.this.upgradeListener);
                            menuItem.addFillListener(new MenuItemFillListener(){

                                public void menuWillBeShown(MenuItem menu, Object data) {
                                    menu.setVisible(subs.getHighestVersion() > subs.getVersion());
                                }
                            });
                            menuItem = menuManager.addMenuItem("sidebar." + key, "Subscription.menu.export");
                            menuItem.addListener(SubscriptionManagerUI.this.exportListener);
                            menuManager.addMenuItem("sidebar." + key, "s2").setStyle(4);
                            menuItem = menuManager.addMenuItem("sidebar." + key, "Subscription.menu.remove");
                            menuItem.addListener(SubscriptionManagerUI.this.removeListener);
                            menuManager.addMenuItem("sidebar." + key, "s3").setStyle(4);
                            menuItem = menuManager.addMenuItem("sidebar." + key, "Subscription.menu.properties");
                            menuItem.addListener(SubscriptionManagerUI.this.propertiesListener);
                        }
                    }
                });
            } else {
                Utils.execSWTThread(new Runnable(){

                    public void run() {
                        ViewTitleInfoManager.refreshTitleInfo(existing_si.getView());
                        SubscriptionManagerUI.this.setStatus(subs, existing_si);
                    }
                });
            }
        }
    }

    protected void setStatus(Subscription subs, sideBarItem sbi) {
        sbi.setWarning(subs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubscription(SideBar side_bar, Subscription subs) {
        SubscriptionManagerUI subscriptionManagerUI = this;
        synchronized (subscriptionManagerUI) {
            final sideBarItem existing = (sideBarItem)subs.getUserData(SUB_IVIEW_KEY);
            if (existing != null) {
                subs.setUserData(SUB_IVIEW_KEY, null);
                existing.destroy();
                Utils.execSWTThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        SubscriptionManagerUI subscriptionManagerUI = SubscriptionManagerUI.this;
                        synchronized (subscriptionManagerUI) {
                            TreeItem ti = existing.getTreeItem();
                            if (ti != null) {
                                ti.dispose();
                            }
                        }
                    }
                });
            }
        }
        this.refreshColumns();
    }

    protected void refreshView(Subscription subs) {
        subscriptionView view;
        sideBarItem item = (sideBarItem)subs.getUserData(SUB_IVIEW_KEY);
        if (item != null && (view = item.getView()) != null) {
            view.updateBrowser(false);
        }
    }

    protected void refreshColumns() {
        for (TableColumn column : this.columns) {
            column.invalidateCells();
        }
    }

    protected void showProperties(Subscription subs) {
        String engine_str;
        SubscriptionHistory history = subs.getHistory();
        SimpleDateFormat df = new SimpleDateFormat();
        String last_error = history.getLastError();
        if (last_error == null) {
            last_error = "";
        }
        String auth_str = String.valueOf(false);
        try {
            WebEngine web_engine;
            Engine engine = subs.getEngine();
            engine_str = engine.getNameEx();
            if (engine instanceof WebEngine && (web_engine = (WebEngine)engine).isNeedsAuth()) {
                auth_str = String.valueOf(true) + ": cookies=" + this.toString(web_engine.getRequiredCookies());
            }
        }
        catch (Throwable e) {
            engine_str = "Unknown";
            auth_str = "";
        }
        String[] keys = new String[]{"subs.prop.enabled", "subs.prop.is_public", "subs.prop.is_auto", "subs.prop.last_scan", "subs.prop.last_result", "subs.prop.next_scan", "subs.prop.last_error", "subs.prop.num_read", "subs.prop.num_unread", "subs.prop.assoc", "subs.prop.version", "subs.prop.high_version", "subscriptions.listwindow.popularity", "subs.prop.template", "subs.prop.auth"};
        String[] values = new String[]{String.valueOf(history.isEnabled()), String.valueOf(subs.isPublic()), String.valueOf(history.isAutoDownload()), df.format(new Date(history.getLastScanTime())), df.format(new Date(history.getLastNewResultTime())), df.format(new Date(history.getNextScanTime())), last_error.length() == 0 ? MessageText.getString("PeersView.uniquepiece.none") : last_error, String.valueOf(history.getNumRead()), String.valueOf(history.getNumUnread()), String.valueOf(subs.getAssociationCount()), String.valueOf(subs.getVersion()), subs.getHighestVersion() > subs.getVersion() ? String.valueOf(subs.getHighestVersion()) : null, subs.getCachedPopularity() <= 1L ? null : String.valueOf(subs.getCachedPopularity()), engine_str, auth_str};
        new PropertiesWindow(subs.getName(), keys, values);
    }

    private String toString(String[] strs) {
        String res = "";
        for (int i = 0; i < strs.length; ++i) {
            res = res + (i == 0 ? "" : ",") + strs[i];
        }
        return res;
    }

    protected Graphic loadGraphic(UISWTInstance swt, String name) {
        Image image = swt.loadImage("org/gudy/azureus2/ui/icons/" + name);
        UISWTGraphic graphic = swt.createGraphic(image);
        this.icon_list.add(graphic);
        return graphic;
    }

    public static class sideBarItem {
        public static final String ALERT_IMAGE_ID = "image.sidebar.vitality.alert";
        public static final String AUTH_IMAGE_ID = "image.sidebar.vitality.auth";
        private subscriptionView view;
        private SideBarEntrySWT sb_entry;
        private TreeItem tree_item;
        private boolean destroyed;
        private SideBarVitalityImage warning;
        private SideBarVitalityImage spinnerImage;

        protected sideBarItem() {
        }

        protected void setTreeItem(TreeItem _tree_item, SideBarEntrySWT _sb_entry) {
            this.tree_item = _tree_item;
            this.sb_entry = _sb_entry;
            this.warning = this.sb_entry.addVitalityImage(ALERT_IMAGE_ID);
            this.spinnerImage = this.sb_entry.addVitalityImage("image.sidebar.vitality.dots");
            this.spinnerImage.setVisible(false);
            if (this.view != null) {
                this.view.setSpinnerImage(this.spinnerImage);
            }
        }

        protected TreeItem getTreeItem() {
            return this.tree_item;
        }

        protected void setView(subscriptionView _view) {
            this.view = _view;
            if (this.view != null) {
                this.view.setSpinnerImage(this.spinnerImage);
            }
        }

        protected subscriptionView getView() {
            return this.view;
        }

        protected void setWarning(Subscription subs) {
            boolean trouble;
            if (this.warning == null) {
                return;
            }
            SubscriptionHistory history = subs.getHistory();
            String last_error = history.getLastError();
            boolean auth_fail = history.isAuthFail();
            if (history.getConsecFails() < 3 && !auth_fail) {
                last_error = null;
            }
            boolean bl = trouble = last_error != null;
            if (trouble) {
                this.warning.setToolTip(last_error);
                this.warning.setImageID(auth_fail ? AUTH_IMAGE_ID : ALERT_IMAGE_ID);
                this.warning.setVisible(true);
            } else {
                this.warning.setVisible(false);
                this.warning.setToolTip("");
            }
        }

        protected boolean isDestroyed() {
            return this.destroyed;
        }

        protected void destroy() {
            this.destroyed = true;
        }

        public void activate() {
            SideBar sideBar = (SideBar)SkinViewManager.getByClass(SideBar.class);
            if (sideBar != null && this.sb_entry != null) {
                sideBar.showItemByID(this.sb_entry.getId());
            }
        }
    }

    protected static class subscriptionView
    extends AbstractIView
    implements ViewTitleInfo,
    OpenCloseSearchDetailsListener {
        private Subscription subs;
        private Composite parent_composite;
        private Composite composite;
        private Browser mainBrowser;
        private Browser detailsBrowser;
        private SideBarVitalityImage spinnerImage;

        protected subscriptionView(Subscription _subs) {
            this.subs = _subs;
        }

        public void delete() {
            if (this.mainBrowser != null && !this.mainBrowser.isDisposed()) {
                this.mainBrowser.setUrl("about:blank");
                this.mainBrowser.setVisible(false);
            }
            if (this.detailsBrowser != null && !this.detailsBrowser.isDisposed()) {
                this.detailsBrowser.setUrl("about:blank");
                this.detailsBrowser.setVisible(false);
            }
            super.delete();
        }

        public Object getTitleInfoProperty(int propertyID) {
            switch (propertyID) {
                case 5: {
                    return this.subs.getName();
                }
                case 1: {
                    long pop = this.subs.getCachedPopularity();
                    String res = this.subs.getName();
                    if (pop > 1L) {
                        res = res + " (" + MessageText.getString("subscriptions.listwindow.popularity").toLowerCase() + "=" + pop + ")";
                    }
                    return res;
                }
                case 0: {
                    if (this.subs.getHistory().getNumUnread() > 0) {
                        return "" + this.subs.getHistory().getNumUnread();
                    }
                    return null;
                }
            }
            return null;
        }

        public void initialize(Composite _parent_composite) {
            this.parent_composite = _parent_composite;
            this.parent_composite.addListener(22, new Listener(){

                public void handleEvent(Event arg0) {
                    subscriptionView.this.createBrowsers();
                }
            });
            this.parent_composite.addListener(23, new Listener(){

                public void handleEvent(Event arg0) {
                    if (subscriptionView.this.spinnerImage != null) {
                        subscriptionView.this.spinnerImage.setVisible(false);
                    }
                    subscriptionView.this.destroyBrowsers();
                }
            });
            this.composite = new Composite(this.parent_composite, 0);
            this.composite.setLayout((Layout)new FormLayout());
            this.subs.addListener(new SubscriptionListener(){

                public void subscriptionChanged(Subscription subs) {
                    Utils.execSWTThread(new Runnable(){

                        public void run() {
                            subscriptionView.this.updateInfo();
                        }
                    });
                }

                public void subscriptionDownloaded(Subscription subs, boolean auto) {
                    if (auto) {
                        subscriptionView.this.updateBrowser(true);
                    }
                }
            });
            this.updateInfo();
        }

        protected void createBrowsers() {
            try {
                this.mainBrowser = new Browser(this.composite, Utils.getInitialBrowserStyle(0));
                BrowserContext context = new BrowserContext("browser-window" + Math.random(), this.mainBrowser, null, true);
                context.addListener(new BrowserContext.loadingListener(){

                    public void browserLoadingChanged(boolean loading, String url) {
                        if (subscriptionView.this.spinnerImage != null) {
                            subscriptionView.this.spinnerImage.setVisible(loading);
                        }
                    }
                });
                context.addMessageListener(new TorrentListener());
                context.addMessageListener(new VuzeListener());
                context.addMessageListener(new DisplayListener(this.mainBrowser));
                context.addMessageListener(new ConfigListener(this.mainBrowser));
                context.addMessageListener(new MetaSearchListener(this));
                String url = ConstantsV3.URL_PREFIX + "xsearch?subscription=" + this.subs.getID() + "&" + ConstantsV3.URL_SUFFIX;
                Boolean edit_mode = (Boolean)this.subs.getUserData(SUB_EDIT_MODE_KEY);
                if (edit_mode != null) {
                    if (edit_mode.booleanValue()) {
                        url = url + SubscriptionManagerUI.EDIT_MODE_MARKER;
                    }
                    this.subs.setUserData(SUB_EDIT_MODE_KEY, null);
                }
                this.mainBrowser.setUrl(url);
                this.mainBrowser.setData("StartURL", (Object)url);
                FormData data = new FormData();
                data.left = new FormAttachment(0, 0);
                data.right = new FormAttachment(100, 0);
                data.top = new FormAttachment((Control)this.composite, 0);
                data.bottom = new FormAttachment(100, 0);
                this.mainBrowser.setLayoutData((Object)data);
                this.detailsBrowser = new Browser(this.composite, Utils.getInitialBrowserStyle(0));
                BrowserContext detailsContext = new BrowserContext("browser-window" + Math.random(), this.detailsBrowser, null, false);
                detailsContext.addListener(new BrowserContext.loadingListener(){

                    public void browserLoadingChanged(boolean loading, String url) {
                        if (subscriptionView.this.spinnerImage != null) {
                            subscriptionView.this.spinnerImage.setVisible(loading);
                        }
                    }
                });
                ClientMessageContext.torrentURLHandler url_handler = new ClientMessageContext.torrentURLHandler(){

                    public void handleTorrentURL(final String url) {
                        Utils.execSWTThreadWithObject("SMUI", new AERunnableObject(){

                            public Object runSupport() {
                                Subscription subs;
                                String subscriptionId = (String)subscriptionView.this.detailsBrowser.getData("subscription_id");
                                String subscriptionResultId = (String)subscriptionView.this.detailsBrowser.getData("subscription_result_id");
                                if (subscriptionId != null && subscriptionResultId != null && (subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(subscriptionId)) != null) {
                                    subs.addPotentialAssociation(subscriptionResultId, url);
                                }
                                return null;
                            }
                        }, 10000L);
                    }
                };
                detailsContext.setTorrentURLHandler(url_handler);
                TorrentListener torrent_listener = new TorrentListener();
                torrent_listener.setTorrentURLHandler(url_handler);
                detailsContext.addMessageListener(torrent_listener);
                detailsContext.addMessageListener(new VuzeListener());
                detailsContext.addMessageListener(new DisplayListener(this.detailsBrowser));
                detailsContext.addMessageListener(new ConfigListener(this.detailsBrowser));
                url = "about:blank";
                this.detailsBrowser.setUrl(url);
                this.detailsBrowser.setData("StartURL", (Object)url);
                ExternalLoginCookieListener cookieListener = new ExternalLoginCookieListener(new CookiesListener(){

                    public void cookiesFound(String cookies) {
                        subscriptionView.this.detailsBrowser.setData("current-cookies", (Object)cookies);
                    }
                }, this.detailsBrowser);
                cookieListener.hook();
                data = new FormData();
                data.left = new FormAttachment(0, 0);
                data.right = new FormAttachment(100, 0);
                data.top = new FormAttachment((Control)this.mainBrowser, 0);
                data.bottom = new FormAttachment(100, 0);
                this.detailsBrowser.setLayoutData((Object)data);
                this.mainBrowser.setVisible(true);
                this.detailsBrowser.setVisible(false);
                this.mainBrowser.getParent().layout(true, true);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }

        protected void destroyBrowsers() {
            if (this.mainBrowser != null) {
                this.mainBrowser.setUrl("about:blank");
                this.mainBrowser.dispose();
                this.mainBrowser = null;
            }
            if (this.detailsBrowser != null) {
                this.detailsBrowser.setUrl("about:blank");
                this.detailsBrowser.dispose();
                this.detailsBrowser = null;
            }
        }

        public void closeSearchResults(Map params) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    subscriptionView.this.detailsBrowser.setVisible(false);
                    FormData gd = (FormData)subscriptionView.this.mainBrowser.getLayoutData();
                    gd.bottom = new FormAttachment(100, 0);
                    subscriptionView.this.mainBrowser.setLayoutData((Object)gd);
                    subscriptionView.this.mainBrowser.getParent().layout(true);
                    subscriptionView.this.detailsBrowser.setUrl("about:blank");
                }
            });
        }

        public void openSearchResults(final Map params) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    String listenerAdded;
                    String url = MapUtils.getMapString(params, "url", "http://google.com/search?q=" + Math.random());
                    if (PlatformConfigMessenger.urlCanRPC(url)) {
                        url = ConstantsV3.appendURLSuffix(url);
                    }
                    if ((listenerAdded = (String)subscriptionView.this.detailsBrowser.getData("g.nt.la")) == null) {
                        subscriptionView.this.detailsBrowser.setData("g.nt.la", (Object)"");
                        subscriptionView.this.detailsBrowser.addProgressListener(new ProgressListener(){

                            public void changed(ProgressEvent event2) {
                            }

                            public void completed(ProgressEvent event2) {
                                Browser search = (Browser)event2.widget;
                                String execAfterLoad = (String)search.getData("execAfterLoad");
                                search.setData("execAfterLoad", null);
                                if (execAfterLoad != null && !execAfterLoad.equals("")) {
                                    boolean result = search.execute(execAfterLoad);
                                }
                            }
                        });
                    }
                    String execAfterLoad = MapUtils.getMapString(params, "execAfterLoad", null);
                    subscriptionView.this.detailsBrowser.setData("execAfterLoad", (Object)execAfterLoad);
                    subscriptionView.this.detailsBrowser.setData("subscription_id", (Object)MapUtils.getMapString(params, "subs_id", null));
                    subscriptionView.this.detailsBrowser.setData("subscription_result_id", (Object)MapUtils.getMapString(params, "subs_rid", null));
                    subscriptionView.this.detailsBrowser.setUrl(url);
                    subscriptionView.this.detailsBrowser.setVisible(true);
                    FormData data = (FormData)subscriptionView.this.mainBrowser.getLayoutData();
                    data.bottom = null;
                    data.height = MapUtils.getMapInt(params, "top-height", 120);
                    subscriptionView.this.mainBrowser.getParent().layout(true, true);
                }
            });
        }

        protected void updateBrowser(final boolean is_auto) {
            if (this.mainBrowser != null) {
                Utils.execSWTThread(new Runnable(){

                    public void run() {
                        if (subscriptionView.this.mainBrowser != null && subscriptionView.this.mainBrowser.isVisible()) {
                            String url = (String)subscriptionView.this.mainBrowser.getData("StartURL");
                            if (is_auto && url.endsWith(SubscriptionManagerUI.EDIT_MODE_MARKER)) {
                                url = url.substring(0, url.lastIndexOf(SubscriptionManagerUI.EDIT_MODE_MARKER));
                                subscriptionView.this.mainBrowser.setData("StartURL", (Object)url);
                            }
                            subscriptionView.this.mainBrowser.setUrl(url);
                        }
                    }
                });
            }
        }

        protected void updateInfo() {
        }

        public Composite getComposite() {
            return this.composite;
        }

        public String getFullTitle() {
            return this.subs.getName();
        }

        public void resizeMainBrowser() {
            if (this.mainBrowser != null) {
                Utils.execSWTThreadLater(0, new Runnable(){

                    public void run() {
                        if (subscriptionView.this.mainBrowser != null && !subscriptionView.this.mainBrowser.isDisposed() && subscriptionView.this.mainBrowser.isVisible()) {
                            FormData data = (FormData)subscriptionView.this.mainBrowser.getLayoutData();
                            data.bottom = new FormAttachment(100, -1);
                            subscriptionView.this.mainBrowser.getParent().layout(true);
                            Utils.execSWTThreadLater(0, new Runnable(){

                                public void run() {
                                    if (subscriptionView.this.mainBrowser != null && !subscriptionView.this.mainBrowser.isDisposed() && subscriptionView.this.mainBrowser.isVisible()) {
                                        FormData data = (FormData)subscriptionView.this.mainBrowser.getLayoutData();
                                        data.bottom = new FormAttachment(100, 0);
                                        subscriptionView.this.mainBrowser.getParent().layout(true);
                                    }
                                }
                            });
                        }
                    }
                });
            }
        }

        public void resizeSecondaryBrowser() {
        }

        public void setSpinnerImage(SideBarVitalityImage spinnerImage) {
            this.spinnerImage = spinnerImage;
        }
    }
}

