/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.subscriptions;

import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.core.subs.SubscriptionManagerListener;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionAdapter;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.columns.subscriptions.ColumnSubscriptionLastChecked;
import com.aelitis.azureus.ui.swt.columns.subscriptions.ColumnSubscriptionName;
import com.aelitis.azureus.ui.swt.columns.subscriptions.ColumnSubscriptionNbNewResults;
import com.aelitis.azureus.ui.swt.columns.subscriptions.ColumnSubscriptionNbResults;
import com.aelitis.azureus.ui.swt.columns.subscriptions.ColumnSubscriptionNew;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionManagerUI;
import com.aelitis.azureus.ui.swt.toolbar.ToolBarEnabler;
import com.aelitis.azureus.ui.swt.toolbar.ToolBarEnablerSelectedContent;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.utils.ImageLoaderFactory;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;

public class SubscriptionsView
implements UIUpdatable,
IView,
SubscriptionManagerListener,
ToolBarEnabler {
    private static final String TABLE_ID = "subscriptions";
    private TableViewSWT view;
    private Composite viewComposite;
    private Font textFont1;
    private Font textFont2;
    private Image rssImage;

    public void associationsChanged(byte[] association_hash) {
    }

    public void subscriptionSelected(Subscription subscription) {
    }

    public void subscriptionAdded(Subscription subscription) {
        if (subscription.isSubscribed()) {
            this.view.addDataSource(subscription);
        }
    }

    public void subscriptionRemoved(Subscription subscription) {
        this.view.removeDataSource(subscription);
    }

    public void subscriptionChanged(Subscription subscription) {
        if (this.view.getRow(subscription) == null) {
            this.subscriptionAdded(subscription);
        } else {
            this.view.refreshTable(true);
        }
    }

    public boolean isEnabled(String itemKey) {
        if ("remove".equals(itemKey)) {
            return this.view.getSelectedRows().length > 0;
        }
        return false;
    }

    public String getUpdateUIName() {
        return null;
    }

    public boolean isSelected(String itemKey) {
        return false;
    }

    public void itemActivated(String itemKey) {
        if ("remove".equals(itemKey)) {
            this.removeSelected();
        }
    }

    private void removeSelected() {
        TableRowCore[] rows = this.view.getSelectedRows();
        for (int i = 0; i < rows.length; ++i) {
            Subscription subs = (Subscription)rows[i].getDataSource();
            MessageBoxShell mb = new MessageBoxShell(Utils.findAnyShell(), MessageText.getString("message.confirm.delete.title"), MessageText.getString("message.confirm.delete.text", new String[]{subs.getName()}), new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
            int result = mb.open();
            if (result != 0) continue;
            subs.remove();
        }
    }

    public void updateUI() {
    }

    public void dataSourceChanged(Object newDataSource) {
    }

    public void delete() {
        this.view.delete();
        if (this.viewComposite != null && !this.viewComposite.isDisposed()) {
            this.viewComposite.dispose();
        }
        if (this.textFont1 != null && !this.textFont1.isDisposed()) {
            this.textFont1.dispose();
        }
        if (this.textFont2 != null && !this.textFont2.isDisposed()) {
            this.textFont2.dispose();
        }
    }

    public void generateDiagnostics(IndentWriter writer) {
        this.view.generate(writer);
    }

    public Composite getComposite() {
        return this.viewComposite;
    }

    public String getData() {
        return "subscriptions.view.title";
    }

    public String getFullTitle() {
        return MessageText.getString("subscriptions.view.title");
    }

    public String getShortTitle() {
        return MessageText.getString("subscriptions.view.title");
    }

    public void initialize(Composite parent) {
        int i;
        this.viewComposite = new Composite(parent, 0);
        this.viewComposite.setLayout((Layout)new FormLayout());
        TableColumnCore[] columns = new TableColumnCore[]{new ColumnSubscriptionNew(TABLE_ID), new ColumnSubscriptionName(TABLE_ID), new ColumnSubscriptionNbNewResults(TABLE_ID), new ColumnSubscriptionNbResults(TABLE_ID), new ColumnSubscriptionLastChecked(TABLE_ID)};
        this.view = new TableViewSWTImpl(TABLE_ID, TABLE_ID, columns, "name", 0x10010004);
        this.view.addLifeCycleListener(new TableLifeCycleListener(){

            public void tableViewInitialized() {
                SubscriptionManagerFactory.getSingleton().addListener(SubscriptionsView.this);
                SubscriptionsView.this.view.addDataSources(SubscriptionManagerFactory.getSingleton().getSubscriptions(true));
            }

            public void tableViewDestroyed() {
                SubscriptionManagerFactory.getSingleton().removeListener(SubscriptionsView.this);
            }
        });
        this.view.addSelectionListener(new TableSelectionAdapter(){

            public void defaultSelected(TableRowCore[] rows, int stateMask) {
                TableRowCore row;
                Subscription sub;
                if (rows.length == 1 && (sub = (Subscription)(row = rows[0]).getDataSource()) != null) {
                    SubscriptionManagerUI.sideBarItem item = (SubscriptionManagerUI.sideBarItem)sub.getUserData(SubscriptionManagerUI.SUB_IVIEW_KEY);
                    item.activate();
                }
            }

            public void selected(TableRowCore[] rows) {
                ISelectedContent[] sels = new ISelectedContent[]{new ToolBarEnablerSelectedContent(SubscriptionsView.this)};
                SelectedContentManager.changeCurrentlySelectedContent("IconBarEnabler", sels, SubscriptionsView.this.view);
            }
        }, false);
        this.view.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event2) {
            }

            public void keyReleased(KeyEvent event2) {
                if (event2.keyCode == 127) {
                    SubscriptionsView.this.removeSelected();
                }
            }
        });
        this.view.setRowDefaultHeight(20);
        this.view.initialize(this.viewComposite);
        final Composite composite = new Composite(this.viewComposite, 2048);
        composite.setBackgroundMode(1);
        composite.setBackground(ColorCache.getColor((Device)composite.getDisplay(), "#F1F9F8"));
        Font font = composite.getFont();
        FontData[] fDatas = font.getFontData();
        for (i = 0; i < fDatas.length; ++i) {
            fDatas[i].setHeight(150 * fDatas[i].getHeight() / 100);
            if (!Constants.isWindows) continue;
            fDatas[i].setStyle(1);
        }
        this.textFont1 = new Font((Device)composite.getDisplay(), fDatas);
        fDatas = font.getFontData();
        for (i = 0; i < fDatas.length; ++i) {
            fDatas[i].setHeight(120 * fDatas[i].getHeight() / 100);
        }
        this.textFont2 = new Font((Device)composite.getDisplay(), fDatas);
        Label preText = new Label(composite, 0);
        preText.setForeground(ColorCache.getColor((Device)composite.getDisplay(), "#6D6F6E"));
        preText.setFont(this.textFont1);
        preText.setText(MessageText.getString("subscriptions.view.help.1"));
        Label image = new Label(composite, 0);
        image.setImage(ImageRepository.getImage("btn_add_rss"));
        Link postText = new Link(composite, 0);
        postText.setForeground(ColorCache.getColor((Device)composite.getDisplay(), "#6D6F6E"));
        postText.setFont(this.textFont2);
        postText.setText(MessageText.getString("subscriptions.view.help.2"));
        postText.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                if (event2.text != null && (event2.text.startsWith("http://") || event2.text.startsWith("https://"))) {
                    Utils.launch(event2.text);
                }
            }
        });
        Label close = new Label(composite, 0);
        close.setImage(ImageLoaderFactory.getInstance().getImage("image.dismissX"));
        close.setCursor(composite.getDisplay().getSystemCursor(21));
        close.addListener(4, new Listener(){

            public void handleEvent(Event arg0) {
                COConfigurationManager.setParameter("subscriptions.view.showhelp", false);
                composite.setVisible(false);
                FormData data = (FormData)SubscriptionsView.this.view.getComposite().getLayoutData();
                data.bottom = new FormAttachment(100, 0);
                SubscriptionsView.this.viewComposite.layout(true);
            }
        });
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 15);
        data.top = new FormAttachment(0, 20);
        data.bottom = new FormAttachment((Control)postText, -5);
        preText.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)preText, 5);
        data.top = new FormAttachment((Control)preText, 0, 128);
        image.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)preText, 0, 16384);
        data.bottom = new FormAttachment(100, -20);
        postText.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100, -10);
        data.top = new FormAttachment(0, 10);
        close.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment((Control)composite, 0);
        this.view.getComposite().setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        composite.setLayoutData((Object)data);
        COConfigurationManager.setBooleanDefault("subscriptions.view.showhelp", true);
        if (!COConfigurationManager.getBooleanParameter("subscriptions.view.showhelp")) {
            composite.setVisible(false);
            data = (FormData)this.view.getComposite().getLayoutData();
            data.bottom = new FormAttachment(100, 0);
            this.viewComposite.layout(true);
        }
    }

    public void refresh() {
        this.view.refreshTable(false);
    }

    public void updateLanguage() {
        this.view.updateLanguage();
    }

    static {
        ImageRepository.addPath("org/gudy/azureus2/ui/icons/btn_add_rss.png", "btn_add_rss");
    }
}

