/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.tests;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.core.messenger.config.PlatformRatingMessenger;
import com.aelitis.azureus.util.ConstantsV3;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;

public class TestPlatformMessenger {
    public void initialize(PluginInterface pi) throws PluginException {
        ConstantsV3.initialize(AzureusCoreFactory.getSingleton());
        System.out.println(ConstantsV3.URL_SUFFIX);
        PlatformMessenger.init();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("section-type", "browse");
        parameters.put("locale", Locale.getDefault().toString());
        System.out.println(SystemTime.getCurrentTime() + ": queueMessage 0");
        PlatformMessenger.queueMessage(new PlatformMessage("AZMSG", "config", "get-browse-sections", parameters, 150L), new PlatformMessengerListener(){

            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                System.out.println(SystemTime.getCurrentTime() + ": replyRecieved " + message + ";" + replyType + ";" + reply);
            }

            public void messageSent(PlatformMessage message) {
                System.out.println(SystemTime.getCurrentTime() + ": messageSent" + message);
            }
        });
        parameters = new HashMap();
        parameters.put("section-type", "minibrowse");
        parameters.put("locale", Locale.getDefault().toString());
        System.out.println(SystemTime.getCurrentTime() + ": queueMessage 1");
        PlatformMessenger.queueMessage(new PlatformMessage("AZMSG", "config", "get-browse-sections", parameters, 550L), new PlatformMessengerListener(){

            public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                System.out.println(SystemTime.getCurrentTime() + ": replyRecieved " + message + ";" + replyType + ";" + reply);
            }

            public void messageSent(PlatformMessage message) {
                System.out.println(SystemTime.getCurrentTime() + ": messageSent" + message);
            }
        });
        System.out.println(SystemTime.getCurrentTime() + ": queueMessage gr");
        PlatformRatingMessenger.getUserRating(new String[]{"content"}, new String[]{"11"}, 500L);
        System.out.println(SystemTime.getCurrentTime() + ": queueMessage 3");
    }

    public static void dumpMap(Map map, String indent) {
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof Map) {
                System.out.println(key + " - " + ((Map)value).size());
                TestPlatformMessenger.dumpMap((Map)value, indent + "  ");
            }
            System.out.println(indent + key + ": " + value);
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display, 2144);
        shell.open();
        boolean count = false;
        try {
            AzureusCore core = AzureusCoreFactory.create();
            TestPlatformMessenger test = new TestPlatformMessenger();
            test.initialize(core.getPluginManager().getDefaultPluginInterface());
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }
}

