/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.messenger.config.PlatformRatingMessenger;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableCountChangeListener;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfo;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentV3;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnControls;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnIsPrivate;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnIsSeeding;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnMediaThumb;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnProgressETA;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnQuality;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnRate;
import com.aelitis.azureus.ui.swt.columns.torrent.ColumnTitle;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.utils.TorrentUIUtilsV3;
import com.aelitis.azureus.ui.swt.views.TorrentListViewListener;
import com.aelitis.azureus.ui.swt.views.list.ListRow;
import com.aelitis.azureus.ui.swt.views.list.ListView;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import com.aelitis.azureus.ui.swt.views.skin.VuzeShareUtils;
import com.aelitis.azureus.util.ConstantsV3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableCellImpl;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DateAddedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.DateCompletedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.RankItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.SizeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.UpItem;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class TorrentListView
extends ListView
implements GlobalManagerListener {
    public static final int VIEW_DOWNLOADING = 0;
    public static final int VIEW_RECENT_DOWNLOADED = 1;
    public static final int VIEW_MY_MEDIA = 2;
    private static final String[] TABLE_IDS = new String[]{"Downloading", "Recent", "Media"};
    private final dowloadManagerListener dmListener;
    protected final GlobalManager globalManager;
    private final int viewMode;
    private TableColumnCore[] tableColumns;
    private SWTSkinObjectText countArea = null;
    private final ArrayList listeners = new ArrayList();
    private final AEMonitor listeners_mon = new AEMonitor("3.TLV.listeners");
    private final Composite dataArea;
    private boolean bAllowScrolling;
    protected boolean bSkipUpdateCount = false;
    private final AzureusCore core;

    public TorrentListView(SkinView skinView, String skinPrefix, int viewMode, boolean bMiniMode, boolean bAllowScrolling) {
        this(skinView, skinPrefix, viewMode, bMiniMode, null, bAllowScrolling);
    }

    public TorrentListView(SkinView skinView, String skinPrefix, int viewMode, final boolean bMiniMode, String tableID, final boolean bAllowScrolling) {
        if (tableID == null) {
            tableID = TABLE_IDS[viewMode] + (bMiniMode ? "-Mini" : "");
        }
        SWTSkinObject soData = skinView.getSkinObject(skinPrefix + "list");
        SWTSkinObject soHeaders = skinView.getSkinObject(skinPrefix + "list-headers");
        this.init(tableID, skinView.getSkin().getSkinProperties(), soData == null ? null : (Composite)soData.getControl(), soHeaders == null ? null : (Composite)soHeaders.getControl(), bAllowScrolling ? 512 : 0);
        this.core = AzureusCoreFactory.getSingleton();
        SWTSkinObject soExtra = skinView.getSkinObject(skinPrefix + "titlextra");
        if (soExtra instanceof SWTSkinObjectText) {
            this.countArea = (SWTSkinObjectText)soExtra;
        }
        this.dataArea = (Composite)soData.getControl();
        this.viewMode = viewMode;
        this.bAllowScrolling = bAllowScrolling;
        this.dmListener = new dowloadManagerListener(this);
        soData.addListener(new SWTSkinObjectListener(){

            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                if (eventType == 0) {
                    SelectedContentManager.changeCurrentlySelectedContent(TorrentListView.this.getTableID(), TorrentListView.this.getCurrentlySelectedContent(), TorrentListView.this);
                } else if (eventType == 1) {
                    SelectedContentManager.changeCurrentlySelectedContent(TorrentListView.this.getTableID(), null, TorrentListView.this);
                }
                return null;
            }
        });
        if (viewMode == 0) {
            this.setupDownloadingTable(bMiniMode);
        } else if (viewMode == 1) {
            this.setupDownloadedTable(bMiniMode);
        } else if (viewMode == 2) {
            this.setupMyMediaTable(bMiniMode);
        }
        if (this.countArea != null) {
            this.countArea.setText("");
        }
        this.getComposite().addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                if (bMiniMode) {
                    TorrentListView.this.fixupRowCount();
                }
                TorrentListView.this.expandNameColumn();
            }
        });
        Listener l = new Listener(){

            public void handleEvent(Event event2) {
                TableRowCore row;
                if (event2.button == 2 && (row = TorrentListView.this.getRow(event2.x, event2.y)) != null) {
                    TableCellSWT cell;
                    DownloadManager dm = (DownloadManager)row.getDataSource(true);
                    if (dm != null) {
                        TOTorrent torrent = dm.getTorrent();
                        PlatformTorrentUtils.updateMetaData(torrent, 1L);
                        Utils.beep();
                    }
                    if ((event2.stateMask & 0x40000) != 0 && (cell = ((ListRow)row).getTableCellSWT(event2.x, event2.y)) != null) {
                        ((TableCellImpl)cell).bDebug = !((TableCellImpl)cell).bDebug;
                    }
                }
            }
        };
        this.getTableComposite().addListener(4, l);
        this.globalManager = this.core.getGlobalManager();
        this.dataArea.layout();
        this._expandNameColumn();
        this.addLifeCycleListener(new TableLifeCycleListener(){

            public void tableViewInitialized() {
                TorrentListView.this.globalManager.addListener(TorrentListView.this, false);
                TorrentListView.this.dataArea.getDisplay().asyncExec((Runnable)new AERunnable(){

                    public void runSupport() {
                        if (TorrentListView.this.dataArea.isDisposed()) {
                            return;
                        }
                        DownloadManager[] managers = TorrentListView.this.sortDMList(TorrentListView.this.globalManager.getDownloadManagers());
                        TorrentListView.this.bSkipUpdateCount = true;
                        int max = (((TorrentListView)TorrentListView.this).dataArea.getClientArea().height - 8) / TorrentListView.this.rowHeightDefault;
                        for (int i = 0; i < managers.length; ++i) {
                            DownloadManager dm = managers[i];
                            TorrentListView.this.downloadManagerAdded(dm, TorrentListView.this.bSkipUpdateCount);
                            if (max != i) continue;
                            TorrentListView.this.processDataSourceQueue();
                            TorrentListView.this.bSkipUpdateCount = false;
                            TorrentListView.this.updateCount();
                            TorrentListView.this.bSkipUpdateCount = true;
                        }
                        TorrentListView.this.processDataSourceQueue();
                        TorrentListView.this.bSkipUpdateCount = false;
                        if (!bAllowScrolling) {
                            TorrentListView.this.regetDownloads();
                        }
                        TorrentListView.this.updateCount();
                    }
                });
            }

            public void tableViewDestroyed() {
                TorrentListView.this.globalManager.removeListener(TorrentListView.this);
            }
        });
        this.addCountChangeListener(new TableCountChangeListener(){

            public void rowRemoved(TableRowCore row) {
                TorrentListView.this.updateCount();
            }

            public void rowAdded(TableRowCore row) {
                TorrentListView.this.updateCount();
            }
        });
        this.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                block5: {
                    block6: {
                        block4: {
                            if (e.keyCode != 127) break block4;
                            TableRowCore[] selectedRows = TorrentListView.this.getSelectedRows();
                            for (int i = 0; i < selectedRows.length; ++i) {
                                DownloadManager dm = (DownloadManager)selectedRows[i].getDataSource(true);
                                TorrentListViewsUtils.removeDownload(dm, TorrentListView.this);
                            }
                            break block5;
                        }
                        if (e.keyCode != 0x100000E) break block6;
                        TorrentListView.this.updateCount();
                        Object[] selectedDataSources = TorrentListView.this.getSelectedDataSources();
                        for (int i = 0; i < selectedDataSources.length; ++i) {
                            DownloadManager dm = (DownloadManager)selectedDataSources[i];
                            if (dm == null) continue;
                            TOTorrent torrent = dm.getTorrent();
                            if ((e.stateMask & SWT.MOD1) > 0) {
                                PlatformTorrentUtils.setContentLastUpdated(torrent, 0L);
                            }
                            PlatformTorrentUtils.updateMetaData(torrent, 10L);
                            PlatformRatingMessenger.updateGlobalRating(torrent, 10L);
                        }
                        break block5;
                    }
                    if (e.character != '\u000f' || e.stateMask != 393216) break block5;
                    Object[] selectedDataSources = TorrentListView.this.getSelectedDataSources();
                    for (int i = 0; i < selectedDataSources.length; ++i) {
                        TOTorrent torrent;
                        String contentHash;
                        DownloadManager dm = (DownloadManager)selectedDataSources[i];
                        if (dm == null || (contentHash = PlatformTorrentUtils.getContentHash(torrent = dm.getTorrent())) == null || contentHash.length() <= 0) continue;
                        String url = ConstantsV3.URL_PREFIX + "download/" + contentHash + ".torrent?referal=coq";
                        DownloadUrlInfo dlInfo = new DownloadUrlInfo(url);
                        TorrentUIUtilsV3.loadTorrent(TorrentListView.this.core, dlInfo, false, false, true, false);
                    }
                }
            }
        });
    }

    private void setupDownloadedTable(boolean bMiniMode) {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        String tableID = this.getTableID();
        if (bMiniMode) {
            TableColumnCore[] v3TableColumns = new TableColumnCore[]{new ColumnMediaThumb(tableID, 30), new ColumnTitle(tableID), new ColumnQuality(tableID), new SizeItem(tableID), new ColumnRate(tableID, true), new DateCompletedItem(tableID, false)};
            ArrayList<TableColumnCore> listTableColumns = new ArrayList<TableColumnCore>();
            for (int i = 0; i < v3TableColumns.length; ++i) {
                listTableColumns.add(v3TableColumns[i]);
            }
            TableColumnCore[] v2TableColumns = TableColumnCreator.createCompleteDM(tableID);
            this.addColumnsToList(v2TableColumns, listTableColumns);
            this.tableColumns = listTableColumns.toArray(new TableColumnCore[listTableColumns.size()]);
            this.setColumnList(this.tableColumns, "DateCompleted", false, true);
            String[] autoHideOrder = new String[]{"Quality", "size", ColumnMediaThumb.COLUMN_ID};
            tcManager.setAutoHideOrder(this.getTableID(), autoHideOrder);
        } else {
            this.tableColumns = new TableColumnCore[]{new ColumnIsSeeding(tableID), new ColumnMediaThumb(tableID, 30), new ColumnTitle(tableID), new ColumnRate(tableID, true), new SizeItem(tableID), new UpItem(tableID), new ColumnIsPrivate(tableID), new DateCompletedItem(tableID, false)};
            this.setColumnList(this.tableColumns, "date_added", false, true);
            String[] autoHideOrder = new String[]{"Quality", "size", ColumnMediaThumb.COLUMN_ID};
            tcManager.setAutoHideOrder(this.getTableID(), autoHideOrder);
        }
    }

    public void addColumnsToList(TableColumnCore[] v2TableColumns, ArrayList listTableColumns) {
        for (int i = 0; i < v2TableColumns.length; ++i) {
            boolean add = true;
            String name = v2TableColumns[i].getName();
            for (int j = 0; j < listTableColumns.size(); ++j) {
                TableColumnCore v3TC = (TableColumnCore)listTableColumns.get(j);
                if (!v3TC.getName().equals(name)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            v2TableColumns[i].setVisible(false);
            v2TableColumns[i].setPositionNoShift(-2);
            listTableColumns.add(v2TableColumns[i]);
            if (!(v2TableColumns[i] instanceof RankItem)) continue;
            RankItem rankItemColumn = (RankItem)v2TableColumns[i];
            rankItemColumn.setShowCompleteIncomplete(true);
        }
    }

    private void setupDownloadingTable(boolean bMiniMode) {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        String tableID = this.getTableID();
        if (bMiniMode) {
            TableColumnCore[] v3TableColumns = new TableColumnCore[]{new ColumnControls(tableID), new ColumnMediaThumb(tableID, 30), new ColumnTitle(tableID), new ColumnQuality(tableID), new SizeItem(tableID), new ColumnProgressETA(tableID), new DateAddedItem(tableID, false)};
            ArrayList<TableColumnCore> listTableColumns = new ArrayList<TableColumnCore>();
            for (int i = 0; i < v3TableColumns.length; ++i) {
                listTableColumns.add(v3TableColumns[i]);
            }
            TableColumnCore[] v2TableColumns = TableColumnCreator.createIncompleteDM(tableID);
            this.addColumnsToList(v2TableColumns, listTableColumns);
            this.tableColumns = listTableColumns.toArray(new TableColumnCore[listTableColumns.size()]);
            this.setColumnList(this.tableColumns, ColumnControls.COLUMN_ID, false, true);
            String[] autoHideOrder = new String[]{"Quality", "size", ColumnMediaThumb.COLUMN_ID};
            tcManager.setAutoHideOrder(this.getTableID(), autoHideOrder);
        } else {
            this.tableColumns = new TableColumnCore[]{new ColumnMediaThumb(tableID, 30), new ColumnTitle(tableID), new ColumnRate(tableID, true), new ColumnQuality(tableID), new SizeItem(tableID), new ColumnProgressETA(tableID), new DateAddedItem(tableID, false)};
            this.setColumnList(this.tableColumns, "date_added", false, true);
            String[] autoHideOrder = new String[]{"Quality", "size", ColumnMediaThumb.COLUMN_ID, "date_added"};
            tcManager.setAutoHideOrder(this.getTableID(), autoHideOrder);
        }
    }

    public void setColumnList(TableColumnCore[] columns, String defaultSortColumnID, boolean defaultSortAscending, boolean titleIsMinWidth) {
        this.tableColumns = columns;
        super.setColumnList(columns, defaultSortColumnID, defaultSortAscending, titleIsMinWidth);
    }

    private void setupMyMediaTable(boolean bMiniMode) {
        String[] autoHideOrder;
        TableColumnCore[] v3TableColumns;
        String tableID = this.getTableID();
        if (bMiniMode) {
            v3TableColumns = new TableColumnCore[]{new ColumnMediaThumb(tableID, 30), new ColumnTitle(tableID), new ColumnQuality(tableID), new ColumnProgressETA(tableID), new ColumnRate(tableID, true), new DateAddedItem(tableID, false), new DateCompletedItem(tableID, false)};
            autoHideOrder = new String[]{ColumnMediaThumb.COLUMN_ID, "Rating"};
        } else {
            v3TableColumns = new TableColumnCore[]{new ColumnMediaThumb(tableID, 30), new ColumnTitle(tableID), new SizeItem(tableID), new ColumnQuality(tableID), new DateCompletedItem(tableID, true), new ColumnRate(tableID, true), new DateAddedItem(tableID, false)};
            autoHideOrder = new String[]{"Quality", "size", ColumnMediaThumb.COLUMN_ID, "DateCompleted"};
        }
        ArrayList<TableColumnCore> listTableColumns = new ArrayList<TableColumnCore>();
        for (int i = 0; i < v3TableColumns.length; ++i) {
            listTableColumns.add(v3TableColumns[i]);
        }
        TableColumnCore[] v2TableColumns = TableColumnCreator.createIncompleteDM(tableID);
        this.addColumnsToList(v2TableColumns, listTableColumns);
        v2TableColumns = TableColumnCreator.createCompleteDM(tableID);
        this.addColumnsToList(v2TableColumns, listTableColumns);
        this.tableColumns = listTableColumns.toArray(new TableColumnCore[listTableColumns.size()]);
        this.setColumnList(this.tableColumns, bMiniMode ? "ProgressETA" : "date_added", false, true);
        TableColumnManager tcManager = TableColumnManager.getInstance();
        tcManager.setAutoHideOrder(this.getTableID(), autoHideOrder);
    }

    public void regetDownloads() {
        TableRowCore[] selectedRows = this.getSelectedRows();
        final int[] rowIndexes = new int[selectedRows.length];
        int selectedIndex = -1;
        if (selectedRows.length > 0) {
            for (int i = 0; i < selectedRows.length; ++i) {
                rowIndexes[i] = selectedRows[i].getIndex();
            }
        }
        this.removeAllTableRows();
        this.fixupRowCount();
        if (selectedIndex >= 0) {
            this.dataArea.getDisplay().asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    for (int i = 0; i < rowIndexes.length; ++i) {
                        TableRowCore row = TorrentListView.this.getRow(rowIndexes[i]);
                        if (row == null) continue;
                        row.setSelected(true);
                    }
                }
            });
        }
    }

    protected void expandNameColumn() {
    }

    protected void _expandNameColumn() {
        int viewWidth = this.getTableComposite().getClientArea().width;
        int columnWidthTotal = 0;
        int nameColumnIdx = -1;
        TableColumnCore[] columns = this.getVisibleColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (columns[i].getName().equals("name")) {
                nameColumnIdx = i;
                continue;
            }
            columnWidthTotal += columns[i].getWidth() + ListView.COLUMN_MARGIN_WIDTH * 2;
        }
        if (nameColumnIdx >= 0) {
            columns[nameColumnIdx].setWidth(viewWidth - columnWidthTotal - ListView.COLUMN_MARGIN_WIDTH * 2);
        }
    }

    protected void fixupRowCount() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TorrentListView.this._fixupRowCount();
            }
        });
    }

    private void _fixupRowCount() {
        if (this.dataArea.isDisposed() || this.bAllowScrolling) {
            return;
        }
        int changeCount = 0;
        int curRowCount = this.size(true);
        int maxRows = this.bAllowScrolling ? 100000 : (this.dataArea.getClientArea().height - 8) / this.rowHeightDefault;
        long totalPossible = this.getTotalPossible();
        if (curRowCount < maxRows && totalPossible > (long)curRowCount) {
            DownloadManager[] managers = this.sortDMList(this.globalManager.getDownloadManagers());
            int pos = 0;
            int i = 0;
            while ((long)i < totalPossible && curRowCount < maxRows) {
                DownloadManager dm = managers[i];
                if (this.isOurDownload(dm) && !this.dataSourceExists(dm)) {
                    this.addDataSource(dm, false);
                    ++changeCount;
                    ++curRowCount;
                    ++pos;
                }
                ++i;
            }
            this.processDataSourceQueue();
        } else {
            while (curRowCount > maxRows) {
                TableRowCore row;
                if ((row = this.getRow(--curRowCount)) != null) {
                    this.removeDataSource(row.getDataSource(true), true);
                }
                ++changeCount;
            }
        }
        this.updateCount();
    }

    protected DownloadManager[] sortDMList(List dms) {
        DownloadManager[] dmsArray = dms.toArray(new DownloadManager[0]);
        Arrays.sort(dmsArray, new Comparator(){

            public int compare(Object o1, Object o2) {
                long l2;
                boolean bOurDL2;
                DownloadManager dm1 = (DownloadManager)o1;
                DownloadManager dm2 = (DownloadManager)o2;
                boolean bOurDL1 = TorrentListView.this.isOurDownload(dm1);
                if (bOurDL1 != (bOurDL2 = TorrentListView.this.isOurDownload(dm2))) {
                    return bOurDL1 ? -1 : 1;
                }
                long l1 = this.getSortValue(dm1);
                return l1 == (l2 = this.getSortValue(dm2)) ? 0 : (l1 > l2 ? -1 : 1);
            }

            private long getSortValue(DownloadManager dm) {
                if (dm != null) {
                    long completedTime = dm.getDownloadState().getLongParameter("stats.download.completed.time");
                    if (completedTime <= 0L) {
                        return dm.getDownloadState().getLongParameter("stats.download.added.time");
                    }
                    return completedTime;
                }
                return 0L;
            }
        });
        return dmsArray;
    }

    public void destroyInitiated() {
    }

    public void destroyed() {
    }

    public void downloadManagerAdded(final DownloadManager dm) {
        final boolean skipUpdateCount = this.bSkipUpdateCount;
        AEThread2 thread = new AEThread2("TLV:DMA", true){

            public void run() {
                TorrentListView.this.downloadManagerAdded(dm, skipUpdateCount);
            }
        };
        thread.start();
    }

    public void downloadManagerAdded(DownloadManager dm, boolean bSkipUpdateCount) {
        dm.addListener(this.dmListener);
        if (this.isOurDownload(dm) && (this.bAllowScrolling || this.size(true) < (this.getClientArea().height - 8) / this.rowHeightDefault)) {
            this.addDataSource(dm, !bSkipUpdateCount);
            if (!this.bAllowScrolling && !bSkipUpdateCount) {
                this.regetDownloads();
            }
            if (!bSkipUpdateCount) {
                this.updateCount();
            }
        }
    }

    public void downloadManagerRemoved(DownloadManager dm) {
        this.removeDataSource(dm, true);
        if (!this.bAllowScrolling) {
            this.regetDownloads();
        } else {
            this.updateCount();
        }
    }

    public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
    }

    public boolean isOurDownload(DownloadManager dm) {
        if (PlatformTorrentUtils.getAdId(dm.getTorrent()) != null) {
            return false;
        }
        boolean bDownloadComplete = dm.isDownloadComplete(false);
        switch (this.viewMode) {
            case 0: {
                return !bDownloadComplete;
            }
            case 1: {
                return bDownloadComplete;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected void updateCount() {
        if (this.bSkipUpdateCount) {
            return;
        }
        Object[] listenersArray = this.listeners.toArray();
        for (int i = 0; i < listenersArray.length; ++i) {
            TorrentListViewListener l = (TorrentListViewListener)listenersArray[i];
            l.countChanged();
        }
        if (this.countArea != null) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    long size2;
                    if (TorrentListView.this.countArea == null) {
                        return;
                    }
                    long size1 = TorrentListView.this.size(true);
                    if (size1 == (size2 = TorrentListView.this.getTotalPossible())) {
                        TorrentListView.this.countArea.setText(MessageText.getString("v3.MainWindow.count", new String[]{"" + size1}));
                    } else {
                        TorrentListView.this.countArea.setText(MessageText.getString("v3.MainWindow.xofx", new String[]{"" + size1, "" + size2}));
                    }
                }
            });
        }
    }

    private long getTotalPossible() {
        int count = this.viewMode == 0 ? this.globalManager.downloadManagerCount(false) : (this.viewMode == 1 ? this.globalManager.downloadManagerCount(true) : this.globalManager.getDownloadManagers().size());
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TorrentListViewListener l) {
        try {
            this.listeners_mon.enter();
            this.listeners.add(l);
        }
        finally {
            this.listeners_mon.exit();
        }
        l.countChanged();
        l.stateChanged(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(TorrentListViewListener l) {
        try {
            this.listeners_mon.enter();
            this.listeners.remove(l);
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    public void fillMenu(Menu menu) {
        Object[] dm_items = this.getSelectedDataSources(true);
        boolean hasSelection = dm_items.length > 0;
        MenuItem itemExplore = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemExplore, "MyTorrentsView.menu.explore");
        itemExplore.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TorrentListView.this.exploreTorrents();
            }
        });
        itemExplore.setEnabled(hasSelection);
        MenuItem itemShare = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemShare, "v3.Share.menu");
        itemShare.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TorrentListView.this.shareTorrents(TorrentListView.this.getTableID() + "-menu");
            }
        });
        itemShare.setEnabled(hasSelection);
        if (Constants.isCVSVersion()) {
            MenuItem itemAdvanced = new MenuItem(menu, 64);
            itemAdvanced.setText("CVS Version");
            Menu menuAdvanced = new Menu((Decorations)menu.getShell(), 4);
            itemAdvanced.setMenu(menuAdvanced);
            DownloadManager[] dms = new DownloadManager[dm_items.length];
            for (int i = 0; i < dm_items.length; ++i) {
                dms[i] = (DownloadManager)dm_items[i];
            }
            TorrentUtil.fillTorrentMenu(menuAdvanced, dms, this.core, this.dataArea, hasSelection, 0, this);
        }
    }

    private void exploreTorrents() {
        Object[] dataSources = this.getSelectedDataSources();
        for (int i = dataSources.length - 1; i >= 0; --i) {
            DownloadManager dm = (DownloadManager)dataSources[i];
            if (dm == null) continue;
            ManagerUtils.open(dm);
        }
    }

    private void shareTorrents(String referer) {
        ISelectedContent[] contents = SelectedContentManager.getCurrentlySelectedContent();
        if (contents.length > 0) {
            VuzeShareUtils.getInstance().shareTorrent(contents[0], referer);
        }
    }

    public boolean getAllowScrolling() {
        return this.bAllowScrolling;
    }

    public ISelectedContent[] getCurrentlySelectedContent() {
        ArrayList<SelectedContentV3> listContent = new ArrayList<SelectedContentV3>();
        Object[] selectedDataSources = this.getSelectedDataSources(true);
        for (int i = 0; i < selectedDataSources.length; ++i) {
            DownloadManager dm = (DownloadManager)selectedDataSources[i];
            if (dm == null) continue;
            try {
                SelectedContentV3 currentContent = new SelectedContentV3(dm);
                listContent.add(currentContent);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return listContent.toArray(new ISelectedContent[listContent.size()]);
    }

    private static class dowloadManagerListener
    implements DownloadManagerListener {
        private final TorrentListView view;

        public dowloadManagerListener(TorrentListView view) {
            this.view = view;
        }

        public void completionChanged(DownloadManager manager, boolean bCompleted) {
            if (this.view.isOurDownload(manager)) {
                this.view.addDataSource(manager, true);
            } else {
                this.view.removeDataSource(manager, true);
            }
            if (!this.view.getAllowScrolling()) {
                this.view.regetDownloads();
            }
        }

        public void downloadComplete(DownloadManager manager) {
            if (this.view.isOurDownload(manager)) {
                this.view.addDataSource(manager, true);
            } else {
                this.view.removeDataSource(manager, true);
            }
            if (!this.view.getAllowScrolling()) {
                this.view.regetDownloads();
            }
        }

        public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
        }

        public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
        }

        public void stateChanged(final DownloadManager manager, int state) {
            AEThread2 thread = new AEThread2("TLV:SC", true){

                public void run() {
                    Object[] listenersArray = dowloadManagerListener.this.view.listeners.toArray();
                    for (int i = 0; i < listenersArray.length; ++i) {
                        TorrentListViewListener l = (TorrentListViewListener)listenersArray[i];
                        l.stateChanged(manager);
                    }
                    TableRowCore row = dowloadManagerListener.this.view.getRow(manager);
                    if (row != null) {
                        row.refresh(true);
                    }
                }
            };
            thread.setPriority(4);
            thread.start();
        }
    }
}

