/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinFactory;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.graphics.SpeedGraphic;
import org.gudy.azureus2.ui.swt.views.AbstractIView;

public class ViewDownSpeedGraph
extends AbstractIView {
    GlobalManager manager = AzureusCoreFactory.getSingleton().getGlobalManager();
    GlobalManagerStats stats = this.manager.getStats();
    OverallStats totalStats = StatsFactory.getStats();
    Canvas downSpeedCanvas;
    SpeedGraphic downSpeedGraphic;
    TimerEventPeriodic timerEvent;
    private boolean everRefreshed = false;

    public void periodicUpdate() {
        int swarms_peer_speed = (int)this.stats.getTotalSwarmsPeerRate(true, false);
        this.downSpeedGraphic.addIntsValue(new int[]{this.stats.getDataReceiveRate() + this.stats.getProtocolReceiveRate(), this.stats.getProtocolReceiveRate(), COConfigurationManager.getIntParameter("Max Download Speed KBs") * 1024, swarms_peer_speed});
    }

    public void initialize(Composite composite) {
        this.downSpeedCanvas = new Canvas(composite, 0x20000000);
        GridData gridData = new GridData(1808);
        this.downSpeedCanvas.setLayoutData((Object)gridData);
        this.downSpeedGraphic = SpeedGraphic.getInstance();
        this.downSpeedGraphic.initialize(this.downSpeedCanvas);
        SWTSkinProperties skinProperties = SWTSkinFactory.getInstance().getSkinProperties();
        Color cBG1 = skinProperties.getColor("color.topbar.speed.bg1");
        Color cBG2 = skinProperties.getColor("color.topbar.speed.bg2");
        Color cBG3 = skinProperties.getColor("color.topbar.speed.bg3");
        this.downSpeedGraphic.setColors(cBG1, cBG2, cBG3);
        this.downSpeedGraphic.setLineColors(skinProperties.getColor("color.topbar.speed.average"), skinProperties.getColor("color.topbar.speed.value0"), skinProperties.getColor("color.topbar.speed.overhead"), skinProperties.getColor("color.topbar.speed.value1"), skinProperties.getColor("color.topbar.speed.value2plus"), skinProperties.getColor("color.topbar.speed.trimmed"));
    }

    public void delete() {
        Utils.disposeComposite((Composite)this.downSpeedCanvas);
        this.downSpeedGraphic.dispose();
    }

    public String getFullTitle() {
        return "DL Speed";
    }

    public Composite getComposite() {
        return this.downSpeedCanvas;
    }

    public void refresh() {
        if (!this.everRefreshed) {
            this.everRefreshed = true;
            this.timerEvent = SimpleTimer.addPeriodicEvent("TopBarSpeedGraphicView", 1000L, new TimerEventPerformer(){

                public void perform(TimerEvent event2) {
                    if (ViewDownSpeedGraph.this.downSpeedCanvas.isDisposed()) {
                        ViewDownSpeedGraph.this.timerEvent.cancel();
                    } else {
                        ViewDownSpeedGraph.this.periodicUpdate();
                    }
                }
            });
        }
        this.downSpeedGraphic.refresh();
    }

    public String getData() {
        return "SpeedView.title.full";
    }
}

