/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.list;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.swt.views.list.ListRow;
import com.aelitis.azureus.ui.swt.views.list.ListView;
import com.aelitis.azureus.ui.swt.views.list.TableColumnMetrics;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AERunnableObject;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedTableItem;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableCellImpl;

public class ListCell
implements BufferedTableItem {
    protected static final boolean DEBUG_COLORCELL = false;
    private String sText;
    protected Color colorFG;
    protected Color colorBG;
    protected Rectangle bounds;
    protected final ListRow row;
    private final int alignment;
    private boolean bLastIsShown = false;
    protected TableCellCore cell;
    protected TableColumn column;
    private Image imgIcon;
    protected ListView view;
    private int fontHeight = -1;
    private int maxLines = -1;
    protected TableCellSWT parentCell = null;
    private int secretWidth = -1;

    public ListCell(ListRow row, int alignment, Rectangle bounds) {
        this.row = row;
        this.alignment = alignment;
        this.bounds = bounds;
        this.view = row == null ? null : (ListView)row.getView();
        Utils.execSWTThreadWithObject("getCellFontHeight", new AERunnableObject(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object runSupport() {
                Display control;
                Object object = control = ListCell.this.view == null ? Display.getDefault() : ListCell.this.view.getControl();
                if (control != null) {
                    GC gc = new GC((Drawable)control);
                    try {
                        ListCell.this.fontHeight = gc.textExtent((String)"(/|,jI~`gy").y;
                    }
                    finally {
                        gc.dispose();
                    }
                }
                return null;
            }
        }, 15000L);
    }

    public void setView(ListView view) {
        this.view = view;
    }

    public void dispose() {
    }

    public void doPaint(GC gc) {
        boolean hasIcon;
        if (gc == null || gc.isDisposed()) {
            Debug.out("gc is null or disposed");
            return;
        }
        if (!this.isShowable()) {
            return;
        }
        if (this.sText == null) {
            return;
        }
        gc.setForeground(this.getForeground());
        gc.setBackground(this.getBackground());
        Rectangle bounds = this.getBounds();
        if (bounds == null) {
            return;
        }
        gc.fillRectangle(bounds);
        if (((TableCellImpl)this.cell).bDebug) {
            ((TableCellImpl)this.cell).debug("drawText " + bounds);
        }
        Point size = gc.textExtent(this.sText);
        boolean bl = hasIcon = this.imgIcon != null && !this.imgIcon.isDisposed();
        if (hasIcon) {
            int w = this.imgIcon.getBounds().width + 2;
            size.x += w;
            gc.drawImage(this.imgIcon, bounds.x, bounds.y);
            bounds.x += w;
        }
        size.x += ListView.COLUMN_PADDING_WIDTH;
        if (this.column.isMaxWidthAuto() && this.column.getMaxWidth() < size.x) {
            this.column.setMaxWidth(size.x);
        }
        if (this.column.isMinWidthAuto() && this.column.getMinWidth() < size.x) {
            this.column.setMinWidth(size.x);
        }
        if (this.column.isPreferredWidthAuto() && this.column.getPreferredWidth() < size.x) {
            this.column.setPreferredWidth(size.x);
        }
        GCStringPrinter.printString(gc, this.sText, bounds, true, true, this.alignment | 0x40);
    }

    private boolean isShowable() {
        boolean b = this.bounds != null && this.bounds.height > 0 && this.column.isVisible();
        return b;
    }

    public Color getBackground() {
        if (this.colorBG == null && this.row != null) {
            return this.row.getBackground();
        }
        return this.colorBG;
    }

    public void setBackground(Color bg) {
        this.colorBG = bg;
    }

    public Rectangle getBounds() {
        TableColumnMetrics columnMetrics;
        TableColumnMetrics tableColumnMetrics = columnMetrics = this.view == null ? null : this.view.getColumnMetrics(this.column);
        if (columnMetrics == null || this.bounds == null || this.parentCell != null) {
            Rectangle r = new Rectangle(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
            if (this.parentCell != null) {
                Rectangle parentBounds = this.parentCell.getBounds();
                if (parentBounds != null) {
                    r.x += parentBounds.x;
                    r.y += parentBounds.y;
                }
                r.x += this.parentCell.getMarginWidth();
                r.y += this.parentCell.getMarginHeight();
            }
            return r;
        }
        this.bounds.x = columnMetrics.x;
        int n = this.bounds.width = this.secretWidth >= 0 ? this.secretWidth : columnMetrics.width;
        if (this.row != null) {
            try {
                int margin = this.view.getRowMarginHeight();
                this.bounds.y = this.row.getVisibleYOffset() + margin;
                this.bounds.height = this.row.getHeight() - margin * 2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.bounds;
    }

    public void setBounds(Rectangle bounds) {
        if (((TableCellImpl)this.cell).bDebug) {
            ((TableCellImpl)this.cell).debug("setBounds " + bounds);
        }
        this.bounds = bounds;
    }

    public void setSecretWidth(int width) {
        this.secretWidth = width;
    }

    public int getPosition() {
        return this.column.getPosition();
    }

    public String getText() {
        return this.sText;
    }

    public boolean isShown() {
        boolean bIsShown = this.isShowable();
        if (this.row != null) {
            bIsShown &= this.row.isVisible();
        }
        if (bIsShown != this.bLastIsShown) {
            this.bLastIsShown = bIsShown;
            if (this.cell != null) {
                int mode = bIsShown ? 0 : 1;
                this.cell.invokeVisibilityListeners(mode, true);
            }
        }
        return bIsShown;
    }

    public void locationChanged() {
    }

    public boolean needsPainting() {
        return this.isShown();
    }

    public void refresh() {
        this.redraw();
    }

    public void setIcon(Image img) {
        this.imgIcon = img;
    }

    public Image getIcon() {
        return this.imgIcon;
    }

    public boolean setForeground(Color color) {
        if (this.isSameColor(this.colorFG, color)) {
            return false;
        }
        this.colorFG = color;
        return true;
    }

    private boolean isSameColor(Color c1, Color c2) {
        if (c1 == null && c2 == null) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.getRGB().equals((Object)c2.getRGB());
    }

    public boolean setForeground(int red, int green, int blue) {
        return false;
    }

    public void setRowForeground(Color color) {
    }

    public boolean setText(String text) {
        if (this.sText == null && text == null) {
            return false;
        }
        if (this.sText != null && text != null && (this.sText == text || this.sText.equals(text))) {
            return false;
        }
        this.sText = text;
        if (this.view != null) {
            this.view.cellRefresh(this, true, true);
        }
        return true;
    }

    public void redraw() {
        if (!this.isShown()) {
            return;
        }
        if (this.row != null) {
            this.row.redraw();
        }
    }

    public void invalidate() {
    }

    public Image getBackgroundImage() {
        Rectangle bounds = this.getBounds();
        if (bounds == null || bounds.isEmpty()) {
            return null;
        }
        Image image = new Image((Device)Display.getDefault(), bounds.width, bounds.height);
        GC gc = new GC((Drawable)image);
        gc.setBackground(this.getBackground());
        gc.setForeground(this.getBackground());
        gc.fillRectangle(image.getBounds());
        gc.dispose();
        return image;
    }

    public Color getForeground() {
        if (this.colorFG == null && this.row != null) {
            return this.row.getForeground();
        }
        return this.colorFG;
    }

    public ListRow getRow() {
        return this.row;
    }

    public void setTableCell(TableCellCore cell) {
        this.cell = cell;
        this.column = cell.getTableColumn();
    }

    public int getMaxLines() {
        if (this.maxLines <= 0) {
            if (this.fontHeight <= 0) {
                this.maxLines = 1;
            } else {
                Rectangle bounds = this.getBounds();
                if (bounds == null) {
                    return 1;
                }
                this.maxLines = (int)Math.ceil((double)bounds.height / (double)this.fontHeight);
            }
        }
        return this.maxLines;
    }

    public void setCursor(final int cursorID) {
        if (this.view == null) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Composite composite = ListCell.this.view.getComposite();
                composite.setCursor(composite.getDisplay().getSystemCursor(cursorID));
            }
        });
    }

    public boolean isMouseOver() {
        return this.getMouseRelative() != null;
    }

    public Point getMouseRelative() {
        if (this.view == null || this.view.isDisposed()) {
            return null;
        }
        Rectangle bounds = this.getBounds();
        if (this.parentCell != null) {
            // empty if block
        }
        Composite table = this.view.getTableComposite();
        Point pt = Display.getCurrent().getCursorLocation();
        if (!bounds.contains(pt = table.toControl(pt))) {
            return null;
        }
        Point rel = new Point(pt.x - bounds.x, pt.y - bounds.y);
        return rel;
    }

    public TableCellSWT getParentCell() {
        return this.parentCell;
    }

    public void setParentCell(TableCellSWT parentCell) {
        this.parentCell = parentCell;
    }
}

