/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.ui.swt.browser.BrowserContext;
import com.aelitis.azureus.ui.swt.browser.listener.TorrentListener;
import com.aelitis.azureus.ui.swt.browser.listener.VuzeListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBrowser;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTab;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.skin.SWTSkinTabSet;
import com.aelitis.azureus.ui.swt.skin.SWTSkinTabSetListener;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarListener;
import com.aelitis.azureus.util.ConstantsV3;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.plugins.ui.sidebar.SideBarVitalityImage;
import org.gudy.azureus2.ui.swt.Utils;

public class Browse
extends SkinView {
    public static boolean PULL_TABS = false;
    private SWTSkinObjectBrowser browserSkinObject;
    private SWTSkin skin;
    private SWTSkinObject soMain;
    private SideBarVitalityImage vitalityImage;

    public SWTSkinObjectBrowser getBrowserSkinObject() {
        return this.browserSkinObject;
    }

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        SideBarEntrySWT entry;
        this.soMain = skinObject;
        this.skin = skinObject.getSkin();
        this.browserSkinObject = (SWTSkinObjectBrowser)this.skin.getSkinObject("browse", this.soMain);
        SideBar sidebar = (SideBar)SkinViewManager.getByClass(SideBar.class);
        if (sidebar != null && (entry = sidebar.getSideBarEntry(this)) != null) {
            this.vitalityImage = entry.addVitalityImage("image.sidebar.vitality.dots");
            this.vitalityImage.setVisible(false);
            sidebar.addListener(new SideBarListener(){
                long lastSelect = 0L;

                public void sidebarItemSelected(SideBarEntrySWT newSideBarEntry, SideBarEntrySWT oldSideBarEntry) {
                    if (entry == newSideBarEntry) {
                        if (entry == oldSideBarEntry) {
                            if (this.lastSelect < SystemTime.getOffsetTime(-1000L) && Browse.this.browserSkinObject != null) {
                                Browse.this.browserSkinObject.restart();
                            }
                        } else {
                            this.lastSelect = SystemTime.getCurrentTime();
                        }
                    }
                }
            });
        }
        this.browserSkinObject.addListener(new BrowserContext.loadingListener(){

            public void browserLoadingChanged(boolean loading, String url) {
                if (Browse.this.vitalityImage != null) {
                    Browse.this.vitalityImage.setVisible(loading);
                }
            }
        });
        if (PULL_TABS) {
            PlatformConfigMessenger.getBrowseSections("browse", 0L, new PlatformConfigMessenger.GetBrowseSectionsReplyListener(){

                public void replyReceived(final Map[] browseSections) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            Browse.this.createBrowseTabs(Browse.this.browserSkinObject, browseSections);
                        }
                    });
                }

                public void messageSent() {
                }
            });
        } else {
            this.createBrowseArea(this.browserSkinObject);
        }
        if (Constants.isCVSVersion()) {
            PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
            PluginInterface pi = pm.getDefaultPluginInterface();
            UIManager uim = pi.getUIManager();
            MenuManager menuManager = uim.getMenuManager();
            MenuItem menuItem = menuManager.addMenuItem("sidebar.Browse", "Button.reset");
            menuItem.addListener(new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    Browse.this.browserSkinObject.restart();
                }
            });
            menuItem = menuManager.addMenuItem("sidebar.Browse", "Tux RPC Test");
            menuItem.addListener(new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    Browse.this.browserSkinObject.setURL("c:\\test\\BrowserMessaging.html");
                }
            });
        }
        return null;
    }

    private void createBrowseArea(SWTSkinObjectBrowser browserSkinObject) {
        this.browserSkinObject = browserSkinObject;
        browserSkinObject.setURL(ConstantsV3.URL_PREFIX + "browse.start" + "?" + ConstantsV3.URL_SUFFIX);
    }

    protected void createBrowseTabs(SWTSkinObject skinObject, final Map[] browseSections) {
        AzureusCore core = AzureusCoreFactory.getSingleton();
        Composite cArea = (Composite)skinObject.getControl();
        final Browser browser = new Browser(cArea, Utils.getInitialBrowserStyle(0));
        BrowserContext context = new BrowserContext("big", browser, null, true);
        context.addMessageListener(new TorrentListener(core));
        context.addMessageListener(new VuzeListener());
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        browser.setLayoutData((Object)formData);
        skinObject = this.skin.getSkinObject("browse-tabs");
        if (skinObject == null) {
            return;
        }
        Control previousControl = null;
        SWTSkinTabSet tabSet = null;
        for (int i = 0; i < browseSections.length; ++i) {
            String sTabName = (String)browseSections[i].get("title");
            String sTabID = "internal.browse.tab." + i;
            SWTSkinObjectTab skinTab = this.skin.createTab(sTabID, "tab", skinObject);
            if (skinTab == null) continue;
            if (tabSet == null) {
                tabSet = this.skin.getTabSet(skinTab);
            }
            Control currentControl = skinTab.getControl();
            if (previousControl != null) {
                formData = (FormData)skinTab.getControl().getLayoutData();
                if (formData == null) {
                    formData = new FormData();
                }
                formData.left = new FormAttachment(previousControl, 1);
                currentControl.setLayoutData((Object)formData);
            }
            previousControl = currentControl;
            SWTSkinObject tabText = this.skin.getSkinObject("browse-tab-text", skinTab);
            if (tabText instanceof SWTSkinObjectText) {
                ((SWTSkinObjectText)tabText).setText(sTabName);
            }
            if (i != 0) continue;
            tabSet.addListener(new SWTSkinTabSetListener(){

                public void tabChanged(SWTSkinTabSet tabSet, String oldTabID, String newTabID) {
                    System.out.println(newTabID);
                    browser.stop();
                    browser.execute("document.clear(); document.write('Loading..');");
                    char c = newTabID.charAt(newTabID.length() - 1);
                    int i = c - 48;
                    if (i >= 0 && i < browseSections.length) {
                        browser.setUrl((String)browseSections[i].get("url"));
                        System.out.println(browser.getUrl());
                    }
                }
            });
            tabSet.setActiveTabByID(sTabID);
        }
        cArea.getParent().layout(true);
    }
}

