/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.buddy.VuzeBuddy;
import com.aelitis.azureus.buddy.VuzeBuddyListener;
import com.aelitis.azureus.buddy.chat.Chat;
import com.aelitis.azureus.buddy.chat.ChatDiscussion;
import com.aelitis.azureus.buddy.chat.ChatListener;
import com.aelitis.azureus.buddy.chat.ChatMessage;
import com.aelitis.azureus.buddy.impl.VuzeBuddyManager;
import com.aelitis.azureus.plugins.net.buddy.BuddyPlugin;
import com.aelitis.azureus.ui.swt.buddy.VuzeBuddySWT;
import com.aelitis.azureus.ui.swt.buddy.chat.impl.MessageNotificationWindow;
import com.aelitis.azureus.ui.swt.layout.SimpleReorderableListLayout;
import com.aelitis.azureus.ui.swt.layout.SimpleReorderableListLayoutData;
import com.aelitis.azureus.ui.swt.shells.friends.SharePage;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.views.skin.AvatarWidget;
import com.aelitis.azureus.ui.swt.views.skin.FriendsToolbar;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.ui.common.util.UserAlerts;
import org.gudy.azureus2.ui.swt.Utils;

public class BuddiesViewer
extends SkinView {
    private static final boolean SHOW_ONLINE_STATUS = System.getProperty("az.buddy.show_online", "1").equals("1");
    public static final int none_active_mode = 0;
    public static final int edit_mode = 1;
    public static final int share_mode = 2;
    public static final int invite_mode = 3;
    public static final int add_buddy_mode = 4;
    public static final int disabled_mode = 5;
    private Composite avatarsPanel = null;
    private Composite parent = null;
    private SWTSkin skin = null;
    private int avatarHightLightBorder;
    private int avatarImageBorder;
    private Point avatarImageSize = null;
    private Point avatarNameSize = null;
    private Point avatarSize = null;
    private int hSpacing;
    private List avatarWidgets = new ArrayList();
    private boolean isShareMode = false;
    private boolean isEditMode = false;
    private boolean isAddBuddyMode = false;
    private boolean isEnabled = true;
    private Color textColor = null;
    private Color selectedTextColor = null;
    private Color textLinkColor = null;
    private Color imageBorderColor = null;
    private Color selectedColor = null;
    private Color highlightedColor = null;
    private SWTSkinObject soNoBuddies;
    private SharePage sharePage;
    private List buddiesList;
    private boolean reorder_outstanding;
    private Chat chat = new Chat();
    private Color colorFileDragBorder;
    private Color colorFileDragBG;
    private ScrolledComposite scrollable;

    public BuddiesViewer() {
        this.chat.addChatListener(new ChatListener(){

            public void newMessage(VuzeBuddy from, final ChatMessage message) {
                final AvatarWidget avatarWidget = BuddiesViewer.this.findWidget(from);
                if (avatarWidget != null) {
                    avatarWidget.setChatDiscussion(BuddiesViewer.this.chat.getChatDiscussionFor(from));
                    BuddyPlugin plugin = VuzeBuddyManager.getBuddyPlugin();
                    if (plugin != null) {
                        BooleanParameter enabledNotifictions = plugin.getEnableChatNotificationsParameter();
                        if (!message.isMe() && enabledNotifictions.getValue()) {
                            avatarWidget.getControl().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    boolean isVisible = true;
                                    if (BuddiesViewer.this.avatarsPanel != null) {
                                        if (!BuddiesViewer.this.avatarsPanel.isVisible()) {
                                            isVisible = false;
                                        }
                                        if (BuddiesViewer.this.avatarsPanel.getShell().getDisplay().getActiveShell() == null) {
                                            isVisible = false;
                                        }
                                    }
                                    if (!isVisible) {
                                        new MessageNotificationWindow(avatarWidget, message);
                                        UserAlerts.requestUserAttention(1, null);
                                    }
                                }
                            });
                        }
                    }
                }
            }

            public void updatedChat(VuzeBuddy buddy) {
                AvatarWidget avatarWidget = BuddiesViewer.this.findWidget(buddy);
                if (avatarWidget != null) {
                    avatarWidget.setChatDiscussion(BuddiesViewer.this.chat.getChatDiscussionFor(buddy));
                }
            }
        });
    }

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.skin = skinObject.getSkin();
        SWTSkinProperties properties = this.skin.getSkinProperties();
        this.colorFileDragBorder = properties.getColor("color.buddy.filedrag.bg.border");
        this.colorFileDragBG = properties.getColor("color.buddy.filedrag.bg");
        this.soNoBuddies = this.skin.getSkinObject("buddies-viewer-nobuddies-panel");
        SWTSkinObject viewer = this.skin.getSkinObject("buddies-viewer");
        if (null != viewer) {
            this.parent = (Composite)skinObject.getControl();
            this.parent.setBackgroundMode(2);
            this.scrollable = new ScrolledComposite(this.parent, 512);
            this.scrollable.setExpandHorizontal(true);
            this.scrollable.setExpandVertical(true);
            this.scrollable.setBackgroundMode(2);
            this.scrollable.getVerticalBar().setIncrement(10);
            this.scrollable.getVerticalBar().setPageIncrement(65);
            FormData fd = new FormData();
            fd.top = new FormAttachment(0, 0);
            fd.bottom = new FormAttachment(100, 0);
            fd.left = new FormAttachment(0, 0);
            fd.right = new FormAttachment(100, 0);
            this.scrollable.setLayoutData((Object)fd);
            this.avatarsPanel = new Composite((Composite)this.scrollable, 0);
            this.avatarsPanel.setBackgroundMode(2);
            this.scrollable.setContent((Control)this.avatarsPanel);
            this.scrollable.addListener(11, new Listener(){

                public void handleEvent(Event event2) {
                    Rectangle r = BuddiesViewer.this.scrollable.getClientArea();
                    BuddiesViewer.this.scrollable.setMinHeight(((BuddiesViewer)BuddiesViewer.this).avatarsPanel.computeSize((int)r.width, (int)-1).y);
                }
            });
            this.textColor = this.parent.getDisplay().getSystemColor(24);
            this.selectedTextColor = this.parent.getDisplay().getSystemColor(27);
            this.textLinkColor = properties.getColor("color.links.hover");
            this.imageBorderColor = properties.getColor("color.buddy.bg.border");
            this.selectedColor = this.parent.getDisplay().getSystemColor(26);
            this.highlightedColor = this.parent.getDisplay().getSystemColor(17);
            this.avatarHightLightBorder = 0;
            this.avatarImageBorder = 1;
            this.hSpacing = 1;
            this.avatarImageSize = new Point(40, 40);
            this.avatarNameSize = new Point(60, 30);
            this.avatarSize = new Point(0, 0);
            this.avatarSize.x = Math.max(this.avatarNameSize.x, this.avatarImageSize.x) + 2 * (this.avatarHightLightBorder + this.avatarImageBorder);
            this.avatarSize.y = this.avatarNameSize.y + this.avatarImageSize.y + (2 * (this.avatarHightLightBorder + this.avatarImageBorder) + 6);
            this.fillBuddies(this.avatarsPanel);
            SimpleReorderableListLayout rLayout = new SimpleReorderableListLayout();
            rLayout.margin = this.hSpacing;
            rLayout.wrap = true;
            rLayout.center = true;
            this.avatarsPanel.setLayout((Layout)rLayout);
            this.avatarsPanel.pack();
            this.avatarsPanel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    BuddiesViewer.this.select(null, false, false);
                }
            });
            this.avatarsPanel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    BuddiesViewer.this.select(null, false, false);
                }
            });
            this.parent.layout();
            this.hookFAQLink();
            this.hookImageAction();
        }
        return null;
    }

    public boolean isEditMode() {
        return this.isEditMode;
    }

    public void setEditMode(boolean value) {
        if (this.isEditMode != value) {
            this.isEditMode = value;
            for (AvatarWidget widget : this.avatarWidgets) {
                widget.refreshVisual();
            }
            if (value) {
                this.setShareMode(false, null);
                this.setAddBuddyMode(false);
            }
        }
    }

    private void fillBuddies(Composite composite) {
        List buddies = this.getBuddies();
        this.showNoBuddiesPanel(buddies.size() == 0);
        for (VuzeBuddySWT vuzeBuddy : buddies) {
            this.createBuddyControls(composite, vuzeBuddy);
        }
        composite.layout();
        Point size = composite.computeSize(-1, -1, true);
        composite.setSize(size);
    }

    private void showNoBuddiesPanel(boolean value) {
        if (this.soNoBuddies != null && this.soNoBuddies.isVisible() != value) {
            this.soNoBuddies.setVisible(value);
        }
    }

    private AvatarWidget createBuddyControls(Composite composite, VuzeBuddySWT vuzeBuddy) {
        AvatarWidget avatarWidget = new AvatarWidget(this, this.avatarSize, this.avatarImageSize, this.avatarNameSize, vuzeBuddy);
        avatarWidget.setBorderWidth(this.avatarHightLightBorder);
        avatarWidget.setTextColor(this.textColor);
        avatarWidget.setSelectedTextColor(this.selectedTextColor);
        avatarWidget.setTextLinkColor(this.textLinkColor);
        avatarWidget.setImageBorderColor(this.imageBorderColor);
        avatarWidget.setImageBorder(this.avatarImageBorder);
        avatarWidget.setSelectedColor(this.selectedColor);
        avatarWidget.setHighlightedColor(this.highlightedColor);
        SimpleReorderableListLayoutData rData = new SimpleReorderableListLayoutData();
        rData.width = this.avatarSize.x;
        rData.height = this.avatarSize.y;
        rData.position = (int)VuzeBuddyManager.getBuddyPosition(vuzeBuddy);
        avatarWidget.getControl().setLayoutData((Object)rData);
        this.avatarWidgets.add(avatarWidget);
        this.chat.checkBuddy(vuzeBuddy);
        return avatarWidget;
    }

    public boolean isFullyVisible(AvatarWidget avatarWidget) {
        if (null != avatarWidget && null != avatarWidget.getControl() && !avatarWidget.getControl().isDisposed()) {
            Rectangle controlBounds = avatarWidget.getControl().getBounds();
            if (controlBounds.x + controlBounds.width < this.avatarsPanel.getBounds().width - this.avatarsPanel.getBounds().x) {
                return true;
            }
        }
        return false;
    }

    public void removeBuddy(final AvatarWidget widget) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                BuddiesViewer.this.avatarWidgets.remove(widget);
                widget.dispose(true, new AvatarWidget.AfterDisposeListener(){

                    public void disposed() {
                        BuddiesViewer.this.avatarsPanel.setSize(BuddiesViewer.this.avatarsPanel.computeSize(-1, -1, true));
                        if (BuddiesViewer.this.avatarWidgets.size() < 1) {
                            BuddiesViewer.this.showNoBuddiesPanel(true);
                        }
                    }
                });
            }
        });
    }

    public void removeBuddy(VuzeBuddy buddy) {
        AvatarWidget widget = this.findWidget(buddy);
        if (null != widget) {
            this.removeBuddy(widget);
        } else {
            Debug.out("Unknown VuzeBuddy; can not remove from viewer since we don't have it.");
        }
    }

    public void updateBuddy(final VuzeBuddy buddy) {
        if (buddy instanceof VuzeBuddySWT) {
            Utils.execSWTThreadLater(0, new AERunnable(){

                public void runSupport() {
                    AvatarWidget widget = BuddiesViewer.this.findWidget(buddy);
                    if (null != widget) {
                        widget.setVuzeBuddy((VuzeBuddySWT)buddy);
                    } else {
                        BuddiesViewer.this.addBuddy(buddy);
                    }
                }
            });
        }
    }

    public void addBuddy(final VuzeBuddy buddy) {
        if (buddy instanceof VuzeBuddySWT) {
            Utils.execSWTThreadLater(0, new AERunnable(){

                public void runSupport() {
                    AvatarWidget widget = BuddiesViewer.this.findWidget(buddy);
                    if (widget == null) {
                        if (BuddiesViewer.this.soNoBuddies != null) {
                            BuddiesViewer.this.soNoBuddies.setVisible(false);
                        }
                        BuddiesViewer.this.createBuddyControls(BuddiesViewer.this.avatarsPanel, (VuzeBuddySWT)buddy);
                        BuddiesViewer.this.avatarsPanel.layout();
                        Point size = BuddiesViewer.this.avatarsPanel.computeSize(-1, -1, true);
                        BuddiesViewer.this.avatarsPanel.setSize(size);
                    }
                }
            });
        } else {
            Debug.out("Wrong type VuzeBuddy... must be of type VuzeBuddySWT");
        }
    }

    private AvatarWidget findWidget(VuzeBuddy buddy) {
        if (null != buddy) {
            for (AvatarWidget widget : this.avatarWidgets) {
                if (null == widget.getVuzeBuddy() || !buddy.getLoginID().equals(widget.getVuzeBuddy().getLoginID())) continue;
                return widget;
            }
        }
        return null;
    }

    public List getSelection() {
        ArrayList<VuzeBuddySWT> selected = new ArrayList<VuzeBuddySWT>();
        for (AvatarWidget widget : this.avatarWidgets) {
            if (!widget.isSelected()) continue;
            selected.add(widget.getVuzeBuddy());
        }
        return selected;
    }

    public void select(VuzeBuddySWT buddy, boolean value, boolean appendSelection) {
        if (null != buddy) {
            for (AvatarWidget widget : this.avatarWidgets) {
                if (buddy.equals(widget.getVuzeBuddy())) {
                    widget.setSelected(value);
                    if (!appendSelection) continue;
                    break;
                }
                if (appendSelection) continue;
                if (value) {
                    if (!widget.isSelected()) continue;
                    widget.setSelected(false);
                    widget.refreshVisual();
                    continue;
                }
                widget.setSelected(false);
                widget.refreshVisual();
            }
        } else {
            for (AvatarWidget widget : this.avatarWidgets) {
                if (!widget.isSelected()) continue;
                widget.setSelected(false);
                widget.refreshVisual();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recomputeOrder(boolean delay) {
        if (delay) {
            BuddiesViewer buddiesViewer = this;
            synchronized (buddiesViewer) {
                if (this.reorder_outstanding) {
                    return;
                }
                this.reorder_outstanding = true;
                new DelayedEvent("BuddiesViewer:delayReorder", 5000L, new AERunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void runSupport() {
                        BuddiesViewer buddiesViewer = BuddiesViewer.this;
                        synchronized (buddiesViewer) {
                            BuddiesViewer.this.reorder_outstanding = false;
                        }
                        BuddiesViewer.this.recomputeOrder(false);
                    }
                });
                return;
            }
        }
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                if (BuddiesViewer.this.avatarsPanel.isDisposed()) {
                    return;
                }
                List buddies = VuzeBuddyManager.getAllVuzeBuddies();
                if (SHOW_ONLINE_STATUS) {
                    Collections.sort(buddies, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            VuzeBuddy v1 = (VuzeBuddy)o1;
                            VuzeBuddy v2 = (VuzeBuddy)o2;
                            int score = 0;
                            ChatDiscussion d1 = BuddiesViewer.this.getChat().getChatDiscussionFor(v1);
                            ChatDiscussion d2 = BuddiesViewer.this.getChat().getChatDiscussionFor(v2);
                            if (d1 != null && d1.getUnreadMessages() > 0) {
                                --score;
                            }
                            if (d2 != null && d2.getUnreadMessages() > 0) {
                                ++score;
                            }
                            if (score == 0) {
                                if (d1 != null && d1.getNbMessages() > 0) {
                                    --score;
                                }
                                if (d2 != null && d2.getNbMessages() > 0) {
                                    ++score;
                                }
                            }
                            if (score == 0) {
                                score -= v1.isOnline(true) ? 1 : 0;
                                score += v2.isOnline(true) ? 1 : 0;
                            }
                            return score;
                        }
                    });
                }
                boolean changed = false;
                for (int i = 0; i < buddies.size(); ++i) {
                    Object data;
                    Control control;
                    VuzeBuddy buddy = (VuzeBuddy)buddies.get(i);
                    AvatarWidget widget = BuddiesViewer.this.findWidget(buddy);
                    if (widget == null || (control = widget.getControl()) == null || control.isDisposed() || !((data = widget.getControl().getLayoutData()) instanceof SimpleReorderableListLayoutData)) continue;
                    SimpleReorderableListLayoutData rData = (SimpleReorderableListLayoutData)widget.getControl().getLayoutData();
                    if (rData.position == i) continue;
                    rData.position = i;
                    changed = true;
                }
                if (changed) {
                    BuddiesViewer.this.avatarsPanel.layout();
                }
            }
        });
    }

    private List getBuddies() {
        if (null == this.buddiesList) {
            VuzeBuddyManager.addListener(new VuzeBuddyListener(){

                public void buddyRemoved(VuzeBuddy buddy) {
                    BuddiesViewer.this.removeBuddy(buddy);
                    BuddiesViewer.this.recomputeOrder(false);
                }

                public void buddyChanged(VuzeBuddy buddy) {
                    BuddiesViewer.this.updateBuddy(buddy);
                    BuddiesViewer.this.recomputeOrder(true);
                }

                public void buddyAdded(VuzeBuddy buddy, int position) {
                    BuddiesViewer.this.addBuddy(buddy);
                    BuddiesViewer.this.recomputeOrder(false);
                }

                public void buddyOrderChanged() {
                }
            }, false);
        }
        this.buddiesList = VuzeBuddyManager.getAllVuzeBuddies();
        return this.buddiesList;
    }

    public Composite getControl() {
        return this.avatarsPanel;
    }

    public boolean isShareMode() {
        return this.isShareMode;
    }

    public void addAllToShare() {
        this.addToShare(this.avatarWidgets);
    }

    public void removeAllFromShare() {
        this.removeFromShare(this.avatarWidgets);
    }

    public void addToShare(List avatars) {
        for (Object object : avatars) {
            if (!(object instanceof AvatarWidget)) continue;
            this.addToShare((AvatarWidget)object);
        }
    }

    public void addToShare(AvatarWidget widget) {
        if (this.sharePage != null) {
            this.sharePage.addBuddy(widget.getVuzeBuddy());
        }
        widget.setSharedAlready(true);
    }

    public void removeFromShare(List avatars) {
        for (Object object : avatars) {
            if (!(object instanceof AvatarWidget)) continue;
            this.removeFromShare((AvatarWidget)object);
        }
    }

    public void removeFromShare(AvatarWidget widget) {
        if (this.sharePage != null) {
            this.sharePage.removeBuddy(widget.getVuzeBuddy());
        }
        widget.setSharedAlready(false);
    }

    public void addToShare(VuzeBuddy buddy) {
        AvatarWidget widget = this.findWidget(buddy);
        if (null != widget && !widget.isSharedAlready()) {
            this.addToShare(widget);
        }
    }

    public void addSelectionToShare() {
        for (AvatarWidget widget : this.avatarWidgets) {
            if (!widget.isSelected()) continue;
            this.addToShare(widget);
        }
    }

    public void removeFromShare(VuzeBuddy buddy) {
        if (null != buddy) {
            for (AvatarWidget widget : this.avatarWidgets) {
                if (null == widget.getVuzeBuddy() || !buddy.getLoginID().equals(widget.getVuzeBuddy().getLoginID())) continue;
                if (this.sharePage != null) {
                    this.sharePage.removeBuddy(widget.getVuzeBuddy());
                }
                widget.setSharedAlready(false);
                break;
            }
        }
    }

    public void setShareMode(boolean isShareMode, SharePage sharePage) {
        this.sharePage = sharePage;
        if (this.isShareMode != isShareMode) {
            this.isShareMode = isShareMode;
            for (AvatarWidget widget : this.avatarWidgets) {
                if (!isShareMode) {
                    widget.setSharedAlready(false);
                }
                widget.refreshVisual();
            }
            if (isShareMode) {
                this.setEditMode(false);
                this.setAddBuddyMode(false);
            }
        }
    }

    public boolean isNonActiveMode() {
        return !this.isAddBuddyMode() && !this.isShareMode() && !this.isEditMode();
    }

    public boolean isAddBuddyMode() {
        return this.isAddBuddyMode;
    }

    public void setAddBuddyMode(boolean isAddBuddyMode) {
        this.isAddBuddyMode = isAddBuddyMode;
        if (isAddBuddyMode) {
            this.setShareMode(false, null);
            this.setEditMode(false);
        }
    }

    public void setMode(int mode) {
        if (mode == 0) {
            this.setShareMode(false, null);
            this.setEditMode(false);
            this.setAddBuddyMode(false);
        } else if (mode == 1) {
            this.setEditMode(true);
        } else if (mode == 2) {
            this.setShareMode(true, this.sharePage);
        } else if (mode == 4) {
            this.setAddBuddyMode(true);
        }
        if (mode == 5) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public void hookFAQLink() {
        SWTSkinObject FAQObject = this.skin.getSkinObject("buddies-viewer-nobuddies-link");
        if (null != FAQObject) {
            SWTSkinButtonUtility FAQButton = new SWTSkinButtonUtility(FAQObject);
            FAQButton.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    String url = "http://faq.vuze.com/?View=entry&EntryID=190";
                    Utils.launch(url);
                }
            });
        }
    }

    public void hookImageAction() {
        SWTSkinObject imageObject = this.skin.getSkinObject("buddies-viewer-nobuddies-graphic");
        if (null != imageObject) {
            SWTSkinButtonUtility imageButton = new SWTSkinButtonUtility(imageObject);
            imageButton.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    FriendsToolbar friendsToolbar = (FriendsToolbar)SkinViewManager.getByClass(FriendsToolbar.class);
                    if (friendsToolbar != null) {
                        friendsToolbar.addBuddy();
                    }
                }
            });
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        if (this.isEnabled != isEnabled) {
            this.isEnabled = isEnabled;
            this.avatarsPanel.setEnabled(isEnabled);
            this.avatarsPanel.layout(true);
        }
    }

    public Chat getChat() {
        return this.chat;
    }

    public Color getColorFileDragBorder() {
        return this.colorFileDragBorder;
    }

    public Color getColorFileDragBG() {
        return this.colorFileDragBG;
    }
}

