/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.buddy.VuzeBuddy;
import com.aelitis.azureus.buddy.VuzeBuddyListener;
import com.aelitis.azureus.buddy.impl.VuzeBuddyManager;
import com.aelitis.azureus.core.messenger.config.PlatformBuddyMessenger;
import com.aelitis.azureus.core.messenger.config.PlatformRelayMessenger;
import com.aelitis.azureus.login.NotLoggedInException;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.shells.friends.AddFriendsPage;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectSash;
import com.aelitis.azureus.ui.swt.utils.SWTLoginUtils;
import com.aelitis.azureus.ui.swt.views.skin.BuddiesViewer;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.util.ConstantsV3;
import com.aelitis.azureus.util.ILoginInfoListener;
import com.aelitis.azureus.util.LoginInfoManager;
import java.util.List;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.DockPosition;
import org.gudy.azureus2.ui.swt.shells.InputShell;
import org.gudy.azureus2.ui.swt.shells.MultipageWizard;
import org.gudy.azureus2.ui.swt.shells.Offset;
import org.gudy.azureus2.ui.swt.shells.ShellDocker;

public class FriendsToolbar
extends SkinView {
    private Label friendsLabel;
    private Label friendsCountLabel;
    private Label onlineFriendsLabel;
    private Label showHideButton;
    private Composite parent;
    private Composite content;
    private Composite shareWithAllPanel;
    private Label edit;
    private Label addFriends;
    private Label image;
    private Label text;
    private int toolbarHeight = 45;
    private Color friendsTextColor;
    private Color numberOfFriendsTextColor;
    private Color secondaryTextColor;
    private Color hoverTextColor;
    private Font boldFont;
    private Font friendsFont;
    private Listener hoverListener;

    public FriendsToolbar() {
    }

    public FriendsToolbar(Composite parent) {
        this.parent = parent;
        this.init();
    }

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.skin = skinObject.getSkin();
        this.parent = (Composite)skinObject.getControl();
        this.init();
        return null;
    }

    private void init() {
        int i;
        if (null == this.parent || this.parent.isDisposed()) {
            throw new NullPointerException("Parent cannot be null or disposed");
        }
        Layout parentLayout = this.parent.getLayout();
        if (null == parentLayout) {
            parentLayout = new FormLayout();
            this.parent.setLayout(parentLayout);
        } else if (!(parentLayout instanceof FormLayout)) {
            throw new IllegalArgumentException("Oops! We can not handle any layout other than FormLayout at the moment!!!");
        }
        this.hoverListener = new Listener(){

            public void handleEvent(Event event2) {
                Widget widget = event2.widget;
                if (!(widget instanceof Control)) {
                    return;
                }
                Control control = (Control)widget;
                switch (event2.type) {
                    case 6: {
                        control.setForeground(FriendsToolbar.this.hoverTextColor);
                        break;
                    }
                    case 7: {
                        control.setForeground(FriendsToolbar.this.secondaryTextColor);
                    }
                }
            }
        };
        this.content = new Composite(this.parent, 0);
        this.content.setBackgroundMode(1);
        this.content.setBackgroundImage(ImageRepository.getImage("friends_bg"));
        FontData[] datas = this.content.getFont().getFontData();
        for (i = 0; i < datas.length; ++i) {
            datas[i].setStyle(1);
            if (ConstantsV3.isOSX) {
                datas[i].setHeight(11);
                continue;
            }
            datas[i].setHeight(8);
        }
        this.boldFont = new Font((Device)this.content.getDisplay(), datas);
        for (i = 0; i < datas.length; ++i) {
            if (ConstantsV3.isOSX) {
                datas[i].setHeight(13);
                continue;
            }
            datas[i].setHeight(10);
        }
        this.friendsFont = new Font((Device)this.content.getDisplay(), datas);
        this.friendsTextColor = new Color((Device)this.content.getDisplay(), 49, 52, 60);
        this.numberOfFriendsTextColor = new Color((Device)this.content.getDisplay(), 77, 77, 77);
        this.secondaryTextColor = new Color((Device)this.content.getDisplay(), 51, 63, 79);
        this.hoverTextColor = new Color((Device)this.content.getDisplay(), 42, 63, 113);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.height = 46;
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.content.setLayoutData((Object)fd);
        this.content.setLayout((Layout)new FormLayout());
        this.createControls();
        this.parent.getParent().layout(true, true);
        this.toolbarHeight = this.parent.getSize().y - 1;
        SWTSkinObject soSidebar = this.skin.getSkinObject("sidebar");
        if (null != soSidebar) {
            soSidebar.getControl().addListener(11, new Listener(){

                public void handleEvent(Event event2) {
                    if (!COConfigurationManager.getBooleanParameter("Friends.visible")) {
                        FriendsToolbar.this.collapseToToolbar();
                    }
                }
            });
        }
    }

    private void createControls() {
        this.friendsLabel = new Label(this.content, 0);
        this.friendsLabel.setFont(this.friendsFont);
        this.friendsLabel.setForeground(this.friendsTextColor);
        this.friendsLabel.setText(MessageText.getString("v3.buddies.friends"));
        this.friendsCountLabel = new Label(this.content, 0);
        this.friendsCountLabel.setFont(this.friendsFont);
        this.friendsCountLabel.setForeground(this.numberOfFriendsTextColor);
        this.onlineFriendsLabel = new Label(this.content, 0);
        this.onlineFriendsLabel.setFont(this.boldFont);
        this.onlineFriendsLabel.setForeground(this.secondaryTextColor);
        this.showHideButton = new Label(this.content, 0);
        this.showHideButton.setData("over", (Object)new Boolean(false));
        Listener hoverBtnListener = new Listener(){

            public void handleEvent(Event event2) {
                Boolean expandedB = (Boolean)FriendsToolbar.this.showHideButton.getData("expanded");
                boolean isExpanded = expandedB != null ? expandedB : true;
                switch (event2.type) {
                    case 6: {
                        FriendsToolbar.this.showHideButton.setData("over", (Object)new Boolean(true));
                        FriendsToolbar.this.showHideButton.setImage(isExpanded ? ImageRepository.getImage("btn_collapse_over") : ImageRepository.getImage("btn_expand_over"));
                        break;
                    }
                    case 7: {
                        FriendsToolbar.this.showHideButton.setData("over", (Object)new Boolean(false));
                        FriendsToolbar.this.showHideButton.setImage(isExpanded ? ImageRepository.getImage("btn_collapse") : ImageRepository.getImage("btn_expand"));
                    }
                }
            }
        };
        this.showHideButton.addListener(6, hoverBtnListener);
        this.showHideButton.addListener(7, hoverBtnListener);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 8);
        data.top = new FormAttachment(0, 4);
        this.friendsLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.friendsLabel, 2);
        data.right = new FormAttachment((Control)this.showHideButton, -5);
        data.top = new FormAttachment(0, 4);
        this.friendsCountLabel.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100, -8);
        data.top = new FormAttachment(0, 10);
        this.showHideButton.setLayoutData((Object)data);
        this.hookTuxGoodies((Control)this.friendsLabel);
        this.updateFriendsLabel();
        VuzeBuddyManager.addListener(new VuzeBuddyListener(){

            public void buddyRemoved(VuzeBuddy buddy) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        FriendsToolbar.this.updateFriendsLabel();
                    }
                });
            }

            public void buddyAdded(VuzeBuddy buddy, int position) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        FriendsToolbar.this.updateFriendsLabel();
                    }
                });
            }

            public void buddyOrderChanged() {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        FriendsToolbar.this.updateFriendsLabel();
                    }
                });
            }

            public void buddyChanged(VuzeBuddy buddy) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        FriendsToolbar.this.updateFriendsLabel();
                    }
                });
            }
        }, false);
        this.createToolItems();
        this.createSharePanel();
        data = new FormData();
        data.left = new FormAttachment(0, 8);
        data.right = new FormAttachment((Control)this.edit, -5);
        data.top = new FormAttachment(0, 28);
        this.onlineFriendsLabel.setLayoutData((Object)data);
        boolean isVisible = COConfigurationManager.getBooleanParameter("Friends.visible");
        SWTSkinObjectSash soSash = (SWTSkinObjectSash)this.skin.getSkinObject("sidebar-sash-bottom");
        if (null != soSash) {
            if (isVisible) {
                COConfigurationManager.setParameter("Friends.sash.percent", (float)soSash.getPercent());
            } else {
                this.collapseToToolbar();
            }
        }
        this.showFooterToggleButton(isVisible);
        COConfigurationManager.addParameterListener("Friends.visible", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                boolean isVisible = COConfigurationManager.getBooleanParameter("Friends.visible");
                FriendsToolbar.this.showFooterToggleButton(isVisible);
                FriendsToolbar.this.showFriends(isVisible);
            }
        });
        this.showHideButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                boolean wasExpanded = COConfigurationManager.getBooleanParameter("Friends.visible");
                COConfigurationManager.setParameter("Friends.visible", !wasExpanded);
            }
        });
    }

    private void createToolItems() {
        this.edit = new Label(this.content, 8);
        this.edit.setFont(this.boldFont);
        this.edit.setForeground(this.secondaryTextColor);
        this.edit.setCursor(this.content.getDisplay().getSystemCursor(21));
        this.edit.addListener(6, this.hoverListener);
        this.edit.addListener(7, this.hoverListener);
        this.edit.setText(MessageText.getString("Button.bar.edit"));
        this.edit.addListener(4, new Listener(){

            public void handleEvent(Event arg0) {
                if (new Boolean(false).equals(FriendsToolbar.this.edit.getData("edit_mode"))) {
                    FriendsToolbar.this.setEditMode();
                } else {
                    FriendsToolbar.this.reset();
                }
            }
        });
        LoginInfoManager.getInstance().addListener(new ILoginInfoListener(){

            public void loginUpdate(LoginInfoManager.LoginInfo info, boolean isNewLoginID) {
                if (null == info.userName) {
                    Utils.execSWTThreadLater(0, new AERunnable(){

                        public void runSupport() {
                            FriendsToolbar.this.edit.setText(MessageText.getString("Button.bar.edit"));
                            FriendsToolbar.this.edit.setData("selection", (Object)new Boolean(false));
                            FriendsToolbar.this.reset();
                            FriendsToolbar.this.content.layout(true);
                        }
                    });
                }
            }

            public void avatarURLUpdated(String newAvatarURL) {
            }
        });
        this.addFriends = new Label(this.content, 0);
        this.addFriends.setFont(this.boldFont);
        this.addFriends.setForeground(this.secondaryTextColor);
        this.addFriends.setCursor(this.content.getDisplay().getSystemCursor(21));
        this.addFriends.addListener(6, this.hoverListener);
        this.addFriends.addListener(7, this.hoverListener);
        this.addFriends.setText(MessageText.getString("Button.bar.add"));
        this.addFriends.addListener(4, new Listener(){

            public void handleEvent(Event arg0) {
                FriendsToolbar.this.addBuddy();
            }
        });
        Label separator = new Label(this.content, 0);
        separator.setFont(this.boldFont);
        separator.setForeground(this.secondaryTextColor);
        separator.setText("/");
        FormData data = new FormData();
        data.right = new FormAttachment(100, -8);
        data.top = new FormAttachment(0, 28);
        this.addFriends.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)this.addFriends, -1);
        data.top = new FormAttachment(0, 28);
        separator.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)separator, -1);
        data.top = new FormAttachment(0, 28);
        this.edit.setLayoutData((Object)data);
    }

    private void createSharePanel() {
        this.shareWithAllPanel = new Composite(this.content, 0);
        this.shareWithAllPanel.setVisible(false);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 8);
        data.top = new FormAttachment(0, 29);
        data.right = new FormAttachment((Control)this.edit, -5);
        this.shareWithAllPanel.setLayoutData((Object)data);
        this.shareWithAllPanel.setLayout((Layout)new FormLayout());
        this.image = new Label(this.shareWithAllPanel, 0);
        this.image.setImage(ImageRepository.getImage("add_to_share"));
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        this.image.setLayoutData((Object)data);
        this.text = new Label(this.shareWithAllPanel, 0);
        this.text.setFont(this.boldFont);
        this.text.setForeground(this.secondaryTextColor);
        this.text.setText(MessageText.getString("v3.Share.add.buddy.all"));
        data = new FormData();
        data.left = new FormAttachment((Control)this.image, 5);
        data.top = new FormAttachment(0, 0);
        this.text.setLayoutData((Object)data);
        this.hookShareListener();
    }

    private void hookShareListener() {
        MouseAdapter listener = new MouseAdapter(){
            boolean shareWithAll = false;

            public void mouseUp(MouseEvent e) {
                this.shareWithAll = !this.shareWithAll;
                FriendsToolbar.this.shareAllBuddies(this.shareWithAll);
            }
        };
        this.shareWithAllPanel.addMouseListener((MouseListener)listener);
        this.image.addMouseListener((MouseListener)listener);
        this.text.addMouseListener((MouseListener)listener);
    }

    public void enableShareButton(boolean value) {
        this.shareWithAllPanel.setEnabled(value);
        this.image.setEnabled(value);
        this.text.setEnabled(value);
        if (!value) {
            BuddiesViewer viewer = (BuddiesViewer)SkinViewManager.getByClass(BuddiesViewer.class);
            if (null != viewer) {
                viewer.setMode(5);
            }
        } else {
            BuddiesViewer viewer = (BuddiesViewer)SkinViewManager.getByClass(BuddiesViewer.class);
            if (null != viewer) {
                viewer.setMode(2);
            }
        }
    }

    protected void shareAllBuddies(boolean value) {
        BuddiesViewer viewer = (BuddiesViewer)SkinViewManager.getByClass(BuddiesViewer.class);
        if (null != viewer) {
            if (value) {
                this.image.setImage(ImageRepository.getImage("add_to_share_selected"));
                viewer.addAllToShare();
            } else {
                this.image.setImage(ImageRepository.getImage("add_to_share"));
                viewer.removeAllFromShare();
            }
        }
    }

    private void updateFriendsLabel() {
        if (this.friendsCountLabel.isDisposed()) {
            return;
        }
        List buddies = VuzeBuddyManager.getAllVuzeBuddies();
        int onlineBuddies = 0;
        for (int i = 0; i < buddies.size(); ++i) {
            VuzeBuddy buddy = (VuzeBuddy)buddies.get(i);
            if (!buddy.isOnline(true)) continue;
            ++onlineBuddies;
        }
        this.friendsCountLabel.setText("(" + buddies.size() + ")");
        this.onlineFriendsLabel.setText(MessageText.getString("v3.buddies.online", new String[]{onlineBuddies + ""}));
        this.content.layout(true);
    }

    public void addBuddy(final String message) {
        if (!VuzeBuddyManager.isEnabled()) {
            VuzeBuddyManager.showDisabledDialog();
            return;
        }
        SWTLoginUtils.waitForLogin(new SWTLoginUtils.loginWaitListener(){

            public void loginComplete() {
                FriendsToolbar.this._addBuddy(message);
            }
        });
    }

    public void addBuddy() {
        this.addBuddy(null);
    }

    protected void _addBuddy(final String message) {
        this.addFriends.setEnabled(false);
        this.showHideButton.setEnabled(false);
        this.edit.setEnabled(false);
        BuddiesViewer viewer = (BuddiesViewer)SkinViewManager.getByClass(BuddiesViewer.class);
        if (null == viewer) {
            return;
        }
        viewer.setMode(4);
        SWTSkinObject soSidebar = this.skin.getSkinObject("sidebar-sash");
        if (null != soSidebar) {
            MultipageWizard shell = new MultipageWizard(UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell(), 2160){

                public void createPages() {
                    AddFriendsPage add = new AddFriendsPage(this);
                    if (message != null) {
                        add.setMessage(message);
                    }
                    this.addPage(add);
                }
            };
            shell.setText("Vuze - Wizard");
            shell.setSize(500, 550);
            boolean useDocker = false;
            if (useDocker) {
                ShellDocker docker = new ShellDocker(soSidebar.getControl(), shell.getShell());
                docker.setAnchorControlPosition(new DockPosition(4, new Offset(1, -shell.getSize().y)));
                docker.openShell(true, false);
            } else {
                UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                if (null == uiFunctions) {
                    Utils.centreWindow(shell.getShell());
                } else {
                    Utils.centerWindowRelativeTo(shell.getShell(), (Control)uiFunctions.getMainShell());
                }
                shell.open();
            }
        }
    }

    public void reset() {
        this.onlineFriendsLabel.setVisible(true);
        this.addFriends.setEnabled(true);
        this.friendsLabel.setEnabled(true);
        this.showHideButton.setEnabled(true);
        this.edit.setEnabled(true);
        this.edit.setText(MessageText.getString("Button.bar.edit"));
        this.edit.setData("edit_mode", (Object)new Boolean(false));
        BuddiesViewer viewer = (BuddiesViewer)SkinViewManager.getByClass(BuddiesViewer.class);
        if (null == viewer) {
            return;
        }
        viewer.setMode(0);
        this.shareWithAllPanel.setVisible(false);
        this.content.layout(true);
    }

    public void setShareMode() {
        BuddiesViewer viewer = (BuddiesViewer)SkinViewManager.getByClass(BuddiesViewer.class);
        if (null == viewer) {
            return;
        }
        viewer.setMode(2);
        this.addFriends.setEnabled(false);
        this.onlineFriendsLabel.setVisible(false);
        this.showHideButton.setEnabled(false);
        this.edit.setEnabled(false);
        this.shareWithAllPanel.setVisible(true);
        this.content.layout(true);
        COConfigurationManager.setParameter("Friends.visible", true);
    }

    public void setAddFriendsMode() {
        SWTLoginUtils.waitForLogin(new SWTLoginUtils.loginWaitListener(){

            public void loginComplete() {
                BuddiesViewer viewer = (BuddiesViewer)SkinViewManager.getByClass(BuddiesViewer.class);
                if (null == viewer) {
                    return;
                }
                viewer.setMode(2);
                FriendsToolbar.this.addFriends.setEnabled(false);
                FriendsToolbar.this.showHideButton.setEnabled(false);
                FriendsToolbar.this.edit.setEnabled(false);
                FriendsToolbar.this.shareWithAllPanel.setVisible(true);
            }

            public long getCancelDelay() {
                return 0L;
            }

            public void loginCanceled() {
                FriendsToolbar.this.reset();
            }
        });
    }

    public void setEditMode() {
        SWTLoginUtils.waitForLogin(new SWTLoginUtils.loginWaitListener(){

            public void loginComplete() {
                COConfigurationManager.setParameter("Friends.visible", true);
                BuddiesViewer viewer = (BuddiesViewer)SkinViewManager.getByClass(BuddiesViewer.class);
                if (null == viewer) {
                    return;
                }
                viewer.setMode(1);
                FriendsToolbar.this.edit.setData("edit_mode", (Object)new Boolean(true));
                FriendsToolbar.this.edit.setText(MessageText.getString("Button.bar.edit.cancel"));
                FriendsToolbar.this.edit.setEnabled(true);
                FriendsToolbar.this.addFriends.setEnabled(false);
                FriendsToolbar.this.showHideButton.setEnabled(false);
                FriendsToolbar.this.content.layout(true);
            }

            public long getCancelDelay() {
                return 0L;
            }

            public void loginCanceled() {
                FriendsToolbar.this.reset();
            }
        });
    }

    private void showFooterToggleButton(boolean isExpanded) {
        boolean isOver;
        this.showHideButton.setData("expanded", (Object)new Boolean(isExpanded));
        Boolean overB = (Boolean)this.showHideButton.getData("over");
        boolean bl = isOver = overB != null ? overB : false;
        if (isOver) {
            this.showHideButton.setImage(isExpanded ? ImageRepository.getImage("btn_collapse_over") : ImageRepository.getImage("btn_expand_over"));
        } else {
            this.showHideButton.setImage(isExpanded ? ImageRepository.getImage("btn_collapse") : ImageRepository.getImage("btn_expand"));
        }
    }

    public void showFriends(final boolean isExpanded) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                SWTSkinObjectSash soSash = (SWTSkinObjectSash)FriendsToolbar.this.skin.getSkinObject("sidebar-sash-bottom");
                if (isExpanded) {
                    soSash.setVisible(true);
                    soSash.setPercent(COConfigurationManager.getFloatParameter("Friends.sash.percent"));
                } else {
                    COConfigurationManager.setParameter("Friends.sash.percent", (float)soSash.getPercent());
                    FriendsToolbar.this.collapseToToolbar();
                }
            }
        });
    }

    private void collapseToToolbar() {
        SWTSkinObject soSidebar = this.skin.getSkinObject("sidebar");
        if (null != soSidebar) {
            SWTSkinObjectSash soSash = (SWTSkinObjectSash)this.skin.getSkinObject("sidebar-sash-bottom");
            soSash.setVisible(false);
            soSash.setBelowPX(this.toolbarHeight);
        }
    }

    private void hookTuxGoodies(Control control) {
        if (!Constants.isCVSVersion()) {
            return;
        }
        Menu menu = new Menu(control);
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText("buddy sync up");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!LoginInfoManager.getInstance().isLoggedIn()) {
                    Utils.openMessageBox(null, 1, "No", "not logged in. no can do");
                    return;
                }
                try {
                    PlatformRelayMessenger.fetch(0L);
                    PlatformBuddyMessenger.sync(null);
                    PlatformBuddyMessenger.getInvites();
                }
                catch (NotLoggedInException notLoggedInException) {
                    // empty catch block
                }
            }
        });
        menuItem = new MenuItem(menu, 8);
        menuItem.setText("send msg to all buddies");
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!LoginInfoManager.getInstance().isLoggedIn()) {
                    Utils.openMessageBox(null, 1, "No", "not logged in. no can do");
                    return;
                }
                InputShell is = new InputShell("Moo", "Message:");
                String txt = is.open();
                if (txt != null) {
                    VuzeActivitiesEntry entry = new VuzeActivitiesEntry(SystemTime.getCurrentTime(), txt, "Test");
                    List buddies = VuzeBuddyManager.getAllVuzeBuddies();
                    for (VuzeBuddy buddy : buddies) {
                        System.out.println("sending to " + buddy.getDisplayName());
                        try {
                            buddy.sendActivity(entry);
                        }
                        catch (NotLoggedInException e1) {
                            Debug.out("Shouldn't Happen", e1);
                        }
                    }
                }
            }
        });
        control.setMenu(menu);
    }

    static {
        ImageRepository.addPath("com/aelitis/azureus/ui/images/sb/icon_hide_notch.png", "btn_collapse");
        ImageRepository.addPath("com/aelitis/azureus/ui/images/sb/icon_hide_notch_over.png", "btn_collapse_over");
        ImageRepository.addPath("com/aelitis/azureus/ui/images/sb/icon_show_notch.png", "btn_expand");
        ImageRepository.addPath("com/aelitis/azureus/ui/images/sb/icon_show_notch_over.png", "btn_expand_over");
        ImageRepository.addPath("com/aelitis/azureus/ui/images/sb/friends_bg.png", "friends_bg");
        ImageRepository.addPath("com/aelitis/azureus/ui/images/buddy_add_to_share.png", "add_to_share");
        ImageRepository.addPath("com/aelitis/azureus/ui/images/buddy_add_to_share_selected.png", "add_to_share_selected");
    }
}

