/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.gudy.azureus2.ui.swt.ImageRepository;

public class LibraryToolbar
extends SkinView {
    private Composite parent;
    private ToolBar toolbar;
    private Label viewTitle;
    private ToolItem smallTabel;
    private ToolItem largeTable;
    private Composite content;

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.skin = skinObject.getSkin();
        this.parent = (Composite)skinObject.getControl();
        this.init();
        return null;
    }

    private void init() {
        if (null == this.parent || this.parent.isDisposed()) {
            throw new NullPointerException("Parent cannot be null or disposed");
        }
        Layout parentLayout = this.parent.getLayout();
        if (null == parentLayout) {
            parentLayout = new FormLayout();
            this.parent.setLayout(parentLayout);
        } else if (!(parentLayout instanceof FormLayout)) {
            throw new IllegalArgumentException("Oops! We can not handle any layout other than FormLayout at the moment!!!");
        }
        this.content = new Composite(this.parent, 0);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.content.setLayoutData((Object)fd);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        this.content.setLayout((Layout)layout);
        this.createControls();
    }

    private void createControls() {
        this.toolbar = new ToolBar(this.content, 256);
        this.toolbar.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.createToolItems();
        this.viewTitle = new Label(this.content, 0);
        this.viewTitle.setText("This is where the title/description can be displayed... or can be left out completely!!!!!");
        this.viewTitle.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
    }

    public void createToolItems() {
        this.smallTabel = new ToolItem(this.toolbar, 32);
        this.smallTabel.setImage(ImageRepository.getImage("button_small_table"));
        this.smallTabel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("Small is selected: " + LibraryToolbar.this.smallTabel.getSelection());
                if (LibraryToolbar.this.smallTabel.getSelection()) {
                    LibraryToolbar.this.largeTable.setSelection(false);
                    LibraryToolbar.this.setTableMode(false);
                } else {
                    LibraryToolbar.this.largeTable.setSelection(true);
                    LibraryToolbar.this.setTableMode(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.largeTable = new ToolItem(this.toolbar, 32);
        this.largeTable.setImage(ImageRepository.getImage("button_large_table"));
        this.largeTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println("Large is selected: " + LibraryToolbar.this.largeTable.getSelection());
                if (LibraryToolbar.this.largeTable.getSelection()) {
                    LibraryToolbar.this.smallTabel.setSelection(false);
                    LibraryToolbar.this.setTableMode(true);
                } else {
                    LibraryToolbar.this.smallTabel.setSelection(true);
                    LibraryToolbar.this.setTableMode(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void setTableMode(boolean isLarge) {
        System.out.println("Table mode is large: " + isLarge);
    }

    static {
        ImageRepository.addPath("com/aelitis/azureus/ui/images/button_table_view_normal.png", "button_small_table");
        ImageRepository.addPath("com/aelitis/azureus/ui/images/button_table_view_large.png", "button_large_table");
    }
}

