/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionAdapter;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.views.TorrentListView;
import com.aelitis.azureus.ui.swt.views.TorrentListViewListener;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.DisplayFormatters;

public class ManageDlList
extends SkinView {
    private String PREFIX = "manage-dl-";
    private TorrentListView view;
    private SWTSkinObjectText statusObject;

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        this.view = new TorrentListView(this, this.PREFIX, 0, false, true);
        skinObject = this.skin.getSkinObject(this.PREFIX + "status");
        if (skinObject instanceof SWTSkinObjectText) {
            this.statusObject = (SWTSkinObjectText)skinObject;
            this.view.addListener(new TorrentListViewListener(){

                public void stateChanged(DownloadManager manager) {
                    TableRowCore[] selectedRows = ManageDlList.this.view.getSelectedRows();
                    ManageDlList.this.updateStatusText(selectedRows.length == 1 ? selectedRows[0] : null);
                }
            });
        }
        this.view.addSelectionListener(new TableSelectionAdapter(){

            public void deselected(TableRowCore[] rows) {
                this.update();
            }

            public void selected(TableRowCore[] rows) {
                this.update();
            }

            public void focusChanged(TableRowCore focusedRow) {
                this.update();
            }

            private void update() {
                ManageDlList.this.updateStatusText(ManageDlList.this.view.getFocusedRow());
            }
        }, true);
        return null;
    }

    protected void updateStatusText(TableRowCore row) {
        if (row != null) {
            DownloadManager dm = (DownloadManager)row.getDataSource(true);
            this.statusObject.setText(DisplayFormatters.formatDownloadStatus(dm));
        } else {
            this.statusObject.setTextID("v3.MainWindow." + this.PREFIX + "status.noselection");
        }
    }
}

